/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.AddActionsDialog;
import oracle.ide.ceditor.saveactions.Bundle;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ListBuilder;
import oracle.javatools.util.StringUtil;

public class SaveActionsOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    BuiltList<SaveActionDescription> lc;
    private List<SaveActionDescription> actions;

    public SaveActionsOptionsPanel() {
        this.setHelpID("f1_idedidesetsaveactions_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private static SaveActionsOptions getSaveOptions(TraversableContext tc) {
        return SaveActionsOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.loadSettingsFrom(SaveActionsOptionsPanel.getSaveOptions(tc));
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.saveSettingsTo(SaveActionsOptionsPanel.getSaveOptions(tc));
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        SaveActionsOptions options = SaveActionsOptionsPanel.getSaveOptions(tc);
        SaveActionsOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(SaveActionsOptions options) {
    }

    void loadSettingsFrom(SaveActionsOptions options) {
        this.actions.clear();
        this.actions.addAll(options.getExecutableSaveActions());
    }

    void saveSettingsTo(SaveActionsOptions options) throws TraversalException {
        options.setExecutableSaveActions(this.actions);
    }

    private void initializeComponent() {
        this.setLayout((LayoutManager)new MigLayout("ins 0, fill"));
        ActionListener addListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddActionsDialog addDialog = new AddActionsDialog(SaveActionsOptionsPanel.this.actions);
                if (addDialog.runDialog()) {
                    SaveActionsOptionsPanel.this.actions.addAll(addDialog.getSelectedActions());
                }
            }
        };
        ActionListener removeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveActionsOptionsPanel.this.actions.removeAll(SaveActionsOptionsPanel.this.lc.getSelectedValues());
            }
        };
        ListBuilder builder = new ListBuilder();
        builder.setLabel(Bundle.get("SAVE_ACTIONS_OPTIONS_TEXT"));
        builder.setEmptyTextLarge(Bundle.get("SAVE_ACTIONS_EMPTY_LIST"));
        builder.setRenderer((ListCellRenderer)new ActionRenderer());
        builder.setReorderable(true);
        builder.setRollover(true);
        builder.setActionsDefault(ListBuilder.DefaultAction.ADD, addListener);
        builder.setActionsDefault(ListBuilder.DefaultAction.REMOVE, removeListener);
        this.lc = builder.build();
        this.actions = this.lc.getListModel();
        this.add(this.lc.getGUI(), "grow, wmax pref+30");
    }

    static class ActionRenderer
    extends DefaultListCellRenderer {
        private static Icon NULL_ICON = new NullIcon();

        ActionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SaveActionDescription) {
                SaveActionDescription action = (SaveActionDescription)value;
                Integer id = Ide.findCmdID((String)action.getId());
                IdeAction ideAction = null;
                if (id != null) {
                    ideAction = IdeAction.find((int)id);
                }
                Icon icon = ideAction == null ? NULL_ICON : (Icon)ideAction.getValue("SmallIcon");
                c.setIcon(icon);
                String text = ideAction == null ? action.getId() : StringUtil.textWithoutMnemonic((Action)ideAction);
                c.setText(text);
            }
            return c;
        }
    }
}

