/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.ideimpl.ceditor.saveactions.SaveActionsHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class SaveActionsOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "SaveActionsOptions";
    private static final String SAVE_ACTION_LIST = "saveActionList";
    private static final String DISABLED_SAVE_ACTION_LIST = "disabledSaveActionList";
    private static final String MIGRATED_SAVE_ACTIONS = "migratedSaveActions";

    static void migrate() {
        Preferences prefs = Preferences.getPreferences();
        SaveActionsOptions saOptions = SaveActionsOptions.getInstance((PropertyStorage)prefs);
        if (!saOptions.getMigratedSaveActions()) {
            saOptions.setMigratedSaveActions(true);
            if (!Ide.getEnvironOptions().getBuildAfterSave()) {
                saOptions.setExecutableSaveAction("BUILD_PROJECT_AFTER_SAVE", false);
            }
            if (Ide.getEnvironOptions().getBuildDependentsAfterSave()) {
                saOptions.setExecutableSaveAction("BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE", true);
            }
        }
    }

    private SaveActionsOptions(HashStructure hash) {
        super(hash);
    }

    public static SaveActionsOptions getInstance(PropertyStorage prefs) {
        return new SaveActionsOptions(SaveActionsOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean isPotentialSaveAction(String actionId) {
        SaveActionDescription hookAction = null;
        List<SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        for (int x = 0; x < hookActions.size(); ++x) {
            hookAction = hookActions.get(x);
            if (!hookAction.getId().equals(actionId)) continue;
            return true;
        }
        return false;
    }

    public List<SaveActionDescription> getExecutableSaveActions() {
        ListStructure enabledActions = this.getEnabledActionList();
        ListStructure disabledActions = this.getDisabledActionList();
        ArrayList<SaveActionDescription> saveActions = new ArrayList<SaveActionDescription>();
        List<SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        for (SaveActionDescription hookAction : hookActions) {
            String id = hookAction.getId();
            if (!enabledActions.contains((Object)id) && (!hookAction.getExecuteByDefault() || disabledActions.contains((Object)id))) continue;
            saveActions.add(hookAction);
        }
        return saveActions;
    }

    public void setExecutableSaveActions(Collection<SaveActionDescription> newSaveActions) {
        List<SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        ListStructure newEnabledActions = ListStructure.newInstance();
        ListStructure newDisabledActions = ListStructure.newInstance();
        for (SaveActionDescription hookAction : hookActions) {
            if (newSaveActions.contains(hookAction)) {
                if (hookAction.getExecuteByDefault()) continue;
                newEnabledActions.add((Object)hookAction.getId());
                continue;
            }
            if (!hookAction.getExecuteByDefault()) continue;
            newDisabledActions.add((Object)hookAction.getId());
        }
        this.setEnabledActionList(newEnabledActions);
        this.setDisabledActionList(newDisabledActions);
    }

    public boolean setExecutableSaveAction(String actionId, boolean executable) {
        SaveActionDescription hookAction = null;
        List<SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        for (int x = 0; x < hookActions.size() && !(hookAction = hookActions.get(x)).getId().equals(actionId); ++x) {
            hookAction = null;
        }
        if (hookAction == null) {
            return false;
        }
        String id = hookAction.getId();
        if (hookAction.getExecuteByDefault()) {
            ListStructure disabledActions = this.getDisabledActionList();
            if (executable) {
                disabledActions.remove((Object)id);
            } else if (!disabledActions.contains((Object)id)) {
                disabledActions.add((Object)id);
            }
            this.setDisabledActionList(disabledActions);
        } else {
            ListStructure enabledActions = this.getEnabledActionList();
            if (executable) {
                if (!enabledActions.contains((Object)id)) {
                    enabledActions.add((Object)id);
                }
            } else {
                enabledActions.remove((Object)id);
            }
        }
        return true;
    }

    public boolean isExecutableSaveAction(String actionId) {
        SaveActionDescription hookAction = null;
        List<SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        for (int x = 0; x < hookActions.size() && !(hookAction = hookActions.get(x)).getId().equals(actionId); ++x) {
            hookAction = null;
        }
        if (hookAction == null) {
            return false;
        }
        String id = hookAction.getId();
        if (hookAction.getExecuteByDefault()) {
            ListStructure disabledActions = this.getDisabledActionList();
            return !disabledActions.contains((Object)id);
        }
        ListStructure enabledActions = this.getEnabledActionList();
        return enabledActions.contains((Object)id);
    }

    private ListStructure getEnabledActionList() {
        return this.getList(SAVE_ACTION_LIST);
    }

    private ListStructure getDisabledActionList() {
        return this.getList(DISABLED_SAVE_ACTION_LIST);
    }

    private ListStructure getList(String name) {
        ListStructure list = this._hash.getListStructure(name);
        if (list == null) {
            list = ListStructure.newInstance();
            this._hash.putListStructure(name, list);
        }
        return list;
    }

    private void setEnabledActionList(ListStructure actionNameList) {
        this.setActionList(SAVE_ACTION_LIST, actionNameList);
    }

    private void setDisabledActionList(ListStructure actionNameList) {
        this.setActionList(DISABLED_SAVE_ACTION_LIST, actionNameList);
    }

    private void setActionList(String name, ListStructure actionNameList) {
        this._hash.putListStructure(name, actionNameList);
    }

    private boolean getMigratedSaveActions() {
        return this._hash.getBoolean(MIGRATED_SAVE_ACTIONS, false);
    }

    private void setMigratedSaveActions(boolean value) {
        this._hash.putBoolean(MIGRATED_SAVE_ACTIONS, value);
    }
}

