/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.gui.babelfish.AbstractBabelfishUpdater;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class BabelfishErrorCodeUpdaterAction
extends AbstractBabelfishUpdater {
    private static final String REGISTER = "BEGIN  dbms_sql_translator.REGISTER_ERROR_TRANSLATION(:PROFILE_NAME,:ERROR_CODE,:TRANSLATED_CODE,:TRANSLATED_SQLSTATE,sys.diutil.int_to_bool(:ENABLED)); END;";
    private static final String DEREGISTER = "BEGIN  dbms_sql_translator.DEREGISTER_ERROR_TRANSLATION(:PROFILE_NAME,:ERROR_CODE); END;";

    @Override
    AbstractBabelfishUpdater.IRowReader getRowReader(RaptorGridRowModel raptorGridRowModel) {
        return new ErrorRowReader(raptorGridRowModel);
    }

    @Override
    List<?> getDeregisterBinds(AbstractBabelfishUpdater.IRowReader iRowReader) {
        ErrorRowReader errorRowReader = (ErrorRowReader)iRowReader;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(errorRowReader.getProfile());
        arrayList.add(errorRowReader.getErrorCode());
        return arrayList;
    }

    @Override
    String getDeregisterSQL() {
        return DEREGISTER;
    }

    @Override
    List<?> getRegisterBinds(AbstractBabelfishUpdater.IRowReader iRowReader) {
        ErrorRowReader errorRowReader = (ErrorRowReader)iRowReader;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(errorRowReader.getProfile());
        arrayList.add(errorRowReader.getErrorCode());
        arrayList.add(errorRowReader.getTranslatedCode());
        arrayList.add(errorRowReader.getTranslatedSQLState());
        arrayList.add(errorRowReader.getStatus());
        return arrayList;
    }

    @Override
    String getRegisterSQL() {
        return REGISTER;
    }

    @Override
    public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
        return null;
    }

    class ErrorRowReader
    implements AbstractBabelfishUpdater.IRowReader {
        String _errorcode;
        String _translated_code;
        String _translated_sqlstate;
        Integer _status;
        String _profile;

        private ErrorRowReader(RaptorGridRowModel raptorGridRowModel) {
            RaptorGridCell raptorGridCell = (RaptorGridCell)raptorGridRowModel.getRow().get(0);
            RaptorGridCell raptorGridCell2 = (RaptorGridCell)raptorGridRowModel.getRow().get(1);
            RaptorGridCell raptorGridCell3 = (RaptorGridCell)raptorGridRowModel.getRow().get(2);
            RaptorGridCell raptorGridCell4 = (RaptorGridCell)raptorGridRowModel.getRow().get(3);
            RaptorGridCell raptorGridCell5 = (RaptorGridCell)raptorGridRowModel.getRow().get(4);
            Object object = raptorGridCell.getCellData();
            Object object2 = raptorGridCell2.getCellData();
            Object object3 = raptorGridCell3.getCellData();
            Object object4 = raptorGridCell4.getCellData();
            Object object5 = raptorGridCell5.getCellData();
            this._profile = this.getValue(object);
            if (this._profile == null || this._profile.trim().equals("")) {
                this._profile = (String)BabelfishErrorCodeUpdaterAction.this._parcel.getBindMap().get("NAME");
            }
            this._errorcode = this.getValue(object2);
            this._translated_code = this.getValue(object3);
            this._translated_sqlstate = this.getValue(object4);
            String string = this.getValue(object5);
            this._status = string.equalsIgnoreCase("DISABLED") || string.equalsIgnoreCase("NO") || string.equalsIgnoreCase("FALSE") ? Integer.valueOf(0) : Integer.valueOf(1);
        }

        public Object getStatus() {
            return this._status;
        }

        public String getErrorCode() {
            return this._errorcode;
        }

        public String getTranslatedCode() {
            return this._translated_code;
        }

        public String getTranslatedSQLState() {
            return this._translated_sqlstate;
        }

        public Object getProfile() {
            return this._profile;
        }

        private String getValue(Object object) {
            try {
                if (object instanceof NUMBER) {
                    return "" + ((NUMBER)object).intValue();
                }
                if (object instanceof CLOB) {
                    return ((CLOB)object).stringValue();
                }
                return object.toString();
            }
            catch (SQLException sQLException) {
                return null;
            }
        }
    }
}

