/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridCellUpdated;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public abstract class AbstractBabelfishUpdater
implements IRaptorGridUpdater,
IRaptorGridCellUpdated {
    EditableGridInfo _parcel = null;

    abstract String getRegisterSQL();

    abstract String getDeregisterSQL();

    abstract List<?> getRegisterBinds(IRowReader var1);

    abstract List<?> getDeregisterBinds(IRowReader var1);

    abstract IRowReader getRowReader(RaptorGridRowModel var1);

    public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        return this.insertRows(string, list, iRaptorTaskProgressUpdater, list2);
    }

    private void resetSate() {
    }

    public int insertRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        this.resetSate();
        for (RaptorGridRowModel raptorGridRowModel : list) {
            Object object;
            if (raptorGridRowModel.isNew()) {
                object = (String)this._parcel.getBindMap().get("NAME");
                ((RaptorGridCell)raptorGridRowModel.getRow().get(0)).setCellData(object);
            }
            object = this.getRowReader(raptorGridRowModel);
            this.insertRows(string, this.getRegisterBinds((IRowReader)object));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertRows(String string, List<?> list) throws DBException {
        Connection connection = Connections.getInstance().getConnection(string);
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil.getInstance((Connection)connection).execute(this.getRegisterSQL(), list);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        this.resetSate();
        Connection connection = Connections.getInstance().getConnection(string);
        try {
            if (Connections.getInstance().lock(connection)) {
                for (RaptorGridRowModel raptorGridRowModel : list) {
                    IRowReader iRowReader = this.getRowReader(raptorGridRowModel);
                    DBUtil.getInstance((Connection)connection).execute(this.getDeregisterSQL(), this.getDeregisterBinds(iRowReader));
                }
            }
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
        return 0;
    }

    public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
        return null;
    }

    public void setGridInfo(EditableGridInfo editableGridInfo) {
        this._parcel = editableGridInfo;
    }

    static interface IRowReader {
    }
}

