/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import antlr.collections.AST;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.gui.ASTResultPanel;
import oracle.dbtools.migration.gui.AScratchWorksheet;
import oracle.dbtools.migration.gui.ParserSetting;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.SourceWorksheet;
import oracle.dbtools.migration.gui.TargetWorksheet;
import oracle.dbtools.migration.gui.newzebra.ZebraNode;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.parser.plugin.Fingerprint;
import oracle.dbtools.migration.translation.RepoTranslationAPI;
import oracle.dbtools.migration.translation.SchemaDetails;
import oracle.dbtools.migration.translation.api.TranslationAPI;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManagerImpl;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import org.antlr.runtime.tree.CommonTree;

public class ScratchEditorProvider
implements ActionProvider<Void> {
    public static final String TRANSLATE_CMD = "ScratchEditor.Translate";
    public static final String DIFF_EDITOR_CMD = "ScratchEditor.DiffEditor";
    public static final String FINGERPRINT_CMD = "ScratchEditor.Fingerprint";
    public static final String UTILS_CMD = "ScratchEditor.Utils";
    private static final Logger LOGGER = Logger.getLogger(AScratchWorksheet.class.getName());
    private static final WorksheetAction TRANSLATE_ACTION = WorksheetAction.createWorksheetAction((String)"ScratchEditor.Translate", (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)3, (double)-1.1);
    private static final WorksheetAction DIFF_EDITOR_ACTION = WorksheetAction.createWorksheetAction((String)"ScratchEditor.DiffEditor", (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)3, (double)-1.0);
    private static final WorksheetAction FINGERPRINT_ACTION = WorksheetAction.createWorksheetAction((String)"ScratchEditor.Fingerprint", (WorksheetAction.ActionType)WorksheetAction.ActionType.CONTEXT_MENU_ONLY, (int)3, (double)-1.0);
    private static final WorksheetAction UTILS_ACTION = WorksheetAction.createWorksheetAction((String)"ScratchEditor.Utils", (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)3, (double)-1.0);
    private SourceWorksheet m_sourceWS = null;
    private TargetWorksheet m_targetWS = null;
    private static final List<WorksheetAction> m_actions = new ArrayList<WorksheetAction>();

    public ScratchEditorProvider() {
        TRANSLATE_ACTION.getIdeAction(TRANSLATE_CMD).putValue("SmallIcon", (Object)SEMessages.getIcon("TRANSLATE_ICON"));
        DIFF_EDITOR_ACTION.getIdeAction(DIFF_EDITOR_CMD).putValue("SmallIcon", (Object)SEMessages.getIcon("TDV_ICON"));
        FINGERPRINT_ACTION.getIdeAction(FINGERPRINT_CMD);
        UTILS_ACTION.getIdeAction(UTILS_CMD).putValue("SmallIcon", (Object)SEMessages.getIcon("UTILS_COMMAND_ICON"));
        m_actions.add(TRANSLATE_ACTION);
        m_actions.add(DIFF_EDITOR_ACTION);
        m_actions.add(FINGERPRINT_ACTION);
        m_actions.add(UTILS_ACTION);
    }

    public void setWorksheets(SourceWorksheet sourceWorksheet, TargetWorksheet targetWorksheet) {
        this.m_sourceWS = sourceWorksheet;
        this.m_targetWS = targetWorksheet;
    }

    public WorksheetTaskWrapper<Void> doAction(String string, final WorksheetContext worksheetContext) {
        if (string.equals(FINGERPRINT_CMD)) {
            RaptorTask<String> raptorTask = new RaptorTask<String>("Running Fingerprint Translation", true, IRaptorTaskRunMode.TASKVIEWER){

                protected String doWork() throws TaskException {
                    String string = ParserSetting.getParserString();
                    if (string == "oracle.dbtools.migration.parser.tsql.TSQLParserMain" || string == "oracle.dbtools.migration.parser.sybase.SybaseParserMain" || string == "oracle.dbtools.migration.parser.db2.Db2ParserMain") {
                        String string2 = null;
                        string2 = ScratchEditorProvider.this.generateFingerprint(worksheetContext.getEditor().getText(), ParserSetting.getSchemaDetails());
                        return string2;
                    }
                    return worksheetContext.getEditor().getText();
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
                final /* synthetic */ RaptorTask val$task;
                {
                    this.val$task = raptorTask;
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        final String string = (String)this.val$task.getResult();
                        if (string != null) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ScratchEditorProvider.this.m_sourceWS.createWorksheetContext().getEditor().setText(string == null ? " " : string);
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.log(Level.WARNING, interruptedException.getLocalizedMessage());
                    }
                    catch (ExecutionException executionException) {
                        LOGGER.log(Level.WARNING, executionException.getLocalizedMessage());
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        } else if (string.equals(TRANSLATE_CMD) || string.equals(DIFF_EDITOR_CMD)) {
            RaptorTask<TranslateResultWithASTs> raptorTask = new RaptorTask<TranslateResultWithASTs>("Running Scratch Tranlation", true, IRaptorTaskRunMode.TASKVIEWER){

                protected TranslateResultWithASTs doWork() throws TaskException {
                    TranslateResultWithASTs translateResultWithASTs = null;
                    translateResultWithASTs = ScratchEditorProvider.this.translate(worksheetContext.getEditor().getText(), ParserSetting.getSchemaDetails());
                    return translateResultWithASTs;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask, string, worksheetContext){
                final /* synthetic */ RaptorTask val$task;
                final /* synthetic */ String val$id;
                final /* synthetic */ WorksheetContext val$ctx;
                {
                    this.val$task = raptorTask;
                    this.val$id = string;
                    this.val$ctx = worksheetContext;
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        final TranslateResultWithASTs translateResultWithASTs = (TranslateResultWithASTs)this.val$task.getResult();
                        if (translateResultWithASTs != null) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    CodingStyleSQLOptions codingStyleSQLOptions;
                                    String string = translateResultWithASTs == null ? " " : translateResultWithASTs.getTargetString();
                                    String string2 = "";
                                    if (!DBConfig.getInstance().getBoolean("AUTO_READONLY_FORMAT").booleanValue()) {
                                        try {
                                            if (CodingStyleManager.getCodingStyleManager() == null) {
                                                CodingStyleManager.setCodingStyleManager((CodingStyleManager)new CodingStyleManagerImpl());
                                            }
                                            codingStyleSQLOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions();
                                            string2 = codingStyleSQLOptions.format(string);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        ScratchEditorProvider.this.m_targetWS.createWorksheetContext().getEditor().setText(string2);
                                    } else {
                                        ScratchEditorProvider.this.m_targetWS.createWorksheetContext().getEditor().setText(string);
                                    }
                                    codingStyleSQLOptions = Preferences.getPreferences();
                                    ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)codingStyleSQLOptions);
                                    if (configurationData.getShowAST()) {
                                        Object object = translateResultWithASTs.getAst("SOURCE_AST");
                                        if (object instanceof AST) {
                                            ScratchEditorProvider.this.m_sourceWS.createWorksheetContext().getCallback().showResultPanel((WorksheetResultPanel)new ASTResultPanel((AST)object, val$id));
                                        } else if (object instanceof JPanel) {
                                            ScratchEditorProvider.this.m_sourceWS.createWorksheetContext().getCallback().showResultPanel((WorksheetResultPanel)new ASTResultPanel((JPanel)object, val$id));
                                        } else if (object instanceof CommonTree) {
                                            ScratchEditorProvider.this.m_sourceWS.createWorksheetContext().getCallback().showResultPanel((WorksheetResultPanel)new ASTResultPanel((CommonTree)object, val$id));
                                        }
                                    }
                                    if (ScratchEditorProvider.DIFF_EDITOR_CMD.equals(val$id)) {
                                        ScratchEditorProvider.this.openDiffEditor(translateResultWithASTs, val$ctx);
                                    }
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.log(Level.WARNING, interruptedException.getLocalizedMessage());
                    }
                    catch (ExecutionException executionException) {
                        LOGGER.log(Level.WARNING, executionException.getLocalizedMessage());
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        } else if (string.equals(UTILS_CMD)) {
            final String string2 = TranslationAPI.getEmulationPackage((String)ParserSetting.getParserString());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (string2 != null) {
                        ScratchEditorProvider.this.m_targetWS.createWorksheetContext().getEditor().setText(string2);
                    } else {
                        ScratchEditorProvider.this.m_targetWS.createWorksheetContext().getEditor().setText("--" + SEMessages.getString("UtilsMissing"));
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        return null;
    }

    protected TranslateResultWithASTs translate(String string, SchemaDetails schemaDetails) {
        TranslateResultWithASTs translateResultWithASTs = null;
        try {
            if (schemaDetails != null && !schemaDetails.getLabel().equals("")) {
                translateResultWithASTs = RepoTranslationAPI.translate((String)string, (SchemaDetails)schemaDetails, (PersistenceManager)this.getPersistenceManager(), (String)ParserSetting.getParserString());
            } else {
                TranslationPreferences translationPreferences = TranslationContext.getStaticTranslationPreferences(null);
                translateResultWithASTs = TranslationAPI.translate((String)string, (String)ParserSetting.getParserString(), (TranslationPreferences)translationPreferences, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)throwable.getLocalizedMessage(), (String)SEMessages.getString("CompareInitiator.1"), null);
        }
        return translateResultWithASTs;
    }

    protected String generateFingerprint(String string, SchemaDetails schemaDetails) {
        Fingerprint fingerprint = null;
        try {
            fingerprint = TranslationAPI.generateFingerprint((String)string, (String)ParserSetting.getParserString());
        }
        catch (TranslationException translationException) {
            translationException.printStackTrace();
        }
        return fingerprint.getFingerprint();
    }

    public WorksheetAction getActionAt(int n) {
        return m_actions.get(n);
    }

    public int getActionsCount() {
        return m_actions.size();
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public int getPanelCount() {
        return 0;
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        return true;
    }

    private PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    private void openDiffEditor(TranslateResultWithASTs translateResultWithASTs, WorksheetContext worksheetContext) {
        if (translateResultWithASTs == null || translateResultWithASTs.getHelper() == null) {
            return;
        }
        View view = this.m_targetWS.getViewWithoutDecoration();
        if (view == null) {
            return;
        }
        String string = worksheetContext.getEditor().getText();
        String string2 = this.m_targetWS.createWorksheetContext().getEditor().getText();
        String string3 = "Oracle Diff";
        if (string2 == null || string2.length() == 0) {
            return;
        }
        boolean bl = true;
        Object var8_8 = null;
        ZebraNode zebraNode = new ZebraNode(URLFactory.newFileURL((String)string3), "TSQL", "PL/SQL");
        Context context = Context.newIdeContext((Node)zebraNode);
        context.setProperty("zebra.file1String", (Object)string);
        context.setProperty("zebra.file2String", (Object)string2);
        context.setProperty("zebra.ignoreWS", (Object)bl);
        context.setProperty("zebra.ancestorFile", var8_8);
        context.setProperty("zebra.algorithmEngine", (Object)translateResultWithASTs.getHelper().getCodeBlockManager().getTopBlock());
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        EditorManager.getEditorManager().openEditor(openEditorOptions);
    }
}

