/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.dbtools.migration.gui.SQLObjPinProvider;
import oracle.dbtools.migration.gui.SQLObjSaveProvider;
import oracle.dbtools.migration.gui.TargetWorksheet;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.extension.WorksheetHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.javatools.icons.OracleIcons;

public final class SQLObjTargetWorksheet
extends TargetWorksheet {
    private static final Logger LOGGER = Logger.getLogger(Worksheet.class.getName());
    private ViewerNode m_viewerNode = null;
    private boolean m_isPinned = false;
    private ToggleToolButton m_pinToggle;

    public SQLObjTargetWorksheet() {
        this.getFocusedEditorPane().getDocument().addDocumentListener(this.m_textListener);
    }

    protected void initActions() {
        ActionProvider actionProvider;
        SQLObjPinProvider sQLObjPinProvider = new SQLObjPinProvider(this);
        this.setToolBarAndMenuActions(sQLObjPinProvider);
        Iterator iterator = WorksheetHook.getProviders();
        while (iterator.hasNext()) {
            try {
                actionProvider = (ActionProvider)((MetaClass)iterator.next()).newInstance();
                if (actionProvider.getClass().getName().equals("oracle.dbtools.worksheet.commands.TransactionControlProvider")) {
                    actionProvider = new SQLObjSaveProvider(this);
                } else if (actionProvider.getClass().getName().equals("oracle.dbtools.raptor.timesten.advisor.IndexAdvisorProvider")) continue;
                this.m_providers.add(actionProvider);
                int n = actionProvider.getActionsCount();
                for (int i = 0; i < n; ++i) {
                    WorksheetAction.ActionType actionType;
                    WorksheetAction worksheetAction = actionProvider.getActionAt(i);
                    for (String string : actionType = worksheetAction.getIds()) {
                        this.m_idMap.put(string, actionProvider);
                        IdeAction ideAction = worksheetAction.getIdeAction(string);
                        this.m_actionMap.put(string, ideAction);
                    }
                    WorksheetAction.ActionType actionType2 = worksheetAction.getType();
                    if (actionType2.isToolbarAction()) {
                        this.m_toolbarActions.add(worksheetAction);
                    }
                    if (!actionType2.isContextMenuAction()) continue;
                    this.m_ctxMenuActions.add(worksheetAction);
                }
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
            }
        }
        iterator = IdeAction.find((int)73);
        if (iterator != null) {
            iterator.addController(this.m_controller);
        }
        if ((actionProvider = IdeAction.find((int)74)) != null) {
            actionProvider.addController(this.m_controller);
        }
        IdeAction ideAction = IdeAction.get((int)81);
    }

    public void setToolBarAndMenuActions(ActionProvider<?> actionProvider) {
        int n = actionProvider.getActionsCount();
        for (int i = 0; i < n; ++i) {
            WorksheetAction.ActionType actionType;
            WorksheetAction worksheetAction = actionProvider.getActionAt(i);
            for (String string : actionType = worksheetAction.getIds()) {
                this.m_idMap.put(string, actionProvider);
                IdeAction ideAction = worksheetAction.getIdeAction(string);
                this.m_actionMap.put(string, ideAction);
            }
            WorksheetAction.ActionType actionType2 = worksheetAction.getType();
            if (actionType2.isToolbarAction()) {
                this.m_toolbarActions.add(worksheetAction);
            }
            if (!actionType2.isContextMenuAction()) continue;
            this.m_ctxMenuActions.add(worksheetAction);
        }
    }

    protected void addButtons(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equals("ScratchEditor.PinSQLObj")) {
            Icon icon = this.m_isPinned ? RaptorImagesArb.getIcon((String)"PINNED") : OracleIcons.getIcon((String)"pin.png");
            ToggleAction toggleAction = new ToggleAction(Messages.getString((String)"AbstractWorksheetResultPanel.1"), icon){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    Icon icon = SQLObjTargetWorksheet.this.m_isPinned ? OracleIcons.getIcon((String)"pin.png") : RaptorImagesArb.getIcon((String)"PINNED");
                    SQLObjTargetWorksheet.this.m_pinToggle.setIcon(icon);
                    SQLObjTargetWorksheet.this.m_isPinned = !SQLObjTargetWorksheet.this.m_isPinned;
                    this.setState(SQLObjTargetWorksheet.this.isPinned());
                    SQLObjTargetWorksheet.this.m_viewerNode.setPinned(SQLObjTargetWorksheet.this.m_isPinned);
                }
            };
            toggleAction.setName(toggleAction.getValue("Name").toString());
            this.m_pinToggle = this.m_toolbar.addToggleButton(toggleAction);
            toggleAction.setState(this.isPinned());
            this.m_pinToggle.setIcon(icon);
            return;
        }
        super.addButtons(stringArray);
    }

    public boolean isPinned() {
        return this.m_isPinned;
    }

    public ViewerNode getViewerNode() {
        return this.m_viewerNode;
    }

    public void setViewerNode(ViewerNode viewerNode) {
        this.m_viewerNode = viewerNode;
    }
}

