/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.gui.SQLObjTargetWorksheet;
import oracle.dbtools.migration.gui.ScratchWorksheetNode;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.MigrationOverlayClient;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Resource;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.extension.WorksheetNode;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public abstract class AScratchWorksheet
extends Worksheet {
    private static final Logger LOGGER = Logger.getLogger(AScratchWorksheet.class.getName());
    private Node m_node = null;
    private PersistableObject m_po = null;
    protected boolean m_textChanged = false;
    protected String m_savedSQL = "";
    protected DocumentListener m_textListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AScratchWorksheet.this.m_textChanged = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AScratchWorksheet.this.m_textChanged = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };

    protected void initContext() {
        Context context = Context.newIdeContext((View)this.getViewWithoutDecoration());
        this.m_node = AScratchWorksheet.getTempNode();
        context.setNode(this.m_node);
        this.setContext(context);
    }

    public Node getNode() {
        return this.m_node;
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            Node node = context.getNode();
            this.m_node = node instanceof WorksheetNode ? (WorksheetNode)node : null;
        }
    }

    public static WorksheetNode getTempNode() {
        ScratchWorksheetNode scratchWorksheetNode = null;
        try {
            File file = File.createTempFile("wks", ".worksheet", Resource.RAPTOR_USER_TEMP);
            file.deleteOnExit();
            scratchWorksheetNode = new ScratchWorksheetNode(file.toURL());
            scratchWorksheetNode.setConnectionName("");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return scratchWorksheetNode;
    }

    public PersistableObject getPersistedObject() {
        return this.m_po;
    }

    public void setPersistedObject(PersistableObject persistableObject) {
        this.m_po = persistableObject;
    }

    public String getSQL() {
        return this.m_savedSQL;
    }

    public void setSQL(String string) {
        this.m_savedSQL = string;
    }

    public boolean isSavedSQL() {
        String string = this.getFocusedEditorPane().getText();
        string = string.replaceAll("\\r\\n|\\r", "\n");
        String string2 = this.m_savedSQL.replaceAll("\\r\\n|\\r", "\n");
        return string.equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSQLObj(String string) {
        if (this.m_po != null) {
            Connection connection = MigrationAddin.getPersistenceManager().getConn();
            PreparedStatement preparedStatement = null;
            String string2 = this.m_po.getObjectType();
            String string3 = "UPDATE ";
            if (string2.equals("MD_VIEWS")) {
                string3 = string3 + "MD_VIEWS";
            } else if (string2.equals("MD_STORED_PROGRAMS")) {
                string3 = string3 + "MD_STORED_PROGRAMS";
            } else if (string2.equals("MD_TRIGGERS")) {
                string3 = string3 + "MD_TRIGGERS";
            }
            string3 = string3 + " SET NATIVE_SQL = ?";
            string3 = string3 + ", LANGUAGE = '";
            string3 = string3 + "OracleSQL'";
            string3 = string3 + " WHERE ID = ?";
            if (Connections.getInstance().lock(connection)) {
                try {
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, this.m_po.getKey().getId());
                    preparedStatement.execute();
                    connection.commit();
                    this.setSQL(string);
                    this.updateVisibleActions();
                    if (this instanceof SQLObjTargetWorksheet) {
                        ViewerNode viewerNode = ((SQLObjTargetWorksheet)this).getViewerNode();
                        CapturedNode capturedNode = (CapturedNode)viewerNode.getBaseNode();
                        if (Boolean.parseBoolean((String)capturedNode.getProperty("NOT_CONVERTED"))) {
                            capturedNode.setProperty("NOT_CONVERTED", (Object)Boolean.FALSE.toString());
                        }
                        if (Boolean.parseBoolean((String)capturedNode.getProperty("INVALID"))) {
                            capturedNode.setProperty("INVALID", (Object)Boolean.FALSE.toString());
                        }
                        MigrationOverlayClient.updateOverlay((Element)capturedNode);
                    }
                }
                catch (Exception exception) {
                    String string4 = exception.getMessage();
                    LOGGER.log(Level.WARNING, string4);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_translationscratchedit_html");
    }
}

