/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import org.openide.util.ImageUtilities;

final class AttentionSupport {
    private static Image imgLeft;
    private static Image imgCenter;
    private static Image imgRight;
    private static int leftWidth;
    private static int rightWidth;
    private static boolean imagesLoaded;

    AttentionSupport() {
    }

    static void paintAttention(Graphics g, int x, int y, int width, int height) {
        AttentionSupport.initImages();
        if (null == imgLeft || null == imgRight || null == imgCenter) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (width > leftWidth + rightWidth) {
            g2d.drawImage(imgLeft, x, y, leftWidth, height, null);
            g2d.drawImage(imgCenter, x + leftWidth, y, width - leftWidth - rightWidth, height, null);
            g2d.drawImage(imgRight, width - rightWidth, y, rightWidth, height, null);
        } else {
            g2d.drawImage(imgCenter, x, y, width, height, null);
        }
    }

    private static void initImages() {
        if (imagesLoaded) {
            return;
        }
        imgLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/attention/tab-left.png");
        imgRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/attention/tab-right.png");
        imgCenter = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/attention/tab-center.png");
        leftWidth = null == imgLeft ? 0 : imgLeft.getWidth(null);
        rightWidth = null == imgRight ? 0 : imgRight.getWidth(null);
    }

    static {
        imagesLoaded = false;
    }
}

