/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbEmptyFS;
import com.oracle.jdeveloper.nbwindowsystem.NbMenubar;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import oracle.ide.controller.MenuCustomizationsHelper;
import oracle.ide.controller.MenuManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.util.Enumerations;

public class NbMenuBarFS
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Attr,
AbstractFileSystem.Info {
    private static final Logger LOG = Logger.getLogger(NbMenuBarFS.class.getName());
    private static String[] SUP_ATTRS = new String[]{"displayName", "instanceCreate", "instanceClass", "position", "property-prefix", "jdev.resolve-section-mnemonics"};
    private NbMenubar bar;
    private Date created = new Date();
    private static Map<String, String> jDev2NbFolderMapping = new HashMap<String, String>(1);

    public NbMenuBarFS() {
        this.list = NbEmptyFS.DEFAULT;
        this.attr = NbEmptyFS.DEFAULT;
        this.info = NbEmptyFS.DEFAULT;
    }

    void assignMenuBar(NbMenubar bar) {
        this.bar = bar;
        this.list = this;
        this.attr = this;
        this.info = this;
        this.refresh(true);
    }

    public String getDisplayName() {
        return "";
    }

    public boolean isReadOnly() {
        return true;
    }

    public String[] children(String path) {
        JComponent item;
        if (path.equals("")) {
            return new String[]{"Menu", "Actions"};
        }
        if ("Menu".equals(path) && this.bar != null) {
            ArrayList<String> arr = new ArrayList<String>();
            for (NbMenubar.NbMenu m : this.bar.menus()) {
                if (!m.isVisible()) continue;
                if (!this.bar.isMenuCmpAccepted(m)) {
                    String menuId = NbMenuBarFS.id(m, null, true);
                    arr.add(menuId + "_hidden");
                    continue;
                }
                String id = NbMenuBarFS.id(m, null, true);
                arr.add(id);
                if (m.getClientProperty(ContainerRefresh.class) != null) continue;
                ContainerRefresh cntnr = new ContainerRefresh("Menu/" + id);
                m.putClientProperty(ContainerRefresh.class, cntnr);
                m.getPopupMenu().addContainerListener(cntnr);
            }
            String[] hiddenNbMenus = this.hiddenNbMenus(path);
            if (hiddenNbMenus != null) {
                arr.addAll(Arrays.asList(hiddenNbMenus));
            }
            return arr.toArray(new String[0]);
        }
        if (path.startsWith("Menu/") && this.bar != null && (item = NbMenuBarFS.find(this.bar, path.substring(5))) instanceof NbMenubar.NbMenu) {
            NbMenubar.NbMenu m = (NbMenubar.NbMenu)item;
            LOG.log(Level.FINE, "Processing {0} for {1}", new Object[]{path, m.getText()});
            ArrayList<String> arr = new ArrayList<String>();
            this.sortContainer(m, arr);
            LOG.log(Level.FINE, "Returning {0} components", arr.size());
            return arr.toArray(new String[0]);
        }
        if (path.startsWith("Actions")) {
            return this.hiddenNbActions(path);
        }
        return null;
    }

    private String[] hiddenNbMenus(String path) {
        HashSet<String> set = new HashSet<String>();
        for (String id : MenuCustomizationsHelper.hiddenActionAndMenuIds()) {
            String rest;
            int idx;
            if (!id.startsWith(path + '/') || (idx = (rest = id.substring(path.length() + 1)).indexOf(47)) != -1 || rest.isEmpty()) continue;
            set.add(rest + "_hidden");
        }
        if (!set.isEmpty()) {
            return set.toArray(new String[0]);
        }
        return null;
    }

    private String[] hiddenNbActions(String path) {
        HashSet<String> set = new HashSet<String>();
        for (String id : MenuCustomizationsHelper.hiddenActionAndMenuIds()) {
            if (!id.startsWith(path + '/')) continue;
            String rest = id.substring(path.length() + 1);
            int idx = rest.indexOf(47);
            if (idx == -1) {
                set.add(rest + ".instance_hidden");
                set.add(rest + ".shadow_hidden");
            }
            if (idx == -1 || rest.length() <= idx) continue;
            set.add(rest.substring(0, idx));
        }
        if (!set.isEmpty()) {
            return set.toArray(new String[0]);
        }
        return null;
    }

    private static String id(Component item, int[] counter, boolean escapeSlashes) {
        String id = NbMenuBarFS.idImpl(item, counter);
        return escapeSlashes ? id.replace('/', '_') : id;
    }

    private static String idImpl(Component item, int[] counter) {
        NbMenubar.NbMenu m;
        String nbFolderName;
        if (item instanceof JSeparator) {
            counter[0] = counter[0] + 1;
            return "JSeparator-" + counter[0] + ".instance";
        }
        String base = null;
        if (item instanceof JComponent) {
            // empty if block
        }
        if (base == null && item instanceof NbMenubar.NbMenu && null != (nbFolderName = jDev2NbFolderMapping.get(base = MenuManager.getMenuId((JMenu)(m = (NbMenubar.NbMenu)item))))) {
            return nbFolderName;
        }
        if (base == null && item instanceof JMenuItem) {
            base = ((JMenuItem)item).getText();
        }
        if (item instanceof JMenu && !NbMenubar.isDirect((JMenu)item)) {
            return base;
        }
        if (item instanceof JMenuItem) {
            return base + ".instance";
        }
        return item.toString();
    }

    private static JComponent find(NbMenubar from, String name) {
        ArrayList<Component> arr = new ArrayList<NbMenubar.NbMenu>(from.menus());
        Component at = null;
        block0: for (String n : name.split("/")) {
            int[] counter = new int[1];
            for (Component component : arr) {
                String id = NbMenuBarFS.id(component, counter, true);
                if (!n.equals(id)) continue;
                at = component;
                if (!(component instanceof NbMenubar.NbMenu) || !NbMenubar.isSpecial((NbMenubar.NbMenu)component)) continue block0;
                NbMenubar.NbMenu m = (NbMenubar.NbMenu)component;
                arr = new ArrayList<Component>(m.children());
                continue block0;
            }
            return null;
        }
        return at instanceof JComponent ? (JComponent)at : null;
    }

    public Object readAttribute(String path, String attr) {
        if (attr.equals("instanceCreate") && path.startsWith("Menu/") && path.endsWith(".instance")) {
            JComponent item = NbMenuBarFS.find(this.bar, path.substring(5));
            if (item == null) {
                if (path.contains("JSeparator-")) {
                    return new JSeparator();
                }
                return null;
            }
            return item;
        }
        if (attr.equals("instanceClass") && path.startsWith("Menu/") && path.endsWith(".instance")) {
            JComponent item = NbMenuBarFS.find(this.bar, path.substring(5));
            if (item instanceof JMenuItem) {
                return JMenuItem.class.getName();
            }
            return JSeparator.class.getName();
        }
        if (attr.equals("position") && path.startsWith("Menu/")) {
            JComponent item = NbMenuBarFS.find(this.bar, path.substring(5));
            if (item == null) {
                return null;
            }
            Object pos = item.getClientProperty("position");
            if (pos != null) {
                return pos;
            }
            Object obj = item.getClientProperty("menu-weight");
            if (!(obj instanceof Number)) {
                return null;
            }
            float f = ((Number)obj).floatValue();
            if (f == Float.MAX_VALUE) {
                return 1000.0 * (double)f;
            }
            return 100.0 * (double)f;
        }
        if (attr.equals("displayName") && path.startsWith("Menu/")) {
            NbMenubar.NbMenu m;
            int p;
            String ret;
            JComponent item = NbMenuBarFS.find(this.bar, path.substring(5));
            String string = ret = item instanceof JMenuItem ? ((JMenuItem)item).getText() : null;
            if (ret != null && item instanceof NbMenubar.NbMenu && (p = (m = (NbMenubar.NbMenu)item).getDisplayedMnemonicIndex()) >= 0) {
                StringBuilder sb = new StringBuilder(ret);
                sb.insert(p, '&');
                ret = sb.toString();
            }
            return ret;
        }
        if (attr.equals("property-prefix")) {
            return "jdev.";
        }
        if (attr.equals("jdev.resolve-section-mnemonics") && path.startsWith("Menu/")) {
            JComponent item = NbMenuBarFS.find(this.bar, path.substring(5));
            return item == null ? null : item.getClientProperty("resolve-section-mnemonics");
        }
        return null;
    }

    public void writeAttribute(String string, String string1, Object o) throws IOException {
        throw new IOException();
    }

    public Enumeration<String> attributes(String string) {
        return Enumerations.array((Object[])SUP_ATTRS);
    }

    public void renameAttributes(String string, String string1) {
    }

    public void deleteAttributes(String string) {
    }

    public Date lastModified(String string) {
        return this.created;
    }

    public boolean folder(String path) {
        return !path.endsWith(".instance");
    }

    public boolean readOnly(String string) {
        return true;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        return 0L;
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        throw new FileNotFoundException();
    }

    public OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    public void lock(String string) throws IOException {
        throw new IOException();
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    private void sortContainer(NbMenubar.NbMenu container, Collection<String> arr) {
        int[] cnt = new int[]{0};
        for (Component component : container.children()) {
            if (!this.bar.isMenuCmpAccepted(component)) continue;
            String id = NbMenuBarFS.id(component, cnt, true);
            arr.add(id);
        }
    }

    static {
        jDev2NbFolderMapping.put("NbConfigureWindow", "ConfigureWindow");
    }

    private class ContainerRefresh
    implements ContainerListener {
        private final String path;

        public ContainerRefresh(String path) {
            this.path = path;
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            NbMenuBarFS.this.refreshResource(this.path, true);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            NbMenuBarFS.this.refreshResource(this.path, true);
        }
    }
}

