/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.docking.DockableFactory;
import oracle.ideimpl.docking.DockableFactoryHook;
import oracle.javatools.util.WeightedList;

final class FactoriesRegistry {
    private Map<String, DockableFactory> _dockableFactories = new HashMap<String, DockableFactory>();
    private WeightedList<String> _dockableFactoriesNames = new WeightedList(5);

    FactoriesRegistry() {
    }

    void registerDockableFactory(String viewTypeId, DockableFactory factory, double priority) {
        this._dockableFactories.put(viewTypeId, factory);
        this._dockableFactoriesNames.add((Object)viewTypeId, priority);
    }

    void unregisterDockableFactory(String viewTypeId) {
        this._dockableFactories.remove(viewTypeId);
        this._dockableFactoriesNames.remove((Object)viewTypeId);
    }

    public DockableFactory getFactory(String viewTypeId) {
        DockableFactoryHook.get().ensureDockableFactoryLoaded(viewTypeId);
        DockableFactory factory = this._dockableFactories.get(viewTypeId);
        return factory;
    }

    List<String> getDockableFactoriesNames() {
        ArrayList<String> names = new ArrayList<String>((Collection<String>)this._dockableFactoriesNames);
        return names;
    }

    List<DockableFactory> getCurrentlyLoadedDockableFactories() {
        return new ArrayList<DockableFactory>(this._dockableFactories.values());
    }
}

