/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

enum DockableOrientation {
    North,
    East,
    South,
    West,
    Tabbed;


    static DockableOrientation fromInt(int orientation) {
        switch (orientation) {
            case 0: {
                return West;
            }
            case 1: {
                return East;
            }
            case 2: {
                return North;
            }
            case 3: {
                return South;
            }
            case 4: {
                return Tabbed;
            }
            case 8: {
                return Tabbed;
            }
            case -1: {
                return Tabbed;
            }
        }
        throw new IllegalArgumentException("Unsupported dockable orientation: " + orientation);
    }

    static DockableOrientation fromString(String orientation) {
        switch (orientation) {
            case "west": {
                return West;
            }
            case "east": {
                return East;
            }
            case "north": {
                return North;
            }
            case "south": {
                return South;
            }
            case "center": {
                return Tabbed;
            }
            case "hosted": {
                return Tabbed;
            }
        }
        throw new IllegalArgumentException("Unsupported dockable orientation: " + orientation);
    }

    String toDefaultModeName() {
        switch (this) {
            case North: {
                return "north";
            }
            case East: {
                return "east";
            }
            case South: {
                return "south";
            }
            case West: {
                return "west";
            }
        }
        return null;
    }
}

