/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.patch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.patch.PatchContext;
import oracle.javatools.patch.PatchContributor;
import oracle.javatools.patch.PatchCreateOptions;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchMatchOptions;
import oracle.javatools.patch.PatchModel;
import oracle.javatools.patch.PatchStreamContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.patch.PatchAssistanceManager;

public class PatchUtil {
    public static URL getOperationWorkingDirectoryURL(URL[] urls) {
        if (urls.length <= 0) {
            return null;
        }
        if (urls.length == 1) {
            return URLFileSystem.isDirectoryPath((URL)urls[0]) ? urls[0] : URLFileSystem.getParent((URL)urls[0]);
        }
        URL operationWorkingDirectoryUrl = null;
        for (int i = 0; i < urls.length; ++i) {
            URL parentDirectoryUrl = URLFileSystem.getParent((URL)urls[i]);
            if (i <= 0) {
                operationWorkingDirectoryUrl = parentDirectoryUrl;
                continue;
            }
            if (URLFileSystem.equals((URL)operationWorkingDirectoryUrl, (URL)parentDirectoryUrl)) continue;
            return null;
        }
        return operationWorkingDirectoryUrl;
    }

    public static String generatePatch(URL prvUrl, URL url) throws Exception {
        PatchCreateOptions createOptions = new PatchCreateOptions();
        createOptions.setRecursive(false);
        createOptions.setIncludeNewFiles(false);
        createOptions.setIgnoreWhitespace(false);
        File from = new File(prvUrl.getPath());
        File to = new File(url.getPath());
        PatchContributor fromCont = new PatchContributor(from.getParentFile(), from.getName());
        PatchContributor toCont = new PatchContributor(to.getParentFile(), to.getName());
        PatchEngine patchEngine = new PatchEngine(toCont);
        PatchModel patchModel = patchEngine.createModel(fromCont, createOptions);
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(StreamDecoder.getDefaultEncoding((URL)url));
        String patchSource = patchFormat.format(patchModel);
        return patchSource;
    }

    public static byte[] generatePatch(InputStream fromIO, InputStream toIO, String type, String encoding) throws Exception {
        PatchStreamContributor fromStream = new PatchStreamContributor(fromIO);
        PatchStreamContributor toStream = new PatchStreamContributor(toIO);
        fromStream.setType(type);
        toStream.setType(type);
        PatchCreateOptions createOptions = new PatchCreateOptions();
        createOptions.setRecursive(false);
        createOptions.setIncludeNewFiles(false);
        createOptions.setIgnoreWhitespace(false);
        PatchEngine patchEngine = new PatchEngine(toStream);
        PatchModel patchModel = patchEngine.createModel(fromStream, createOptions);
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(encoding);
        return patchFormat.formatByte(patchModel);
    }

    public static byte[] applyReversePatch(byte[] patch, InputStream is, String encoding) throws ParseException, IOException {
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(encoding);
        PatchModel model = patchFormat.parse(patch, true, PatchAssistanceManager.getAssistance(patch));
        PatchStreamContributor toStream = new PatchStreamContributor(is);
        PatchEngine engine = new PatchEngine(toStream);
        PatchMatchOptions options = new PatchMatchOptions();
        options.setIgnoreWhitespace(false);
        options.setMaximumFuzzFactor(0);
        options.setPrefixSlashNumber(0);
        PatchModel reverseModel = engine.reverseModel(model, null);
        PatchContext pContext = engine.matchModelNoFiles(reverseModel, options);
        return engine.applyModelNoFiles(reverseModel, pContext);
    }

    public static boolean isPatch(String patchFile) {
        Path path = Paths.get(patchFile, new String[0]);
        try {
            byte[] patch = Files.readAllBytes(path);
            PatchFormat patchFormat = new PatchFormat();
            PatchModel model = patchFormat.parse(patch, true, PatchAssistanceManager.getAssistance(patch));
            if (model.getEntries().length >= 0) {
                return model.getEntries()[0].getHunks().length > 0;
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (ParseException e) {
            return false;
        }
        return false;
    }
}

