/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MSAccessXMLExporterFileParser {
    private static final String VERSION_2000 = "MS Access 2000";
    private static final String VERSION_1997 = "MS Access 97";
    private static final String VERSION_2002 = "MS Access 2002";
    private static final String VERSION_2003 = "MS Access 2003";
    private static final String VERSION_2007 = "MS Access 2007";
    public static final String MY_LANGUAGE_ID = "MSAccessSQL";
    private String _filePath;
    private XMLDocument _xmlDocument;
    private Node _rootNode;
    private CaptureContext _context;
    private int m_uaMask;
    private MigrationStorer m_storer;
    private Hashtable<AccessId, DBObjectId> m_IdCache;
    private HashMap<String, Integer> m_schemaNameCount;

    public MSAccessXMLExporterFileParser(String string, MigrationStorer migrationStorer, CaptureContext captureContext) {
        this._filePath = string;
        this._context = captureContext;
        this.m_storer = migrationStorer;
        this.m_IdCache = new Hashtable();
        this.m_schemaNameCount = new HashMap();
    }

    public boolean loadFile() {
        CaptureEvent captureEvent = new CaptureEvent(6, "", MigrationAddinArb.getString((String)"START_CAPTURE"));
        this._context.getAudience().fireListeners(captureEvent);
        if (this.loadXML()) {
            captureEvent.setEventId(7);
            this._context.getAudience().fireListeners(captureEvent);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadXML() {
        FileInputStream fileInputStream = null;
        try {
            CaptureEvent captureEvent = new CaptureEvent(3, MSAccessMigrationAddinArb.getString("LOADING_XML"), this._filePath);
            this._context.getAudience().fireListeners(captureEvent);
            fileInputStream = new FileInputStream(new File(this._filePath));
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            dOMParser.parse((InputStream)fileInputStream);
            this._xmlDocument = dOMParser.getDocument();
            this._rootNode = this._xmlDocument.getElementsByTagName("DATABASES").item(0);
            captureEvent.setEventId(4);
            this._context.getAudience().fireListeners(captureEvent);
            this.capture();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void capture() {
        try {
            DBObjectId dBObjectId = (DBObjectId)this._context.getContextVariable("CONNECTIONID");
            MdCatalog mdCatalog = new MdCatalog(dBObjectId);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), "");
            mdCatalog.setDummyFlag("Y");
            this._context.getAudience().fireListeners(captureEvent);
            mdCatalog.setCatalogName("MSAccessDatabase");
            mdCatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
            captureEvent.setEventId(4);
            this._context.getAudience().fireListeners(captureEvent);
            this._context.setContextVariable("CATALOGID", (Object)mdCatalog.getKey());
            NodeList nodeList = this._rootNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                this.captureDatabase(node, this._context);
            }
            this.getStorer().commit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public int getUAValue() {
        return this.m_uaMask;
    }

    private void captureDatabase(Node node, CaptureContext captureContext) {
        if (node.getNodeName().equals("DATABASE")) {
            this.captureSchema(captureContext, node);
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"TABLES");
            this.captureTable(captureContext, XMLHelper.getChildNodes((Node)node2, (String)"TABLE"));
            Node node3 = XMLHelper.getChildNode((Node)node, (String)"USERS");
            this.captureUsers(captureContext, XMLHelper.getChildNodes((Node)node3, (String)"USER"));
            Node node4 = XMLHelper.getChildNode((Node)node, (String)"GROUPS");
            this.captureGroups(captureContext, XMLHelper.getChildNodes((Node)node4, (String)"GROUP"));
            Node node5 = XMLHelper.getChildNode((Node)node, (String)"QUERIES");
            this.captureQueries(captureContext, XMLHelper.getChildNodes((Node)node5, (String)"QUERY"));
            Node node6 = XMLHelper.getChildNode((Node)node, (String)"MODULES");
            this.captureModules(captureContext, XMLHelper.getChildNodes((Node)node6, (String)"MODULE"));
            Node node7 = XMLHelper.getChildNode((Node)node, (String)"RELATIONS");
            this.captureRelations(captureContext, XMLHelper.getChildNodes((Node)node7, (String)"RELATION"));
        }
    }

    private void captureSchema(CaptureContext captureContext, Node node) {
        try {
            Integer n;
            Integer n2;
            String string = XMLHelper.getNodeValue((Node)node, (String)"DBNAME");
            String string2 = XMLHelper.getNodeValue((Node)node, (String)"DBUSER");
            String string3 = XMLHelper.getNodeValue((Node)node, (String)"DBPASSWORD");
            String string4 = XMLHelper.getNodeValue((Node)node, (String)"ACCESSVERSION");
            this.m_uaMask = MSAccessXMLExporterFileParser.toUAValue(string4);
            CaptureAudience captureAudience = captureContext.getAudience();
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            boolean bl = false;
            if (this.m_schemaNameCount.containsKey(string)) {
                n2 = this.m_schemaNameCount.get(string);
                this.m_schemaNameCount.put(string, n2 + 1);
                bl = true;
            } else {
                this.m_schemaNameCount.put(string, 0);
            }
            n2 = new MdSchema(dBObjectId);
            if (bl) {
                n = this.m_schemaNameCount.get(string);
                n2.setName(string + "_" + n.toString());
            } else {
                n2.setName(string);
            }
            n = new AdditionalProperty(MSAccessMigrationAddinArb.getString("ACCESS_DB_USER"), string2);
            n2.addProperty((AdditionalProperty)n, dBObjectId2);
            AdditionalProperty additionalProperty = new AdditionalProperty(MSAccessMigrationAddinArb.getString("ACCESS_DB_PASSWORD"), string3);
            n2.addProperty(additionalProperty, dBObjectId2);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), n2.getName());
            captureAudience.fireListeners(captureEvent);
            n2 = (MdSchema)this.getStorer().storeObject((PersistableObject)n2);
            captureEvent.setEventId(4);
            captureAudience.fireListeners(captureEvent);
            captureContext.setContextVariable("SCHEMAID", (Object)n2.getKey());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureTable(CaptureContext captureContext, XMLNode[] xMLNodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"TBLNAME");
                String string2 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"TBLID");
                String string3 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"DESCRIPTION");
                DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                MdTable mdTable = new MdTable(dBObjectId2, string, "[" + string + "]");
                mdTable.addProperty(new AdditionalProperty(MSAccessMigrationAddinArb.getString("ACCESS_TABLE_ID"), string2), dBObjectId);
                if (string3 != null && string3.length() > 0) {
                    mdTable.setComments(string3);
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), mdTable.getTableName());
                captureAudience.fireListeners(captureEvent);
                mdTable = (MdTable)this.getStorer().storeObject((PersistableObject)mdTable);
                this.m_IdCache.put(new AccessId(string2, "MD_TABLES"), mdTable.getKey());
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
                this.captureTableDetails(captureContext, mdTable, (Node)xMLNodeArray[i]);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureTableDetails(CaptureContext captureContext, MdTable mdTable, Node node) {
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"COLUMNS");
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node2, (String)"COLUMN");
        this.captureColumnDetails(captureContext, mdTable, (Node[])xMLNodeArray);
        Node node3 = XMLHelper.getChildNode((Node)node, (String)"INDEXES");
        XMLNode[] xMLNodeArray2 = XMLHelper.getChildNodes((Node)node3, (String)"INDEX");
        this.captureIndexDetails(captureContext, mdTable, (Node[])xMLNodeArray2);
    }

    private void captureColumnDetails(CaptureContext captureContext, MdTable mdTable, Node[] nodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        try {
            for (int i = 0; i < nodeArray.length; ++i) {
                MdColumn mdColumn;
                Node node = nodeArray[i];
                String string = XMLHelper.getNodeValue((Node)node, (String)"COLNAME");
                String string2 = XMLHelper.getNodeValue((Node)node, (String)"COLTYPEDESC");
                String string3 = XMLHelper.getNodeValue((Node)node, (String)"COLREQUIRED");
                String string4 = XMLHelper.getNodeValue((Node)node, (String)"COLAUTOINCR");
                String string5 = XMLHelper.getNodeValue((Node)node, (String)"COLID");
                String string6 = XMLHelper.getNodeValue((Node)node, (String)"NEXTCOUNTERVALUE");
                String string7 = XMLHelper.getNodeValue((Node)node, (String)"COLTEXTSIZE");
                String string8 = XMLHelper.getNodeValue((Node)node, (String)"DEFAULTVALUE");
                String string9 = XMLHelper.getNodeValue((Node)node, (String)"COLUMNDESCRIPTION");
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                if (string4.equals("1")) {
                    long l = Long.parseLong(string6);
                    mdColumn = new MdIdentityColumn(mdTable.getKey(), string, Integer.valueOf(i + 1), l, 1L, dBObjectId);
                    mdColumn.setNullable("N");
                } else {
                    mdColumn = new MdColumn(mdTable.getKey(), string, Integer.valueOf(i + 1));
                    if (string3.equals("1")) {
                        mdColumn.setNullable("Y");
                    } else {
                        mdColumn.setNullable("N");
                    }
                }
                mdColumn.setColumnType(string2);
                if (string2.equals("Text")) {
                    mdColumn.setPrecision(Integer.valueOf(string7));
                }
                if (string8 != null && string8.length() > 0) {
                    mdColumn.setDefaultValue(string8);
                    mdColumn.addProperty(new AdditionalProperty("ACCESS_HAS_DEFAULT", "Y"), dBObjectId);
                }
                if (string9 != null && string9.length() > 0) {
                    mdColumn.setComments(string9);
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), mdColumn.getColumnName());
                captureAudience.fireListeners(captureEvent);
                mdColumn = (MdColumn)this.getStorer().storeObject((PersistableObject)mdColumn);
                this.m_IdCache.put(new AccessId(string5, "MD_COLUMNS"), mdColumn.getKey());
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureIndexDetails(CaptureContext captureContext, MdTable mdTable, Node[] nodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        try {
            for (int i = 0; i < nodeArray.length; ++i) {
                CaptureEvent captureEvent;
                MdIndexe mdIndexe;
                Node node = nodeArray[i];
                String string = XMLHelper.getNodeValue((Node)node, (String)"INDNAME");
                String string2 = XMLHelper.getNodeValue((Node)node, (String)"ISPRIMARY");
                if (string2.equals("1")) {
                    mdIndexe = new MdConstraint(mdTable.getKey(), MY_LANGUAGE_ID);
                    mdIndexe.setName(string);
                    mdIndexe.setConstraintType("PK");
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdIndexe.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdIndexe = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdIndexe);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    this.createIndexDetails(captureContext, (MdConstraint)mdIndexe, node);
                    continue;
                }
                mdIndexe = new MdIndexe(mdTable.getKey());
                mdIndexe.setIndexName(string);
                mdIndexe.setIndexType("NON_UNIQUE");
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
                captureAudience.fireListeners(captureEvent);
                mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
                this.createNonUniqueIndexDetails(captureContext, mdIndexe, node);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void createNonUniqueIndexDetails(CaptureContext captureContext, MdIndexe mdIndexe, Node node) {
        try {
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"INDEX_COLUMNS");
            XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node2, (String)"INDEX_COLUMN");
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                MdColumn mdColumn;
                XMLNode xMLNode = xMLNodeArray[i];
                String string = XMLHelper.getNodeValue((Node)xMLNode, (String)"COLNAME");
                DBObjectId dBObjectId = persistenceUtility.getIdForColumn(mdIndexe.getTableId(), string);
                MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), dBObjectId, Integer.valueOf(i + 1));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                if (!mdIndexe.getIndexType().equals("PRIMARY") || !(mdColumn = (MdColumn)persistenceUtility.loadPersistableObject(dBObjectId, "MD_COLUMNS")).getNullable().equals("Y")) continue;
                mdColumn.setNullable("N");
                mdColumn = (MdColumn)this.getStorer().storeObject((PersistableObject)mdColumn);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void createIndexDetails(CaptureContext captureContext, MdConstraint mdConstraint, Node node) {
        try {
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"INDEX_COLUMNS");
            XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node2, (String)"INDEX_COLUMN");
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                String string = XMLHelper.getNodeValue((Node)xMLNode, (String)"COLNAME");
                DBObjectId dBObjectId = persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string);
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(i + 1));
                mdConstraintDetail.setColumnId(dBObjectId);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureUsers(CaptureContext captureContext, XMLNode[] xMLNodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"USERNAME");
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                MdUser mdUser = new MdUser(dBObjectId, string);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), mdUser.getUsername());
                captureAudience.fireListeners(captureEvent);
                mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureGroups(CaptureContext captureContext, XMLNode[] xMLNodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"GRPNAME");
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                MdGroup mdGroup = new MdGroup(dBObjectId);
                mdGroup.setGroupName(string);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP"), mdGroup.getGroupName());
                captureAudience.fireListeners(captureEvent);
                mdGroup = (MdGroup)this.getStorer().storeObject((PersistableObject)mdGroup);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
                this.captureGroupDetails(captureContext, mdGroup, xMLNodeArray[i]);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureGroupDetails(CaptureContext captureContext, MdGroup mdGroup, XMLNode xMLNode) {
        try {
            CaptureAudience captureAudience = captureContext.getAudience();
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)xMLNode, (String)"GROUPUSERS");
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                XMLNode xMLNode2 = xMLNodeArray[i];
                String string = XMLHelper.getNodeValue((Node)xMLNode2, (String)"GROUPUSER");
                MdGroupMember mdGroupMember = new MdGroupMember(mdGroup.getKey());
                PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                DBObjectId dBObjectId2 = persistenceUtility.getIdForUser(dBObjectId, string);
                mdGroupMember.setUserId(dBObjectId2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP_MEMBERS"), string);
                captureAudience.fireListeners(captureEvent);
                mdGroupMember = (MdGroupMember)this.getStorer().storeObject((PersistableObject)mdGroupMember);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureQueries(CaptureContext captureContext, XMLNode[] xMLNodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"QRYNAME");
                String string2 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"DATECREATED");
                String string3 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"LASTUPDATED");
                String string4 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"QRYSQL");
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                MdView mdView = new MdView(dBObjectId, MY_LANGUAGE_ID);
                mdView.setViewName(string);
                mdView.setCreatedOn(new Date(new Long(string2)));
                mdView.setLastUpdatedOn(new Date(new Long(string3)));
                mdView.setNativeSql(string4);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdView.getViewName());
                captureAudience.fireListeners(captureEvent);
                mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureModules(CaptureContext captureContext, XMLNode[] xMLNodeArray) {
        CaptureAudience captureAudience = captureContext.getAudience();
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"MODULENAME");
                XMLNode[] xMLNodeArray2 = XMLHelper.getChildNodes((Node)xMLNodeArray[i], (String)"LINES");
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < xMLNodeArray2.length; ++j) {
                    stringBuffer.append(xMLNodeArray2[j].getTextContent());
                    stringBuffer.append('\n');
                }
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                MdStoredProgram mdStoredProgram = new MdStoredProgram(dBObjectId, MY_LANGUAGE_ID);
                mdStoredProgram.setName(string);
                mdStoredProgram.setNativeSql(stringBuffer.toString());
                mdStoredProgram.setProgramtype("PROCEDURE");
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdStoredProgram.getName());
                captureAudience.fireListeners(captureEvent);
                mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureRelations(CaptureContext captureContext, XMLNode[] xMLNodeArray) {
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"RELNAME");
                String string2 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"PARENTTBLID");
                String string3 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"CHILDTBLID");
                String string4 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"ISDELETECASCADE");
                String string5 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"ISENFORCED");
                DBObjectId dBObjectId = this.getId(string2, "MD_TABLES");
                DBObjectId dBObjectId2 = this.getId(string3, "MD_TABLES");
                MdConstraint mdConstraint = new MdConstraint(dBObjectId2, MY_LANGUAGE_ID);
                mdConstraint.setName(string);
                mdConstraint.setReftableId(dBObjectId);
                mdConstraint.setConstraintType("FOREIGN KEY");
                if (string5.equals("1") && string4.equals("1")) {
                    mdConstraint.setDeleteClause("CASCADE");
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                Node node = XMLHelper.getChildNode((Node)xMLNodeArray[i], (String)"RELATION_COLUMNS");
                this.createRelationDetails(captureContext, XMLHelper.getChildNodes((Node)node, (String)"RELATION_COLUMN"), mdConstraint);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void createRelationDetails(CaptureContext captureContext, XMLNode[] xMLNodeArray, MdConstraint mdConstraint) {
        int n = 1;
        try {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"PARENTCOLID");
                String string2 = XMLHelper.getNodeValue((Node)xMLNodeArray[i], (String)"CHILDCOLID");
                DBObjectId dBObjectId = this.getId(string, "MD_COLUMNS");
                DBObjectId dBObjectId2 = this.getId(string2, "MD_COLUMNS");
                n = this.createConstraintDetails(mdConstraint.getKey(), dBObjectId, "Y", n, captureContext);
                n = this.createConstraintDetails(mdConstraint.getKey(), dBObjectId2, "N", n, captureContext);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private int createConstraintDetails(DBObjectId dBObjectId, DBObjectId dBObjectId2, String string, int n, CaptureContext captureContext) throws PersistenceException, SQLException {
        int n2 = n;
        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(dBObjectId, Integer.valueOf(n2++));
        mdConstraintDetail.setColumnId(dBObjectId2);
        mdConstraintDetail.setRefFlag(string);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), "");
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        return n2;
    }

    private DBObjectId getId(String string, String string2) {
        AccessId accessId = new AccessId(string, string2);
        return this.m_IdCache.get(accessId);
    }

    public void setTableCellRenderer() {
    }

    private static int toUAValue(String string) {
        if (string == null) {
            return 4096;
        }
        if (string.equals(VERSION_1997)) {
            return 256;
        }
        if (string.equals(VERSION_2000)) {
            return 512;
        }
        if (string.equals(VERSION_2002)) {
            return 1024;
        }
        if (string.equals(VERSION_2003)) {
            return 2048;
        }
        if (string.equals(VERSION_2007)) {
            return 4096;
        }
        return 4096;
    }

    protected MigrationStorer getStorer() {
        return this.m_storer;
    }

    private static class AccessId {
        private String m_id;
        private String m_type;

        public AccessId(String string, String string2) {
            this.setId(string);
            this.setType(string2);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.m_id == null ? 0 : this.m_id.hashCode());
            n = 31 * n + (this.m_type == null ? 0 : this.m_type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AccessId accessId = (AccessId)object;
            if (this.m_id == null ? accessId.m_id != null : !this.m_id.equals(accessId.m_id)) {
                return false;
            }
            return !(this.m_type == null ? accessId.m_type != null : !this.m_type.equals(accessId.m_type));
        }

        public String getId() {
            return this.m_id;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setId(String string) {
            this.m_id = string;
        }

        protected void setType(String string) {
            this.m_type = string;
        }
    }
}

