/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;

public class MSAccessPreferencePanel
extends DefaultTraversablePanel {
    public static final String TITLE = MSAccessMigrationAddinArb.getString("MIGPREFS_ACCESS_OPTIONS");
    private static final long serialVersionUID = 8630362976651886497L;
    private JCheckBox m_removeLocalTablesCheckBox;

    public MSAccessPreferencePanel() {
        this.setDefaultTitle(TITLE);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, MSAccessMigrationAddinArb.getString("ACCESS_CHANGE_MDB_OPTION"), 0, 0, null, null));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add(jPanel, gridBagConstraints);
        this.m_removeLocalTablesCheckBox = new JCheckBox();
        this.m_removeLocalTablesCheckBox.setToolTipText(MSAccessMigrationAddinArb.getString("MIGPREFS_TIP_REMOVE_LOCAL_TABLES"));
        this.m_removeLocalTablesCheckBox.setText(MSAccessMigrationAddinArb.getString("MIGPREFS_REMOVE_LOCAL_TABLES"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        jPanel.add((Component)this.m_removeLocalTablesCheckBox, gridBagConstraints2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 50.0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridx = 0;
        this.add(jPanel2, gridBagConstraints3);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_migprefmsaccess_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        MigrationConfig migrationConfig = MSAccessPreferencePanel.getConfigFromContext(traversableContext);
        boolean bl = migrationConfig.getBooleanProperty("RemoveLocalTables");
        this.m_removeLocalTablesCheckBox.setSelected(bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        MigrationConfig migrationConfig = MSAccessPreferencePanel.getConfigFromContext(traversableContext);
        migrationConfig.setBooleanProperty("RemoveLocalTables", this.m_removeLocalTablesCheckBox.isSelected());
    }

    private static MigrationConfig getConfigFromContext(TraversableContext traversableContext) {
        return MigrationConfig.getInstance((PropertyStorage)traversableContext.getPropertyStorage());
    }
}

