/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.plugin.MSAccessXMLExporterFileParser;

public class MSAccessOfflineCapturer
extends AbstractOfflineCapturer {
    private MigrationStorer m_storer;
    private String m_xmlfile;
    private MSAccessXMLExporterFileParser m_parser;

    public MSAccessOfflineCapturer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    protected String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        this.m_xmlfile = string;
        ArrayList arrayList = this.getSelectedDatabaseList();
        for (String string2 : arrayList) {
            this.addDatabaseToCapture(string2);
        }
        return "MSAccess" + string;
    }

    public void cleanUp() throws OfflineCaptureException {
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        return null;
    }

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        return null;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        MdConnection mdConnection = null;
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        try {
            mdConnection = MdConnection.retrieveExistingInstance((PersistenceManager)MigrationAddin.getPersistenceManager(), (DBObjectId)dBObjectId);
            if (this.m_parser == null) {
                CapturedDatabases.getInstance().addMdConnection(mdConnection);
                this.m_parser = new MSAccessXMLExporterFileParser(this.m_xmlfile, this.m_storer, captureContext);
                this.m_parser.loadFile();
                int n = this.m_parser.getUAValue();
                MigrationAddin.getMigrationConfig().updateUACode(n);
                this.updateStatistics(mdConnection);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void captureStarting() {
        String string = this.getNextDatabase();
    }

    public String getModelName() throws CaptureException {
        return "MSAccess";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/MSAccess";
    }

    private void updateStatistics(MdConnection mdConnection) throws PersistenceException {
        PersistenceUtility persistenceUtility = this.m_storer.getPersistenceUtility();
        persistenceUtility.updateConnectionStatistics(mdConnection);
    }
}

