/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.text.MessageFormat;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.convert.ObjectTranslationList;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.plugin.Messages;

public class MSAccessConverter
extends AbstractConverter {
    public ITranslator getPlaformTranslator() {
        return ParserFactory.getParser((String)"oracle.dbtools.migration.parser.msaccess.MSAccessParserMain");
    }

    public String getDefaultValueMappingXML() {
        return "MSAccessDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject persistableObject, String string, PersistenceManager persistenceManager) throws ConvertException {
        ConvertResultImpl convertResultImpl = null;
        if (string.equals("ACCESS_HAS_DEFAULT")) {
            String string2;
            MdColumn mdColumn = (MdColumn)persistableObject;
            if (mdColumn.getColumnType().equals("VARCHAR2") || mdColumn.getColumnType().equals("BLOB")) {
                String string3 = mdColumn.getDefaultValue();
                if (string3 != null) {
                    if (string3.indexOf("'") == -1) {
                        mdColumn.setDefaultValue("'" + string3 + "'");
                    }
                    if (string3.startsWith("=")) {
                        mdColumn.setDefaultValue("");
                        Logger logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
                        String string4 = MessageFormat.format(Messages.getString("MSAccessConverter.1"), string3, mdColumn.getObjectName());
                        logger.severe(string4);
                    }
                }
            } else if (mdColumn.getColumnType().equals("DATE") && (string2 = mdColumn.getDefaultValue()) != null && !string2.trim().equals("") && string2.indexOf("#") != -1) {
                string2 = string2.replaceAll("#", "");
                string2 = string2.replaceAll("=", "");
                string2 = "'" + string2.trim() + "'";
                String string5 = MigrationAddin.getMigrationConfig().getDateOfflineDateMask();
                string2 = "TO_DATE(" + string2 + ",'" + string5 + "')";
                mdColumn.setDefaultValue(string2);
            }
            convertResultImpl = new ConvertResultImpl(persistableObject);
        }
        return convertResultImpl;
    }

    public String[] getPropertyKeyList() {
        return new String[]{"ACCESS_HAS_DEFAULT"};
    }

    public String getEmulationPkgName() {
        return "msaccess_utilities";
    }

    public ObjectTranslationList getSupportedTranslationObjects() {
        return null;
    }
}

