/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Addin;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.ide.gallery.GalleryFilter;
import oracle.ide.gallery.GalleryHandler;
import oracle.ideimpl.gallery.GalleryCustomizationsHook;
import oracle.ideimpl.gallery.GalleryElementReference;

final class GalleryCustomizationsAddin
implements Addin {
    private static final Logger LOGGER = Logger.getLogger(GalleryCustomizationsAddin.class.getName());

    GalleryCustomizationsAddin() {
    }

    public void initialize() {
        GalleryHandler.get().addGalleryFilter(new CustomizationFilter());
    }

    private class CustomizationFilter
    extends GalleryFilter {
        final Map<String, List<GalleryElementReference>> _galleryItems = new HashMap<String, List<GalleryElementReference>>();
        final Set<String> _folders = new HashSet<String>();

        public CustomizationFilter() {
            GalleryCustomizationsHook customizationsHook = GalleryCustomizationsHook.get();
            for (GalleryElementReference ref : customizationsHook.getHiddenItems()) {
                if (!this._galleryItems.containsKey(ref.getName())) {
                    this._galleryItems.put(ref.getName(), new ArrayList());
                }
                List<GalleryElementReference> list = this._galleryItems.get(ref.getName());
                list.add(ref);
            }
            this._folders.addAll(customizationsHook.getHiddenFolderNames());
        }

        @Override
        public boolean accept(ElementInfo info) {
            String className = info.getInvokableClassName();
            if (this._galleryItems.keySet().contains(className)) {
                List<GalleryElementReference> list = this._galleryItems.get(className);
                for (GalleryElementReference ref : list) {
                    String refId = ref.getId();
                    if (!(info.getId() == null ? refId == null : info.getId().equals(refId))) continue;
                    this.info(info);
                    return false;
                }
            }
            for (String s : info.getPath()) {
                if (!this._folders.contains(s)) continue;
                this.info(info);
                return false;
            }
            return true;
        }

        @Override
        public boolean accept(FolderInfo folderInfo) {
            if (this._folders.contains(folderInfo.getCategory()) || this._folders.contains(folderInfo.getName())) {
                LOGGER.log(Level.INFO, folderInfo.getName() + " gallery folder has been hidden in the active role.");
                return false;
            }
            return true;
        }

        private void info(ElementInfo info) {
            LOGGER.log(Level.INFO, info.getName() + " gallery item (name=" + info.getInvokableClassName() + ", id=" + info.getId() + ") has been hidden in the active role.");
        }
    }
}

