/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;

final class GalleryItemsListModel
extends DefaultListModel {
    final transient GalleryFolder _folder;
    final transient List<GalleryElement> _elements;

    public GalleryItemsListModel(GalleryFolder folder) {
        this._folder = folder;
        if (folder == null) {
            this._elements = Collections.emptyList();
        } else {
            this._elements = new ArrayList<GalleryElement>();
            this.refreshElements();
        }
    }

    private void refreshElements() {
        if (this._folder != null) {
            GalleryElement[] children;
            this._elements.clear();
            for (GalleryElement e : children = this._folder.getSortedElementChildren()) {
                try {
                    if (!ModelUtil.hasLength((String)e.getShortLabel())) continue;
                    this._elements.add(e);
                }
                catch (RuntimeException ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    @Override
    public int getSize() {
        return this._elements.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.get(index);
    }

    public Object get(int index) {
        if (index >= 0 && index < this._elements.size()) {
            return this._elements.get(index);
        }
        return null;
    }

    @Override
    protected void fireContentsChanged(Object source, int startIndex, int endIndex) {
        this.refreshElements();
        super.fireContentsChanged(source, startIndex, endIndex);
    }

    GalleryElement[] getGalleryElements() {
        return this._elements.toArray(new GalleryElement[this._elements.size()]);
    }
}

