/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class GalleryItemsList
extends JList {
    public GalleryItemsList() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GalleryItemsList.this.firePropertyChange("cellRenderer", null, GalleryItemsList.this.getCellRenderer());
            }
        });
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        if (this.getLayoutOrientation() == 0 && (this.getFixedCellHeight() <= 0 || this.getFixedCellWidth() <= 0) && this.getModel().getSize() > 0) {
            int visibleRowCount = this.getVisibleRowCount();
            int totalSize = this.getModel().getSize();
            Insets inset = this.getInsets();
            if (visibleRowCount <= totalSize) {
                Rectangle r = this.getCellBounds(visibleRowCount - 1, visibleRowCount - 1);
                if (r != null) {
                    size.height = r.y + r.height + inset.bottom;
                }
            } else {
                Rectangle r = this.getCellBounds(totalSize - 1, totalSize - 1);
                if (r != null) {
                    int balHeight = (visibleRowCount - totalSize) * r.height;
                    size.height = r.y + r.height + balHeight + inset.bottom;
                }
            }
        }
        return size;
    }
}

