/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIArrayElementInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;

final class DebugJDIDataArrayInfo
extends DebugJDIDataCompositeInfo
implements DebugDataArrayInfo {
    DebugJDIDataArrayInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        super(dj, clazz, value, owner);
    }

    public DebugClassInfo getArrayElementClassInfo() {
        this.throwIfExpired();
        ReferenceType rt = this.clazz.getReferenceType();
        if (rt instanceof ArrayType) {
            ArrayType at = (ArrayType)rt;
            try {
                DebugJDIClassInfo c = this.dj.findClassByType(at.componentType());
                if (c != null) {
                    return c;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.dj.findClassByName(at.componentTypeName(), true);
        }
        return null;
    }

    public int getArrayStart() {
        return 0;
    }

    public int getArrayCount() {
        return this.getArrayCount(false);
    }

    public DebugArrayElementInfo[] getArrayElements() {
        return this.getArrayElements(0, -1, false);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count) {
        return this.getArrayElements(start, count, false);
    }

    public int getArrayCount(boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null) {
            return 0;
        }
        ArrayReference ar = (ArrayReference)this.value;
        int count = 0;
        if (nonNullCompositesOnly) {
            List<Value> values = ar.getValues(0, -1);
            for (int i = 0; i < values.size(); ++i) {
                Value value = values.get(i);
                if (value == null) continue;
                ++count;
            }
        } else {
            count = ar.length();
        }
        return count;
    }

    public DebugArrayElementInfo[] getArrayElements(boolean nonNullCompositesOnly) {
        return this.getArrayElements(0, -1, nonNullCompositesOnly);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null) {
            return new DebugArrayElementInfo[0];
        }
        ArrayReference ar = (ArrayReference)this.value;
        ArrayType at = (ArrayType)ar.referenceType();
        if (at != null) {
            // empty if block
        }
        DebugJDIClassInfo clazz = (DebugJDIClassInfo)this.getArrayElementClassInfo();
        ArrayList<DebugJDIArrayElementInfo> v = new ArrayList<DebugJDIArrayElementInfo>();
        int countToGo = count;
        int entriesFoundSoFar = 0;
        if (ar.length() > 0) {
            boolean countSatisfied = false;
            while (!countSatisfied) {
                List<Value> values = ar.getValues(start, countToGo);
                for (int i = 0; i < values.size(); ++i) {
                    Value value = values.get(i);
                    if (nonNullCompositesOnly && value == null) continue;
                    DebugJDIDataInfo data = value != null ? this.dj.makeData(value, null) : this.dj.makeNullData(clazz, null);
                    v.add(new DebugJDIArrayElementInfo(this.dj, clazz, start + i, data, this));
                }
                if (v.size() >= count || count != countToGo) {
                    countSatisfied = true;
                    continue;
                }
                start = v.size() > 0 && entriesFoundSoFar != v.size() ? ((DebugArrayElementInfo)v.get(v.size() - 1)).getIndex() + 1 : (start += countToGo);
                if (start + countToGo > ar.length() && (countToGo = ar.length() - start) == 0) {
                    countSatisfied = true;
                }
                entriesFoundSoFar = v.size();
            }
            int resultSize = v.size();
            if (count != -1 && count < v.size()) {
                resultSize = count;
            }
            DebugArrayElementInfo[] array = new DebugArrayElementInfo[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                array[i] = (DebugArrayElementInfo)v.get(i);
            }
            return array;
        }
        return new DebugArrayElementInfo[0];
    }

    public DebugArrayElementInfo[] getPreviousArrayElements(int end, int count, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null) {
            return new DebugArrayElementInfo[0];
        }
        ArrayReference ar = (ArrayReference)this.value;
        ArrayType at = (ArrayType)ar.referenceType();
        if (at != null) {
            // empty if block
        }
        DebugJDIClassInfo clazz = (DebugJDIClassInfo)this.getArrayElementClassInfo();
        ArrayList<DebugJDIArrayElementInfo> v = new ArrayList<DebugJDIArrayElementInfo>();
        int countToGo = count;
        int entriesFoundSoFar = 0;
        if (ar.length() > 0) {
            int i;
            boolean countSatisfied = false;
            while (!countSatisfied) {
                int retrievalStart = Math.max(0, end - countToGo + 1);
                List<Value> values = ar.getValues(retrievalStart, countToGo);
                for (i = values.size() - 1; i >= 0; --i) {
                    Value value = values.get(i);
                    if (nonNullCompositesOnly && value == null) continue;
                    DebugJDIDataInfo data = value != null ? this.dj.makeData(value, null) : this.dj.makeNullData(clazz, null);
                    int index = retrievalStart + i;
                    v.add(0, new DebugJDIArrayElementInfo(this.dj, clazz, index, data, this));
                }
                if (v.size() >= count || count != countToGo) {
                    countSatisfied = true;
                    continue;
                }
                end = v.size() > 0 && entriesFoundSoFar != v.size() ? ((DebugArrayElementInfo)v.get(0)).getIndex() - 1 : (end -= countToGo);
                if (end - countToGo + 1 < 0 && (countToGo = end) == 0) {
                    countSatisfied = true;
                }
                entriesFoundSoFar = v.size();
            }
            int resultSize = Math.min(count, v.size());
            DebugArrayElementInfo[] array = new DebugArrayElementInfo[resultSize];
            for (i = 0; i < resultSize; ++i) {
                array[i] = (DebugArrayElementInfo)v.get(i);
            }
            return array;
        }
        return new DebugArrayElementInfo[0];
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataArrayInfo) {
            return super.equals(o);
        }
        return false;
    }
}

