/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;

class DebugJDIBreakpointFileLine
extends DebugJDIBreakpoint
implements DebugBreakpointFileLine {
    protected String filename;
    protected int line;

    DebugJDIBreakpointFileLine(DebugJDI dj, String filename, int line) {
        super(dj);
        this.filename = filename;
        this.line = line;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public void setFileLine(String filename, int line) {
        if (ModelUtil.areDifferent((Object)this.filename, (Object)filename) || this.line != line) {
            this.prepareForChange();
            this.filename = filename;
            this.line = line;
            this.afterChange();
        }
    }

    @Override
    String getClassPrepareFilter() {
        return "";
    }

    @Override
    boolean needsVerification() {
        if (this.filename.endsWith(".txt") || this.filename.endsWith(".text") || this.filename.indexOf(46) == -1) {
            return false;
        }
        return !this.filename.endsWith(".js");
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        boolean verboseDebug;
        block15: {
            verboseDebug = false;
            if (verboseDebug) {
                System.out.println("DebugJDIBreakpointFileLine.verify(" + rtName + " trying to match " + this.filename + ":" + this.line);
            }
            try {
                ArrayList<Location> locationsOfLine;
                String defaultStratum;
                block14: {
                    defaultStratum = rt.defaultStratum();
                    locationsOfLine = null;
                    try {
                        locationsOfLine = DebugJDI.getLocationsOfLine(rt, defaultStratum, this.filename, this.line);
                    }
                    catch (ClassNotPreparedException cnpe) {
                        if (verboseDebug) {
                            System.out.println(" not verified due to ClassNotPreparedException");
                        }
                        return false;
                    }
                    catch (AbsentInformationException aie) {
                        if (!verboseDebug) break block14;
                        System.out.println(" AbsentInformationException getting locations of line, will try another way");
                    }
                }
                if (locationsOfLine == null) {
                    List<Location> l = rt.allLineLocations(defaultStratum, this.filename);
                    ArrayList<Location> v = new ArrayList<Location>();
                    int size = l.size();
                    for (int i = 0; i < size; ++i) {
                        Location location = l.get(i);
                        if (DebugJDI.getLineNumber(location, defaultStratum) != this.line) continue;
                        v.add(location);
                    }
                    locationsOfLine = v;
                }
                int size = locationsOfLine.size();
                if (verboseDebug) {
                    System.out.println("locationsOfLine size " + size + " for stratum " + defaultStratum);
                }
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        Location location = (Location)locationsOfLine.get(i);
                        this.locationIdentified(location);
                    }
                    if (verboseDebug) {
                        System.out.println(" returning true");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!verboseDebug || e instanceof AbsentInformationException) break block15;
                e.printStackTrace();
            }
        }
        if (verboseDebug) {
            System.out.println(" returning false");
        }
        return false;
    }
}

