/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.OracleExtension;
import com.sun.jdi.OracleReferenceType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.awt.List;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.DebuggerLocation;
import oracle.ide.util.Assert;
import oracle.ide.util.VersionNumber;
import oracle.ideimpl.runner.MethodDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.util.Log;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManager;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManagerFactory;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointClass;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointClassLoad;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointDeadlock;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointException;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointFileLine;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethod;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethodSignature;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointWatchpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataArrayInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataPrimitiveInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIExecutionTrackingBreakpointMethod;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorInPinTable;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorInStatic;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIPinnedInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStoppedListener;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadGroupInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.CodeExecutionBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodSignature;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointProperties;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugLocationUtils;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerEngine;
import oracle.jdevimpl.debugger.support.MethodVisitationInfoRetrievalKey;
import oracle.jdevimpl.debugger.support.TargetMethod;
import oracle.jdevimpl.debugger.support.UserSelectedURLCacher;
import oracle.jdevimpl.debugger.support.XSLTDebugHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerHelperHook;
import oracle.jdevimpl.runner.debug.DebuggerLanguageHelper;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.ExecutionTrackerForVirtualMachine;
import oracle.jdevimpl.runner.debug.ExecutionTrackerImplForVirtualMachine;
import oracle.jdevimpl.runner.debug.ExecutionTrackingVM;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class DebugJDI
implements DebugVirtualMachine,
DebugCapabilities,
Runnable,
ExecutionTrackingVM {
    static final boolean MULTI_THREADED_METHOD_EVALUATIONS = System.getProperty("debugger.multithreaded.method.evaluations") != null;
    private static final String JAVA_LANG_BYTE_STRING = "java.lang.Byte";
    private static final String JAVA_LANG_CHARACTER_STRING = "java.lang.Character";
    private static final String JAVA_LANG_DOUBLE_STRING = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT_STRING = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER_STRING = "java.lang.Integer";
    private static final String JAVA_LANG_LONG_STRING = "java.lang.Long";
    private static final String JAVA_LANG_SHORT_STRING = "java.lang.Short";
    private static final String JAVA_LANG_BOOLEAN_STRING = "java.lang.Boolean";
    private static final int JAVA_LANG_BYTE_CODE = 1;
    private static final int JAVA_LANG_CHARACTER_CODE = 2;
    private static final int JAVA_LANG_DOUBLE_CODE = 3;
    private static final int JAVA_LANG_FLOAT_CODE = 4;
    private static final int JAVA_LANG_INTEGER_CODE = 5;
    private static final int JAVA_LANG_LONG_CODE = 6;
    private static final int JAVA_LANG_SHORT_CODE = 7;
    private static final int JAVA_LANG_BOOLEAN_CODE = 8;
    private static DebugJDIAnonymousBlockManagerFactory anonymousBlockManagerFactory;
    private static DebugJDIAnonymousBlockManager anonymousBlockManager;
    VirtualMachine vm;
    private boolean vmWasRunning;
    private int languages = 0;
    private LinkedHashMap<EventSet, ThreadReference> unhandledEventSets;
    private java.util.List<Object> needToResume;
    private EventQueue eq;
    EventRequestManager erm;
    private ClassUnloadRequest cur;
    private ClassPrepareRequest startCPR;
    private ThreadStartRequest startTSR;
    private Map<ThreadReference, StepRequest> startStepRequests;
    private Location stepLocation;
    private String[] stepStack;
    private StepRequest stepRequest;
    private boolean useMethodExitRequest;
    private MethodExitRequest methodExitRequestForStepToEndOfMethod;
    private Method methodExitRequestForStepToEndOfMethodMethod = null;
    private MethodExitRequest methodExitRequestForStepOut;
    boolean canGetMethodReturnValues;
    private int runCommand;
    private ThreadReference runCommandThread;
    private Thread runningThread;
    private Thread testConnectionThread;
    private java.util.List<DebugJDIBreakpoint> breakpoints;
    private Set<EventRequest> bpRequests;
    private Map<String, ClassPrepareRequest> cprsByFilter;
    private Map<ClassPrepareRequest, java.util.List<DebugJDIBreakpoint>> cprBreakpoints;
    private boolean redefineClassesOccurred;
    private Object classesLock = new Object();
    private java.util.List<DebugJDIClassInfo> classes = new ArrayList<DebugJDIClassInfo>();
    Map<ReferenceType, DebugJDIClassInfo> classesByReferenceType;
    private Map<String, Object> classesByName;
    private Map<String, Object> classesByNameWithoutPackage;
    private Set<ReferenceType> classesCollected;
    private Set<ReferenceType> classesNotCollected;
    private Set<ObjectReference> objectsCollected;
    private Set<ObjectReference> objectsNotCollected;
    private boolean debuggableClassLoaded;
    private boolean lookForAnyUnloadedClassesNeeded;
    private Map<Long, DebugJDIHeapObjectInfo> id2ObjectReference;
    private java.util.List<String> debuggable;
    private java.util.List<String> nonDebuggable;
    private Set<String> nonDebuggableClassExclusionFilters;
    private Map<ObjectReference, java.util.List<ThreadReference>> otherWaitingThreads;
    Map<ThreadReference, SoftReference<DebugJDIThreadInfo>> threadInfos;
    int stoppedCountThreadContextClassLoaders;
    Map<StackFrame, SoftReference<DebugJDIStackFrameInfo>> stackFrameInfos;
    Map classLoaderInfos;
    Map classLoaderIds;
    private ClassLoaderReference systemClassLoader;
    private DebugJDIBreakpoint currentBreakpoint;
    private DebugJDIThreadInfo currentThread;
    ThreadReference eventThread;
    private Map<Long, MethodExitEvent> threadReturnValues;
    private DebugJDIDataObjectInfo currentThrow;
    private DebugJDILocation currentThrowHandler;
    private DebugJDIDataObjectInfo watchpointObject;
    private DebugJDIFieldInfo watchpointField;
    private DebugJDIDataInfo watchpointFieldFutureValue;
    private java.util.List<ThreadReference> knownDeadlockedThreads;
    int stoppedCount;
    java.util.List<DebugJDIStoppedListener> stoppedListeners;
    private Object[] syncObjects;
    private boolean[] syncValues;
    private static final int SYNC_STOPPED = 0;
    private static final int SYNC_PAUSE_REQUESTED = 1;
    private static final int SYNC_TERMINATED = 2;
    private static final int SYNC_DISCONNECT_REQUESTED = 3;
    private static final int SYNC_TERMINATE_REQUESTED = 4;
    private static final int SYNC_CONNECTION_LOGS = 5;
    private static final int SYNC_CONNECTION_LOST = 6;
    private static final int SYNC_SYSTEM_CLASS_LOADER = 7;
    private static final int SYNC_COUNT = 8;
    private java.util.List<DebugJDIPinnedInfo> pins;
    private MessagePage logPage;
    DebugListener debugListener;
    private DebugBreakpointLogListener bpLogListener;
    private java.util.List<Object> connectionLogs;
    private static int stdErrCount;
    private static PrintStream stdErr;
    private ClassPrepareRequest prepareRequest = null;
    private DebugStackFrameInfo currentStackFrame;
    private MethodEntryRequest methodEntryRequestStepIntoMethod;
    private String stepIntoMethodName;
    private String stepIntoMethodCallerPackage;
    private String stepIntoMethodCallerFileName;
    private String stepIntoMethodCallerPath;
    private int stepIntoMethodCallerLineMin;
    private int stepIntoMethodCallerLineMax;
    private DebugJDIBreakpoint stepIntoMethodBreakpoint;
    private boolean stepIntoMethodBeingUsedForStepIntoOuter = false;
    private static final Log SIOLogger;
    private static final Log classesLogger;
    Object methodCallLock = new Object();
    MethodEvaluationWorker methodEvaluationWorker;
    private boolean breakpointsSuspended;
    private boolean cleanedUp;
    private boolean debuggeeStarted;
    private long m_aliveTime;
    private DeadlockDetector m_deadlockDetectorThread;
    private DebuggerEngine engine;
    private static int lineNumberAdjustmentValue;
    private ExecutionTrackerForVirtualMachine executionTracker;
    private CountDownLatch executionTrackingStepOverCountdownLatch;
    private Map<Long, Long[]> resumeAndStopTimes = new HashMap<Long, Long[]>();
    private static boolean ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS;
    private Map<String, DebugJDIExecutionTrackingBreakpointMethod> methodEntryBreakpoints = new HashMap<String, DebugJDIExecutionTrackingBreakpointMethod>();
    private java.util.List<DebugJDIExecutionTrackingBreakpointMethod> unsetETMethodBreakpoints = new ArrayList<DebugJDIExecutionTrackingBreakpointMethod>();
    private boolean handleAllClassPrepareEvents = false;
    private int cpeCount;
    private long cpeProcessingTime;
    private long cpeWallTime;
    private static Boolean isDebuggerBeforeJDK142;
    boolean printedClassNotPreparedWarning = false;
    private static final Set<String> plsqlJavaClasses;
    private PCL pcl;
    private Boolean isOracleDatabaseVM;
    private static boolean lastStepWasLambdaThunk;
    private static final int RunCommand_StartInto = 0;
    private static final int RunCommand_StartOver = 1;
    private static final int RunCommand_Run = 2;
    private static final int RunCommand_StepInto = 3;
    private static final int RunCommand_StepOver = 4;
    private static final int RunCommand_StepIntoBC = 5;
    private static final int RunCommand_StepOverBC = 6;
    private static final int RunCommand_StepOut = 7;
    private static final int RunCommand_StepToEndOfMethod = 8;
    private static final int RunCommand_ContinueStep = 9;
    private static final int RunCommand_StepIntoMethod = 10;
    Map<MethodVisitationInfoRetrievalKey, Map<TargetMethod, TargetMethod.VisitationTrackingInfo>> methodVisitationStateTracking = new HashMap<MethodVisitationInfoRetrievalKey, Map<TargetMethod, TargetMethod.VisitationTrackingInfo>>();
    private UserSelectedURLCacher userUrlCacher = null;

    DebugJDI(VirtualMachine vm, DebuggerEngine engine) {
        String allowMEBP;
        VersionNumber versionNumber;
        this.engine = engine;
        this.initSync();
        this.unhandledEventSets = new LinkedHashMap();
        this.needToResume = new ArrayList<Object>();
        this.stoppedCount = 0;
        this.stoppedListeners = new ArrayList<DebugJDIStoppedListener>();
        this.breakpoints = new ArrayList<DebugJDIBreakpoint>();
        this.bpRequests = new HashSet<EventRequest>();
        this.cprsByFilter = new HashMap<String, ClassPrepareRequest>();
        this.cprBreakpoints = new HashMap<ClassPrepareRequest, java.util.List<DebugJDIBreakpoint>>();
        this.classesByReferenceType = new HashMap<ReferenceType, DebugJDIClassInfo>();
        this.classesByName = new HashMap<String, Object>();
        this.classesByNameWithoutPackage = new HashMap<String, Object>();
        this.classesCollected = new HashSet<ReferenceType>();
        this.classesNotCollected = new HashSet<ReferenceType>();
        this.objectsCollected = new HashSet<ObjectReference>();
        this.objectsNotCollected = new HashSet<ObjectReference>();
        this.debuggable = new ArrayList<String>();
        this.nonDebuggable = new ArrayList<String>();
        this.nonDebuggableClassExclusionFilters = new HashSet<String>();
        this.otherWaitingThreads = new HashMap<ObjectReference, java.util.List<ThreadReference>>();
        this.threadInfos = new HashMap<ThreadReference, SoftReference<DebugJDIThreadInfo>>();
        this.stackFrameInfos = new HashMap<StackFrame, SoftReference<DebugJDIStackFrameInfo>>();
        this.classLoaderInfos = new HashMap();
        this.classLoaderIds = new HashMap();
        this.knownDeadlockedThreads = new ArrayList<ThreadReference>();
        this.pins = new ArrayList<DebugJDIPinnedInfo>();
        this.vmWasRunning = false;
        this.vm = vm;
        try {
            String log = Ide.getProperty((String)"DebuggerConnectionLog");
            if (log == null) {
                log = System.getProperty("DebuggerConnectionLog");
            }
            if (log != null) {
                if (log.equals("System.out")) {
                    this.addConnectionLog(System.out);
                } else if (log.equals("System.err")) {
                    this.addConnectionLog(System.err);
                } else if (log.equals("file")) {
                    this.addConnectionLog(File.createTempFile("jpda", null, new File(Ide.getBinDirectory())));
                }
            }
        }
        catch (Exception log) {
            // empty catch block
        }
        String version = vm.version();
        if (version != null && (versionNumber = new VersionNumber(version)).isAfter(new VersionNumber("1.4"), true)) {
            this.useMethodExitRequest = true;
        }
        this.canGetMethodReturnValues = vm.canGetMethodReturnValues();
        this.eq = vm.eventQueue();
        this.lookForVMStartEvent();
        this.setSyncValue(0, true);
        this.erm = vm.eventRequestManager();
        this.cur = this.erm.createClassUnloadRequest();
        this.cur.setSuspendPolicy(2);
        this.cur.enable();
        this.addPrimitiveClasses();
        for (ReferenceType rt : vm.allClasses()) {
            this.addClassForReferenceType(rt, true);
        }
        if (classesLogger.isEnabled()) {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            Runnable cpeReporter = new Runnable(){
                int lastCount = -1;

                @Override
                public void run() {
                    if (DebugJDI.this.cpeCount != this.lastCount) {
                        classesLogger.trace("Processed " + DebugJDI.this.cpeCount + " ClassPrepareEvents in " + DebugJDI.this.cpeProcessingTime + " (Thread CPU)ms, wall time " + DebugJDI.this.cpeWallTime);
                        this.lastCount = DebugJDI.this.cpeCount;
                    }
                }
            };
            ScheduledFuture<?> scheduledFuture = scheduler.scheduleAtFixedRate(cpeReporter, 60L, 60L, TimeUnit.SECONDS);
        }
        if (System.getProperty("DebugJDI.handleAllClassPrepareEvents") != null) {
            this.handleAllClassPrepareEvents = true;
        }
        if (this.handleAllClassPrepareEvents) {
            this.prepareRequest = this.erm.createClassPrepareRequest();
            this.prepareRequest.setSuspendPolicy(0);
            this.prepareRequest.enable();
        }
        if ((allowMEBP = System.getProperty("DebugJDI.enableMethodEntryBreakpoints")) != null) {
            if (allowMEBP.equalsIgnoreCase("YES") || allowMEBP.equalsIgnoreCase("TRUE")) {
                ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS = true;
                JDebugger.logger.trace("Method entry breakpoints for Execution Tracking enabled via system property");
            } else {
                ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS = false;
                JDebugger.logger.trace("Method entry breakpoints for Execution Tracking disabled via system property");
            }
        } else {
            JDebugger.logger.trace("Method entry breakpoints for Execution Tracking defaulted to " + ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS);
        }
        this.startMethodEvaluationWorker();
    }

    Project getProject() {
        return this.engine.getProject();
    }

    Workspace getWorkspace() {
        return this.engine.getWorkspace();
    }

    private void addPrimitiveClasses() {
        Type type = (ByteType)this.vm.mirrorOf((byte)0).type();
        if (type != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (CharType)this.vm.mirrorOf('\u0000').type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (DoubleType)this.vm.mirrorOf(0.0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (FloatType)this.vm.mirrorOf(0.0f).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (IntegerType)this.vm.mirrorOf(0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (LongType)this.vm.mirrorOf(0L).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (ShortType)this.vm.mirrorOf((short)0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (BooleanType)this.vm.mirrorOf(false).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = this.getVoidType()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
    }

    private VoidType getVoidType() {
        try {
            for (ReferenceType c : this.vm.allClasses()) {
                if (!(c instanceof ClassType)) continue;
                ClassType ct = (ClassType)c;
                for (Method m : ct.methodsByName("notify")) {
                    Type type = m.returnType();
                    if (!(type instanceof VoidType)) continue;
                    return (VoidType)type;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public synchronized void afterConnection(MessagePage logPage) {
        if (this.vmWasRunning) {
            this.lookForAnyUnloadedClassesNeeded = true;
        }
        this.logPage = logPage;
        if (System.getProperty("DebugJDI.doClassLoaderPreprocessing") != null) {
            if (logPage != null) {
                int count = this.classes.size();
                String sCount = Integer.toString(count);
                logPage.log((Object)DebugJDIArb.format(4, sCount));
            }
            this.preprocessClassLoaders();
            if (logPage != null) {
                logPage.log((Object)DebugJDIArb.getString(6));
            }
        }
    }

    public synchronized void addDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.add((DebugListener)this.debugListener, (DebugListener)l);
    }

    public synchronized void removeDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.remove((DebugListener)this.debugListener, (DebugListener)l);
    }

    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.add((DebugBreakpointLogListener)this.bpLogListener, (DebugBreakpointLogListener)l);
    }

    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.remove((DebugBreakpointLogListener)this.bpLogListener, (DebugBreakpointLogListener)l);
    }

    private void lookForVMStartEvent() {
        boolean foundVMStartEvent = false;
        EventSet es = null;
        try {
            if (this.eq != null) {
                es = this.eq.remove(1000L);
            }
        }
        catch (InterruptedException ie) {
            es = null;
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
            es = null;
        }
        if (es != null) {
            Event e;
            EventIterator ei = es.eventIterator();
            if (ei.hasNext() && (e = ei.nextEvent()) instanceof VMStartEvent && es.suspendPolicy() == 2) {
                foundVMStartEvent = true;
                this.needToResume.add(es);
            }
            if (!foundVMStartEvent) {
                es.resume();
            }
        }
        if (!foundVMStartEvent) {
            this.vm.suspend();
            this.needToResume.add(this.vm);
            this.vmWasRunning = true;
        }
    }

    private static synchronized boolean isDebuggerBeforeJDK142() {
        VersionNumber versionNumber;
        if (isDebuggerBeforeJDK142 != null) {
            return isDebuggerBeforeJDK142;
        }
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && (versionNumber = new VersionNumber(javaVersion = javaVersion.replace('_', '.'))).isBefore(new VersionNumber("1.4.2"))) {
            isDebuggerBeforeJDK142 = Boolean.TRUE;
            return true;
        }
        isDebuggerBeforeJDK142 = Boolean.FALSE;
        return false;
    }

    private boolean isClassPrepared(ReferenceType rt) {
        try {
            if (this.isRIM()) {
                return true;
            }
            if (rt instanceof ArrayType) {
                return true;
            }
            if (this.isOracleDatabaseVM()) {
                return true;
            }
            if (DebugJDI.isDebuggerBeforeJDK142() ? rt.isInitialized() || rt.isPrepared() : rt.isPrepared()) {
                return true;
            }
        }
        catch (ObjectCollectedException e) {
            return true;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
        catch (VMDisconnectedException e) {
            return false;
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
            return true;
        }
        if (!this.printedClassNotPreparedWarning) {
            Assert.println((String)("Unexpected: some debuggee classes (including " + rt.name() + ") are not prepared. This can cause debugger performance problems."));
            this.printedClassNotPreparedWarning = true;
        }
        return false;
    }

    private DebugJDIClassInfo addClassForReferenceType(ReferenceType rt, boolean checkPrepared) {
        if (checkPrepared && !this.isClassPrepared(rt)) {
            return null;
        }
        if (!this.classesByReferenceType.containsKey(rt)) {
            DebugJDIClassInfo clazz = new DebugJDIClassInfo(this, rt);
            if (!this.debuggableClassLoaded && rt instanceof ClassType && clazz.isDebuggable()) {
                this.debuggableClassLoaded = true;
            }
            this.addClass(clazz);
            return clazz;
        }
        return null;
    }

    private DebugJDIClassInfo addClassForReferenceTypeAndNestedChildren(ReferenceType rt, boolean checkPrepared) {
        java.util.List<ReferenceType> children = rt.nestedTypes();
        for (ReferenceType child : children) {
            this.addClassForReferenceType(child, checkPrepared);
            classesLogger.trace("Adding nested class " + child.name());
        }
        classesLogger.trace("Adding outer class " + rt.name());
        return this.addClassForReferenceType(rt, checkPrepared);
    }

    private OracleReferenceType getOracleReferenceType(ReferenceType rt) {
        try {
            return OracleExtension.convert((ReferenceType)rt).sourcePrimaryReferenceType();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClass(DebugJDIClassInfo clazz) {
        OracleReferenceType ort;
        if ((this.languages & 1) == 0 && clazz.name.startsWith("java.") && !plsqlJavaClasses.contains(clazz.name)) {
            this.languages |= 1;
        }
        if ((this.languages & 2) == 0 && (clazz.name.startsWith("$Oracle.Package.") || clazz.name.startsWith("$Oracle.PackageBody.") || clazz.name.startsWith("$Oracle.Function.") || clazz.name.startsWith("$Oracle.Procedure.") || clazz.name.startsWith("$Oracle.Type.") || clazz.name.startsWith("$Oracle.TypeBody.") || clazz.name.startsWith("$Oracle.Trigger.") || clazz.name.startsWith("$Oracle.Block."))) {
            this.languages |= 2;
        }
        if ((this.languages & 4) == 0 && clazz.name.startsWith(XSLTDebugHelper.getXSLTPackage() + ".")) {
            this.languages |= 4;
        }
        Object object = this.classesLock;
        synchronized (object) {
            this.classes.add(clazz);
        }
        ReferenceType rt = clazz.getReferenceType();
        if (rt != null) {
            this.classesByReferenceType.put(rt, clazz);
        }
        DebugShared.putClass(this.classesByName, (String)clazz.name, (DebugClassInfo)clazz);
        DebugShared.putClass(this.classesByNameWithoutPackage, (String)clazz.getNameWithoutPackage(), (DebugClassInfo)clazz);
        if (clazz.name.startsWith("$Oracle.Block.") && (ort = this.getOracleReferenceType(rt)) != null) {
            DebugJDI.makeAnonymousBlockManager();
            if (anonymousBlockManager != null) {
                anonymousBlockManager.add(System.identityHashCode(this), clazz, ort);
            }
        }
        if (rt instanceof ClassType && this.debuggeeStarted) {
            this.verifyBreakpoints(rt, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClass(DebugJDIClassInfo clazz) {
        clazz.rtCollected = true;
        Object object = this.classesLock;
        synchronized (object) {
            this.classes.remove((Object)clazz);
        }
        object = this;
        synchronized (object) {
            this.classesByReferenceType.remove(clazz.getReferenceType());
            DebugShared.removeClass(this.classesByName, (String)clazz.name, (DebugClassInfo)clazz);
            DebugShared.removeClass(this.classesByNameWithoutPackage, (String)clazz.getNameWithoutPackage(), (DebugClassInfo)clazz);
            if (anonymousBlockManager != null) {
                anonymousBlockManager.remove(System.identityHashCode(this), clazz);
            }
        }
    }

    public boolean wasRunning() {
        return this.vmWasRunning;
    }

    public synchronized void disconnect() {
        this.disconnect(!this.vmWasRunning);
    }

    public synchronized void disconnect(boolean terminate) {
        if (this.vm != null && !this.getSyncValue(2)) {
            this.setSyncValue(4, terminate);
            this.setSyncValue(3, true);
            try {
                if (terminate) {
                    this.pins.clear();
                    this.vm.exit(0);
                } else {
                    this.unpinAll();
                }
                this.vm.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.incrementStoppedCount(false);
            if (!this.isRunning()) {
                this.vm = null;
                this.cleanUp();
            }
        }
    }

    public boolean isConnected() {
        return this.vm != null;
    }

    public boolean isStopped() {
        return this.getSyncValue(0);
    }

    public boolean isRunning() {
        return this.runningThread != null;
    }

    public boolean isTerminated() {
        return this.getSyncValue(2);
    }

    public boolean isRIM() {
        return this.vm != null ? "RIM JVM".equals(this.vm.name()) : false;
    }

    private void parsePackages(String s, java.util.List<String> v) {
        v.clear();
        while (s != null) {
            String a;
            int semi = s.indexOf(59);
            if (semi == -1) {
                a = s;
                s = null;
            } else {
                a = s.substring(0, semi);
                s = s.substring(semi + 1);
            }
            if (a.length() <= 0) continue;
            v.add(a);
        }
    }

    public synchronized void setNonDebuggablePackages(String nonDebuggablePackages) {
        this.setDebuggablePackages(null, nonDebuggablePackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebuggablePackages(String debuggablePackages, String nonDebuggablePackages) {
        ArrayList<DebugJDIClassInfo> classesCopy;
        java.util.List<String> list = this.debuggable;
        synchronized (list) {
            this.parsePackages(debuggablePackages, this.debuggable);
            this.parsePackages(nonDebuggablePackages, this.nonDebuggable);
            this.nonDebuggableClassExclusionFilters.clear();
        }
        this.debuggableClassLoaded = false;
        Iterator iterator = this.classesLock;
        synchronized (iterator) {
            classesCopy = new ArrayList<DebugJDIClassInfo>(this.classes);
        }
        for (DebugJDIClassInfo clazz : classesCopy) {
            try {
                DebugJDI debugJDI = this;
                synchronized (debugJDI) {
                    clazz.checkDebuggable();
                    if (!this.debuggableClassLoaded && clazz.type instanceof ClassType && clazz.isDebuggable()) {
                        this.debuggableClassLoaded = true;
                    }
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public void requestCodeCoverage(String pkg, String filename) {
    }

    public void unrequestCodeCoverage(String pkg, String filename) {
    }

    public void discardCodeCoverage() {
    }

    private EditorProperties getEditorProperties() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        if (this.pcl == null) {
            this.pcl = new PCL();
            editorProperties.addPropertyChangeListener((PropertyChangeListener)this.pcl);
        }
        return editorProperties;
    }

    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String pkg, String filename, int line) {
        MethodDescriptor md;
        DebugJDIBreakpointPackageFileLine bp = new DebugJDIBreakpointPackageFileLine(this, pkg, filename, line);
        this.putBreakpoint(bp);
        if (ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS && (md = DebugJDIBreakpointMethodSignature.createMethodDescriptor(pkg, filename, line)) != null) {
            DebugJDIExecutionTrackingBreakpointMethod etbp = this.methodEntryBreakpoints.get(md.toString());
            if (etbp == null) {
                etbp = new DebugJDIExecutionTrackingBreakpointMethod(this, md);
                this.methodEntryBreakpoints.put(md.toString(), etbp);
            }
            etbp.addParent(bp);
            bp.setChild(etbp);
            if (this.getEditorProperties().getBooleanProperty("stepping-margin-enabled")) {
                this.putBreakpoint(etbp);
            } else {
                this.unsetETMethodBreakpoints.add(etbp);
            }
        }
        return bp;
    }

    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String filename, int line) {
        MethodDescriptor md;
        DebugJDIBreakpointFileLine bp = new DebugJDIBreakpointFileLine(this, filename, line);
        this.putBreakpoint(bp);
        if (ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS && (md = DebugJDIBreakpointMethodSignature.createMethodDescriptor(null, filename, line)) != null) {
            DebugJDIExecutionTrackingBreakpointMethod etbp = this.methodEntryBreakpoints.get(md.toString());
            if (etbp == null) {
                etbp = new DebugJDIExecutionTrackingBreakpointMethod(this, md);
                this.methodEntryBreakpoints.put(md.toString(), etbp);
            }
            etbp.addParent(bp);
            bp.setChild(etbp);
            if (this.getEditorProperties().getBooleanProperty("stepping-margin-enabled")) {
                this.putBreakpoint(etbp);
            } else {
                this.unsetETMethodBreakpoints.add(etbp);
            }
        }
        return bp;
    }

    public synchronized DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String method, int bytecodeOffset) {
        DebugJDIBreakpointMethodBytecode bp = new DebugJDIBreakpointMethodBytecode(this, method, bytecodeOffset);
        this.putBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointMethod putBreakpointMethod(String method) {
        DebugJDIBreakpointMethod bp = new DebugJDIBreakpointMethod(this, method);
        this.putBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointMethodSignature putBreakpointMethodSignature(MethodDescriptor method) {
        DebugJDIBreakpointMethodSignature bp = new DebugJDIBreakpointMethodSignature(this, method);
        this.putBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointClass putBreakpointClass(String className) {
        DebugJDIBreakpointClass bp = new DebugJDIBreakpointClass(this, className);
        this.putBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointException putBreakpointException(String exception) {
        return this.putBreakpointException(exception, true, true);
    }

    public synchronized DebugBreakpointException putBreakpointException(String exception, boolean caught, boolean uncaught) {
        DebugJDIBreakpointException bp = new DebugJDIBreakpointException(this, exception, caught, uncaught);
        this.putBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointClassLoad putBreakpointClassLoad(String className) {
        DebugJDIBreakpointClassLoad bp = new DebugJDIBreakpointClassLoad(this, className);
        this.putBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int threshold) {
        return null;
    }

    public synchronized DebugBreakpointAllocationClass putBreakpointAllocationClass(String clazz) {
        return null;
    }

    public synchronized DebugBreakpointDeadlock putBreakpointDeadlock() {
        if (this.canPutBreakpointDeadlock()) {
            DebugJDIBreakpointDeadlock bp = new DebugJDIBreakpointDeadlock(this);
            this.putBreakpoint(bp);
            return bp;
        }
        return null;
    }

    public synchronized DebugBreakpointWatchpoint putBreakpointWatchpoint(String className, String fieldName, boolean access, boolean modify) {
        if (access ? (modify ? !this.vm.canWatchFieldAccess() && !this.vm.canWatchFieldModification() : !this.vm.canWatchFieldAccess()) : modify && !this.vm.canWatchFieldModification()) {
            return null;
        }
        DebugJDIBreakpointWatchpoint bp = new DebugJDIBreakpointWatchpoint(this, className, fieldName, access, modify);
        this.putBreakpoint(bp);
        return bp;
    }

    public DebugBreakpointProperties putBreakpointProperties(Map<String, String> properties) {
        return null;
    }

    public synchronized void removeAllBreakpoints() {
        for (int i = this.breakpoints.size() - 1; i >= 0; --i) {
            DebugJDIBreakpoint bp = this.breakpoints.get(i);
            bp.remove();
        }
        this.breakpoints.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resume() {
        if (this.debuggeeStarted) {
            DebugJDI debugJDI;
            if (this.currentThread != null) {
                Long[] times = new Long[]{System.nanoTime(), -1L};
                this.resumeAndStopTimes.put(this.currentThread.getThreadId(), times);
            }
            if (this.executionTracker != null && this.executionTracker.isBackgroundStepping()) {
                while (this.executionTracker.isBackgroundStepping()) {
                    debugJDI = this;
                    synchronized (debugJDI) {
                        DebugLocation location = this.currentThread.getStackFrame(0).getLocation();
                        if (location != null) {
                            this.executionTracker.trackBackgroundResume((DebuggerLocation)location);
                        }
                        DebugJDIThreadInfo threadInfo = (DebugJDIThreadInfo)this.executionTracker.getThreadToTrack();
                        this.executionTrackingStepOverCountdownLatch = new CountDownLatch(1);
                        this.doRunCommand(4, threadInfo);
                    }
                    try {
                        this.executionTrackingStepOverCountdownLatch.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            debugJDI = this;
            synchronized (debugJDI) {
                this.doRunCommand(2, null);
                return;
            }
        }
        DebugJDI debugJDI = this;
        synchronized (debugJDI) {
            this.debuggeeStarted = true;
            this.verifyBreakpointsAndRun(2);
            return;
        }
    }

    public synchronized boolean didStepFinish() {
        return this.startCPR == null && this.startTSR == null && this.stepRequest == null && this.methodExitRequestForStepToEndOfMethod == null && this.methodEntryRequestStepIntoMethod == null;
    }

    public synchronized void continueStep() {
        this.doRunCommand(9, null);
    }

    public synchronized void start(boolean stepOverClassInit) {
        int command;
        int n = command = stepOverClassInit ? 1 : 0;
        if (this.debuggeeStarted) {
            this.doRunCommand(command, null);
        } else {
            this.debuggeeStarted = true;
            this.verifyBreakpointsAndRun(command);
        }
    }

    public synchronized void setPauseInterval(int i) {
    }

    public synchronized void pauseProgram() {
        this.setSyncValue(1, true);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    public void cancelPauseProgram() {
        this.setSyncValue(1, false);
    }

    public synchronized int getCurrentStatus() {
        if (this.isStopped()) {
            DebugBreakpoint currentBP = this.getCurrentBreakpoint();
            if (currentBP != null) {
                if (currentBP instanceof DebugBreakpointPackageFileLine || currentBP instanceof DebugBreakpointFileLine || currentBP instanceof DebugBreakpointMethodBytecode || currentBP instanceof DebugBreakpointMethod || currentBP instanceof DebugBreakpointClass) {
                    return 1;
                }
                if (currentBP instanceof DebugBreakpointException) {
                    return 2;
                }
                if (currentBP instanceof DebugBreakpointClassLoad) {
                    return 3;
                }
                if (currentBP instanceof DebugBreakpointAllocationClass || currentBP instanceof DebugBreakpointAllocationThreshold) {
                    return 4;
                }
                if (currentBP instanceof DebugBreakpointDeadlock) {
                    return 5;
                }
                if (currentBP instanceof DebugBreakpointWatchpoint) {
                    return 10;
                }
            } else {
                if (this.getCurrentThread() == null) {
                    return 8;
                }
                if (this.getCurrentThrow() != null && this.getCurrentThrowHandler() == null) {
                    return 6;
                }
                return 7;
            }
        }
        return 0;
    }

    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    public synchronized DebugThreadInfo getCurrentThread() {
        return this.currentThread;
    }

    public synchronized DebugDataObjectInfo getCurrentThrow() {
        return this.currentThrow;
    }

    public synchronized boolean isCurrentThrowHandled() {
        return this.currentThrowHandler != null;
    }

    public synchronized DebugLocation getCurrentThrowHandler() {
        return this.currentThrowHandler;
    }

    public DebugDataObjectInfo getWatchpointObject() {
        return this.watchpointObject;
    }

    public DebugFieldInfo getWatchpointField() {
        return this.watchpointField;
    }

    public DebugDataInfo getWatchpointFieldFutureValue() {
        return this.watchpointFieldFutureValue;
    }

    public synchronized DebugThreadInfo[][] getDeadlockedThreads() {
        if (this.canGetMonitors()) {
            return DebugShared.getDeadlockedThreads((DebugVirtualMachine)this);
        }
        return new DebugThreadInfo[0][];
    }

    public synchronized DebugThreadGroupInfo[] listTopThreadGroups() {
        ArrayList<DebugJDIThreadGroupInfo> v = new ArrayList<DebugJDIThreadGroupInfo>();
        Iterator<ThreadGroupReference> it = this.getTopLevelThreadGroupsIterator();
        if (it != null) {
            while (it.hasNext()) {
                v.add(new DebugJDIThreadGroupInfo(this, it.next()));
            }
        }
        return v.toArray(new DebugThreadGroupInfo[v.size()]);
    }

    public synchronized DebugThreadGroupInfo[] listAllThreadGroups() {
        HashSet<DebugThreadGroupInfo> v = new HashSet<DebugThreadGroupInfo>();
        Iterator<ThreadGroupReference> it = this.getTopLevelThreadGroupsIterator();
        if (it != null) {
            this.recursiveAddThreadGroups(v, it);
        }
        return v.toArray(new DebugThreadGroupInfo[v.size()]);
    }

    private void recursiveAddThreadGroups(Set<DebugThreadGroupInfo> v, Iterator itGroups) {
        while (itGroups.hasNext()) {
            ThreadGroupReference tgr = (ThreadGroupReference)itGroups.next();
            DebugJDIThreadGroupInfo group = new DebugJDIThreadGroupInfo(this, tgr);
            if (!v.add(group)) continue;
            this.recursiveAddThreadGroups(v, tgr.threadGroups().iterator());
        }
    }

    public synchronized DebugThreadInfo[] listThreads() {
        java.util.List<ThreadReference> threads = this.allThreads();
        int size = threads.size();
        DebugThreadInfo[] a = new DebugThreadInfo[size];
        for (int i = 0; i < size; ++i) {
            a[i] = DebugJDIThreadInfo.makeThreadInfo(this, threads.get(i));
        }
        return a;
    }

    private java.util.List<ThreadReference> allThreads() {
        ArrayList<ThreadReference> list = new ArrayList<ThreadReference>();
        Iterator<ThreadGroupReference> it = this.getTopLevelThreadGroupsIterator();
        if (it != null) {
            while (it.hasNext()) {
                DebugJDI.recursiveAddThreads(it.next(), list);
            }
        }
        return list;
    }

    private Iterator<ThreadGroupReference> getTopLevelThreadGroupsIterator() {
        try {
            return this.vm.topLevelThreadGroups().iterator();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InternalException internalException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static void recursiveAddThreads(ThreadGroupReference tgr, java.util.List<ThreadReference> list) {
        try {
            if (tgr.isCollected()) {
                return;
            }
            list.addAll(tgr.threads());
            java.util.List<ThreadGroupReference> groups = tgr.threadGroups();
            int groupsSize = groups.size();
            for (int i = 0; i < groupsSize; ++i) {
                DebugJDI.recursiveAddThreads(groups.get(i), list);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (VMOutOfMemoryException vMOutOfMemoryException) {
        }
        catch (InternalException internalException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    ObjectReference getWaitMonitor(ThreadReference tr) {
        try {
            if (tr.status() == 4) {
                ObjectReference or = tr.currentContendedMonitor();
                if (or == null) {
                    int count = tr.frameCount();
                    for (int i = 0; i < count && i < 2; ++i) {
                        Method method;
                        ReferenceType rt;
                        Location location;
                        StackFrame sf = tr.frame(i);
                        if (sf == null || (location = sf.location()) == null || (rt = location.declaringType()) == null || !rt.name().equals("java.lang.Object") || (method = location.method()) == null || !method.name().equals("wait") || (or = sf.thisObject()) == null) continue;
                        java.util.List<ThreadReference> list = this.otherWaitingThreads.get(or);
                        if (list == null) {
                            list = new ArrayList<ThreadReference>();
                            this.otherWaitingThreads.put(or, list);
                        }
                        list.add(tr);
                        break;
                    }
                }
                return or;
            }
        }
        catch (InternalException or) {
        }
        catch (IncompatibleThreadStateException or) {
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        return null;
    }

    java.util.List<ThreadReference> getOtherWaitingThreads(ObjectReference or) {
        return this.otherWaitingThreads.get(or);
    }

    public synchronized DebugMonitorInfo[] listMonitorsInUse() {
        if (this.canGetMonitors()) {
            HashSet<ObjectReference> v = new HashSet<ObjectReference>();
            java.util.List<ThreadReference> threads = this.allThreads();
            int threadsSize = threads.size();
            for (int i = 0; i < threadsSize; ++i) {
                ThreadReference tr = threads.get(i);
                try {
                    switch (tr.status()) {
                        case 3: {
                            ObjectReference or = tr.currentContendedMonitor();
                            if (or == null) break;
                            v.add(or);
                            break;
                        }
                        case 4: {
                            ObjectReference or = this.getWaitMonitor(tr);
                            if (or == null) break;
                            v.add(or);
                            break;
                        }
                    }
                    java.util.List<ObjectReference> ownedMonitors = tr.ownedMonitors();
                    int jsize = ownedMonitors.size();
                    for (int j = 0; j < jsize; ++j) {
                        ObjectReference or = ownedMonitors.get(j);
                        if (or == null) continue;
                        v.add(or);
                    }
                    continue;
                }
                catch (Exception ownedMonitors) {
                    // empty catch block
                }
            }
            int size = v.size();
            ObjectReference[] orArray = v.toArray(new ObjectReference[size]);
            DebugMonitorInfo[] monitorArray = new DebugMonitorInfo[size];
            for (int i = 0; i < size; ++i) {
                monitorArray[i] = new DebugJDIMonitorInfo(this, orArray[i]);
            }
            return monitorArray;
        }
        return new DebugMonitorInfo[0];
    }

    public synchronized DebugThreadInfo[] listWaitingThreads() {
        if (this.canGetMonitors()) {
            java.util.List<ThreadReference> threads = this.allThreads();
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            int size = threads.size();
            for (int i = 0; i < size; ++i) {
                ThreadReference tr = threads.get(i);
                try {
                    if (tr.status() != 4) continue;
                    v.add(DebugJDIThreadInfo.makeThreadInfo(this, tr));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            return v.toArray(array);
        }
        return new DebugThreadInfo[0];
    }

    public synchronized DebugThreadInfo[] listBlockedThreads() {
        if (this.canGetMonitors()) {
            java.util.List<ThreadReference> threads = this.allThreads();
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            int size = threads.size();
            for (int i = 0; i < size; ++i) {
                ThreadReference tr = threads.get(i);
                try {
                    if (tr.status() != 3) continue;
                    v.add(DebugJDIThreadInfo.makeThreadInfo(this, tr));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            return v.toArray(array);
        }
        return new DebugThreadInfo[0];
    }

    private void lookForMissedClasses() {
        if (this.prepareRequest != null) {
            return;
        }
        boolean started = this.startTestConnectionThread("lookForMissedClasses");
        try {
            for (ReferenceType rt : this.vm.allClasses()) {
                if (this.classesByReferenceType.containsKey(rt) || this.classesCollected != null && this.classesCollected.contains(rt)) continue;
                this.addClassForReferenceType(rt, true);
            }
        }
        catch (VMDisconnectedException it) {
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        if (started) {
            this.killTestConnectionThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookForUnloadedClassesByName(String className) {
        ArrayList<DebugJDIClassInfo> classesCopy;
        ArrayList<DebugJDIClassInfo> classesMatchingName = new ArrayList<DebugJDIClassInfo>();
        Object object = this.classesLock;
        synchronized (object) {
            classesCopy = new ArrayList<DebugJDIClassInfo>(this.classes);
        }
        object = this;
        synchronized (object) {
            DebugJDIClassInfo clazz;
            int i;
            for (i = classesCopy.size() - 1; i >= 0; --i) {
                clazz = (DebugJDIClassInfo)((Object)classesCopy.get(i));
                if (!className.equals(clazz.name)) continue;
                this.classesNotCollected.remove(clazz.getReferenceType());
                classesMatchingName.add(clazz);
            }
            for (i = classesMatchingName.size() - 1; i >= 0; --i) {
                clazz = (DebugJDIClassInfo)((Object)classesMatchingName.get(i));
                if (!this.isClassCollected(clazz.getReferenceType())) continue;
                this.removeClass(clazz);
            }
            VirtualMachine pinnedVm = this.vm;
            if (pinnedVm != null) {
                java.util.List<ReferenceType> allClasses = pinnedVm.classesByName(className);
                for (ReferenceType rt : allClasses) {
                    if (this.classesByReferenceType.containsKey(rt) || this.classesCollected != null && this.classesCollected.contains(rt)) continue;
                    this.isClassCollected(rt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookForAnyUnloadedClasses() {
        DebugJDIClassInfo[] array;
        DebugJDI debugJDI = this;
        synchronized (debugJDI) {
            if (!this.lookForAnyUnloadedClassesNeeded) {
                return;
            }
            if (this.logPage != null) {
                this.logPage.log((Object)DebugJDIArb.getString(0));
            }
        }
        Object object = this.classesLock;
        synchronized (object) {
            array = this.classes.toArray(new DebugJDIClassInfo[this.classes.size()]);
        }
        object = this;
        synchronized (object) {
            for (DebugJDIClassInfo clazz : array) {
                if (!this.isClassCollected(clazz.getReferenceType())) continue;
                this.removeClass(clazz);
            }
            if (this.logPage != null) {
                this.logPage.log((Object)DebugJDIArb.getString(1));
            }
            if (this.cur != null) {
                this.lookForAnyUnloadedClassesNeeded = false;
            }
        }
    }

    boolean isClassCollected(ReferenceType rt) {
        if (this.isRIM()) {
            return false;
        }
        if (rt == null) {
            return false;
        }
        if (this.classesCollected != null && this.classesCollected.contains(rt)) {
            return true;
        }
        if (this.classesNotCollected.contains(rt)) {
            return false;
        }
        boolean collected = false;
        try {
            ClassObjectReference co = rt.classObject();
            collected = this.isObjectCollected(co);
        }
        catch (ObjectCollectedException e) {
            collected = true;
        }
        catch (UnsupportedOperationException e) {
        }
        catch (VMDisconnectedException e) {
            return false;
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        if (collected) {
            if (this.classesCollected == null) {
                this.classesCollected = new HashSet<ReferenceType>();
            }
            this.classesCollected.add(rt);
        } else {
            if (this.classesNotCollected == null) {
                this.classesNotCollected = new HashSet<ReferenceType>();
            }
            this.classesNotCollected.add(rt);
        }
        return collected;
    }

    boolean isObjectCollected(ObjectReference or) {
        if (this.objectsCollected.contains(or)) {
            return true;
        }
        if (this.objectsNotCollected.contains(or)) {
            return false;
        }
        boolean collected = false;
        try {
            collected = or.isCollected();
        }
        catch (ObjectCollectedException e) {
            collected = true;
        }
        catch (UnsupportedOperationException e) {
        }
        catch (VMDisconnectedException e) {
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        if (collected) {
            this.objectsCollected.add(or);
        } else {
            this.objectsNotCollected.add(or);
        }
        return collected;
    }

    public DebugClassInfo[] listClasses() {
        return this.listClasses(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugClassInfo[] listClasses(boolean fast) {
        long start = System.nanoTime();
        classesLogger.trace("DebugJDI.listClasses invocation forcing fetch of all class info from debuggee");
        Object object = this;
        synchronized (object) {
            if (!fast) {
                this.lookForAnyUnloadedClasses();
            }
            this.lookForMissedClasses();
        }
        classesLogger.trace("DebugJDI.listClasses completed in " + (System.nanoTime() - start) + " ns");
        object = this.classesLock;
        synchronized (object) {
            return this.classes.toArray(new DebugClassInfo[this.classes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countClasses() {
        long start = System.nanoTime();
        classesLogger.trace("DebugJDI.countClasses invocation forcing fetch of all class info from debuggee");
        Object object = this;
        synchronized (object) {
            this.lookForAnyUnloadedClasses();
            this.lookForMissedClasses();
        }
        classesLogger.trace("DebugJDI.countClasses completed in " + (System.nanoTime() - start) + " ns");
        object = this.classesLock;
        synchronized (object) {
            return this.classes.size();
        }
    }

    private Object getClassesNamed(String name) {
        java.util.List<ReferenceType> classes = this.vm.classesByName(name);
        if (classes != null && classes.size() > 0) {
            ArrayList<DebugJDIClassInfo> loadedClasses = new ArrayList<DebugJDIClassInfo>();
            for (ReferenceType loadedType : classes) {
                DebugJDIClassInfo classForRT = this.addClassForReferenceTypeAndNestedChildren(loadedType, true);
                if (classForRT != null) {
                    loadedClasses.add(classForRT);
                    classesLogger.trace("getClassesNamed(" + name + ") loads " + classForRT.getName());
                    continue;
                }
                Object classOrClassList = this.classesByName.get(name);
                if (classOrClassList instanceof DebugJDIClassInfo) {
                    DebugJDIClassInfo info = (DebugJDIClassInfo)((Object)classOrClassList);
                    classesLogger.trace("getClassesNamed(" + name + ") returns already-loaded " + info.getName());
                    loadedClasses.add(info);
                    continue;
                }
                if (!(classOrClassList instanceof java.util.List)) continue;
                java.util.List list = (java.util.List)classOrClassList;
                classesLogger.trace("getClassesName(" + name + ") returns " + list.size() + " already-loaded classes named " + name);
                loadedClasses.addAll(list);
            }
            if (loadedClasses.size() == 1) {
                return loadedClasses.get(0);
            }
            return loadedClasses;
        }
        return null;
    }

    public DebugClassInfo findFirstClassByName(String name) {
        return this.findFirstClassByName(name, false);
    }

    public DebugClassInfo findFirstClassByName(String name, boolean nameWithoutPackage) {
        DebugJDIClassInfo clazz;
        while (true) {
            if ((clazz = (DebugJDIClassInfo)DebugShared.getFirstClass(nameWithoutPackage ? this.classesByNameWithoutPackage : this.classesByName, (String)name)) == null) {
                java.util.List<ReferenceType> classes = this.vm.classesByName(name);
                if (classes != null && classes.size() > 0) {
                    for (ReferenceType loadedType : classes) {
                        DebugJDIClassInfo classForRT = this.addClassForReferenceTypeAndNestedChildren(loadedType, true);
                        if (clazz == null) {
                            classesLogger.trace("findFirstClassByName() lazy fetch of " + name + " successful");
                            clazz = classForRT;
                            continue;
                        }
                        classesLogger.trace("findFirstClassByName() lazy fetch of " + name + " also matched and loaded " + loadedType.name());
                    }
                } else {
                    classesLogger.trace("findFirstClassByName() lazy fetch of " + name + " found nothing");
                }
            }
            if (clazz == null || !this.isClassCollected(clazz.getReferenceType())) break;
            this.removeClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocessClassLoaders() {
        Object object = this.classesLock;
        synchronized (object) {
            long start = System.nanoTime();
            this.lookForMissedClasses();
            classesLogger.trace("DebugJDI.preprocessClassLoaders() triggered load of missing classes, took " + (System.nanoTime() - start) + " ns");
            for (DebugJDIClassInfo clazz : this.classes) {
                clazz.getClassLoaderReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugClassLoaderInfo[] listClassLoaders() {
        ArrayList<DebugJDIClassInfo> classesCopy;
        Object object = this.classesLock;
        synchronized (object) {
            classesCopy = new ArrayList<DebugJDIClassInfo>(this.classes);
        }
        for (int i = 0; i < classesCopy.size(); ++i) {
            DebugJDIClassInfo clazz = (DebugJDIClassInfo)((Object)classesCopy.get(i));
            clazz.getClassLoader();
        }
        DebugJDIThreadInfo.getThreadContextClassLoaders(this);
        ArrayList expired = new ArrayList();
        ArrayList<DebugJDIClassLoaderInfo> v = new ArrayList<DebugJDIClassLoaderInfo>();
        Map map = this.classLoaderInfos;
        synchronized (map) {
            for (Map.Entry entry : this.classLoaderInfos.entrySet()) {
                Object key = entry.getKey();
                DebugJDIClassLoaderInfo classLoader = (DebugJDIClassLoaderInfo)((Object)entry.getValue());
                if (classLoader.hasExpired()) {
                    expired.add(key);
                    continue;
                }
                v.add(classLoader);
            }
            for (Map.Entry key : expired) {
                this.classLoaderInfos.remove(key);
            }
        }
        return v.toArray(new DebugClassLoaderInfo[v.size()]);
    }

    public synchronized int countHeap(DebugHeapSubset subset) {
        long start = System.nanoTime();
        this.lookForMissedClasses();
        classesLogger.trace("DebugJDI.countHeap triggered load of any missed classes, elapsed time " + (System.nanoTime() - start) + " ns");
        if (this.vm != null && subset != null && this.vm.canGetInstanceInfo()) {
            Object obj = this.classesByName.get(subset.getName());
            if (obj == null) {
                return 0;
            }
            if (obj instanceof java.util.List) {
                return ((java.util.List)((Object)this.classesByName)).size();
            }
            return 1;
        }
        return 0;
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset subset) {
        return this.getHeap(subset, 0);
    }

    public int getSizeOfAddress() {
        return 0;
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset subset, int sort) {
        if (!this.canGetHeap()) {
            return null;
        }
        if (this.vm == null || subset == null) {
            return null;
        }
        if (!this.vm.canGetInstanceInfo()) {
            return null;
        }
        long start = System.nanoTime();
        this.lookForMissedClasses();
        classesLogger.trace("DebugJDI.getHeap() triggered load of missing classes, took " + (System.nanoTime() - start) + " ns");
        java.util.List<ObjectReference> referrers = null;
        long originalId = -1L;
        if (subset instanceof DebugHeapSubsetAncestors && subset.getName().startsWith(DbgArb.format((int)604, (Object)""))) {
            this.throwIfRunning();
            DebugJDIHeapObjectInfo o = this.id2ObjectReference.get(new Long(((DebugHeapSubsetAncestors)subset).getAddress()));
            if (o == null) {
                o = this.getNotGottenObjectReference(((DebugHeapSubsetAncestors)subset).getAddress(), subset.getClassInfo());
            }
            if (o != null && o instanceof DebugJDIHeapObjectInfo) {
                ObjectReference or = o.getObjectReference();
                originalId = or.uniqueID();
                if (or != null) {
                    referrers = or.referringObjects(0L);
                }
            }
        }
        Object obj = this.classesByName.get(subset.getName());
        if (referrers == null && obj == null) {
            return null;
        }
        this.throwIfRunning();
        ArrayList<ObjectReference> allOrList = null;
        if (referrers == null) {
            ArrayList<ReferenceType> ctList = new ArrayList<ReferenceType>();
            if (obj instanceof java.util.List) {
                for (DebugJDIClassInfo obj1 : (java.util.List)obj) {
                    if (obj1 == null) continue;
                    ctList.add(obj1.getReferenceType());
                }
            } else {
                ctList.add(((DebugJDIClassInfo)((Object)obj)).getReferenceType());
            }
            Iterator refTypeIter = ctList.iterator();
            allOrList = new ArrayList<ObjectReference>();
            while (refTypeIter != null && refTypeIter.hasNext()) {
                ReferenceType rt = (ReferenceType)refTypeIter.next();
                if (rt == null) continue;
                java.util.List<ObjectReference> orList = rt.instances(0L);
                allOrList.addAll(orList);
            }
        } else {
            allOrList = referrers;
        }
        int allOrListLen = allOrList.size();
        int[] heapDepths = new int[allOrListLen];
        Arrays.fill(heapDepths, 0);
        ArrayList<DebugJDIHeapAncestorOutsideHeap> heapObjsList = new ArrayList<DebugJDIHeapAncestorOutsideHeap>(allOrListLen);
        ArrayList heapHelpers = new ArrayList(allOrListLen);
        int counter1 = 0;
        HashSet<Long> visited = new HashSet<Long>();
        for (int ii = 0; ii < allOrListLen; ++ii) {
            ObjectReference or = (ObjectReference)allOrList.get(ii);
            if (or.isCollected()) {
                ++counter1;
                continue;
            }
            if (referrers == null) {
                DebugJDIHeapAncestorOutsideHeap jdiOH = null;
                jdiOH = this.getOHObject(or);
                if (jdiOH == null) continue;
                heapObjsList.add(jdiOH);
                continue;
            }
            int[] integ = new int[]{0};
            java.util.List<OutsideHeapDepthHelper> jdiOHL = null;
            jdiOHL = this.getReferrerOHObject(or, integ, originalId, visited);
            if (jdiOHL != null) {
                heapHelpers.addAll(jdiOHL);
            }
            ++counter1;
        }
        DebugJDIHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap = null;
        long[] heapIds = null;
        if (heapHelpers == null || heapHelpers.size() == 0) {
            class HeapInfoSorter
            implements Comparator<DebugJDIHeapAncestorOutsideHeap> {
                private int sortBy = 0;

                HeapInfoSorter(int sortBy) {
                    this.sortBy = sortBy;
                }

                @Override
                public int compare(DebugJDIHeapAncestorOutsideHeap o1, DebugJDIHeapAncestorOutsideHeap o2) {
                    if (this.sortBy == 0) {
                        return new Long(o1.getAddress() - o2.getAddress()).intValue();
                    }
                    if (this.sortBy == 1) {
                        return 0;
                    }
                    if (this.sortBy == 2) {
                        return o1.getDataInfo().getClassInfo().getName().compareTo(o2.getDataInfo().getClassInfo().getName());
                    }
                    if (this.sortBy == 3) {
                        return 0;
                    }
                    return 0;
                }
            }
            Collections.sort(heapObjsList, new HeapInfoSorter(sort));
            heapAncestorsOutsideHeap = heapObjsList.toArray(new DebugJDIHeapAncestorOutsideHeap[heapObjsList.size()]);
            heapIds = new long[heapObjsList.size()];
            int counter = 0;
            for (DebugJDIHeapAncestorOutsideHeap heapId : heapObjsList) {
                heapIds[counter] = heapId.getAddress();
                ++counter;
            }
        } else {
            class OutsideHeapInfoSorter
            implements Comparator<OutsideHeapDepthHelper> {
                private int sortBy = 0;

                OutsideHeapInfoSorter(int sortBy) {
                    this.sortBy = sortBy;
                }

                @Override
                public int compare(OutsideHeapDepthHelper o1, OutsideHeapDepthHelper o2) {
                    if (this.sortBy == 0) {
                        return new Long(o1.heapObj.getAddress() - o2.heapObj.getAddress()).intValue();
                    }
                    if (this.sortBy == 1) {
                        return 0;
                    }
                    if (this.sortBy == 2) {
                        return o1.heapObj.getDataInfo().getClassInfo().getName().compareTo(o2.heapObj.getDataInfo().getClassInfo().getName());
                    }
                    if (this.sortBy == 3) {
                        return 0;
                    }
                    return 0;
                }
            }
            Collections.sort(heapHelpers, new OutsideHeapInfoSorter(sort));
            heapDepths = new int[heapHelpers.size()];
            heapObjsList = new ArrayList(heapHelpers.size());
            for (int i1 = 0; i1 < heapHelpers.size(); ++i1) {
                OutsideHeapDepthHelper helper = (OutsideHeapDepthHelper)heapHelpers.get(i1);
                if (helper == null) continue;
                heapObjsList.add(helper.heapObj);
                heapDepths[i1] = helper.depth;
            }
            heapAncestorsOutsideHeap = heapObjsList.toArray(new DebugJDIHeapAncestorOutsideHeap[heapObjsList.size()]);
            heapIds = new long[heapObjsList.size()];
            int counter = 0;
            for (DebugJDIHeapAncestorOutsideHeap heapId : heapObjsList) {
                heapIds[counter] = heapId.getAddress();
                ++counter;
            }
        }
        return new DebugJDIHeapInfo(this, subset, heapAncestorsOutsideHeap, heapIds, heapDepths);
    }

    public synchronized boolean isHeapAddressValid(long address) {
        return false;
    }

    public synchronized DebugHeapObjectInfo getHeapObjectAtAddress(long address) {
        return this.id2ObjectReference.get(new Long(address));
    }

    public synchronized void doGarbageCollection() {
    }

    public DebugCapabilities getCapabilities() {
        return this;
    }

    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    public boolean canPutBreakpointFileLine() {
        return true;
    }

    public boolean canPutBreakpointMethodBytecode() {
        return true;
    }

    public boolean canPutBreakpointMethod() {
        return true;
    }

    public boolean canPutBreakpointMethodSignature() {
        return true;
    }

    public boolean canPutBreakpointClass() {
        return true;
    }

    public boolean canPutBreakpointException() {
        return true;
    }

    public boolean canPutBreakpointClassLoad() {
        return true;
    }

    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    public synchronized boolean canPutBreakpointDeadlock() {
        if (this.vm != null) {
            return this.vm.canGetCurrentContendedMonitor() && this.vm.canGetMonitorInfo() && this.vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    public boolean canPutBreakpointWatchpoint() {
        if (this.vm != null) {
            return this.vm.canWatchFieldAccess() || this.vm.canWatchFieldModification();
        }
        return false;
    }

    public boolean canPutBreakpointProperties() {
        return false;
    }

    public boolean canSetDebuggablePackages() {
        return true;
    }

    public boolean canPauseProgram() {
        return true;
    }

    public boolean canRedefineClasses() {
        if (this.vm != null) {
            return this.vm.canRedefineClasses();
        }
        return false;
    }

    public boolean canCountObjectsOfClass() {
        if (this.vm != null) {
            return this.vm.canGetInstanceInfo();
        }
        return false;
    }

    public boolean canCountMemoryOfClass() {
        return false;
    }

    public boolean canSetDebuggableClass() {
        return true;
    }

    public boolean canGetHeap() {
        if (this.vm != null) {
            return this.vm.canGetInstanceInfo();
        }
        return false;
    }

    public boolean canDoGarbageCollection() {
        return false;
    }

    public boolean canDoCodeCoverage() {
        return false;
    }

    public synchronized boolean canDisassembleMethod() {
        if (this.vm != null) {
            return this.vm.canGetBytecodes();
        }
        return false;
    }

    public synchronized boolean canGetBytecodes() {
        if (this.vm != null) {
            return this.vm.canGetBytecodes();
        }
        return false;
    }

    public boolean canInvokeMethod() {
        return true;
    }

    public synchronized boolean canGetMonitors() {
        if (this.vm != null) {
            return this.vm.canGetCurrentContendedMonitor() && this.vm.canGetMonitorInfo() && this.vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    public boolean canListSlots() {
        return false;
    }

    public boolean canPopFrames() {
        if (this.vm != null) {
            return this.vm.canPopFrames();
        }
        return false;
    }

    public boolean canSuspendThread() {
        return true;
    }

    public boolean canResumeThread() {
        return true;
    }

    public boolean canInterruptThread() {
        return true;
    }

    public boolean canDebuggerStopThread() {
        return true;
    }

    public boolean canListRegisters() {
        return false;
    }

    public boolean canListFloatRegisters() {
        return false;
    }

    public synchronized boolean canStepToEndOfMethod() {
        return this.useMethodExitRequest;
    }

    public boolean canStepIntoMethod() {
        return true;
    }

    public boolean canStepIntoOuterMethod() {
        return true;
    }

    public boolean canContinueStep() {
        return true;
    }

    public boolean canGetReturnValue() {
        return this.canGetMethodReturnValues;
    }

    public boolean canGetReturnedValue() {
        return this.canGetMethodReturnValues;
    }

    public boolean canSetLocation() {
        return false;
    }

    public boolean canPin() {
        return true;
    }

    public boolean canGetAddresses() {
        return false;
    }

    public boolean canGetUniqueIDs() {
        return true;
    }

    synchronized void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException("Program Is Running");
        }
    }

    synchronized DebugJDIClassInfo findClass(ReferenceType rt) {
        if (rt == null) {
            return null;
        }
        if (this.isClassCollected(rt)) {
            return null;
        }
        DebugJDIClassInfo clazz = this.classesByReferenceType.get(rt);
        if (clazz != null) {
            return clazz;
        }
        if (this.vm == null) {
            return null;
        }
        java.util.List<ReferenceType> classesMatchingName = this.vm.classesByName(rt.name());
        if (classesMatchingName != null) {
            for (ReferenceType rtFromList : classesMatchingName) {
                if (!rtFromList.equals(rt)) continue;
                clazz = this.addClassForReferenceType(rtFromList, true);
                classesLogger.trace("findClass(ReferenceType) lazy fetch of " + rt.name() + " successful");
                return clazz;
            }
        }
        classesLogger.trace("findClass(ReferenceType) lazy fetch of " + rt.name() + " failed");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugJDIClassInfo findClassByType(Type t) {
        if (t instanceof ReferenceType) {
            return this.findClass((ReferenceType)t);
        }
        Object object = this.classesLock;
        synchronized (object) {
            for (DebugJDIClassInfo clazz : this.classes) {
                if (clazz.type == null || !clazz.type.equals(t)) continue;
                return clazz;
            }
        }
        for (ReferenceType rtFromList : this.vm.classesByName(t.name())) {
            DebugJDIClassInfo clazz;
            if (!rtFromList.equals(t)) continue;
            clazz = this.addClassForReferenceType(rtFromList, true);
            classesLogger.trace("findClassByType(Type) lazy fetch of " + t.name() + " successful");
            return clazz;
        }
        classesLogger.trace("findClassByType(" + t.name() + " unsuccessful, returning null");
        return null;
    }

    synchronized DebugJDIClassInfo findClassByName(String name, boolean makeIt) {
        DebugJDIClassInfo c = (DebugJDIClassInfo)DebugShared.getFirstClass(this.classesByName, (String)name);
        if (c == null && makeIt) {
            c = new DebugJDIClassInfo(name);
            classesLogger.trace("findClassByName(" + name + ", true) makes classInfo since it wasn't found in map");
        } else if (c == null) {
            classesLogger.trace("findClassByName(" + name + ", false) returning null, no such class in map");
        }
        return c;
    }

    synchronized DebugJDIDataInfo makeNullData(DebugJDIClassInfo clazz, Object owner) {
        if (clazz.isArray()) {
            return new DebugJDIDataArrayInfo(this, clazz, null, owner);
        }
        return new DebugJDIDataObjectInfo(this, clazz, null, owner);
    }

    synchronized DebugJDIDataInfo makeData(Value v, Object owner) {
        try {
            DebugJDIClassInfo clazz = this.findClassByType(v.type());
            if (v instanceof PrimitiveValue) {
                return new DebugJDIDataPrimitiveInfo(this, clazz, v, owner);
            }
            if (v instanceof ArrayReference) {
                return new DebugJDIDataArrayInfo(this, clazz, v, owner);
            }
            if (v instanceof ObjectReference) {
                return new DebugJDIDataObjectInfo(this, clazz, v, owner);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    Value makeValue(Object newValue) {
        if (newValue == null) {
            return null;
        }
        if (newValue instanceof DebugJDIDataInfo) {
            return ((DebugJDIDataInfo)((Object)newValue)).value;
        }
        if (newValue instanceof Boolean) {
            return this.vm.mirrorOf((Boolean)newValue);
        }
        if (newValue instanceof Byte) {
            return this.vm.mirrorOf((Byte)newValue);
        }
        if (newValue instanceof Character) {
            return this.vm.mirrorOf(((Character)newValue).charValue());
        }
        if (newValue instanceof Double) {
            return this.vm.mirrorOf((Double)newValue);
        }
        if (newValue instanceof Float) {
            return this.vm.mirrorOf(((Float)newValue).floatValue());
        }
        if (newValue instanceof Integer) {
            return this.vm.mirrorOf((Integer)newValue);
        }
        if (newValue instanceof Long) {
            return this.vm.mirrorOf((Long)newValue);
        }
        if (newValue instanceof Short) {
            return this.vm.mirrorOf((Short)newValue);
        }
        if (newValue instanceof String) {
            return this.vm.mirrorOf((String)newValue);
        }
        throw new IllegalArgumentException("Invalid newValue argument");
    }

    Value makeBooleanValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.booleanDecode((String)newValue));
    }

    Value makeByteValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.byteDecode((String)newValue));
    }

    Value makeCharValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.charDecode((String)newValue));
    }

    Value makeDoubleValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.doubleDecode((String)newValue));
    }

    Value makeFloatValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.floatDecode((String)newValue));
    }

    Value makeIntegerValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.intDecode((String)newValue));
    }

    Value makeLongValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.longDecode((String)newValue));
    }

    Value makeShortValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.shortDecode((String)newValue));
    }

    StringReference makeStringValue(String newValue) {
        return this.vm.mirrorOf(newValue);
    }

    java.util.List<Value> makeArgumentsFromStrings(Method m, String[] arguments) {
        ArrayList<Value> argList = null;
        try {
            int length = arguments.length;
            java.util.List<Type> argTypes = m.argumentTypes();
            if (argTypes.size() != length) {
                return null;
            }
            argList = new ArrayList<Value>(length);
            for (int i = 0; i < length; ++i) {
                Type type = argTypes.get(i);
                Value v = null;
                if (type instanceof BooleanType) {
                    v = this.makeBooleanValue(arguments[i]);
                } else if (type instanceof ByteType) {
                    v = this.makeByteValue(arguments[i]);
                } else if (type instanceof CharType) {
                    v = this.makeCharValue(arguments[i]);
                } else if (type instanceof DoubleType) {
                    v = this.makeDoubleValue(arguments[i]);
                } else if (type instanceof FloatType) {
                    v = this.makeFloatValue(arguments[i]);
                } else if (type instanceof IntegerType) {
                    v = this.makeIntegerValue(arguments[i]);
                } else if (type instanceof LongType) {
                    v = this.makeLongValue(arguments[i]);
                } else if (type instanceof ShortType) {
                    v = this.makeShortValue(arguments[i]);
                } else if (type instanceof ClassType && type.name().equals("java.lang.String")) {
                    v = this.makeStringValue(arguments[i]);
                }
                if (v == null) {
                    return null;
                }
                argList.add(v);
            }
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        return argList;
    }

    synchronized DebugPinnedInfo pinObject(ObjectReference or, DebugPinListener pinListener) {
        DebugJDIPinnedInfo pin = new DebugJDIPinnedInfo(this, or, pinListener);
        this.pins.add(pin);
        return pin;
    }

    synchronized void unpinObject(DebugJDIPinnedInfo pin) {
        if (this.pins != null) {
            this.pins.remove(pin);
        }
    }

    private void unpinAll() {
        for (int i = this.pins.size() - 1; i >= 0; --i) {
            DebugJDIPinnedInfo pin = this.pins.get(i);
            this.unpinObject(pin);
        }
    }

    private synchronized void checkPinnedObjects() {
        DebugJDIPinnedInfo pin;
        int i;
        ArrayList<DebugJDIPinnedInfo> discardedList = new ArrayList<DebugJDIPinnedInfo>();
        for (i = this.pins.size() - 1; i >= 0; --i) {
            pin = this.pins.get(i);
            if (!this.isObjectCollected(pin.or)) continue;
            pin.discarded = true;
            discardedList.add(pin);
        }
        for (i = 0; i < discardedList.size(); ++i) {
            pin = (DebugJDIPinnedInfo)discardedList.get(i);
            this.pins.remove(pin);
            pin.pinListener.pinnedObjectDiscarded((DebugVirtualMachine)this, (DebugPinnedInfo)pin);
        }
    }

    synchronized void putBreakpoint(DebugJDIBreakpoint bp) {
        this.breakpoints.add(bp);
        bp.afterChange();
    }

    private boolean isOracleDatabaseVM() {
        if (this.isOracleDatabaseVM != null) {
            return this.isOracleDatabaseVM;
        }
        if (this.vm != null) {
            if ("Oracle Multilanguage Debugger".equals(this.vm.name())) {
                this.isOracleDatabaseVM = Boolean.TRUE;
                return true;
            }
            this.isOracleDatabaseVM = Boolean.FALSE;
            return false;
        }
        return false;
    }

    private synchronized void removeBPClassPrepareRequest(DebugJDIBreakpoint bp, String filter) {
        ClassPrepareRequest cpr;
        if (filter.startsWith("$Oracle.") && this.isOracleDatabaseVM()) {
            filter = "";
        }
        if ((cpr = this.cprsByFilter.get(filter)) != null) {
            java.util.List<DebugJDIBreakpoint> bps = this.cprBreakpoints.get(cpr);
            bps.remove((Object)bp);
            if (bps.isEmpty()) {
                cpr.disable();
                this.erm.deleteEventRequest(cpr);
                this.cprBreakpoints.remove(cpr);
                this.cprsByFilter.remove(filter);
            }
        }
    }

    synchronized void breakpointBeforeChange(DebugJDIBreakpoint bp) {
        String filter;
        if (bp.getEnabled() && (filter = bp.getClassPrepareFilter()) != null) {
            this.removeBPClassPrepareRequest(bp, filter);
            if (filter.equals("java.lang.Exception")) {
                this.removeBPClassPrepareRequest(bp, "$Oracle.Builtin.EXCEPTION");
            }
        }
    }

    synchronized void createBPClassPrepareRequest(DebugJDIBreakpoint bp, String filter) {
        ClassPrepareRequest cpr;
        if (filter.startsWith("$Oracle.") && this.isOracleDatabaseVM()) {
            filter = "";
        }
        if ((cpr = this.cprsByFilter.get(filter)) == null) {
            cpr = this.erm.createClassPrepareRequest();
            cpr.setSuspendPolicy(2);
            if (filter.length() > 0) {
                cpr.addClassFilter(filter);
            }
            cpr.enable();
            classesLogger.trace("created ClassPrepareRequest for breakpoint " + (Object)((Object)bp) + " with filter " + filter);
            this.cprsByFilter.put(filter, cpr);
            this.cprBreakpoints.put(cpr, new ArrayList());
        }
        java.util.List<DebugJDIBreakpoint> bps = this.cprBreakpoints.get(cpr);
        bps.add(bp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void breakpointAfterChange(DebugJDIBreakpoint bp) {
        ArrayList<DebugJDIClassInfo> classesCopy;
        Object filename;
        String filter;
        if (bp.getEnabled() && (filter = bp.getClassPrepareFilter()) != null) {
            this.createBPClassPrepareRequest(bp, filter);
            if (filter.equals("java.lang.Exception") && this.isOracleDatabaseVM()) {
                this.createBPClassPrepareRequest(bp, "$Oracle.Builtin.EXCEPTION");
            }
        }
        if (bp instanceof DebugJDIBreakpointFileLine) {
            String pkg = null;
            if (bp instanceof DebugJDIBreakpointPackageFileLine) {
                pkg = ((DebugJDIBreakpointPackageFileLine)bp).getPackage();
            }
            if ((filename = ((DebugJDIBreakpointFileLine)bp).getFilename()) != null) {
                Object classname = filename;
                if (((String)filename).lastIndexOf(46) != -1) {
                    classname = ((String)filename).substring(0, ((String)filename).lastIndexOf(46));
                }
                if (pkg != null) {
                    this.findFirstClassByName(pkg + "." + (String)classname, false);
                } else {
                    this.findFirstClassByName((String)classname, true);
                }
            }
        }
        filename = this.classesLock;
        synchronized (filename) {
            classesCopy = new ArrayList<DebugJDIClassInfo>(this.classes);
        }
        if (this.debuggeeStarted && bp.needsVerification()) {
            boolean verified = false;
            for (DebugJDIClassInfo clazz : classesCopy) {
                try {
                    ReferenceType rt = clazz.getReferenceType();
                    if (!(rt instanceof ClassType) || !bp.verify(rt, rt.name())) continue;
                    verified = true;
                }
                catch (ObjectCollectedException rt) {
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
            }
            if (verified && this.debugListener != null) {
                this.debugListener.breakpointChanged((DebugBreakpoint)bp);
            }
        }
    }

    private void verifyBreakpointsAndRun(final int runCommand) {
        SwingWorker<Object, java.util.List<DebugJDIBreakpoint>> worker = new SwingWorker<Object, java.util.List<DebugJDIBreakpoint>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object doInBackground() {
                ArrayList classesCopy;
                Object object = DebugJDI.this.classesLock;
                synchronized (object) {
                    classesCopy = new ArrayList(DebugJDI.this.classes);
                }
                if (DebugJDI.this.breakpoints.size() > 0) {
                    for (int i = 0; i < classesCopy.size(); ++i) {
                        java.util.List result;
                        DebugJDIClassInfo clazz = (DebugJDIClassInfo)((Object)classesCopy.get(i));
                        ReferenceType refType = clazz.getReferenceType();
                        if (!(refType instanceof ClassType) || (result = DebugJDI.this.verifyBreakpoints(refType, false)) == null) continue;
                        this.publish(result);
                    }
                }
                return null;
            }

            @Override
            protected void process(java.util.List<java.util.List<DebugJDIBreakpoint>> chunks) {
                for (java.util.List<DebugJDIBreakpoint> list : chunks) {
                    for (DebugJDIBreakpoint bp : list) {
                        if (DebugJDI.this.debugListener == null) continue;
                        DebugJDI.this.debugListener.breakpointChanged((DebugBreakpoint)bp);
                    }
                }
            }

            @Override
            protected void done() {
                DebugJDI.this.doRunCommand(runCommand, null);
            }
        };
        worker.execute();
    }

    synchronized boolean removeBreakpoint(DebugJDIBreakpoint bp) {
        if (bp instanceof DebugJDIBreakpointMethodSignature) {
            this.methodEntryBreakpoints.remove((Object)bp);
            this.unsetETMethodBreakpoints.remove((Object)bp);
        }
        if (this.breakpoints.indexOf((Object)bp) != -1) {
            this.breakpoints.remove((Object)bp);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOptionsForStepRequest(EventRequest er) {
        MethodEntryRequest mer;
        StepRequest sr = er instanceof StepRequest ? (StepRequest)er : null;
        MethodExitRequest mxr = er instanceof MethodExitRequest ? (MethodExitRequest)er : null;
        MethodEntryRequest methodEntryRequest = mer = er instanceof MethodEntryRequest ? (MethodEntryRequest)er : null;
        if (!this.stepIntoMethodBeingUsedForStepIntoOuter) {
            java.util.List<String> list = this.debuggable;
            synchronized (list) {
                int size = this.nonDebuggable.size();
                for (int i = 0; i < size; ++i) {
                    String s = this.nonDebuggable.get(i);
                    if (sr != null) {
                        sr.addClassExclusionFilter(s);
                        sr.addClassExclusionFilter(s + ".*");
                        continue;
                    }
                    if (mxr != null) {
                        mxr.addClassExclusionFilter(s);
                        mxr.addClassExclusionFilter(s + ".*");
                        continue;
                    }
                    if (mer == null) continue;
                    mer.addClassExclusionFilter(s);
                    mer.addClassExclusionFilter(s + ".*");
                }
                for (String s : this.nonDebuggableClassExclusionFilters) {
                    if (sr != null) {
                        sr.addClassExclusionFilter(s);
                        continue;
                    }
                    if (mxr != null) {
                        mxr.addClassExclusionFilter(s);
                        continue;
                    }
                    if (mer == null) continue;
                    mer.addClassExclusionFilter(s);
                }
            }
            this.stepIntoMethodBeingUsedForStepIntoOuter = false;
        }
        try {
            er.setSuspendPolicy(2);
            er.enable();
        }
        catch (InternalException internalException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStartCPR() {
        this.startCPR = this.erm.createClassPrepareRequest();
        java.util.List<String> list = this.debuggable;
        synchronized (list) {
            int size = this.nonDebuggable.size();
            for (int i = 0; i < size; ++i) {
                String s = this.nonDebuggable.get(i);
                this.startCPR.addClassExclusionFilter(s);
                this.startCPR.addClassExclusionFilter(s + ".*");
            }
        }
        this.startCPR.setSuspendPolicy(2);
        this.startCPR.enable();
    }

    private void removeStartCPR() {
        if (this.startCPR != null) {
            this.startCPR.disable();
            this.erm.deleteEventRequest(this.startCPR);
            this.startCPR = null;
        }
    }

    private void createStartTSR() {
        this.startTSR = this.erm.createThreadStartRequest();
        this.startTSR.setSuspendPolicy(2);
        this.startTSR.enable();
        this.startStepRequests = new HashMap<ThreadReference, StepRequest>();
        java.util.List<ThreadReference> threads = this.allThreads();
        for (int i = threads.size() - 1; i >= 0; --i) {
            ThreadReference tr = threads.get(i);
            int status = tr.status();
            if (status == 5 || status == 0) continue;
            try {
                tr.frameCount();
                this.createStartStepRequest(tr);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void removeStartTSR() {
        if (this.startTSR != null) {
            this.startTSR.disable();
            this.erm.deleteEventRequest(this.startTSR);
            this.startTSR = null;
        }
    }

    private void createStartStepRequest(ThreadReference tr) {
        if (!this.startStepRequests.containsKey(tr)) {
            StepRequest sr = this.erm.createStepRequest(tr, -2, 1);
            this.setOptionsForStepRequest(sr);
            this.startStepRequests.put(tr, sr);
        }
    }

    private void removeStartRequest() {
        this.removeStartCPR();
        this.removeStartTSR();
        if (this.startStepRequests != null) {
            Iterator<StepRequest> i = this.startStepRequests.values().iterator();
            this.startStepRequests = null;
            while (i.hasNext()) {
                StepRequest sr = i.next();
                sr.disable();
                this.erm.deleteEventRequest(sr);
            }
        }
    }

    private void removeStepRequest() {
        try {
            this.removeStartRequest();
            this.stepLocation = null;
            this.stepStack = null;
            if (this.stepRequest != null) {
                this.stepRequest.disable();
                this.erm.deleteEventRequest(this.stepRequest);
                this.stepRequest = null;
            }
            this.removeMethodExitRequestForStepToEndOfMethod();
            this.removeMethodExitRequestForStepOut();
            this.removeMethodEntryRequestStepIntoMethod();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldStopAtStepEvent(LocatableEvent le) {
        ReferenceType rt;
        if (this.runCommand == 8 && le instanceof MethodExitEvent && this.stepStack != null && this.methodExitRequestForStepToEndOfMethodMethod != null) {
            try {
                return this.methodExitRequestForStepToEndOfMethodMethod == le.thread().frame(0).location().method();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (le instanceof MethodExitEvent) {
            return false;
        }
        if (this.runCommand == 10 && le instanceof MethodEntryEvent) {
            try {
                MethodEntryEvent mee = (MethodEntryEvent)le;
                Method currentMethod = mee.method();
                boolean foundMethod = false;
                if (currentMethod != null) {
                    if (lastStepWasLambdaThunk) {
                        if (currentMethod.isSynthetic()) {
                            return false;
                        }
                        lastStepWasLambdaThunk = false;
                        return true;
                    }
                    if (currentMethod.name().equals(this.stepIntoMethodName)) {
                        if (currentMethod.declaringType().name().contains("$$Lambda")) {
                            lastStepWasLambdaThunk = true;
                            foundMethod = false;
                        } else {
                            foundMethod = true;
                        }
                    } else if (currentMethod.isConstructor() && this.stepIntoMethodName != null && this.stepIntoMethodName.startsWith("<init>")) {
                        ReferenceType refType = currentMethod.declaringType();
                        String realStepIntoName = this.stepIntoMethodName.substring(6);
                        boolean bl = foundMethod = refType.name().equals(realStepIntoName) || refType.name().endsWith("." + realStepIntoName);
                    }
                }
                if (foundMethod) {
                    SIOLogger.trace("     DebugJDI: shouldStopAtStepEvent(" + currentMethod.name() + ")  method name matched");
                    if (le.thread().frameCount() > 1) {
                        int callerFrame = 1;
                        Location callerLocation = le.thread().frame(callerFrame).location();
                        while (callerLocation.method().isSynthetic()) {
                            SIOLogger.trace(" ignoring synthetic frame when looking for caller in stack " + callerLocation.method());
                            callerLocation = le.thread().frame(++callerFrame).location();
                        }
                        if (callerLocation.lineNumber() >= this.stepIntoMethodCallerLineMin && callerLocation.lineNumber() <= this.stepIntoMethodCallerLineMax) {
                            SIOLogger.trace("      caller line matches");
                            String sourcePath = callerLocation.sourcePath().replace('\\', '/');
                            if (this.stepIntoMethodCallerPath.equals(sourcePath)) {
                                SIOLogger.trace("      source path matches, shouldStopAtEvent returning TRUE");
                                return true;
                            }
                            SIOLogger.trace("      source path mismatched, shouldStopAtvent returning FALSE");
                            return false;
                        }
                        SIOLogger.trace("       caller line out of range: " + callerLocation.lineNumber() + " not in " + this.stepIntoMethodCallerLineMin + "-" + this.stepIntoMethodCallerLineMax);
                    }
                }
                if (!this.isCallerStillOnTheStack(le.thread(), this.stepIntoMethodCallerLineMin, this.stepIntoMethodCallerLineMax, this.stepIntoMethodCallerPath)) {
                    this.removeStepRequest();
                }
            }
            catch (Exception ex) {
                SIOLogger.trace("     Exception in DebugJDI.shouldStopAtEvent():  " + ex.getMessage());
            }
            return false;
        }
        Location location = le.location();
        if (location != null && (rt = location.declaringType()) != null) {
            String className = rt.name();
            if (this.isClassDebuggable(className)) {
                Method method = null;
                try {
                    method = location.method();
                    if (this.runCommand == 1) {
                        if (className.startsWith("$Oracle.Block.")) {
                            return false;
                        }
                        if (method == null || method.name().equals("<clinit>")) {
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    return false;
                }
                if (className.startsWith("$Oracle.Block.") && this.getOracleReferenceType(rt) == null) {
                    return false;
                }
                if (this.runCommand != 5 && this.runCommand != 6 && DebugJDI.getLineNumber(location, rt.defaultStratum()) == -1) {
                    return false;
                }
                if (this.runCommand != 5 && this.runCommand != 6 && this.runCommand != 8 && DebugJDI.sameSourceLocation(location, this.stepLocation) && DebugJDI.sameStack(DebugJDI.getStack(le.thread()), this.stepStack)) {
                    return false;
                }
                if (method.isSynthetic()) {
                    return false;
                }
                return this.runCommand != 4 || this.stepStack == null || DebugJDI.getStackFrameCount(le.thread()) <= this.stepStack.length;
            }
            java.util.List<String> list = this.debuggable;
            synchronized (list) {
                String filter = this.getNonDebuggableClassExclusionFilter(className);
                if (filter != null && this.nonDebuggableClassExclusionFilters.add(filter)) {
                    EventRequest er = le.request();
                    try {
                        er.disable();
                        if (er instanceof StepRequest) {
                            ((StepRequest)er).addClassExclusionFilter(filter);
                        } else if (er instanceof MethodExitRequest) {
                            ((MethodExitRequest)er).addClassExclusionFilter(filter);
                        }
                        er.enable();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    private boolean isCallerStillOnTheStack(ThreadReference threadRef, int callerLineMin, int callerLineMax, String callerPath) {
        try {
            boolean found = false;
            int frameCount = threadRef.frameCount();
            if (callerPath == null && callerLineMin == 0) {
                System.out.println("DebugJDI.isCallerStillOnStack: Caller info invalid, investigate");
                return true;
            }
            for (int x = 0; x < frameCount; ++x) {
                String sourcePath;
                Location callerLocation = threadRef.frame(x).location();
                if (callerLocation.lineNumber() < callerLineMin || callerLocation.lineNumber() > callerLineMax || !callerPath.equals(sourcePath = callerLocation.sourcePath().replace('\\', '/'))) continue;
                found = true;
                break;
            }
            return found;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void makeMethodExitRequestForStepToEndOfMethod(ThreadReference tr) {
        if (this.useMethodExitRequest) {
            this.methodExitRequestForStepToEndOfMethod = this.makeMethodExitRequestForTopFrame(tr, 2);
            try {
                this.methodExitRequestForStepToEndOfMethodMethod = tr.frame(0).location().method();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
            this.setOptionsForStepRequest(this.methodExitRequestForStepToEndOfMethod);
        }
    }

    private void removeMethodExitRequestForStepToEndOfMethod() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepToEndOfMethod != null) {
            this.methodExitRequestForStepToEndOfMethod.disable();
            this.erm.deleteEventRequest(this.methodExitRequestForStepToEndOfMethod);
            this.methodExitRequestForStepToEndOfMethod = null;
            this.methodExitRequestForStepToEndOfMethodMethod = null;
        }
    }

    private MethodExitRequest makeMethodExitRequestForTopFrame(ThreadReference tr, int suspendPolicy) {
        MethodExitRequest mer = this.erm.createMethodExitRequest();
        mer.addThreadFilter(tr);
        try {
            ObjectReference thisObject;
            StackFrame sf = tr.frame(0);
            Location location = sf.location();
            if (location != null) {
                mer.addClassFilter(location.declaringType());
            }
            if ((thisObject = sf.thisObject()) != null) {
                mer.addInstanceFilter(thisObject);
            }
            mer.setSuspendPolicy(suspendPolicy);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        return mer;
    }

    private void makeMethodExitRequestForStepOut(ThreadReference tr) {
        if (this.useMethodExitRequest && this.canGetMethodReturnValues) {
            this.methodExitRequestForStepOut = this.makeMethodExitRequestForTopFrame(tr, 0);
            this.methodExitRequestForStepOut.enable();
        }
    }

    private void removeMethodExitRequestForStepOut() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepOut != null) {
            this.methodExitRequestForStepOut.disable();
            this.erm.deleteEventRequest(this.methodExitRequestForStepOut);
            this.methodExitRequestForStepOut = null;
        }
    }

    private void makeMethodEntryRequestStepIntoMethod(ThreadReference tr) {
        MethodEntryRequest mer = this.erm.createMethodEntryRequest();
        mer.addThreadFilter(tr);
        this.setOptionsForStepRequest(mer);
        this.methodEntryRequestStepIntoMethod = mer;
    }

    private void removeMethodEntryRequestStepIntoMethod() {
        if (this.methodEntryRequestStepIntoMethod != null) {
            try {
                this.methodEntryRequestStepIntoMethod.disable();
                this.erm.deleteEventRequest(this.methodEntryRequestStepIntoMethod);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
            this.methodEntryRequestStepIntoMethod = null;
            this.stepIntoMethodName = null;
            this.stepIntoMethodCallerPath = null;
            this.stepIntoMethodCallerPackage = null;
            this.stepIntoMethodCallerFileName = null;
            this.stepIntoMethodCallerLineMin = 0;
            this.stepIntoMethodCallerLineMax = 0;
        }
    }

    private synchronized void doRunCommand(int command, DebugJDIThreadInfo thread) {
        this.throwIfRunning();
        if (this.currentThread != null) {
            Long[] times = new Long[]{System.nanoTime(), -1L};
            this.resumeAndStopTimes.put(this.currentThread.getThreadId(), times);
        }
        this.runCommand = command;
        this.runCommandThread = thread != null ? thread.tr : null;
        this.runningThread = new Thread((Runnable)this, "JPDA Event Processor");
        this.runningThread.start();
    }

    private void resumeAsNeeded() {
        while (!this.needToResume.isEmpty()) {
            Object o = this.needToResume.remove(0);
            if (o instanceof EventSet) {
                ((EventSet)o).resume();
                continue;
            }
            if (!(o instanceof VirtualMachine)) continue;
            ((VirtualMachine)o).resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int runCommandLocal = this.runCommand;
        if (this.m_deadlockDetectorThread == null) {
            this.m_deadlockDetectorThread = new DeadlockDetector();
            this.m_deadlockDetectorThread.start();
        }
        this.killTestConnectionThread();
        this.threadReturnValues = null;
        if (this.runCommand != 9) {
            this.removeStepRequest();
        }
        if (this.runCommandThread == null) {
            this.runCommandThread = this.currentThread == null ? null : this.currentThread.tr;
        }
        switch (this.runCommand) {
            case 0: 
            case 1: {
                if (this.debuggableClassLoaded) {
                    this.createStartTSR();
                    break;
                }
                this.createStartCPR();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -2, 1);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 4: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -2, 2);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 5: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 1);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 6: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 2);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 7: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 3);
                this.setOptionsForStepRequest(this.stepRequest);
                this.makeMethodExitRequestForStepOut(this.runCommandThread);
                if (!this.canGetReturnedValue()) break;
                this.threadReturnValues = new HashMap<Long, MethodExitEvent>();
                break;
            }
            case 8: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 3);
                this.setOptionsForStepRequest(this.stepRequest);
                this.makeMethodExitRequestForStepToEndOfMethod(this.runCommandThread);
                if (!this.canGetReturnedValue()) break;
                this.threadReturnValues = new HashMap<Long, MethodExitEvent>();
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                Location location = DebugJDI.getLocation(this.runCommandThread);
                if (location.lineNumber() < this.stepIntoMethodCallerLineMin || location.lineNumber() > this.stepIntoMethodCallerLineMax || !DebugJDI.getSourceName(location).equals(this.stepIntoMethodCallerFileName) || !this.stepIntoMethodCallerPath.equals(DebugJDI.getSourcePath(location).replace('\\', '/'))) {
                    this.stepIntoMethodBreakpoint = (DebugJDIBreakpointPackageFileLine)this.putBreakpointPackageFileLine(this.stepIntoMethodCallerPackage, this.stepIntoMethodCallerFileName, this.stepIntoMethodCallerLineMin);
                    break;
                }
                this.makeMethodEntryRequestStepIntoMethod(this.runCommandThread);
            }
        }
        this.setSyncValue(0, false);
        this.incrementStoppedCount(false);
        this.currentBreakpoint = null;
        this.currentThread = null;
        this.eventThread = null;
        this.id2ObjectReference = new HashMap<Long, DebugJDIHeapObjectInfo>();
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        if (this.otherWaitingThreads == null) {
            this.otherWaitingThreads = new HashMap<ObjectReference, java.util.List<ThreadReference>>();
        }
        this.otherWaitingThreads.clear();
        boolean isDeadlockBreakpointSet = this.isDeadlockBreakpointSet();
        int waitTime = isDeadlockBreakpointSet ? 3000 : -1;
        long timeDeadlockChecked = System.currentTimeMillis();
        this.resumeAsNeeded();
        do {
            try {
                EventSet es = null;
                LinkedHashMap<EventSet, ThreadReference> linkedHashMap = this.unhandledEventSets;
                synchronized (linkedHashMap) {
                    if (!this.unhandledEventSets.keySet().isEmpty()) {
                        es = this.unhandledEventSets.keySet().iterator().next();
                        ThreadReference tr = this.unhandledEventSets.get(es);
                        this.vm.suspend();
                        this.needToResume.add(this.vm);
                        if (tr != null) {
                            tr.resume();
                        }
                        this.unhandledEventSets.remove(es);
                    }
                }
                if (es == null) {
                    try {
                        EventQueue currentEq = this.eq;
                        if (currentEq == null) {
                            this.setSyncValue(2, true);
                            this.vm = null;
                        } else {
                            if (waitTime != -1) {
                                this.m_aliveTime = System.currentTimeMillis();
                                es = currentEq.remove();
                                this.m_aliveTime = 0L;
                            } else {
                                es = currentEq.remove();
                            }
                            if (es != null) {
                                this.needToResume.add(es);
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        this.m_aliveTime = 0L;
                    }
                }
                if (es != null) {
                    EventIterator ei = es.eventIterator();
                    while (ei.hasNext()) {
                        ThreadReference tr;
                        Event e = ei.nextEvent();
                        EventRequest er = e.request();
                        if (er != null && er == this.startTSR) {
                            ThreadStartEvent tse = (ThreadStartEvent)e;
                            tr = tse.thread();
                            this.createStartStepRequest(tr);
                            continue;
                        }
                        if (e instanceof ClassPrepareEvent) {
                            long cpeThreadCPUStartTime = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1000000L;
                            long cpeWallStartTime = System.currentTimeMillis();
                            ClassPrepareEvent cpe = (ClassPrepareEvent)e;
                            ReferenceType rt = cpe.referenceType();
                            classesLogger.trace("Class prepare event: " + rt.name());
                            if (cpe.request() == this.prepareRequest) {
                                if (!(this.classesByReferenceType.containsKey(rt) || this.classesCollected != null && this.classesCollected.contains(rt))) {
                                    this.addClassForReferenceTypeAndNestedChildren(rt, true);
                                }
                            } else {
                                this.classesNotCollected.add(rt);
                                if (this.addClassForReferenceType(rt, false) != null && this.checkForBreakpointHit(e, cpe.thread())) {
                                    this.setSyncValue(0, true);
                                }
                                if (er != null && er == this.startCPR && this.debuggableClassLoaded) {
                                    this.removeStartCPR();
                                    this.createStartTSR();
                                }
                            }
                            if (!classesLogger.isEnabled()) continue;
                            ++this.cpeCount;
                            long cpeThreadCPUEndTime = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1000000L;
                            long cpeWallEndTime = System.currentTimeMillis();
                            this.cpeProcessingTime += cpeThreadCPUEndTime - cpeThreadCPUStartTime;
                            this.cpeWallTime += cpeWallEndTime - cpeWallStartTime;
                            continue;
                        }
                        if (e instanceof BreakpointEvent || e instanceof ExceptionEvent || e instanceof WatchpointEvent) {
                            if (this.breakpointsSuspended) continue;
                            ThreadReference threadReference = ((LocatableEvent)e).thread();
                            if (this.stepIntoMethodBreakpoint != null && this.stepIntoMethodBreakpoint.isThisYourEvent(e, threadReference)) {
                                this.stepIntoMethodBreakpoint.remove();
                                this.stepIntoMethodBreakpoint = null;
                                this.makeMethodEntryRequestStepIntoMethod(threadReference);
                                continue;
                            }
                            if (!this.checkForBreakpointHit(e, threadReference)) continue;
                            int bpLine = ((LocatableEvent)e).location().lineNumber();
                            String bpSource = ((LocatableEvent)e).location().sourceName();
                            this.setSyncValue(0, true);
                            SIOLogger.trace("DebugJDI:breakpoint event, stopping for that and not for step");
                            continue;
                        }
                        if (e instanceof StepEvent) {
                            DebugLocation location;
                            StepEvent se = (StepEvent)e;
                            if (!this.shouldStopAtStepEvent(se)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            tr = se.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
                            this.eventThread = tr;
                            if (this.executionTracker == null || !this.executionTracker.isBackgroundStepping() || !this.executionTracker.isTrackingThread(this.currentThread.getThreadId()) || (location = this.currentThread.getStackFrame(0).getLocation()) == null) continue;
                            this.executionTracker.trackBackgroundStep((DebuggerLocation)location);
                            continue;
                        }
                        if (e instanceof MethodExitEvent) {
                            MethodExitEvent mee = (MethodExitEvent)e;
                            if (this.threadReturnValues != null) {
                                this.threadReturnValues.put(new Long(mee.thread().uniqueID()), mee);
                            }
                            if (!this.shouldStopAtStepEvent(mee)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            tr = mee.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
                            this.eventThread = tr;
                            continue;
                        }
                        if (e instanceof MethodEntryEvent) {
                            boolean stopAtOccurrenceCounterSatisfied = true;
                            MethodEntryEvent mee = (MethodEntryEvent)e;
                            boolean logMEE = false;
                            if (logMEE) {
                                SIOLogger.trace("DebugJDI: MethodEntryEvent seen " + mee.method());
                            }
                            ThreadReference tr2 = mee.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr2);
                            DebugStackFrameInfo callerFrame = this.currentThread.getStackFrame(1);
                            if (callerFrame != null) {
                                MethodVisitationInfoRetrievalKey key;
                                Map<TargetMethod, TargetMethod.VisitationTrackingInfo> trackingState;
                                DebugLocation callerLocation = callerFrame.getLocation();
                                if (logMEE) {
                                    SIOLogger.trace("     MethodEntryEvent: Called from " + callerLocation.getClassInfo().getName() + ":" + callerLocation.getLine());
                                }
                                if ((trackingState = this.methodVisitationStateTracking.get(key = new MethodVisitationInfoRetrievalKey(callerLocation, tr2.uniqueID(), this.currentThread.getStackFrameCount() - 1))) != null) {
                                    int callerLineMin = DebugLocationUtils.getFirstLineOfStatementEncompassingLocation((DebugLocation)callerLocation);
                                    int callerLineMax = DebugLocationUtils.getLastLineOfStatementEncompassingLocation((DebugLocation)callerLocation);
                                    TargetMethod target = new TargetMethod(mee.method().name(), callerLocation.getClassInfo().getPackage(), callerLocation.getClassInfo().getNameWithoutPackage(), callerLineMin, callerLineMax);
                                    if (trackingState.containsKey(target)) {
                                        TargetMethod.VisitationTrackingInfo mvTracking = trackingState.get(target);
                                        int stopAtVisitationCount = mvTracking.getStopAtOccurrence();
                                        int visitationCount = mvTracking.getVisitationCount();
                                        if (stopAtVisitationCount != -1 && visitationCount < stopAtVisitationCount) {
                                            stopAtOccurrenceCounterSatisfied = false;
                                        }
                                        mvTracking.incrementVisitationCount();
                                        if (logMEE) {
                                            SIOLogger.trace("     MethodEventryEvent: Incremented target " + target + " visitation count to " + mvTracking.getVisitationCount() + " stop=" + stopAtOccurrenceCounterSatisfied);
                                        }
                                    }
                                }
                            }
                            if (!stopAtOccurrenceCounterSatisfied || !this.shouldStopAtStepEvent(mee)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            if (logMEE) {
                                SIOLogger.trace("     MethodEntryEvent: counter satisifed and should stop true, stopping");
                            }
                            this.eventThread = tr2;
                            continue;
                        }
                        if (e instanceof ClassUnloadEvent) {
                            try {
                                if (((ClassUnloadEvent)e).classSignature() == null || ((ClassUnloadEvent)e).classSignature().length() <= 0) continue;
                                String className = ((ClassUnloadEvent)e).className();
                                this.lookForUnloadedClassesByName(className);
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                            continue;
                        }
                        if (e instanceof VMDeathEvent) {
                            this.setSyncValue(2, true);
                            this.vm = null;
                            continue;
                        }
                        if (!(e instanceof VMDisconnectEvent)) continue;
                        this.vm = null;
                    }
                    if (!this.getSyncValue(0)) {
                        this.eventThread = null;
                        this.currentThread = null;
                        this.currentThrow = null;
                        this.currentThrowHandler = null;
                        this.watchpointObject = null;
                        this.watchpointField = null;
                        this.watchpointFieldFutureValue = null;
                        this.resumeAsNeeded();
                    }
                }
                if (this.vm == null || this.getSyncValue(2) || this.getSyncValue(0)) continue;
                if (this.checkForPause()) {
                    this.needToResume.add(this.vm);
                    this.setSyncValue(0, true);
                    continue;
                }
                if (!isDeadlockBreakpointSet || System.currentTimeMillis() - timeDeadlockChecked < 3000L) continue;
                if (this.checkForDeadlock()) {
                    this.needToResume.add(this.vm);
                    this.setSyncValue(0, true);
                    continue;
                }
                timeDeadlockChecked = System.currentTimeMillis();
            }
            catch (VMDisconnectedException e) {
                this.vm = null;
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        } while (this.vm != null && !this.getSyncValue(2) && !this.getSyncValue(0));
        this.runningThread = null;
        this.incrementStoppedCount(true);
        if (this.getSyncValue(2)) {
            if (this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.cleanUp();
        } else if (this.getSyncValue(0)) {
            if (this.stepIntoMethodBreakpoint != null) {
                this.stepIntoMethodBreakpoint.remove();
                this.stepIntoMethodBreakpoint = null;
            }
            this.programStopped();
        } else if (this.getSyncValue(3)) {
            if (this.getSyncValue(4) && this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.cleanUp();
        } else {
            this.setSyncValue(6, true);
            this.connectionLost();
        }
        if (runCommandLocal == 4 && this.executionTrackingStepOverCountdownLatch != null) {
            this.executionTrackingStepOverCountdownLatch.countDown();
        }
    }

    public Long[] getResumeAndStopTimes(long threadID) {
        return this.resumeAndStopTimes.get(threadID);
    }

    private void programStopped() {
        Long[] times;
        if (this.currentThread != null && (times = this.resumeAndStopTimes.get(this.currentThread.getThreadId())) != null) {
            times[1] = System.nanoTime();
            this.resumeAndStopTimes.put(this.currentThread.getThreadId(), times);
        }
        this.startTestConnectionThread("programStopped");
        this.checkPinnedObjects();
        if (this.debugListener != null) {
            this.debugListener.programStopped();
        }
    }

    private boolean isAtEndOfAMethodThatReturnsSomething(ThreadReference tr) {
        try {
            StackFrame sf = tr.frame(0);
            Location location = sf.location();
            Method m = location.method();
            if (!(m.returnType() instanceof VoidType) || m.isConstructor()) {
                short opcode;
                long bc = location.codeIndex();
                byte[] bytecodes = m.bytecodes();
                if (bc >= 0L && bc < (long)bytecodes.length && DebugSharedDisassemble.isReturnBytecode((short)(opcode = (short)(bytecodes[(int)bc] & 0xFF)))) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void connectionLost() {
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
        this.cleanUp();
    }

    private boolean startTestConnectionThread(String name) {
        if (this.testConnectionThread != null) {
            return false;
        }
        final String threadName = "JPDA Test Connection Thread (" + name + ")";
        this.testConnectionThread = new Thread(threadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    try {
                        EventQueue eqLocal;
                        while ((eqLocal = DebugJDI.this.eq) != null) {
                            EventSet es = eqLocal.remove(3000L);
                            if (es == null) continue;
                            boolean breakOut = false;
                            EventIterator ei = es.eventIterator();
                            while (ei.hasNext()) {
                                Event e = ei.nextEvent();
                                if (e instanceof VMDisconnectEvent) {
                                    boolean connectionLostAlreadyRecognized;
                                    if (!DebugJDI.this.getSyncValue(3) && !(connectionLostAlreadyRecognized = DebugJDI.this.setSyncValue(6, true))) {
                                        DebugJDI.this.connectionLost();
                                    }
                                    breakOut = true;
                                    continue;
                                }
                                if (e instanceof ClassPrepareEvent) {
                                    ReferenceType rt = ((ClassPrepareEvent)e).referenceType();
                                    DebugJDI.this.classesNotCollected.add(rt);
                                    DebugJDI.this.addClassForReferenceTypeAndNestedChildren(rt, false);
                                    continue;
                                }
                                if (e instanceof ClassUnloadEvent || e instanceof LocatableEvent) {
                                    ThreadReference tr = null;
                                    if (e instanceof LocatableEvent) {
                                        tr = ((LocatableEvent)e).thread();
                                    }
                                    if (tr != null) {
                                        tr.suspend();
                                    }
                                    LinkedHashMap linkedHashMap = DebugJDI.this.unhandledEventSets;
                                    synchronized (linkedHashMap) {
                                        DebugJDI.this.unhandledEventSets.put(es, tr);
                                        break;
                                    }
                                }
                                Assert.println((String)(threadName + " - got unexpected event " + e));
                            }
                            if (!breakOut) {
                                es.resume();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException eqLocal) {
                    }
                    catch (VMDisconnectedException e) {
                        boolean connectionLostAlreadyRecognized = DebugJDI.this.setSyncValue(6, true);
                        if (connectionLostAlreadyRecognized) break block15;
                        DebugJDI.this.connectionLost();
                    }
                }
                DebugJDI.this.testConnectionThread = null;
            }
        };
        this.testConnectionThread.start();
        return true;
    }

    private void killTestConnectionThread() {
        this.killThreadAndWait(this.testConnectionThread);
        this.testConnectionThread = null;
    }

    private void killThreadAndWait(Thread t) {
        if (t != null) {
            while (t.isAlive()) {
                t.interrupt();
                try {
                    t.join(1000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void safeSuspendVM() {
        for (ThreadReference tr : this.allThreads()) {
            try {
                tr.status();
            }
            catch (Exception e) {
                Assert.println((String)("tr.status() threw " + e));
            }
        }
        this.vm.suspend();
    }

    private boolean checkForPause() {
        if (this.setSyncValue(1, false)) {
            this.safeSuspendVM();
            return true;
        }
        return false;
    }

    private synchronized boolean isDeadlockBreakpointSet() {
        for (DebugJDIBreakpoint bp : this.breakpoints) {
            DebugJDIBreakpointDeadlock bpd;
            if (!(bp instanceof DebugJDIBreakpointDeadlock) || !(bpd = (DebugJDIBreakpointDeadlock)bp).getEnabled() || !bpd.getStop() && !bpd.getLog() && bpd.getEnableOtherBPs() == null && bpd.getDisableOtherBPs() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForDeadlock() {
        this.safeSuspendVM();
        if (this.areThreadsDeadlocked()) {
            ThreadReference tr = this.knownDeadlockedThreads.get(this.knownDeadlockedThreads.size() - 1);
            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
            DebugJDIBreakpointDeadlock stop = null;
            DebugJDI debugJDI = this;
            synchronized (debugJDI) {
                for (DebugJDIBreakpoint bp : this.breakpoints) {
                    DebugJDIBreakpointDeadlock bpd;
                    if (!(bp instanceof DebugJDIBreakpointDeadlock) || !this.doBreakpointActions(bpd = (DebugJDIBreakpointDeadlock)bp, null, tr)) continue;
                    stop = bpd;
                }
            }
            if (stop != null) {
                this.eventThread = null;
                this.currentBreakpoint = stop;
                return true;
            }
            this.currentThread = null;
        }
        this.vm.resume();
        return false;
    }

    private boolean areThreadsDeadlocked() {
        try {
            ArrayList<ThreadReference> threads = new ArrayList<ThreadReference>(this.allThreads());
            threads.removeAll(this.knownDeadlockedThreads);
            ArrayList<ThreadReference> possibleDeadlockedThreads = new ArrayList<ThreadReference>();
            while (threads.size() > 0) {
                ThreadReference tr1 = (ThreadReference)threads.remove(0);
                if (tr1.status() == 3) {
                    possibleDeadlockedThreads.add(tr1);
                    ThreadReference tr2 = tr1;
                    while ((tr2 = tr2.currentContendedMonitor().owningThread()) != null) {
                        threads.remove(tr2);
                        if (tr2.status() != 3) break;
                        if (tr2 == tr1) {
                            this.knownDeadlockedThreads.addAll(possibleDeadlockedThreads);
                            return true;
                        }
                        possibleDeadlockedThreads.add(tr2);
                    }
                }
                possibleDeadlockedThreads.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    void stepInto(DebugJDIThreadInfo thread) {
        this.doRunCommand(3, thread);
    }

    void stepOver(DebugJDIThreadInfo thread) {
        this.doRunCommand(4, thread);
    }

    void stepIntoBC(DebugJDIThreadInfo thread) {
        this.doRunCommand(5, thread);
    }

    void stepOverBC(DebugJDIThreadInfo thread) {
        this.doRunCommand(6, thread);
    }

    void stepOut(DebugJDIThreadInfo thread) {
        this.doRunCommand(7, thread);
    }

    void stepToEndOfMethod(DebugJDIThreadInfo thread) {
        if (this.useMethodExitRequest) {
            this.doRunCommand(8, thread);
        }
    }

    void stepIntoMethod(DebugJDIThreadInfo thread, String methodName, String callerPackage, String callerFileName, int callerLineMin, int callerLineMax) {
        this.removeMethodEntryRequestStepIntoMethod();
        this.stepIntoMethodName = methodName;
        this.stepIntoMethodCallerPackage = callerPackage;
        this.stepIntoMethodCallerFileName = callerFileName;
        this.stepIntoMethodCallerLineMin = callerLineMin;
        this.stepIntoMethodCallerLineMax = callerLineMax;
        StringBuilder buf = new StringBuilder();
        if (this.stepIntoMethodCallerPackage.length() > 0) {
            buf.append(this.stepIntoMethodCallerPackage.replace('.', '/'));
            buf.append('/');
        }
        buf.append(this.stepIntoMethodCallerFileName);
        this.stepIntoMethodCallerPath = buf.toString();
        this.doRunCommand(10, thread);
    }

    MethodVisitationInfoRetrievalKey stepIntoMethod(DebugJDIThreadInfo thread, TargetMethod selectedMethod, Map<TargetMethod, TargetMethod.VisitationTrackingInfo> methodsToTrack) {
        DebugLocation currentLocation = thread.getStackFrame(0).getLocation();
        if (currentLocation instanceof DebugJDILocation) {
            DebugJDILocation location = (DebugJDILocation)currentLocation;
            String fqClass = location.getClassInfo().getName();
            DebuggingProcess dp = (DebuggingProcess)this.engine;
            int startOfStatement = currentLocation.getLine();
            java.util.List helpers = DebuggerHelperHook.getLanguageSpecificHelpers((Project)this.getProject());
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.canGetStartOfStatementLineNumber()) continue;
                startOfStatement = helper.getStartOfStatementLineNumber(dp, fqClass, startOfStatement);
            }
            location.setLine(startOfStatement);
        }
        MethodVisitationInfoRetrievalKey key = new MethodVisitationInfoRetrievalKey(currentLocation, thread.getThreadId(), thread.getStackFrameCount());
        this.methodVisitationStateTracking.put(key, methodsToTrack);
        this.stepIntoMethodBeingUsedForStepIntoOuter = true;
        this.stepIntoMethod(thread, selectedMethod.getMethodName(), selectedMethod.getCallerPackage(), selectedMethod.getCallerFile(), selectedMethod.getCallerLineMin(), selectedMethod.getCallerLineMax());
        return key;
    }

    public Map<TargetMethod, TargetMethod.VisitationTrackingInfo> getMethodVisitationInfo(MethodVisitationInfoRetrievalKey retrievalKey) {
        return this.methodVisitationStateTracking.get(retrievalKey);
    }

    public void clearMethodVisitationInfo(MethodVisitationInfoRetrievalKey retrievalKey) {
        SIOLogger.trace("DebugJDI.clearMethodVisitationInfo for " + retrievalKey);
        this.methodVisitationStateTracking.remove(retrievalKey);
    }

    java.util.List tempDisableRequests() {
        ArrayList<EventRequest> requestsToDisable = new ArrayList<EventRequest>();
        if (this.stepRequest != null && this.stepRequest.isEnabled()) {
            requestsToDisable.add(this.stepRequest);
        }
        if (this.methodExitRequestForStepToEndOfMethod != null && this.methodExitRequestForStepToEndOfMethod.isEnabled()) {
            requestsToDisable.add(this.methodExitRequestForStepToEndOfMethod);
        }
        if (this.methodExitRequestForStepOut != null && this.methodExitRequestForStepOut.isEnabled()) {
            requestsToDisable.add(this.methodExitRequestForStepOut);
        }
        if (this.methodEntryRequestStepIntoMethod != null && this.methodEntryRequestStepIntoMethod.isEnabled()) {
            requestsToDisable.add(this.methodEntryRequestStepIntoMethod);
        }
        if (this.startCPR != null && this.startCPR.isEnabled()) {
            requestsToDisable.add(this.startCPR);
        }
        if (this.startTSR != null && this.startTSR.isEnabled()) {
            requestsToDisable.add(this.startTSR);
        }
        if (this.startStepRequests != null) {
            for (StepRequest sr : this.startStepRequests.values()) {
                if (!sr.isEnabled()) continue;
                requestsToDisable.add(sr);
            }
        }
        int size = requestsToDisable.size();
        for (int i = 0; i < size; ++i) {
            EventRequest er = (EventRequest)requestsToDisable.get(i);
            er.disable();
        }
        this.tempDisableBreakpoints();
        return requestsToDisable;
    }

    void tempReenableRequests(java.util.List requestsToEnable) {
        int size = requestsToEnable.size();
        for (int i = 0; i < size; ++i) {
            EventRequest er = (EventRequest)requestsToEnable.get(i);
            er.enable();
        }
        this.tempReenableBreakpoints();
    }

    synchronized void tempDisableBreakpoints() {
        for (DebugJDIBreakpoint bp : this.breakpoints) {
            bp.tempDisableRequests();
        }
    }

    synchronized void tempReenableBreakpoints() {
        for (DebugJDIBreakpoint bp : this.breakpoints) {
            bp.tempReenableRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanUp() {
        if (!this.cleanedUp) {
            this.cleanedUp = true;
            this.engine = null;
            this.threadReturnValues = null;
            if (anonymousBlockManager != null) {
                anonymousBlockManager.remove(System.identityHashCode(this));
            }
            Object object = this.unhandledEventSets;
            synchronized (object) {
                this.unhandledEventSets.clear();
            }
            this.needToResume.clear();
            this.eq = null;
            this.erm = null;
            this.cur = null;
            this.startCPR = null;
            this.startTSR = null;
            if (this.startStepRequests != null) {
                this.startStepRequests.clear();
            }
            this.stepLocation = null;
            this.stepStack = null;
            this.stepRequest = null;
            this.methodExitRequestForStepToEndOfMethod = null;
            this.methodExitRequestForStepToEndOfMethodMethod = null;
            this.methodExitRequestForStepOut = null;
            this.methodEntryRequestStepIntoMethod = null;
            this.methodVisitationStateTracking.clear();
            object = this;
            synchronized (object) {
                if (this.breakpoints != null) {
                    this.disconnectBreakpoints();
                    this.breakpoints.clear();
                }
                if (this.cprBreakpoints != null) {
                    this.cprBreakpoints.clear();
                }
            }
            object = this.classesLock;
            synchronized (object) {
                this.classes.clear();
            }
            if (this.cprsByFilter != null) {
                this.cprsByFilter.clear();
            }
            if (this.classesByReferenceType != null) {
                this.classesByReferenceType.clear();
            }
            if (this.classesByName != null) {
                this.classesByName.clear();
            }
            if (this.classesByNameWithoutPackage != null) {
                this.classesByNameWithoutPackage.clear();
            }
            if (this.classesCollected != null) {
                this.classesCollected.clear();
            }
            if (this.classesNotCollected != null) {
                this.classesNotCollected.clear();
            }
            if (this.objectsCollected != null) {
                this.objectsCollected.clear();
            }
            if (this.objectsNotCollected != null) {
                this.objectsNotCollected.clear();
            }
            if (this.debuggable != null) {
                this.debuggable.clear();
            }
            if (this.nonDebuggable != null) {
                this.nonDebuggable.clear();
            }
            if (this.nonDebuggableClassExclusionFilters != null) {
                this.nonDebuggableClassExclusionFilters.clear();
            }
            if (this.otherWaitingThreads != null) {
                this.otherWaitingThreads.clear();
            }
            object = this.threadInfos;
            synchronized (object) {
                this.threadInfos.clear();
            }
            this.stackFrameInfos.clear();
            this.classLoaderInfos.clear();
            this.classLoaderIds.clear();
            this.systemClassLoader = null;
            this.currentBreakpoint = null;
            this.currentThread = null;
            this.eventThread = null;
            this.currentThrow = null;
            this.currentThrowHandler = null;
            this.watchpointObject = null;
            this.watchpointField = null;
            this.watchpointFieldFutureValue = null;
            if (this.stoppedListeners != null) {
                this.stoppedListeners.clear();
            }
            if (this.pins != null) {
                this.pins.clear();
            }
            this.debugListener = null;
            this.bpLogListener = null;
            object = this.syncObjects[5];
            synchronized (object) {
                if (this.connectionLogs != null) {
                    if ((stdErrCount -= this.connectionLogs.size()) == 0 && stdErr != null) {
                        System.setErr(stdErr);
                        stdErr = null;
                    }
                    this.connectionLogs.clear();
                }
            }
            this.stopMethodEvaluationWorker();
            this.stopDeadlockDetectorThread();
            if (this.pcl != null) {
                EditorProperties.getProperties().removePropertyChangeListener((PropertyChangeListener)this.pcl);
                this.pcl = null;
            }
        }
    }

    private synchronized void disconnectBreakpoints() {
        for (DebugJDIBreakpoint bp : this.breakpoints) {
            bp.disconnect();
        }
        this.bpRequests.clear();
    }

    private boolean checkForBreakpointHit(Event e, ThreadReference tr) {
        if (!this.bpRequests.contains(e.request())) {
            return false;
        }
        boolean started = this.startTestConnectionThread("checkForBreakpointHit");
        this.eventThread = tr;
        this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
        if (e instanceof ExceptionEvent) {
            ExceptionEvent ee = (ExceptionEvent)e;
            this.currentThrow = (DebugJDIDataObjectInfo)this.makeData(ee.exception(), null);
            Location loc = ee.catchLocation();
            if (loc != null) {
                this.currentThrowHandler = this.makeLocation(loc);
            }
        } else if (e instanceof WatchpointEvent) {
            ModificationWatchpointEvent mwe;
            Value fieldValueToBe;
            DebugJDIClassInfo fieldClass;
            WatchpointEvent we = (WatchpointEvent)e;
            Field f = we.field();
            try {
                fieldClass = this.findClassByType(f.type());
            }
            catch (Exception ex) {
                fieldClass = this.findClassByName(f.typeName(), true);
            }
            if (fieldClass == null) {
                fieldClass = this.findClassByName(f.typeName(), true);
            }
            ObjectReference object = we.object();
            DebugJDIClassInfo objectClass = this.findClass(f.declaringType());
            this.watchpointObject = object != null ? (DebugJDIDataObjectInfo)this.makeData(object, null) : (DebugJDIDataObjectInfo)this.makeNullData(objectClass, null);
            this.watchpointField = new DebugJDIFieldInfo(this, f, objectClass, object);
            this.watchpointFieldFutureValue = e instanceof ModificationWatchpointEvent ? ((fieldValueToBe = (mwe = (ModificationWatchpointEvent)e).valueToBe()) != null ? this.makeData(fieldValueToBe, null) : this.makeNullData(fieldClass, null)) : null;
        }
        DebugJDIBreakpoint stop = null;
        java.util.List<DebugJDIBreakpoint> v = this.findBreakpointsForEvent(e, tr);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            DebugJDIBreakpoint bp = v.get(i);
            if (!this.doBreakpointActions(bp, e, tr)) continue;
            stop = bp;
        }
        if (started) {
            this.killTestConnectionThread();
        }
        if (stop != null) {
            this.eventThread = tr;
            this.currentBreakpoint = stop;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.List<DebugJDIBreakpoint> findBreakpointsForEvent(Event e, ThreadReference tr) {
        ArrayList<DebugJDIBreakpoint> breakpointsCopy;
        ArrayList<DebugJDIBreakpoint> v = new ArrayList<DebugJDIBreakpoint>();
        DebugJDI debugJDI = this;
        synchronized (debugJDI) {
            breakpointsCopy = new ArrayList<DebugJDIBreakpoint>(this.breakpoints);
        }
        for (DebugJDIBreakpoint bp : breakpointsCopy) {
            if (!bp.isThisYourEvent(e, tr)) continue;
            v.add(bp);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doBreakpointActions(DebugJDIBreakpoint bp, Event e, ThreadReference tr) {
        String disableOtherBPs;
        String enableOtherBPs;
        if (bp instanceof CodeExecutionBreakpoint) {
            CodeExecutionBreakpoint code = (CodeExecutionBreakpoint)bp;
            code.executeAfterStop();
        }
        if ((enableOtherBPs = bp.getEnableOtherBPs()) != null && enableOtherBPs.length() > 0) {
            DebugJDI debugJDI = this;
            synchronized (debugJDI) {
                for (DebugJDIBreakpoint debugJDIBreakpoint : this.breakpoints) {
                    if (!enableOtherBPs.equals(debugJDIBreakpoint.getName()) || debugJDIBreakpoint.getEnabled()) continue;
                    debugJDIBreakpoint.setEnabled(true);
                    if (this.debugListener == null) continue;
                    this.debugListener.breakpointChanged((DebugBreakpoint)debugJDIBreakpoint);
                }
            }
        }
        if ((disableOtherBPs = bp.getDisableOtherBPs()) != null && disableOtherBPs.length() > 0) {
            DebugJDI debugJDI = this;
            synchronized (debugJDI) {
                for (DebugJDIBreakpoint other : this.breakpoints) {
                    if (!disableOtherBPs.equals(other.getName()) || !other.getEnabled()) continue;
                    other.setEnabled(false);
                    if (this.debugListener == null) continue;
                    this.debugListener.breakpointChanged((DebugBreakpoint)other);
                }
            }
        }
        DebugBreakpointLogListener listener = this.bpLogListener;
        if (bp.getLog() && listener != null) {
            this.incrementStoppedCount(false);
            DebugJDIThreadInfo debugJDIThreadInfo = DebugJDIThreadInfo.makeThreadInfo(this, tr);
            DebugStackFrameInfo[] stack = debugJDIThreadInfo.listStack();
            if (bp instanceof DebugJDIBreakpointPackageFileLine || bp instanceof DebugJDIBreakpointFileLine || bp instanceof DebugJDIBreakpointMethodBytecode || bp instanceof DebugJDIBreakpointMethod || bp instanceof DebugJDIBreakpointClass) {
                listener.logBreakpoint((DebugBreakpoint)bp, (DebugThreadInfo)debugJDIThreadInfo, stack);
            } else if (bp instanceof DebugJDIBreakpointException) {
                Value v;
                if (this.currentThrow == null) {
                    return bp.getStop();
                }
                ObjectReference or = (ObjectReference)this.currentThrow.value;
                ReferenceType rt = or.referenceType();
                String className = rt.name();
                String detail = "";
                Field f = rt.fieldByName("detailMessage");
                if (f != null && (v = or.getValue(f)) != null) {
                    detail = ((StringReference)v).value();
                }
                listener.logException((DebugBreakpoint)bp, className, detail, (DebugThreadInfo)debugJDIThreadInfo, stack);
            } else if (bp instanceof DebugJDIBreakpointClassLoad) {
                ClassPrepareEvent cpe = (ClassPrepareEvent)e;
                ReferenceType rt = cpe.referenceType();
                String className = rt.name();
                listener.logClassLoad((DebugBreakpoint)bp, className, (DebugThreadInfo)debugJDIThreadInfo, stack);
            } else if (bp instanceof DebugJDIBreakpointDeadlock) {
                listener.logDeadlock((DebugBreakpoint)bp, (DebugThreadInfo)debugJDIThreadInfo, stack);
            } else if (bp instanceof DebugJDIBreakpointWatchpoint) {
                listener.logWatchpoint((DebugBreakpoint)bp, (DebugFieldInfo)this.watchpointField, (DebugDataInfo)this.watchpointFieldFutureValue, (DebugThreadInfo)debugJDIThreadInfo, stack);
            }
            this.incrementStoppedCount(false);
        }
        return bp.getStop();
    }

    static Location getFirstLocation(java.util.List locations) {
        int index = -1;
        long lowestBC = 0L;
        int size = locations.size();
        for (int i = 0; i < size; ++i) {
            Location location = (Location)locations.get(i);
            long bc = location.codeIndex();
            if (index != -1 && bc >= lowestBC) continue;
            index = i;
            lowestBC = bc;
        }
        if (index != -1) {
            return (Location)locations.get(index);
        }
        return null;
    }

    DebugJDILocation makeLocation(Location location) {
        return new DebugJDILocation(this, location);
    }

    private void initSync() {
        int i;
        this.syncObjects = new Object[8];
        for (i = 0; i < 8; ++i) {
            this.syncObjects[i] = new Integer(i);
        }
        this.syncValues = new boolean[8];
        for (i = 0; i < 8; ++i) {
            this.syncValues[i] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSyncValue(int i, boolean value) {
        Object object = this.syncObjects[i];
        synchronized (object) {
            boolean prevValue = this.syncValues[i];
            this.syncValues[i] = value;
            return prevValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSyncValue(int i) {
        Object object = this.syncObjects[i];
        synchronized (object) {
            return this.syncValues[i];
        }
    }

    private synchronized java.util.List<DebugJDIBreakpoint> verifyBreakpoints(ReferenceType rt, boolean callListeners) {
        ArrayList<DebugJDIBreakpoint> changedBreakpoints = null;
        String rtName = rt.name();
        for (DebugJDIBreakpoint bp : this.breakpoints) {
            try {
                if (!bp.needsVerification() || !bp.verify(rt, rtName)) continue;
                if (callListeners) {
                    if (this.debugListener == null) continue;
                    this.debugListener.breakpointChanged((DebugBreakpoint)bp);
                    continue;
                }
                if (changedBreakpoints == null) {
                    changedBreakpoints = new ArrayList<DebugJDIBreakpoint>();
                }
                changedBreakpoints.add(bp);
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        return changedBreakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionLog(Object log) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            boolean needToSetDebugTraceMode = false;
            if (this.connectionLogs == null) {
                this.connectionLogs = new ArrayList<Object>();
                needToSetDebugTraceMode = true;
            }
            this.connectionLogs.add(log);
            if (++stdErrCount == 1 && stdErr == null) {
                stdErr = System.err;
                FakePrintStream fake = new FakePrintStream(stdErr);
                System.setErr(fake);
            }
            if (needToSetDebugTraceMode && this.vm != null) {
                this.vm.setDebugTraceMode(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionLog(Object log) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                this.connectionLogs.remove(log);
                if (this.connectionLogs.size() == 0) {
                    this.connectionLogs = null;
                    if (this.vm != null) {
                        this.vm.setDebugTraceMode(0);
                    }
                }
                if (--stdErrCount == 0 && stdErr != null) {
                    System.setErr(stdErr);
                    stdErr = null;
                }
            }
        }
    }

    public synchronized String getName() {
        return this.vm.name();
    }

    public int getLanguages() {
        return this.languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] redefineClasses(Map nameToGuts) {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.vm.canRedefineClasses()) {
            String msg;
            Throwable thrown = null;
            try {
                HashMap<ReferenceType, byte[]> rtToGuts = new HashMap<ReferenceType, byte[]>();
                ArrayList<DebugJDIClassInfo> classesAffected = new ArrayList<DebugJDIClassInfo>();
                for (Map.Entry entry : nameToGuts.entrySet()) {
                    String key = (String)entry.getKey();
                    classesLogger.trace(key + " redefined");
                    Object c = this.getClassesNamed(key);
                    if (c == null) continue;
                    byte[] guts = (byte[])entry.getValue();
                    if (c instanceof DebugJDIClassInfo) {
                        DebugJDIClassInfo clazz = (DebugJDIClassInfo)((Object)c);
                        if (clazz.getReferenceType() == null) continue;
                        this.redefiningClass(clazz);
                        classesAffected.add(clazz);
                        rtToGuts.put(clazz.getReferenceType(), guts);
                        continue;
                    }
                    if (!(c instanceof java.util.List)) continue;
                    java.util.List list = (java.util.List)c;
                    for (DebugJDIClassInfo clazz : list) {
                        if (clazz.getReferenceType() == null) continue;
                        this.redefiningClass(clazz);
                        classesAffected.add(clazz);
                        rtToGuts.put(clazz.getReferenceType(), guts);
                    }
                }
                try {
                    this.redefineClassesOccurred = true;
                    this.vm.redefineClasses(rtToGuts);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                }
                for (int i = classesAffected.size() - 1; i >= 0; --i) {
                    this.redefinedClass((DebugJDIClassInfo)((Object)classesAffected.get(i)));
                }
                return null;
            }
            catch (Error err) {
                thrown = err;
            }
            catch (Exception e) {
                thrown = e;
            }
            if (thrown != null && (msg = thrown.getMessage()) != null) {
                if (msg.endsWith(" not implemented")) {
                    msg = msg.substring(0, msg.length() - 16);
                }
                if (thrown instanceof UnsupportedOperationException) {
                    msg = DebugJDIArb.format(2, msg);
                }
                if (thrown instanceof VerifyError) {
                    msg = DebugJDIArb.format(8, msg);
                }
                if (msg.length() > 0) {
                    errors.add(msg);
                }
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefiningClass(DebugJDIClassInfo clazz) {
        clazz.redefiningClass();
        DebugJDI debugJDI = this;
        synchronized (debugJDI) {
            for (DebugJDIBreakpoint bp : this.breakpoints) {
                bp.redefiningClass(clazz.getReferenceType());
            }
        }
    }

    private void redefinedClass(DebugJDIClassInfo clazz) {
        if (this.debuggeeStarted) {
            if (this.executionTracker != null) {
                this.executionTracker.trackClassRedefinition((DebugClassInfo)clazz);
            }
            this.verifyBreakpoints(clazz.getReferenceType(), true);
        }
    }

    public boolean canGetConstantPool() {
        if (this.vm != null) {
            return this.vm.canGetConstantPool();
        }
        return false;
    }

    public DebugEvaluator[] getEvaluators() {
        return null;
    }

    public void clearEvaluators() {
    }

    public boolean canShowDebugLocations() {
        return false;
    }

    public boolean showDebugLocation(DebugLocation location) {
        return false;
    }

    public String getID() {
        if (this.languages == 4) {
            return DbgArb.getString((int)855);
        }
        return DbgArb.getString((int)856);
    }

    public void setSuspendBreakpoints(boolean suspended) {
        this.breakpointsSuspended = suspended;
    }

    public boolean getSuspendBreakpoints() {
        return this.breakpointsSuspended;
    }

    public DebuggerWindowOptions getDebuggerWindowOptions(DebuggerWindowOptions.WindowId windowId) {
        switch (windowId) {
            case StackWindow: {
                return DebuggerWindowOptions.DEFAULT;
            }
            case LocalsWindow: 
            case SmartWindow: 
            case WatchWindow: 
            case InspectorWindow: 
            case HeapWindow: {
                return DebuggerWindowOptions.DEFAULT;
            }
            case MonitorsWindow: 
            case ThreadsWindow: 
            case BreakpointsWindow: 
            case ClassesWindow: {
                return DebuggerWindowOptions.DEFAULT;
            }
        }
        System.out.println("DebugJDI.getDebuggerWindowOptions: Unknown window type " + windowId);
        return null;
    }

    public boolean canSuspendBreakpoints() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logToConnectionLogs(String s) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                int size = this.connectionLogs.size();
                for (int i = 0; i < size; ++i) {
                    Object log = this.connectionLogs.get(i);
                    try {
                        if (log instanceof List) {
                            List list = (List)log;
                            list.add(s);
                            list.makeVisible(list.getItemCount() - 1);
                            continue;
                        }
                        if (log instanceof PrintStream) {
                            PrintStream ps = (PrintStream)log;
                            ps.println(s);
                            continue;
                        }
                        if (!(log instanceof File)) continue;
                        String filename = ((File)log).getAbsolutePath();
                        PrintWriter writer = new PrintWriter(new FileWriter(filename, true));
                        writer.println(s);
                        writer.flush();
                        writer.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void addStoppedListener(DebugJDIStoppedListener l) {
        this.stoppedListeners.add(l);
    }

    void removeStoppedListener(DebugJDIStoppedListener l) {
        this.stoppedListeners.remove(l);
    }

    void incrementStoppedCount(boolean stopped) {
        ++this.stoppedCount;
        if (this.currentThrow != null) {
            this.currentThrow.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointObject != null) {
            this.watchpointObject.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointField != null) {
            this.watchpointField.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointFieldFutureValue != null) {
            this.watchpointFieldFutureValue.stoppedCount = this.stoppedCount;
        }
        if (this.classesNotCollected != null) {
            this.classesNotCollected.clear();
        }
        if (this.objectsNotCollected != null) {
            this.objectsNotCollected.clear();
        }
        DebugJDIThreadInfo.clearCache(this, stopped);
        DebugJDIStackFrameInfo.clearCache(this);
        if (this.stoppedListeners != null) {
            DebugJDIStoppedListener[] array = this.stoppedListeners.toArray(new DebugJDIStoppedListener[this.stoppedListeners.size()]);
            for (int i = 0; i < array.length; ++i) {
                array[i].stopped(stopped);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClassDebuggable(String className) {
        java.util.List<String> list = this.debuggable;
        synchronized (list) {
            return DebugShared.isClassOrPackageDebuggable((String)className, this.debuggable, this.nonDebuggable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNonDebuggableClassExclusionFilter(String className) {
        java.util.List<String> list = this.debuggable;
        synchronized (list) {
            if (this.debuggable.size() != 0) {
                int dot = className.indexOf(46);
                while (dot != -1) {
                    String part = className.substring(0, dot + 1);
                    if (!DebugJDI.findPartialNameInPackageList(part, this.debuggable)) {
                        return part + "*";
                    }
                    dot = className.indexOf(46, dot + 1);
                }
                return className;
            }
        }
        return null;
    }

    private static boolean findPartialNameInPackageList(String part, java.util.List v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            String s = (String)v.get(i);
            if (!s.startsWith(part)) continue;
            return true;
        }
        return false;
    }

    private static Location getLocation(ThreadReference tr) {
        try {
            return tr.frame(0).location();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getSourceName(Location location) {
        try {
            return location.sourceName();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getSourcePath(Location location) {
        try {
            return location.sourcePath();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static boolean sameSourceLocation(Location loc1, Location loc2) {
        try {
            String defaultStratum;
            if (loc1.method().equals(loc2.method()) && DebugJDI.getLineNumber(loc1, defaultStratum = loc1.declaringType().defaultStratum()) == DebugJDI.getLineNumber(loc2, defaultStratum)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static int getStackFrameCount(ThreadReference tr) {
        try {
            return tr.frameCount();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static String[] getStack(ThreadReference tr) {
        try {
            java.util.List<StackFrame> frames = tr.frames();
            int size = frames.size();
            String[] s = new String[size];
            for (int i = 0; i < size; ++i) {
                try {
                    s[i] = frames.get(i).toString();
                    continue;
                }
                catch (Throwable t) {
                    s[i] = t.getMessage();
                }
            }
            return s;
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }

    private static boolean sameStack(String[] stack1, String[] stack2) {
        try {
            if (stack1 == null || stack2 == null) {
                return false;
            }
            int length = stack1.length;
            if (length != stack2.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (stack1[i] != null && stack2[i] != null && stack1[i].equals(stack2[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void addBPRequest(EventRequest er) {
        this.bpRequests.add(er);
    }

    void removeBPRequest(EventRequest er) {
        this.bpRequests.remove(er);
    }

    boolean isMethodObsolete(Method method) {
        if (this.redefineClassesOccurred) {
            try {
                return method.isObsolete();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoaderReference getSystemClassLoader() {
        Object object = this.syncObjects[7];
        synchronized (object) {
            DebugJDIDataObjectInfo systemClassLoaderObject;
            DebugJDIClassInfo classLoaderClass;
            if (this.systemClassLoader == null && (classLoaderClass = this.findClassByName("java.lang.ClassLoader", false)) != null && (systemClassLoaderObject = (DebugJDIDataObjectInfo)DebugShared.getSystemClassLoaderObject((DebugClassInfo)classLoaderClass)) != null) {
                this.systemClassLoader = (ClassLoaderReference)systemClassLoaderObject.value;
            }
            return this.systemClassLoader;
        }
    }

    ClassLoaderReference getClassLoader(ReferenceType rt) throws Exception {
        ClassLoaderReference clr = rt.classLoader();
        if (this.isOracleDatabaseVM() && clr != null && clr.referenceType() == rt) {
            return null;
        }
        return clr;
    }

    public static synchronized void setDebugJDIAnonymousBlockManagerFactory(DebugJDIAnonymousBlockManagerFactory factory) {
        anonymousBlockManagerFactory = factory;
    }

    static synchronized void makeAnonymousBlockManager() {
        if (anonymousBlockManager == null && anonymousBlockManagerFactory != null) {
            anonymousBlockManager = anonymousBlockManagerFactory.createInstance();
        }
    }

    static int getLineNumber(Location loc, String stratum) {
        int lineNumber = -1;
        try {
            lineNumber = loc.lineNumber(stratum);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lineNumber != -1 && DebugJDI.shouldAdjustLineNumbers(loc.declaringType())) {
            lineNumber += lineNumberAdjustmentValue;
        }
        return lineNumber;
    }

    static boolean shouldAdjustLineNumbers(ReferenceType rt) {
        return rt.name().startsWith("$Oracle.") && !rt.name().startsWith("$Oracle.Block.");
    }

    public static void setLineNumberAdjustmentValue(int value) {
        lineNumberAdjustmentValue = value;
    }

    static java.util.List getLocationsOfLine(Object o, String stratum, String filename, int lineNumber) throws AbsentInformationException {
        ReferenceType rt = null;
        if (o instanceof Method) {
            rt = ((Method)o).declaringType();
        } else if (o instanceof ReferenceType) {
            rt = (ReferenceType)o;
        } else {
            throw new IllegalArgumentException();
        }
        if (DebugJDI.shouldAdjustLineNumbers(rt)) {
            lineNumber -= lineNumberAdjustmentValue;
        }
        if (o instanceof Method) {
            if (stratum == null && filename == null) {
                return ((Method)o).locationsOfLine(lineNumber);
            }
            return ((Method)o).locationsOfLine(stratum, filename, lineNumber);
        }
        return ((ReferenceType)o).locationsOfLine(stratum, filename, lineNumber);
    }

    boolean isSafeToGetAnnotations() {
        if (this.eventThread != null && this.vm.canGetOwnedMonitorInfo()) {
            java.util.List<ThreadReference> threads = this.allThreads();
            for (int x = 0; x < threads.size(); ++x) {
                ThreadReference threadReference = threads.get(x);
                if (threadReference.equals(this.eventThread)) continue;
                try {
                    java.util.List<ObjectReference> ownedMonitors = threadReference.ownedMonitors();
                    for (ObjectReference monitor : ownedMonitors) {
                        ReferenceType referenceType = monitor.referenceType();
                        String name = referenceType.name();
                        if (!name.equals("java.lang.SecurityManager") && !name.equals("sun.reflect.annotation.AnnotationType") && !name.equals("java.lang.Class")) continue;
                        return false;
                    }
                    continue;
                }
                catch (IncompatibleThreadStateException e) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DebugJDIAnnotationInfo[] getAnnotations(ObjectReference orAnnotatedElement) {
        try {
            Log logger = JDebugger.logger;
            ClassType ctAnnotatedElement = (ClassType)orAnnotatedElement.referenceType();
            Method mGetDeclaredAnnotations = ctAnnotatedElement.concreteMethodByName("getDeclaredAnnotations", "()[Ljava/lang/annotation/Annotation;");
            if (mGetDeclaredAnnotations == null) return new DebugJDIAnnotationInfo[0];
            Object object = this.methodCallLock;
            synchronized (object) {
                java.util.List prev = this.tempDisableRequests();
                try {
                    ArrayReference arAnnotations = null;
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.startMethodEvaluationWorker();
                        this.methodEvaluationWorker.or = orAnnotatedElement;
                        this.methodEvaluationWorker.methodEvaluationType = MethodEvaluationType.VIRTUAL_CALL;
                        this.methodEvaluationWorker.dj = this;
                        this.methodEvaluationWorker.m = mGetDeclaredAnnotations;
                        this.methodEvaluationWorker.argList = Collections.emptyList();
                        try {
                            arAnnotations = (ArrayReference)this.evaluateMethodCheckForHang();
                        }
                        catch (Exception ex) {
                            DebugJDIAnnotationInfo[] debugJDIAnnotationInfoArray = new DebugJDIAnnotationInfo[]{};
                            DebugJDIStackFrameInfo.rebuildCache(this);
                            this.tempReenableRequests(prev);
                            return debugJDIAnnotationInfoArray;
                        }
                    } else {
                        if (logger.isEnabled()) {
                            ClassType ctClass = (ClassType)orAnnotatedElement.referenceType();
                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)mGetDeclaredAnnotations.name());
                        }
                        int flag = MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        arAnnotations = (ArrayReference)orAnnotatedElement.invokeMethod(this.eventThread, mGetDeclaredAnnotations, Collections.EMPTY_LIST, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(arAnnotations == null ? "null" : "not null"));
                        }
                    }
                    if (arAnnotations == null) return new DebugJDIAnnotationInfo[0];
                    DebugJDIAnnotationInfo[] array = new DebugJDIAnnotationInfo[arAnnotations.length()];
                    int i = 0;
                    for (Value annotation : arAnnotations.getValues()) {
                        array[i] = new DebugJDIAnnotationInfo(this, (ObjectReference)annotation);
                        ++i;
                    }
                    DebugJDIAnnotationInfo[] debugJDIAnnotationInfoArray = array;
                    return debugJDIAnnotationInfoArray;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    public boolean canStopOnException() {
        return false;
    }

    public boolean canStopOnError() {
        return false;
    }

    public boolean canStopOnDebuggerStatement() {
        return false;
    }

    public boolean canTransferErrors() {
        return false;
    }

    public boolean getStopOnException() {
        return false;
    }

    public boolean getStopOnError() {
        return false;
    }

    public boolean getStopOnDebuggerStatement() {
        return false;
    }

    public boolean getTransferErrors() {
        return false;
    }

    public void setStopOnException(boolean b) {
    }

    public void setStopOnError(boolean b) {
    }

    public void setStopOnDebuggerStatement(boolean b) {
    }

    public void setTransferErrors(boolean b) {
    }

    public void setCurrentStackFrame(DebugStackFrameInfo sfInfo) {
        this.currentStackFrame = sfInfo;
    }

    public DebugStackFrameInfo getCurrentStackFrame() {
        return this.currentStackFrame;
    }

    public boolean canStopInChrome() {
        return false;
    }

    public boolean getStopInChrome() {
        return false;
    }

    public void setStopInChrome(boolean b) {
    }

    Value getReturnValueForThread(long threadId) {
        if (this.runCommand == 8) {
            return this.getReturnOrReturnedValueForThread(threadId);
        }
        return null;
    }

    Value getReturnedValueForThread(long threadId) {
        if (this.runCommand == 7) {
            return this.getReturnOrReturnedValueForThread(threadId);
        }
        return null;
    }

    private Value getReturnOrReturnedValueForThread(long threadId) {
        Value returnValue;
        MethodExitEvent e;
        if (this.threadReturnValues != null && (e = this.threadReturnValues.get(new Long(threadId))) != null && (returnValue = e.returnValue()) != null && !(returnValue.type() instanceof VoidType)) {
            return returnValue;
        }
        return null;
    }

    MethodExitEvent getMethodExitEventForThread(long threadId) {
        if (this.threadReturnValues != null) {
            return this.threadReturnValues.get(new Long(threadId));
        }
        return null;
    }

    DebugHeapObjectInfo[] getHeapObjects(long[] heapAddresses, int start, int count) {
        ArrayList<DebugJDIHeapObjectInfo> ret = new ArrayList<DebugJDIHeapObjectInfo>();
        for (int i = 0; i < count; ++i) {
            DebugJDIHeapObjectInfo oi = this.id2ObjectReference.get(new Long(heapAddresses[start + i]));
            if (oi == null) continue;
            ret.add(oi);
        }
        return ret.toArray(new DebugHeapObjectInfo[ret.size()]);
    }

    DebugJDIDataCompositeInfo getObjectFromAddress(long address) {
        DebugJDIHeapObjectInfo oi = this.id2ObjectReference.get(new Long(address));
        if (oi != null) {
            return (DebugJDIDataCompositeInfo)oi.getDataInfo();
        }
        return null;
    }

    private DebugJDIHeapAncestorOutsideHeap getOHObject(ObjectReference or) {
        if (this.id2ObjectReference == null) {
            this.id2ObjectReference = new HashMap<Long, DebugJDIHeapObjectInfo>();
        }
        this.id2ObjectReference.put(new Long(or.uniqueID()), this.makeJDIHeapObjectInfo(or));
        return new DebugJDIHeapAncestorOutsideHeap(this, or.uniqueID());
    }

    private java.util.List<OutsideHeapDepthHelper> getReferrerOHObject(ObjectReference or, int[] heapDepth, long originalId, Set<Long> visited) {
        ArrayList<OuterObjectReference> outers = new ArrayList<OuterObjectReference>();
        outers.addAll(this.getOuterRootReferences(or, heapDepth, originalId, visited));
        if (this.id2ObjectReference == null) {
            this.id2ObjectReference = new HashMap<Long, DebugJDIHeapObjectInfo>();
        }
        ArrayList<OutsideHeapDepthHelper> ret = new ArrayList<OutsideHeapDepthHelper>();
        for (int i = 0; i < outers.size(); ++i) {
            OuterObjectReference outer = (OuterObjectReference)outers.get(i);
            DebugJDIHeapObjectInfo oi = this.makeJDIHeapObjectInfo(outer.or);
            this.id2ObjectReference.put(new Long(outer.or.uniqueID()), oi);
            DebugJDIHeapAncestorOutsideHeap oa = null;
            oa = outer.isStaticField && outer.dfi != null ? new DebugJDIHeapAncestorInStatic(this, outer.or.uniqueID(), (DebugJDIClassInfo)outer.dfi.getClassInfo(), (DebugJDIFieldInfo)outer.dfi) : new DebugJDIHeapAncestorInPinTable(this, outer.or.uniqueID(), (DebugJDIClassInfo)oi.getClassInfo(), outer.or);
            if (oa == null) continue;
            ret.add(new OutsideHeapDepthHelper(oa, heapDepth[0]));
        }
        return ret;
    }

    private java.util.List<OuterObjectReference> getOuterRootReferences(ObjectReference or, int[] heapDepth, long originalId, Set<Long> visited) {
        ArrayList<OuterObjectReference> ret = new ArrayList<OuterObjectReference>();
        if (or.type() == null) {
            return ret;
        }
        String name = or.type().name();
        HeapWindowSettings hws = (HeapWindowSettings)Ide.getSettings().getData("HeapWindowOptions");
        if (hws != null && hws.isIgnoreSoftWeak() && name.startsWith("java.lang.ref.")) {
            return ret;
        }
        if (visited == null) {
            visited = new HashSet<Long>();
        }
        if (visited.contains(or.uniqueID())) {
            return ret;
        }
        visited.add(or.uniqueID());
        heapDepth[0] = heapDepth[0] + 1;
        Field staticField = null;
        boolean isStatic = false;
        if (or != null && or instanceof ClassObjectReference) {
            ArrayList<DebugJDIClassInfo> classes = new ArrayList<DebugJDIClassInfo>();
            Object classList = this.classesByName.get(((ClassObjectReference)or).reflectedType().name());
            if (classList instanceof java.util.List) {
                for (int i2 = 0; i2 < ((java.util.List)classList).size(); ++i2) {
                    classes.add((DebugJDIClassInfo)((Object)((java.util.List)classList).get(i2)));
                }
            } else {
                classes.add((DebugJDIClassInfo)((Object)classList));
            }
            for (int i3 = 0; i3 < classes.size(); ++i3) {
                DebugJDIClassInfo ci = (DebugJDIClassInfo)((Object)classes.get(i3));
                DebugFieldInfo[] fields = ci.getFields(0, false, false);
                for (int i4 = 0; i4 < fields.length; ++i4) {
                    Value value;
                    if (fields[i4] == null || !fields[i4].isStatic()) continue;
                    Field field = ((DebugJDIFieldInfo)fields[i4]).getJDIField();
                    Type ct = ci.getJDIType();
                    if (!(ct instanceof ClassType) || (value = ((ClassType)ct).getValue(field)) == null || !(value instanceof ObjectReference) || ((ObjectReference)value).uniqueID() != originalId) continue;
                    isStatic = true;
                    staticField = field;
                    ret.add(new OuterObjectReference(heapDepth[0], or, isStatic, staticField, (DebugJDIFieldInfo)fields[i4]));
                }
            }
        }
        if (!name.equals("java.lang.Class")) {
            ret.add(new OuterObjectReference(heapDepth[0], or, false, null, null));
        }
        return ret;
    }

    private DebugJDIHeapObjectInfo makeJDIHeapObjectInfo(ObjectReference or) {
        DebugJDIClassInfo clazz = this.findClass(or.referenceType());
        return new DebugJDIHeapObjectInfo(this, or, false, 0, clazz);
    }

    private DebugJDIHeapObjectInfo getNotGottenObjectReference(long l, DebugClassInfo classInfo) {
        Iterator<ReferenceType> crIterator;
        ReferenceType cr;
        if (classInfo != null && classInfo instanceof DebugJDIClassInfo && ((DebugJDIClassInfo)classInfo).getJDIType() instanceof ReferenceType && (cr = (ReferenceType)((DebugJDIClassInfo)classInfo).getJDIType()) != null) {
            java.util.List<ObjectReference> orL = cr.instances(0L);
            for (ObjectReference or : orL) {
                if (or == null || or.uniqueID() != l) continue;
                return this.makeJDIHeapObjectInfo(or);
            }
        }
        if ((crIterator = this.classesByReferenceType.keySet().iterator()) != null) {
            while (crIterator.hasNext()) {
                ReferenceType cr2 = crIterator.next();
                if (cr2 == null) continue;
                java.util.List<ObjectReference> orL = cr2.instances(0L);
                for (ObjectReference or : orL) {
                    if (or == null || or.uniqueID() != l) continue;
                    return this.makeJDIHeapObjectInfo(or);
                }
            }
        }
        return null;
    }

    public Object newObject(String typeName, java.util.List<Object> parameters) throws Exception {
        DebugJDIDataObjectInfo newObject = null;
        if (JAVA_LANG_BYTE_STRING.equals(typeName) || "Byte".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_BYTE_STRING, 1, "(B)V", parameters);
        } else if (JAVA_LANG_CHARACTER_STRING.equals(typeName) || "Character".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_CHARACTER_STRING, 2, "(C)V", parameters);
        } else if (JAVA_LANG_DOUBLE_STRING.equals(typeName) || "Double".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_DOUBLE_STRING, 3, "(D)V", parameters);
        } else if (JAVA_LANG_FLOAT_STRING.equals(typeName) || "Float".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_FLOAT_STRING, 4, "(F)V", parameters);
        } else if (JAVA_LANG_INTEGER_STRING.equals(typeName) || "Integer".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_INTEGER_STRING, 5, "(I)V", parameters);
        } else if (JAVA_LANG_LONG_STRING.equals(typeName) || "Long".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_LONG_STRING, 6, "(J)V", parameters);
        } else if (JAVA_LANG_SHORT_STRING.equals(typeName) || "Short".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_SHORT_STRING, 7, "(S)V", parameters);
        } else if (JAVA_LANG_BOOLEAN_STRING.equals(typeName) || "Boolean".equals(typeName)) {
            newObject = this.newObject(JAVA_LANG_BOOLEAN_STRING, 8, "(Z)V", parameters);
        }
        if (newObject != null) {
            return newObject;
        }
        throw new Exception("Unable to evaluate source expression: new object");
    }

    private DebugJDIDataObjectInfo newObject(String typeName, int typeCode, String constructorSignature, java.util.List<Object> parameters) throws Exception {
        Log logger = JDebugger.logger;
        ArrayList<Value> values = new ArrayList<Value>();
        Object classObject = this.classesByName.get(typeName);
        ClassType clazz = this.getNewObjectClassType(classObject);
        Method constructor = this.getNewObjectConstructor(clazz, parameters, values, constructorSignature, typeCode);
        return this.callNewObjectConstructor(constructor, clazz, classObject, logger, values, typeName);
    }

    private ClassType getNewObjectClassType(Object classObject) {
        Type type;
        ClassType clazz = null;
        if (classObject instanceof DebugJDIClassInfo) {
            Type type2 = ((DebugJDIClassInfo)((Object)classObject)).getJDIType();
            if (type2 instanceof ClassType) {
                clazz = (ClassType)type2;
            }
        } else if (classObject instanceof java.util.List && ((java.util.List)classObject).size() > 0 && (classObject = ((java.util.List)classObject).get(0)) != null && (type = ((DebugJDIClassInfo)((Object)classObject)).getJDIType()) instanceof ClassType) {
            clazz = (ClassType)type;
        }
        return clazz;
    }

    private Method getNewObjectConstructor(ClassType clazz, java.util.List<Object> parameters, java.util.List<Value> values, String oneParamSignature, int typeCode) throws Exception {
        EvaluationInfo param1EI;
        Object param1;
        if (clazz == null) {
            return null;
        }
        if (parameters == null || parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
            java.util.List<Method> constructors = clazz.methodsByName("<init>");
            for (Method m : constructors) {
                if (m.arguments().size() != 0) continue;
                return m;
            }
        } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
            try {
                switch (typeCode) {
                    case 1: {
                        byte bv = param1EI.getByteValue();
                        values.add(this.vm.mirrorOf(bv));
                        break;
                    }
                    case 2: {
                        char cv = param1EI.getCharValue();
                        values.add(this.vm.mirrorOf(cv));
                        break;
                    }
                    case 3: {
                        double dv = param1EI.getDoubleValue();
                        values.add(this.vm.mirrorOf(dv));
                        break;
                    }
                    case 4: {
                        float fv = param1EI.getFloatValue();
                        values.add(this.vm.mirrorOf(fv));
                        break;
                    }
                    case 5: {
                        int iv = param1EI.getIntValue();
                        values.add(this.vm.mirrorOf(iv));
                        break;
                    }
                    case 6: {
                        long lv = param1EI.getLongValue();
                        values.add(this.vm.mirrorOf(lv));
                        break;
                    }
                    case 7: {
                        short sv = param1EI.getShortValue();
                        values.add(this.vm.mirrorOf(sv));
                        break;
                    }
                    case 8: {
                        boolean zv = param1EI.getBooleanValue();
                        values.add(this.vm.mirrorOf(zv));
                    }
                }
                java.util.List<Method> constructors = clazz.methodsByName("<init>", oneParamSignature);
                if (constructors.size() != 0) {
                    return constructors.get(0);
                }
            }
            catch (Throwable ee) {
                throw new Exception("Unable to evaluate source expression: new object");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DebugJDIDataObjectInfo callNewObjectConstructor(Method constructor, ClassType clazz, Object classObject, Log logger, java.util.List<Value> values, String typeString) throws Exception {
        if (constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && classObject != null) {
            ObjectReference or = null;
            Object object = this.methodCallLock;
            synchronized (object) {
                java.util.List prev = this.tempDisableRequests();
                try {
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.startMethodEvaluationWorker();
                        this.methodEvaluationWorker.ct = clazz;
                        this.methodEvaluationWorker.methodEvaluationType = MethodEvaluationType.NEW_INSTANCE;
                        this.methodEvaluationWorker.dj = this;
                        this.methodEvaluationWorker.m = constructor;
                        this.methodEvaluationWorker.argList = values;
                        try {
                            or = (ObjectReference)this.evaluateMethodCheckForHang();
                        }
                        catch (Exception ex) {
                            DebugJDIDataObjectInfo debugJDIDataObjectInfo = null;
                            DebugJDIStackFrameInfo.rebuildCache(this);
                            this.tempReenableRequests(prev);
                            return debugJDIDataObjectInfo;
                        }
                    } else {
                        if (logger.isEnabled()) {
                            logger.trace("Invoking newInstance method: {0}.{1}", (Object)clazz.name(), (Object)constructor.name());
                        }
                        int flag = MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        or = clazz.newInstance(this.eventThread, constructor, values, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(or == null ? "null" : "not null"));
                        }
                    }
                    logger.trace("Created instance of " + typeString);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)((Object)classObject), or, null);
            }
        }
        return null;
    }

    public void cacheUserFoundURL(String lookedFor, URL foundUrl) {
        if (this.userUrlCacher == null) {
            this.userUrlCacher = new UserSelectedURLCacher();
        }
        this.userUrlCacher.addCachedURL(lookedFor, foundUrl);
    }

    public URL getChachedUserFoundLocation(String lookingFor) {
        if (this.userUrlCacher == null) {
            return null;
        }
        return this.userUrlCacher.getCachedUrl(lookingFor);
    }

    public long[] countObjectsOfClasses(DebugClassInfo[] classes) {
        try {
            if (this.canCountObjectsOfClass()) {
                ArrayList<ReferenceType> refTypes = new ArrayList<ReferenceType>();
                for (DebugClassInfo debugClassInfo : classes) {
                    ReferenceType refType = (ReferenceType)((DebugJDIClassInfo)debugClassInfo).type;
                    refTypes.add(refType);
                }
                return this.vm.instanceCounts(refTypes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMethodEvaluationWorker() {
        DebugWindowSettings debuggerSettings;
        if (this.methodEvaluationWorker == null && (debuggerSettings = DebugWindowSettings.getInstance()).isDetectMethodEvalDeadlocks()) {
            JDebugger.logger.trace("Starting method evaluation worker");
            this.methodEvaluationWorker = new MethodEvaluationWorker();
            Object object = this.methodEvaluationWorker.waitForWork;
            synchronized (object) {
                this.methodEvaluationWorker.start();
                try {
                    this.methodEvaluationWorker.waitForWork.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JDebugger.logger.trace("Method evaluation worker is running");
            }
        }
    }

    void stopMethodEvaluationWorker() {
        if (this.methodEvaluationWorker != null) {
            this.methodEvaluationWorker.terminate();
            this.methodEvaluationWorker = null;
        }
    }

    void stopDeadlockDetectorThread() {
        if (this.m_deadlockDetectorThread != null) {
            this.m_deadlockDetectorThread.terminate();
            this.m_deadlockDetectorThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value evaluateMethodCheckForHang() throws Exception {
        MethodEvaluationWorker worker = this.methodEvaluationWorker;
        boolean evaluationHanging = false;
        worker.gotValue = false;
        worker.exceptionThrown = null;
        worker.value = null;
        Log logger = JDebugger.logger;
        Object object = worker.waitForWork;
        synchronized (object) {
            worker.waitForWork.notify();
        }
        if (worker.gotValue) {
            if (worker.exceptionThrown != null) {
                throw new Exception(worker.exceptionThrown);
            }
            return worker.value;
        }
        if (worker.done) {
            return null;
        }
        object = worker.finished;
        synchronized (object) {
            if (!worker.gotValue) {
                try {
                    worker.finished.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (worker.gotValue) {
                if (worker.exceptionThrown != null) {
                    throw new Exception(worker.exceptionThrown);
                }
                return worker.value;
            }
            logger.trace("Method evaluation is hanging for more than 5 seconds");
            evaluationHanging = true;
        }
        if (worker.done) {
            return null;
        }
        if (!MULTI_THREADED_METHOD_EVALUATIONS && evaluationHanging) {
            object = worker.finished;
            synchronized (object) {
                if (!worker.gotValue) {
                    DebugJDIThreadInfo thread;
                    logger.trace("Settings all threads running");
                    DebugThreadInfo[] threads = this.listThreads();
                    for (int x = 0; x < threads.length; ++x) {
                        if (!(threads[x] instanceof DebugJDIThreadInfo)) continue;
                        thread = (DebugJDIThreadInfo)threads[x];
                        if (thread.tr == this.eventThread) continue;
                        logger.trace("Thread name: " + threads[x].getName());
                        logger.trace(" SuspendCount: " + thread.tr.suspendCount());
                        thread.tr.resume();
                    }
                    try {
                        logger.trace("Waiting 10 more seconds");
                        worker.finished.wait(10000L);
                    }
                    catch (InterruptedException x) {
                        // empty catch block
                    }
                    logger.trace("Suspending all threads");
                    for (int x = 0; x < threads.length; ++x) {
                        if (!(threads[x] instanceof DebugJDIThreadInfo)) continue;
                        thread = (DebugJDIThreadInfo)threads[x];
                        if (thread.tr == this.eventThread) continue;
                        thread.tr.suspend();
                        logger.trace("Thread name: " + threads[x].getName());
                        logger.trace(" SuspendCount: " + thread.tr.suspendCount());
                    }
                    if (worker.gotValue) {
                        logger.trace("Hanging method evaluation has finished!");
                        evaluationHanging = false;
                    }
                }
            }
        }
        if (worker.gotValue) {
            if (worker.exceptionThrown != null) {
                throw new Exception(worker.exceptionThrown);
            }
            return worker.value;
        }
        if (worker.done) {
            return null;
        }
        if (evaluationHanging) {
            this.eventThread.suspend();
            final String title = DebugJDIArb.getString(9);
            final String msg = DebugJDIArb.getString(10);
            final DebugJDI debugJdi = this;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, msg, title, 2);
                    JDebugger.terminateDebuggingProcess((DebugVirtualMachine)debugJdi);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        return null;
    }

    public void setExecutionTracker(ExecutionTrackerForVirtualMachine et) {
        this.executionTracker = et;
    }

    public ExecutionTrackerForVirtualMachine getExecutionTracker() {
        return this.getExecutionTracker(false);
    }

    public ExecutionTrackerForVirtualMachine getExecutionTracker(boolean init) {
        if (this.executionTracker == null && init) {
            this.executionTracker = new ExecutionTrackerImplForVirtualMachine((DebugVirtualMachine)this);
        }
        return this.executionTracker;
    }

    static {
        SIOLogger = new Log("SIOLogger");
        classesLogger = new Log("ClassesLogger");
        lineNumberAdjustmentValue = 1;
        ALLOW_EX_TRK_TO_SET_METHOD_BREAKPOINTS = false;
        plsqlJavaClasses = new HashSet<String>();
        plsqlJavaClasses.add("java.lang.Class");
        plsqlJavaClasses.add("java.lang.ClassLoader");
        plsqlJavaClasses.add("java.lang.Exception");
        plsqlJavaClasses.add("java.lang.Object");
        plsqlJavaClasses.add("java.lang.String");
        plsqlJavaClasses.add("java.lang.Thread");
        plsqlJavaClasses.add("java.lang.ThreadGroup");
        plsqlJavaClasses.add("java.lang.Throwable");
        lastStepWasLambdaThunk = false;
    }

    class DeadlockDetector
    extends Thread {
        private boolean done;
        private int threshhold;

        DeadlockDetector() {
            super("Debugger Deadlock Detection");
            this.done = false;
            this.threshhold = 3000;
        }

        private void sleepThree() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void terminate() {
            this.done = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.done) {
                long aliveTime = DebugJDI.this.m_aliveTime;
                if (aliveTime == 0L) {
                    this.sleepThree();
                    continue;
                }
                if (System.currentTimeMillis() - aliveTime < (long)this.threshhold) {
                    this.sleepThree();
                    continue;
                }
                Thread currentRunningThread = DebugJDI.this.runningThread;
                if (currentRunningThread != null) {
                    currentRunningThread.interrupt();
                }
                this.sleepThree();
            }
        }
    }

    static class MethodEvaluationWorker
    extends Thread {
        private boolean done = false;
        private Object waitForWork = new Object();
        private Object finished = new Object();
        private Value value;
        private boolean gotValue;
        private Throwable exceptionThrown;
        ClassType ct;
        ObjectReference or;
        DebugJDI dj;
        java.util.List<Value> argList;
        Method m;
        MethodEvaluationType methodEvaluationType;

        MethodEvaluationWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.waitForWork;
            synchronized (object) {
                this.waitForWork.notify();
                while (!this.done) {
                    try {
                        this.waitForWork.wait();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    Log logger = JDebugger.logger;
                    try {
                        try {
                            if (this.dj.eventThread != null) {
                                switch (this.methodEvaluationType) {
                                    case STATIC_CALL: {
                                        if (logger.isEnabled()) {
                                            logger.trace("Invoking static method: {0}.{1}", (Object)this.ct.name(), (Object)this.m.name());
                                        }
                                        int flag = MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                                        this.value = this.ct.invokeMethod(this.dj.eventThread, this.m, this.argList, flag);
                                        break;
                                    }
                                    case NON_VIRTUAL_CALL: 
                                    case VIRTUAL_CALL: {
                                        int flag;
                                        if (logger.isEnabled()) {
                                            ClassType ctClass = (ClassType)this.or.referenceType();
                                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)this.m.name());
                                        }
                                        int n = flag = MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                                        if (this.methodEvaluationType == MethodEvaluationType.NON_VIRTUAL_CALL) {
                                            flag |= 2;
                                        }
                                        this.value = this.or.invokeMethod(this.dj.eventThread, this.m, this.argList, flag);
                                        break;
                                    }
                                    case NEW_INSTANCE: {
                                        if (logger.isEnabled()) {
                                            logger.trace("Invoking newInstance method: {0}.{1}", (Object)this.ct.name(), (Object)this.m.name());
                                        }
                                        int flag = MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                                        this.value = this.ct.newInstance(this.dj.eventThread, this.m, this.argList, flag);
                                        break;
                                    }
                                }
                            }
                            if (logger.isEnabled()) {
                                logger.trace("Method return is {0}", (Object)(this.value == null ? "null" : "not null"));
                            }
                            this.gotValue = true;
                        }
                        catch (Exception ex) {
                            this.exceptionThrown = ex;
                            this.gotValue = true;
                        }
                    }
                    catch (Throwable t) {
                        FeedbackManager.reportException((Throwable)t);
                        this.exceptionThrown = t;
                        this.gotValue = true;
                    }
                    if (this.exceptionThrown != null) {
                        Assert.println((String)("invoking of method threw " + this.exceptionThrown.getMessage()));
                        logger.trace("Exception thrown during invocation of method");
                    }
                    Object object2 = this.finished;
                    synchronized (object2) {
                        this.finished.notify();
                    }
                }
            }
        }

        void terminate() {
            this.done = true;
            this.interrupt();
        }
    }

    static enum MethodEvaluationType {
        NEW_INSTANCE,
        VIRTUAL_CALL,
        NON_VIRTUAL_CALL,
        STATIC_CALL;

    }

    class OutsideHeapDepthHelper {
        DebugJDIHeapAncestorOutsideHeap heapObj;
        int depth;

        OutsideHeapDepthHelper(DebugJDIHeapAncestorOutsideHeap heapObj, int depth) {
            this.heapObj = heapObj;
            this.depth = depth;
        }
    }

    class OuterObjectReference {
        int depth = 0;
        ObjectReference or;
        boolean isStaticField;
        Field staticField;
        DebugFieldInfo dfi;

        OuterObjectReference(int depth, ObjectReference or, boolean isStaticField, Field staticField, DebugJDIFieldInfo fi) {
            this.depth = depth;
            this.or = or;
            this.isStaticField = isStaticField;
            this.staticField = staticField;
            this.dfi = fi;
        }
    }

    class FakePrintStream
    extends PrintStream {
        String nextLine;
        boolean passOn;

        FakePrintStream(OutputStream stdErr) {
            super(stdErr);
            this.nextLine = "";
        }

        @Override
        public void print(boolean x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + (x ? "true" : "false");
            }
        }

        @Override
        public void print(char x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        @Override
        public void print(int x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        @Override
        public void print(long x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        @Override
        public void print(float x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        @Override
        public void print(double x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        @Override
        public void print(char[] x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + x;
            }
        }

        @Override
        public void print(String x) {
            if (this.passOn) {
                super.print(x);
            } else {
                if (x == null) {
                    x = "null";
                }
                this.nextLine = this.nextLine + x;
            }
        }

        @Override
        public void print(Object x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        @Override
        public void println() {
            if (this.passOn) {
                super.println();
            } else {
                this.log();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(boolean x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(char x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(int x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(long x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(float x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(double x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(char[] x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(String x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(Object x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        private void log() {
            if (this.nextLine.startsWith("[JDI:")) {
                DebugJDI.this.logToConnectionLogs(this.nextLine);
            } else {
                this.passOn = true;
                super.println(this.nextLine);
                this.passOn = false;
            }
            this.nextLine = "";
        }
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block4: {
                if (!evt.getPropertyName().equals("stepping-margin-enabled")) break block4;
                if (evt.getNewValue() == Boolean.TRUE) {
                    Iterator bpsToSet = DebugJDI.this.unsetETMethodBreakpoints.iterator();
                    while (bpsToSet.hasNext()) {
                        DebugJDIExecutionTrackingBreakpointMethod bpToSet = (DebugJDIExecutionTrackingBreakpointMethod)((Object)bpsToSet.next());
                        DebugJDI.this.putBreakpoint(bpToSet);
                        bpsToSet.remove();
                    }
                } else {
                    for (DebugJDIExecutionTrackingBreakpointMethod bpToUnset : DebugJDI.this.methodEntryBreakpoints.values()) {
                        DebugJDI.this.removeBreakpoint(bpToUnset);
                        DebugJDI.this.unsetETMethodBreakpoints.add(bpToUnset);
                    }
                }
            }
        }
    }
}

