/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.find;

import java.awt.Dimension;
import oracle.ide.inspector.find.SearchableText;
import oracle.ide.inspector.find.TextHighlightEffect;

public abstract class FindTextSupport
implements SearchableText {
    private String _baseText = "";
    private int _cachedPreferredHeight = -1;
    private int _cachedPreferredWidth = -1;

    @Override
    public void setText(String text) {
        this._baseText = text != null ? text : "";
        this.setDisplayedText(text);
        this.cacheSize();
    }

    @Override
    public boolean findText(String textToFind, boolean matchCase) {
        int findIndex;
        String realTextToFind;
        String src = matchCase ? this._baseText : this._baseText.toLowerCase();
        String string = realTextToFind = textToFind == null ? "" : textToFind.trim();
        if (!matchCase) {
            realTextToFind = realTextToFind.toLowerCase();
        }
        if ((findIndex = src.indexOf(realTextToFind)) != -1) {
            String highlightedText = TextHighlightEffect.toHighlightedText(this._baseText, findIndex, realTextToFind.length());
            this.setDisplayedText(highlightedText);
        }
        return findIndex != -1;
    }

    @Override
    public void removeFoundTextEffect() {
        this.setDisplayedText(this._baseText);
    }

    public abstract void setDisplayedText(String var1);

    public Dimension getPreferredSize() {
        if (this._cachedPreferredHeight != -1) {
            return new Dimension(this._cachedPreferredWidth, this._cachedPreferredHeight);
        }
        return this.getSuperPreferredSize();
    }

    private void cacheSize() {
        Dimension dim = this.getSuperPreferredSize();
        if (dim != null && (int)dim.getHeight() != 0) {
            this._cachedPreferredHeight = (int)dim.getHeight();
            this._cachedPreferredWidth = (int)dim.getWidth();
        } else {
            this._cachedPreferredHeight = -1;
            this._cachedPreferredWidth = -1;
        }
    }

    public abstract Dimension getSuperPreferredSize();
}

