/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.editor;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.TextFieldEditorBehavior;
import oracle.bali.inspector.editor.TextFieldEditorSetup;
import oracle.ide.inspector.editor.ExtendedTextFieldEditorBehavior;
import oracle.javatools.ui.ExtendedTextField;

public class ExtendedTextFieldEditorSetup
extends TextFieldEditorSetup {
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof ExtendedTextField;
    }

    protected void addAdditionalListeners(PropertyEditorFactory2 propertyEditor, JTextComponent editor) {
        if (!(editor instanceof ExtendedTextField)) {
            return;
        }
        ExtendedTextField extended = (ExtendedTextField)editor;
        JTextArea textArea = extended.getLargerTextArea();
        if (textArea == null) {
            return;
        }
        ExtendedTextFieldEditorBehavior behavior = new ExtendedTextFieldEditorBehavior(extended, propertyEditor);
        ExtendedTextFieldEditorSetup.addTextFieldBehaviorTo((TextFieldEditorBehavior)behavior, (JTextComponent)textArea);
    }

    private static class TextAreaKeyListener
    extends KeyAdapter {
        private ExtendedTextField editor;
        private PropertyEditorFactory2 propertyEditor;

        TextAreaKeyListener(ExtendedTextField editor, PropertyEditorFactory2 propertyEditor) {
            this.editor = editor;
            this.propertyEditor = propertyEditor;
            TextFieldEditorBehavior.setDirty((JTextComponent)this.editor, (boolean)false);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keycode = e.getKeyCode();
            if (keycode == 27) {
                String oldText = this.propertyEditor.getAsText();
                this.editor.setText(oldText);
                TextFieldEditorBehavior.setDirty((JTextComponent)this.editor, (boolean)false);
                return;
            }
            if (keycode == 0) {
                return;
            }
            TextFieldEditorBehavior.setDirty((JTextComponent)this.editor, (boolean)true);
        }
    }
}

