/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class ScrollablePanelDelegate {
    static final int DEFAULT_SCROLL_UNIT_INCREMENT = 20;
    static final int PROPERTY_FORM_Y_GAP = 4;
    private final JComponent owner;

    ScrollablePanelDelegate(JComponent owner) {
        this.owner = owner;
    }

    Dimension preferredScrollableViewportSize() {
        return this.owner.getPreferredSize();
    }

    int scrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.scrollUpOrDown(visibleRect, direction);
        }
        return 20;
    }

    private int scrollUpOrDown(Rectangle visibleRect, int direction) {
        int increment = Integer.MAX_VALUE;
        Rectangle temp = new Rectangle();
        int count = this.owner.getComponentCount();
        for (Component c : this.owner.getComponents()) {
            increment = Math.min(increment, this.scrollableUnitWhenScrollingUpOrDown(visibleRect, direction, c.getBounds(temp)));
        }
        return increment > 0 ? increment : 20;
    }

    private int scrollableUnitWhenScrollingUpOrDown(Rectangle visibleRect, int direction, Rectangle bounds) {
        if (this.scrollingDown(direction)) {
            return this.scrollableUnitIncrementWheScrollingDown(visibleRect, bounds);
        }
        return this.scrollableUnitIncrementWheScrollingUp(visibleRect, bounds);
    }

    private boolean scrollingDown(int direction) {
        return direction > 0;
    }

    private int scrollableUnitIncrementWheScrollingDown(Rectangle visibleRect, Rectangle bounds) {
        if (bounds.y + bounds.height <= visibleRect.y) {
            return 0;
        }
        return bounds.y + bounds.height - visibleRect.y + 2;
    }

    private int scrollableUnitIncrementWheScrollingUp(Rectangle visibleRect, Rectangle bounds) {
        if (bounds.y >= visibleRect.y) {
            return 0;
        }
        return visibleRect.y - bounds.y + 2;
    }

    int scrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    void paintComponent(Graphics g) {
        if (!this.owner.isOpaque()) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        g.setColor(this.owner.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
    }

    boolean scrollableTracksViewportWidth() {
        return true;
    }

    boolean scrollableTracksViewportHeight() {
        return false;
    }
}

