/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Dimension;
import javax.swing.JLabel;
import oracle.ide.inspector.find.FindTextSupport;
import oracle.ide.inspector.find.SearchableLabel;
import oracle.ide.inspector.find.SearchableText;

public final class PropertyLabel
extends JLabel
implements SearchableLabel {
    private FindTextSupport _findTextSupport;

    public PropertyLabel() {
        this((String)null);
    }

    public PropertyLabel(String text) {
        super(text);
        this.getSearchableText().setText(text);
    }

    public boolean findText(String searchText, boolean matchCase) {
        return this.getSearchableText().findText(searchText, matchCase);
    }

    public void clearHighlight() {
        this.getSearchableText().removeFoundTextEffect();
    }

    @Override
    public SearchableText getSearchableText() {
        if (this._findTextSupport == null) {
            this._findTextSupport = new FindTextSupport(){

                @Override
                public void setDisplayedText(String text) {
                    PropertyLabel.super.setText(text);
                }

                @Override
                public Dimension getSuperPreferredSize() {
                    return PropertyLabel.super.getPreferredSize();
                }
            };
        }
        return this._findTextSupport;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._findTextSupport != null) {
            return this._findTextSupport.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setText(String text) {
        if (this._findTextSupport != null) {
            this._findTextSupport.setText(text);
        } else {
            super.setText(text);
        }
    }
}

