/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.PropertyCategory;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.PropertyModelValueApplier;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.ide.inspector.InspectorBundle;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyDisplay;
import oracle.ide.inspector.PropertyEditorInfo;
import oracle.ide.inspector.RenderingOptimizer;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.ValueApplierPropertyChangeListener;
import oracle.ide.util.Assert;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.status.Issue;
import oracle.javatools.ui.border.RoundedBorderComponent;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.ActionTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.infotip.templates.TemplateUtils;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.ProxyFactory;

public final class PropertyInfo
extends PropertyModelValueApplier
implements SinglePropertyInfo,
Hoverable,
HoverProvider {
    private static final Logger LOGGER = Logger.getLogger(PropertyInfo.class.getName());
    private static final HoverFlavor HOVER_FLAVOR = HoverFlavor.getFlavor((String)"info");
    private static final FormatBundle BUNDLE = new FormatBundle(InspectorBundle.class);
    final int row;
    private RenderingOptimizer renderingOptimizer;
    private PropertyDisplay propertyDisplay;
    private PropertyModel model;
    private String displayName;
    private Properties properties;
    private Object modelValueMirror;
    private PropertyEditorFactory2 editorFactory;
    private ValueApplierPropertyChangeListener propertyChangeListener;
    private String propertyIdAsString;
    private InfoTipHover hover;
    private JLabel iconLabel;
    private HoverableRegistrar registrar = new HoverableRegistrar((Hoverable)ProxyFactory.newWeakProxy(Hoverable.class, (Object)((Object)this)));

    PropertyInfo(PropertyModel model, int row, RenderingOptimizer renderingOptimizer, PropertyDisplay propertyDisplay) {
        this.model = model;
        this.row = row;
        this.renderingOptimizer = renderingOptimizer;
        this.propertyDisplay = propertyDisplay;
        this.modelValueMirror = this.value();
        this.displayName = this.displayNameFromModel();
    }

    void updatePropertyId(String newValue) {
        this.propertyIdAsString = newValue;
    }

    void update(PropertyModel model) {
        this.detachFromPropertyEditor();
        this.model = model;
        this.displayName = this.displayNameFromModel();
        this.modelValueMirror = this.value();
    }

    private String displayNameFromModel() {
        String displayName = this.model.getPropertyDisplayName(this.row);
        if (displayName == null) {
            displayName = "";
        }
        return displayName;
    }

    PropertyModel model() {
        return this.model;
    }

    PropertyGroup groupFromModel() {
        return this.model().getPropertyGroup(this.row);
    }

    PropertyCategory categoryFromModel() {
        return this.model().getPropertyCategory(this.row);
    }

    Object dataFromModel(Object columnId) {
        return this.model.getData(columnId, this.row);
    }

    void partOf(Properties properties) {
        this.properties = properties;
    }

    void rendered() {
        if (this.properties == null) {
            return;
        }
        this.properties.rendered(this);
    }

    void addPropertyEditorInfo(LabelAndEditor labelAndEditor, Container iconContainer) {
        PropertyEditorInfo info = new PropertyEditorInfo(this.propertyIdAsString, labelAndEditor, iconContainer, this.row);
        this.renderingOptimizer.addPropertyEditorInfo(info);
    }

    PropertyEditorFactory2 editorFactory() {
        return this.editorFactory;
    }

    void updateEditorFactory(PropertyEditorFactory2 editorFactory) {
        this.detachFromPropertyEditor();
        this.editorFactory = editorFactory;
        if (this.editorFactory == null) {
            return;
        }
        Object value = this.modelValueMirror;
        try {
            editorFactory.setValue(value);
        }
        catch (Exception e) {
            String msg = "Exception updating property editor for property '" + this.displayName() + "': " + e.getMessage() + ". Stack trace:";
            Assert.println((String)msg);
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void detachFromPropertyEditor() {
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.detach();
        }
    }

    void attachToPropertyEditor(PropertyEditorFactory2 propertyEditor, Component editor) {
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.detach();
            this.propertyChangeListener.attachTo(propertyEditor, editor);
            return;
        }
        this.propertyChangeListener = new ValueApplierPropertyChangeListener(this, propertyEditor, editor);
    }

    void dispose() {
        this.detachFromPropertyEditor();
        this.cleanUpHover();
    }

    private void cleanUpHover() {
        if (null == this.iconLabel) {
            return;
        }
        if (null != this.iconLabel) {
            this.iconLabel.removeAncestorListener(this.registrar);
        }
        this.iconLabel = null;
        this.hover = null;
    }

    void updateComponentWithFocus(Component c, PropertyEditorFactory2 f) {
        this.renderingOptimizer.updateComponentWithFocus(c, f);
    }

    FocusListener updatePropertyDescriptionFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (PropertyInfo.this.propertyDisplay == null) {
                    return;
                }
                try {
                    String propertyDescription = PropertyInfo.this.model.getPropertyDescription(PropertyInfo.this.row);
                    PropertyInfo.this.propertyDisplay.showPropertyDescription(propertyDescription);
                }
                catch (Exception ignored) {
                    Assert.println((String)("Ignoring exception when showing description for property " + PropertyInfo.this.displayName()));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (PropertyInfo.this.propertyDisplay == null) {
                    return;
                }
                PropertyInfo.this.propertyDisplay.showPropertyDescription(null);
            }
        };
    }

    public String displayName() {
        return this.displayName;
    }

    public Object displayValue() {
        return this.model.getPropertyDisplayValue(this.row);
    }

    protected Object value() {
        return this.model.getPropertyValue(this.row);
    }

    Object defaultDisplayValue() {
        Object defaultDisplayValue = this.model.getData(PropertyModel.COLUMN_DEFAULT_DISPLAY_VALUE, this.row);
        return PropertyModel.DOES_NOT_EXIST == defaultDisplayValue ? null : defaultDisplayValue;
    }

    Object defaultValue() {
        Object defaultValue = this.model.getData(PropertyModel.COLUMN_DEFAULT_VALUE, this.row);
        return PropertyModel.DOES_NOT_EXIST == defaultValue ? null : defaultValue;
    }

    boolean writable() {
        return this.model.isPropertyWritable(this.row);
    }

    boolean hidden() {
        return this.model.getBooleanData(PropertyModel.COLUMN_IS_HIDDEN, this.row);
    }

    boolean isMandatory() {
        return this.model.isMandatory(this.row);
    }

    boolean isExpert() {
        return this.model.getBooleanData(PropertyModel.COLUMN_IS_EXPERT, this.row);
    }

    Object id() {
        return this.model.getPropertyID(this.row);
    }

    boolean isValueConflicting() {
        int columnIndex = this.model.getColumnIndex(PropertyModel.COLUMN_VALUE);
        if (-1 == columnIndex) {
            LOGGER.log(Level.WARNING, MessageFormat.format("Column {0} not found in model {1}", PropertyModel.COLUMN_VALUE, this.model.getClass()));
            return false;
        }
        return this.model.isDataConflicting(columnIndex, this.row);
    }

    boolean isMatchingPropertyId(Object propertyId) {
        if (propertyId == null) {
            return false;
        }
        return this.model.isMatchingPropertyID(propertyId, this.row);
    }

    void updateModelValue(Object newValue) {
        try {
            if (this.alreadyUpdated(newValue)) {
                return;
            }
            this.modelValueMirror = newValue;
            this.model.setPropertyValue(this.row, this.modelValueMirror);
        }
        catch (Throwable t) {
            FeedbackManager.reportException((Throwable)t);
        }
    }

    private boolean alreadyUpdated(Object newValue) {
        if (ModelUtil.areEqual((Object)this.value(), (Object)newValue)) {
            return true;
        }
        return ModelUtil.areEqual((Object)this.modelValueMirror, (Object)newValue);
    }

    public void apply(Object newValue) throws Exception {
        try {
            this.model.setPropertyValue(this.row, newValue);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    Container iconContainer() {
        Container container = RenderingUtils.emptyContainer();
        Icon icon = this.icon();
        if (icon instanceof ImageIcon) {
            this.cleanUpHover();
            this.iconLabel = new JLabel(icon);
            container.add(this.iconLabel);
            this.iconLabel.addAncestorListener(this.registrar);
        } else {
            RenderingUtils.addEmptyIconContainerTo(container);
        }
        return container;
    }

    Icon icon() {
        return this.model.getIcon(this.row);
    }

    HoverProvider hoverProvider() {
        Object data = this.model.getData(PropertyModel.COLUMN_HOVER_PROVIDER, this.row);
        if (data instanceof HoverProvider) {
            return (HoverProvider)data;
        }
        return this;
    }

    List<ActionGroup> actionGroups() {
        return this.model.getActionGroups(this.row);
    }

    boolean hasActionGroups() {
        List<ActionGroup> actionGroups = this.actionGroups();
        return actionGroups != null && !actionGroups.isEmpty();
    }

    Collection<? extends Issue> validationIssues() {
        Object data = this.model.getData(PropertyModel.COLUMN_VALIDATION_ISSUES, this.row);
        if (!(data instanceof Collection)) {
            return Collections.emptyList();
        }
        return (Collection)data;
    }

    public String toString() {
        if (this.displayName == null) {
            return null;
        }
        return "'" + this.displayName + "'";
    }

    public PropertyEditorFactory2 getPropertyEditorFactory() {
        return this.editorFactory();
    }

    public PropertyModel getPropertyModel() {
        return this.model;
    }

    public int getPropertyModelRow() {
        return this.row;
    }

    public Hover hover(Point p, List<HoverFlavor> flavors) {
        Hover hover = null;
        if (null == this.iconLabel) {
            return null;
        }
        HoverProvider hoverProvider = this.hoverProvider();
        if (null != hoverProvider) {
            hover = hoverProvider.hover((JComponent)this.iconLabel, p, flavors);
        }
        if (null != hover) {
            hover.showHover();
        }
        return hover;
    }

    public Hover hover(JComponent comp, Point p, List<HoverFlavor> flavors) {
        if (!flavors.contains(HOVER_FLAVOR)) {
            return null;
        }
        if (null != this.hover) {
            return this.hover;
        }
        String title = this.model.getIconToolTip(this.row);
        if (!ModelUtil.hasLength((String)title)) {
            return null;
        }
        Icon icon = this.icon();
        if (null == icon) {
            return null;
        }
        Template template = this.createHoverContent(icon, title);
        this.hover = new InfoTipHover(template, InfoTipStyles.DEFAULT, comp, comp.getBounds(), HOVER_FLAVOR);
        return this.hover;
    }

    private Template createHoverContent(Icon icon, String title) {
        AbstractAction action = null;
        JComponent info = null;
        final Object defaultValue = this.defaultValue();
        if (null != defaultValue) {
            boolean isMultiLine;
            Object defaultDisplayValue = this.defaultDisplayValue();
            String defaultDisplayValueString = null != defaultDisplayValue ? String.valueOf(defaultDisplayValue) : "";
            boolean bl = isMultiLine = defaultDisplayValueString.split("\\n").length > 1;
            if (isMultiLine) {
                info = new JPanel((LayoutManager)new MigLayout("ins 0 0 2 0, gapy 2, wmax 420"));
                info.add(new JLabel(BUNDLE.get("DEFAULT_VALUE_LABEL", new Object[]{""})));
                BasicEditorPane editor = new BasicEditorPane();
                editor.setText(defaultDisplayValueString);
                editor.setEditable(false);
                editor.setCaretPosition(0);
                JScrollPane sp = TemplateUtils.createHorizontalScrollPane();
                sp.setBackground(editor.getBackground());
                sp.setViewportView((Component)editor);
                info.add((Component)RoundedBorderComponent.createRoundedComponent((JComponent)sp, (Color)InfoTipStyles.DEFAULT.getInternalBorderColor()), "newline");
            } else {
                info = new JLabel(BUNDLE.get("DEFAULT_VALUE_LABEL", new Object[]{defaultDisplayValueString}));
            }
            action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyInfo.this.updateModelValue(defaultValue);
                }
            };
            action.putValue("Name", BUNDLE.get("RESET_TO_DEFAULT"));
        }
        return new ActionTemplate(icon, title, info, action);
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<PropertyInfo, Icon>(){

            public Icon adapt(PropertyInfo obj) {
                return obj.icon();
            }
        });
    }

    private static class HoverableRegistrar
    implements AncestorListener {
        private final Hoverable hoverable;

        public HoverableRegistrar(Hoverable hoverable) {
            this.hoverable = hoverable;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            JComponent component = event.getComponent();
            HoverableRegistry.registerComponent((Component)component, (Hoverable)this.hoverable);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            JComponent component = event.getComponent();
            HoverableRegistry.unregisterComponent((Component)component, (Hoverable)this.hoverable);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

