/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.List;
import oracle.ide.inspector.CategoryCollection;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyGroupPanel;

final class PropertiesRenderer {
    private CategoryCollection categoryCollection;

    PropertiesRenderer(CategoryCollection categoryCollection) {
        this.update(categoryCollection);
    }

    void update(CategoryCollection categoryCollection) {
        this.categoryCollection = categoryCollection;
    }

    void renderWithoutGroups(Properties properties, Orientation orientation) {
        if (properties.isEmpty()) {
            return;
        }
        properties.sort();
        PropertyGroupPanel panel = new PropertyGroupPanel("");
        panel.renderAll(properties, orientation);
        if (panel.getComponentCount() > 0) {
            this.categoryCollection.addCategory(panel, properties);
        }
    }

    void render(Properties properties, Orientation orientation) {
        if (properties.isEmpty()) {
            return;
        }
        List<String> groups = properties.organizeByGroups();
        if (groups.isEmpty()) {
            return;
        }
        this.renderGroup(groups.get(0), properties, orientation);
        for (int i = 1; i < groups.size(); ++i) {
            this.touchGroupWithoutRendering(groups.get(i), properties);
        }
    }

    private void renderGroup(String group, Properties properties, Orientation orientation) {
        this.updateCurrentCategoryTitle(group);
        PropertyGroupPanel panel = new PropertyGroupPanel(group);
        panel.render(properties, orientation);
        if (panel.getComponentCount() > 0) {
            this.categoryCollection.addCategory(panel, properties);
        }
    }

    private void touchGroupWithoutRendering(String group, Properties properties) {
        this.updateCurrentCategoryTitle(group);
        if (properties.propertiesInGroup(group).isEmpty()) {
            return;
        }
        this.categoryCollection.addCategory(new PropertyGroupPanel(group), properties);
    }

    private void updateCurrentCategoryTitle(String group) {
        this.categoryCollection.currentCategory(group);
    }
}

