/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.List;
import oracle.ide.inspector.CategoryCollection;
import oracle.ide.inspector.CategoryCollectionDisplay;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyCategoryLayoutPanel;
import oracle.ide.inspector.layout.CategoryLayout;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.PropertyFormLayout;

final class PropertiesLayoutRenderer {
    private final CategoryCollectionDisplay categoryCollectionDisplay;
    private CategoryCollection categoryCollection;

    PropertiesLayoutRenderer(CategoryCollectionDisplay categoryCollectionDisplay, CategoryCollection categoryCollection) {
        this.categoryCollectionDisplay = categoryCollectionDisplay;
        this.update(categoryCollection);
    }

    void update(CategoryCollection categoryCollection) {
        this.categoryCollection = categoryCollection;
    }

    void render(Properties properties, PropertyFormLayout formLayout, Orientation orientation) {
        if (properties.isEmpty()) {
            return;
        }
        List<Element> layoutChildren = formLayout.getChildren();
        int elementAfterFirstCategoryIndex = this.renderOnlyFirstCategory(layoutChildren, properties, orientation);
        this.touchCategoriesWithoutRendering(layoutChildren, elementAfterFirstCategoryIndex, properties, orientation);
    }

    private int renderOnlyFirstCategory(List<Element> layoutChildren, Properties properties, Orientation orientation) {
        int nextElementIndex = 0;
        for (Element e : layoutChildren) {
            ++nextElementIndex;
            if (!this.renderCategory(e, properties, orientation)) continue;
        }
        return nextElementIndex;
    }

    private void touchCategoriesWithoutRendering(List<Element> layout, int startingIndex, Properties properties, Orientation orientation) {
        for (int i = startingIndex; i < layout.size(); ++i) {
            Element e = layout.get(i);
            if (!(e instanceof CategoryLayout)) continue;
            CategoryLayout categoryLayout = (CategoryLayout)e;
            this.updateCurrentCategoryTitle(categoryLayout);
            properties.tagWith(categoryLayout);
            if (properties.elementCountByCategory(categoryLayout.getID()) == 0) continue;
            PropertyCategoryLayoutPanel categoryPanel = new PropertyCategoryLayoutPanel(categoryLayout);
            this.categoryCollection.addCategory(categoryPanel, properties);
        }
    }

    private boolean renderCategory(Element possibleCategory, Properties properties, Orientation orientation) {
        if (!(possibleCategory instanceof CategoryLayout)) {
            this.categoryCollection.clearCurrentCategory();
            return false;
        }
        CategoryLayout categoryLayout = (CategoryLayout)possibleCategory;
        this.updateCurrentCategoryTitle(categoryLayout);
        properties.tagWith(categoryLayout);
        if (properties.elementCountByCategory(categoryLayout.getID()) == 0) {
            return false;
        }
        PropertyCategoryLayoutPanel categoryPanel = new PropertyCategoryLayoutPanel(categoryLayout);
        String title = categoryPanel.categoryTitle();
        if (title != null && !this.categoryCollectionDisplay.userSelectedCategories().isUnselected(title)) {
            categoryPanel.render(properties, orientation);
        }
        this.categoryCollection.addCategory(categoryPanel, properties);
        return true;
    }

    private void updateCurrentCategoryTitle(CategoryLayout category) {
        this.categoryCollection.currentCategory(category.getTitle());
    }
}

