/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.bali.inspector.AbstractCustomEditorButton;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.inspector.CustomEditors;

class LazyLoadMenuItem
extends JMenuItem {
    private AbstractCustomEditorButton customEditorButton;
    private String name;
    private ActionContext context;

    LazyLoadMenuItem(Action action, ActionContext context, AbstractCustomEditorButton customEditorButton) {
        this.name = this.nameFrom(action);
        if (this.name == null) {
            this.name = "";
        }
        this.setText(this.name);
        this.context = context;
        this.customEditorButton = customEditorButton;
        this.setEnabled(action.isEnabled());
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"enabled".equals(evt.getPropertyName())) {
                    return;
                }
                Object value = evt.getNewValue();
                if (!(value instanceof Boolean)) {
                    return;
                }
                LazyLoadMenuItem.this.setEnabled((Boolean)value);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LazyLoadMenuItem.this.callRealAction(e);
            }
        });
    }

    private void callRealAction(ActionEvent e) {
        List<ActionGroup> actions = CustomEditors.actionGroups((SinglePropertyInfo)this.customEditorButton);
        if (actions.isEmpty()) {
            return;
        }
        for (ActionGroup group : actions) {
            for (Action action : group) {
                if (!this.name.equals(this.nameFrom(action))) continue;
                ActionContext.updateContextIn((Action)action, (ActionContext)this.context).actionPerformed(e);
                return;
            }
        }
    }

    private String nameFrom(Action action) {
        return (String)action.getValue("Name");
    }
}

