/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.beans.Customizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.ArraySelectionModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.Context;
import oracle.ide.inspector.Inspectable;

public class CompositeInspectable
implements Inspectable {
    private final List<Inspectable> inspectables = new ArrayList<Inspectable>();
    private final MultiObjectModel model = new MyMultiModel();

    public List<Inspectable> inspectables() {
        return new ArrayList<Inspectable>(this.inspectables);
    }

    public CompositeInspectable(List<Inspectable> inspectables) {
        this.inspectables.addAll(inspectables);
        this.updateModel(this.inspectables);
    }

    private void updateModel(List<Inspectable> inspectables) {
        ArraySelectionModel selectionModel = new ArraySelectionModel();
        int index = 0;
        for (Inspectable inspectable : inspectables) {
            PropertyModel propertyModel;
            if (inspectable == null || (propertyModel = inspectable.getPropertyModel()) == null) continue;
            selectionModel.addItem(index++, (Object)propertyModel);
        }
        this.model.setSelectionModel((SelectionModel)selectionModel);
    }

    @Override
    public void setContext(Context context) {
        for (Inspectable i : this.inspectables) {
            i.setContext(context);
        }
    }

    @Override
    public Object getTarget() {
        for (Inspectable i : this.inspectables) {
            Object target = i.getTarget();
            if (target == null) continue;
            return target;
        }
        return null;
    }

    @Override
    public PropertyModel getPropertyModel() {
        return this.model;
    }

    @Override
    public Customizer getCustomizer() {
        for (Inspectable i : this.inspectables) {
            Customizer customizer = i.getCustomizer();
            if (customizer == null) continue;
            return customizer;
        }
        return null;
    }

    @Override
    public Component[] getAdditionalTabPages() {
        ArrayList<Component> tabPages = new ArrayList<Component>();
        for (Inspectable i : this.inspectables) {
            Component[] c = i.getAdditionalTabPages();
            if (c == null || c.length <= 0) continue;
            tabPages.addAll(Arrays.asList(c));
        }
        return tabPages.toArray(new Component[tabPages.size()]);
    }

    private static class MyMultiModel
    extends MultiObjectModel {
        private MyMultiModel() {
        }

        public boolean isPropertyCommon(int rowIndex) {
            return true;
        }

        public boolean isDataConflicting(int columnIndex, int rowIndex) {
            return false;
        }

        public String getTargetDisplayName() {
            SelectionModel selModel = this.getSelectionModel();
            for (int i = 0; i < selModel.getSelectedItemCount(); ++i) {
                PropertyModel subModel = (PropertyModel)selModel.getSelectedItem(i);
                String subDisplayName = subModel.getTargetDisplayName();
                if (subDisplayName == null) continue;
                return subDisplayName;
            }
            return null;
        }

        public void dispose() {
        }
    }
}

