/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.owaoutput;

import java.sql.Connection;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.OutputController;
import oracle.dbtools.worksheet.commands.owaoutput.OWAOutputDockable;
import oracle.dbtools.worksheet.commands.owaoutput.OWAOutputPane;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public final class OWAOutputController
extends OutputController {
    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        OWAOutputPane oWAOutputPane = (OWAOutputPane)this.getPane(context);
        if (oWAOutputPane != null && ideAction.getCommandId() == OWAOutputPane.TOGGLE_CMD_ID) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)new EnableOWAOutputTask(oWAOutputPane, Messages.getString("OWAOutputPane.11").trim(), ideAction.getState()));
            return true;
        }
        return bl;
    }

    @Override
    public AbstractOutputPane getPane(Context context) {
        View view = context.getView();
        if (view instanceof OWAOutputDockable) {
            OWAOutputDockable oWAOutputDockable = (OWAOutputDockable)context.getView();
            OWAOutputPane oWAOutputPane = (OWAOutputPane)oWAOutputDockable.getPane();
            return oWAOutputPane;
        }
        return null;
    }

    private static class EnableOWAOutputTask
    extends DatabaseQueryTask<Void> {
        private AbstractOutputPane m_pane;
        private Connection m_conn;
        private String m_connectionName;
        private boolean m_shouldEnable = false;
        boolean m_shouldPrint = false;

        EnableOWAOutputTask(AbstractOutputPane abstractOutputPane, String string, boolean bl) {
            super(string, IRaptorTaskRunMode.MODAL_OPTIONAL, false, true);
            this.m_pane = abstractOutputPane;
            this.m_connectionName = Connections.getInstance().getConnectionName(abstractOutputPane.getCurrentConnection());
            this.m_shouldEnable = bl;
            this.m_shouldPrint = true;
        }

        public String getConnectionName() {
            return this.m_connectionName;
        }

        public String getQuery() {
            return "";
        }

        protected Void doWork() throws TaskException {
            if (this.m_shouldEnable) {
                this.m_pane.enableOutput(this.m_conn, this.m_shouldPrint);
            } else {
                this.m_pane.disableOutput(this.m_conn);
            }
            return null;
        }
    }
}

