/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.dbmsoutput;

import java.sql.Connection;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputDockable;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.OutputController;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public final class DbmsOutputController
extends OutputController {
    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        AbstractOutputPane abstractOutputPane = this.getPane(context);
        if (abstractOutputPane != null && ideAction.getCommandId() == DbmsOutputPane.TOGGLE_CMD_ID) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)new EnableDbmsOutputTask(abstractOutputPane.getCurrentConnection(), abstractOutputPane, "Enable DBMS_OUTPUT", IRaptorTaskRunMode.MODAL_OPTIONAL, false, false, ideAction.getState(), true));
            return true;
        }
        return bl;
    }

    @Override
    protected AbstractOutputPane getPane(Context context) {
        View view = context.getView();
        if (view instanceof DbmsOutputDockable) {
            DbmsOutputDockable dbmsOutputDockable = (DbmsOutputDockable)context.getView();
            AbstractOutputPane abstractOutputPane = dbmsOutputDockable.getPane();
            return abstractOutputPane;
        }
        return null;
    }

    public static class EnableDbmsOutputTask
    extends DatabaseQueryTask {
        Connection m_conn;
        AbstractOutputPane m_pane;
        String m_connectionName;
        boolean m_shouldEnable = false;
        boolean m_shouldPrint = false;

        public EnableDbmsOutputTask(Connection connection, AbstractOutputPane abstractOutputPane, String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(string, iRaptorTaskRunMode, bl, bl2);
            this.m_pane = abstractOutputPane;
            this.m_conn = connection;
            this.m_connectionName = Connections.getInstance().getConnectionName(connection);
            this.m_shouldEnable = bl3;
            this.m_shouldPrint = bl4;
        }

        public EnableDbmsOutputTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
            super(string, iRaptorTaskRunMode, bl, bl2);
        }

        public String getConnectionName() {
            return this.m_connectionName;
        }

        public String getQuery() {
            return "";
        }

        protected Object doWork() throws TaskException {
            if (this.m_shouldEnable) {
                this.m_pane.enableOutput(this.m_conn, this.m_shouldPrint);
            } else {
                this.m_pane.disableOutput(this.m_conn);
            }
            return null;
        }
    }
}

