/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.ExplainPlanAction;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;

public class AutotraceActionProvider
implements ActionProvider<Void> {
    static final String oracleDriver = "oracle.jdbc.OracleDriver";
    public static final String AUTOTRACE_CMD_ID = "Worksheet.Autotrace";
    public static final String EXPLAINPLAN_CMD_ID = "Worksheet.Explainplan";
    private WorksheetAction autotraceAction = WorksheetAction.createWorksheetAction("Worksheet.Autotrace", WorksheetAction.ActionType.BOTH, 0, -10.0);
    static final String actionPrefix = "Worksheet.VSQL_Child";
    private static final String[] IDs = new String[]{"Worksheet.Explainplan", "Worksheet.VSQL_Child0", "Worksheet.VSQL_Child1", "Worksheet.VSQL_Child2"};
    private WorksheetAction explainAction = WorksheetAction.createWorksheetAction(IDs, "Worksheet.Explainplan", WorksheetAction.ActionType.BOTH, 0, -10.0);
    private WorksheetContext ctx;
    private boolean[] enabledChildMenus = new boolean[]{false, false, false};

    public static boolean canExplainAutotrace(String string, String string2) throws DBException, SQLException {
        if (AUTOTRACE_CMD_ID.equals(string) && !AutotraceActionProvider.isOracle(string2)) {
            return false;
        }
        return AutotraceActionProvider.isRegistered(string2);
    }

    private static boolean isRegistered(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        if (string2 != null) {
            WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
            return worksheetFeatures.getAutotraceModelConstructor() != null;
        }
        return false;
    }

    private static boolean isOracle(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        return oracleDriver.equals(string2);
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        this.ctx = worksheetContext;
        boolean bl = false;
        try {
            bl = AutotraceActionProvider.canExplainAutotrace(string, worksheetContext.getConnectionName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return false;
        }
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        if (0 == basicDocument.getLength()) {
            return false;
        }
        if (string.startsWith(actionPrefix)) {
            int n = Integer.parseInt(string.substring(actionPrefix.length()));
            if (n == 0) {
                this.analyzeSQL();
            }
            return this.enabledChildMenus[n];
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeSQL() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            int n2;
            String string = this.ctx.getConnectionName();
            if (string == null) {
                return;
            }
            if (!Connections.getInstance().isOracle(string)) return;
            String string2 = this.ctx.getEditor().getSelectedText();
            if (string2 == null) {
                string2 = this.ctx.getEditor().getText();
            }
            if ((string2 = AnalyzeAction.extractSql(this.ctx, n2 = this.ctx.getEditor().getCaretPosition(), string2, null)) == null) {
                return;
            }
            SyntaxError syntaxError = SyntaxError.checkSQLQuerySyntax((String)string2);
            if (syntaxError != null) {
                int n3 = 0;
                while (n3 < 3) {
                    this.vSQLmenus(n3, null);
                    ++n3;
                }
                return;
            }
            this.enabledChildMenus = new boolean[]{false, false, false};
            String string3 = ExplainPlanAction.stmt2sqlid(string2);
            Connection connection = Connections.getInstance().getConnection(string);
            statement = connection.prepareStatement("select child_number from v$sql \n where sql_id = ?  \n order by child_number");
            statement.setString(1, string3);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt("child_number");
                if (2 < n) continue;
                this.enabledChildMenus[n] = true;
            }
            n = 0;
            while (n < 3) {
                this.vSQLmenus(n, string3);
                ++n;
            }
            return;
        }
        catch (SQLRecoverableException sQLRecoverableException) {
            return;
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            if (sQLSyntaxErrorException.getErrorCode() == 942) return;
            sQLSyntaxErrorException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void vSQLmenus(int n, String string) {
        IdeAction ideAction = IdeAction.find((String)(actionPrefix + n));
        ideAction.putValue("Name", (Object)this.menuLabel(n, string, this.enabledChildMenus[n]));
    }

    private String menuLabel(int n, String string, boolean bl) {
        if (string != null) {
            if (bl) {
                return "<html>V$SQL_PLAN.SQL_ID=<font color=blue>" + string + "</font>, V$SQL_PLAN.CHILD_NUMBER=<font color=blue>" + n + "</font>";
            }
            return "V$SQL_PLAN.SQL_ID=" + string + ", V$SQL_PLAN.CHILD_NUMBER=" + n;
        }
        return "V$SQL_PLAN.CHILD_NUMBER=" + n;
    }

    @Override
    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        boolean bl;
        AnalyzeAction analyzeAction = null;
        boolean bl2 = bl = EXPLAINPLAN_CMD_ID.equals(string) || string.startsWith(actionPrefix);
        if (AUTOTRACE_CMD_ID.equals(string)) {
            analyzeAction = new AutotraceAction(string, worksheetContext);
        } else if (bl) {
            analyzeAction = new ExplainPlanAction(string, worksheetContext);
        } else {
            return null;
        }
        AutotracePanel autotracePanel = new AutotracePanel(string, bl, worksheetContext);
        analyzeAction.setAutoTracePanel(autotracePanel);
        ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
        arrayList.add((IRaptorTaskListener)autotracePanel.new AbstractPanel.ResultsPanelTaskListener());
        for (IRaptorTaskListener iRaptorTaskListener : arrayList) {
            analyzeAction.getDescriptor().addListener(iRaptorTaskListener);
        }
        return analyzeAction != null ? new WorksheetTaskWrapper<Void>(analyzeAction, arrayList, Collections.EMPTY_LIST, worksheetContext) : null;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        if (n == 0) {
            return this.explainAction;
        }
        return this.autotraceAction;
    }

    @Override
    public int getActionsCount() {
        return 2;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }
}

