/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

class RecentFilesTracker
extends StructureChangeListener
implements EditorListener,
Subject,
Addin {
    public static final int URL_ADDED = UpdateMessage.newMessageID((String)"RecentFilesTracker.ADDED");
    public static final int URL_REMOVED = UpdateMessage.newMessageID((String)"RecentFilesTracker.REMOVED");
    private static RecentFilesTracker s_instance;
    private IdeSubject m_subject;

    RecentFilesTracker() {
    }

    static synchronized RecentFilesTracker getInstance() {
        assert (s_instance != null);
        return s_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        assert (s_instance == null);
        Class<RecentFilesTracker> clazz = RecentFilesTracker.class;
        synchronized (RecentFilesTracker.class) {
            s_instance = this;
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
            RecentFilesCache.getCache().addStructureChangeListener(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<URL> getRecentFiles() {
        return RecentFilesCache.getCache().getRecentFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Observer observer) {
        IdeSubject ideSubject;
        RecentFilesTracker recentFilesTracker = this;
        synchronized (recentFilesTracker) {
            if (this.m_subject == null) {
                this.m_subject = new IdeSubject();
            }
            ideSubject = this.m_subject;
        }
        ideSubject.attach(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Observer observer) {
        IdeSubject ideSubject;
        RecentFilesTracker recentFilesTracker = this;
        synchronized (recentFilesTracker) {
            ideSubject = this.m_subject;
        }
        if (ideSubject != null) {
            ideSubject.detach(observer);
        }
    }

    public void editorActivated(Editor editor) {
        Context context = editor.getContext();
        this.trackNode(context.getNode());
    }

    public void editorClosed(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorOpened(Editor editor) {
        Context context = editor.getContext();
        this.trackNode(context.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        IdeSubject ideSubject;
        RecentFilesTracker recentFilesTracker = this;
        synchronized (recentFilesTracker) {
            if (this.m_subject == null) {
                this.m_subject = new IdeSubject();
            }
            ideSubject = this.m_subject;
        }
        ideSubject.notifyObservers(object, updateMessage);
    }

    public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
        ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        for (ChangeInfo changeInfo : changeInfoArray) {
            if (changeInfo.getChangeType() == 1) {
                arrayList2.add(changeInfo.getNewValueAsURL());
                continue;
            }
            if (changeInfo.getChangeType() != 3) continue;
            arrayList.add(changeInfo.getOldValueAsURL());
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            URL uRL = (URL)object.next();
            if (!arrayList2.contains(uRL)) continue;
            object.remove();
        }
        if (arrayList.size() > 0) {
            object = new UpdateMessage(URL_REMOVED, (Object)this);
            object.getRemoveObjects().addAll(arrayList);
            this.notifyObservers((Object)this, (UpdateMessage)object);
        }
        if (arrayList2.size() > 0) {
            object = new UpdateMessage(URL_ADDED, (Object)this);
            object.getAddObjects().addAll(arrayList2);
            this.notifyObservers((Object)this, (UpdateMessage)object);
        }
    }

    private void trackNode(Node node) {
        URL uRL;
        if ((node instanceof PlSqlNode || node instanceof SqlNode) && (uRL = node.getURL()) != null && "file".equals(uRL.getProtocol())) {
            RecentFilesCache.getCache().addFile(uRL);
        }
    }

    static class RecentFilesCache
    extends HashStructureAdapter {
        static final String CACHE_KEY = "RaptorRecentFilesCache";
        static final String LIST_KEY = "RecentFiles";

        static RecentFilesCache getCache() {
            Preferences preferences = Preferences.getPreferences();
            return new RecentFilesCache(RecentFilesCache.findOrCreate((PropertyStorage)preferences, (String)CACHE_KEY));
        }

        private RecentFilesCache(HashStructure hashStructure) {
            super(hashStructure);
        }

        void addFile(final URL uRL) {
            final ListStructure listStructure = this._hash.getOrCreateListStructure(LIST_KEY);
            final int n = listStructure.size();
            if (n > 0 && URLFileSystem.equals((URL)((URL)listStructure.get(n - 1)), (URL)uRL)) {
                return;
            }
            this._hash.applyBatchChanges(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean bl = false;
                    Object object = listStructure.iteratorLock();
                    synchronized (object) {
                        Iterator iterator = listStructure.iterator();
                        while (iterator.hasNext()) {
                            URL uRL2 = (URL)iterator.next();
                            if (!URLFileSystem.equals((URL)uRL, (URL)uRL2)) continue;
                            bl = true;
                            iterator.remove();
                            break;
                        }
                    }
                    if (!bl && n >= 20) {
                        listStructure.remove(0);
                    }
                    listStructure.add((Object)uRL);
                }
            });
        }

        void clearList() {
            ListStructure listStructure = this.getList();
            listStructure.clear();
        }

        private ListStructure getList() {
            ListStructure listStructure = this._hash.getOrCreateListStructure(LIST_KEY);
            return listStructure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<URL> getRecentFiles() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            ListStructure listStructure = this.getList();
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                for (URL uRL : listStructure) {
                    arrayList.add(uRL);
                }
            }
            return arrayList;
        }

        void removeFile(URL uRL) {
            this.removeFiles(new URL[]{uRL});
        }

        void removeFiles(final URL[] uRLArray) {
            this._hash.applyBatchChanges(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ListStructure listStructure = this.getList();
                    Object object = listStructure.iteratorLock();
                    synchronized (object) {
                        block3: for (URL uRL : uRLArray) {
                            Iterator iterator = listStructure.iterator();
                            while (iterator.hasNext()) {
                                URL uRL2 = (URL)iterator.next();
                                if (!URLFileSystem.equals((URL)uRL, (URL)uRL2)) continue;
                                iterator.remove();
                                continue block3;
                            }
                        }
                    }
                }
            });
        }
    }
}

