/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util.wfs110;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.sdovis.util.XMLDOMParser;
import oracle.sdovis.util.wfs110.FeatureType;
import oracle.sdovis.util.wfs110.FeatureTypeList;
import oracle.sdovis.util.wfs110.FilterCapabilities;
import oracle.sdovis.util.wfs110.Operation;
import oracle.sdovis.util.wfs110.OperationsMetadata;
import oracle.sdovis.util.wfs110.ServesGMLObjectList;
import oracle.sdovis.util.wfs110.ServiceIdentification;
import oracle.sdovis.util.wfs110.ServiceProvider;
import oracle.sdovis.util.wfs110.SupportsGMLObjectTypeList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Capabilities {
    private Hashtable<String, String> xmlns = new Hashtable();
    private String schemaLocation = null;
    private String version = "1.1.0";
    private int updateSequence = 0;
    private ServiceIdentification identification = new ServiceIdentification();
    private ServiceProvider provider = new ServiceProvider();
    private OperationsMetadata operations = new OperationsMetadata();
    private FeatureTypeList features = new FeatureTypeList();
    private ServesGMLObjectList gmlObjects = new ServesGMLObjectList();
    private SupportsGMLObjectTypeList supportGMLObjects = new SupportsGMLObjectTypeList();
    private FilterCapabilities filterCapabilities = new FilterCapabilities();

    public void reset() {
        this.xmlns.clear();
        this.schemaLocation = null;
        this.identification.reset();
        this.provider.reset();
        this.operations.reset();
        this.features.reset();
        this.gmlObjects.reset();
        this.supportGMLObjects.reset();
        this.filterCapabilities.reset();
    }

    public String getVersion() {
        return this.version;
    }

    public String[] getXmlNameSpaceKeys() {
        if (this.xmlns.size() == 0) {
            return null;
        }
        ArrayList<String> xmlKeys = new ArrayList<String>();
        Enumeration<String> e = this.xmlns.keys();
        while (e.hasMoreElements()) {
            xmlKeys.add(e.nextElement());
        }
        if (xmlKeys.size() == 0) {
            return null;
        }
        return xmlKeys.toArray(new String[xmlKeys.size()]);
    }

    public String getXmlNameSpace(String key) {
        if (key == null) {
            return null;
        }
        return this.xmlns.get(key);
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public int getUpdateSequence() {
        return this.updateSequence;
    }

    public String getGETURLforGetCapabilities() {
        Operation op = this.operations.getOperation("GetCapabilities");
        if (op == null) {
            return null;
        }
        return op.getDCP().getHttp().getGetURL();
    }

    public String getPOSTURLforGetCapabilities() {
        Operation op = this.operations.getOperation("GetCapabilities");
        if (op == null) {
            return null;
        }
        return op.getDCP().getHttp().getPostURL();
    }

    public String getGETURLforDescribeFeatureType() {
        Operation op = this.operations.getOperation("DescribeFeatureType");
        if (op == null) {
            return null;
        }
        return op.getDCP().getHttp().getGetURL();
    }

    public String getPOSTURLforDescribeFeatureType() {
        Operation op = this.operations.getOperation("DescribeFeatureType");
        if (op == null) {
            return null;
        }
        return op.getDCP().getHttp().getPostURL();
    }

    public String getGETURLforGetFeature() {
        Operation op = this.operations.getOperation("GetFeature");
        if (op == null) {
            return null;
        }
        return op.getDCP().getHttp().getGetURL();
    }

    public String getPOSTURLforGetFeature() {
        Operation op = this.operations.getOperation("GetFeature");
        if (op == null) {
            return null;
        }
        return op.getDCP().getHttp().getPostURL();
    }

    public FeatureType[] getFeatures() {
        return this.features.getFeatureTypes();
    }

    public void parseCapabilities(String capabilitiesDoc) throws Exception {
        this.reset();
        XMLDOMParser parser = new XMLDOMParser();
        parser.parse(capabilitiesDoc);
        Document doc = parser.getDocument();
        Node root = doc.getFirstChild();
        if (root == null) {
            throw new Exception("Invalid capabilities string. Root node not found.");
        }
        if (!root.getNodeName().equalsIgnoreCase("WFS_Capabilities")) {
            NodeList nl = doc.getElementsByTagName("WFS_Capabilities");
            if (nl != null && nl.getLength() > 0) {
                root = nl.item(0);
            } else {
                throw new Exception("WFS_Capabilities node not found.");
            }
        }
        this.parseRootNode(parser, root);
        NodeList capNodes = root.getChildNodes();
        if (capNodes != null) {
            for (int j = 0; j < capNodes.getLength(); ++j) {
                Node node = capNodes.item(j);
                if (this.normalize(node.getNodeName()).equalsIgnoreCase("ServiceIdentification")) {
                    this.parseServiceIdentification(node);
                    continue;
                }
                if (this.normalize(node.getNodeName()).equalsIgnoreCase("ServiceProvider")) {
                    this.parseServiceProvider(parser, node);
                    continue;
                }
                if (this.normalize(node.getNodeName()).equalsIgnoreCase("OperationsMetadata")) {
                    this.parseOperationsMetadata(parser, node);
                    continue;
                }
                if (!this.normalize(node.getNodeName()).equalsIgnoreCase("FeatureTypeList")) continue;
                this.parseFeatureTypeList(parser, node);
            }
        }
    }

    private void parseRootNode(XMLDOMParser parser, Node root) throws Exception {
        String value = XMLDOMParser.getAttribute(root, "version");
        if (value != null && value.trim().length() > 0) {
            if (!value.trim().equalsIgnoreCase("1.1.0")) {
                throw new Exception("Invalid capabilities version: " + value.trim());
            }
            this.version = value.trim();
        }
        if ((value = XMLDOMParser.getAttribute(root, "updateSequence")) != null && value.trim().length() > 0) {
            int seq;
            this.updateSequence = seq = Integer.parseInt(value.trim());
        }
        if ((value = XMLDOMParser.getAttribute(root, "xmlns")) != null && value.trim().length() > 0) {
            this.xmlns.put("xmlns", value.trim());
        }
        if ((value = XMLDOMParser.getAttribute(root, "xmlns:wfs")) != null && value.trim().length() > 0) {
            this.xmlns.put("xmlns:wfs", value.trim());
        }
        if ((value = XMLDOMParser.getAttribute(root, "xmlns:ogc")) != null && value.trim().length() > 0) {
            this.xmlns.put("xmlns:ogc", value.trim());
        }
        if ((value = XMLDOMParser.getAttribute(root, "xmlns:xlink")) != null && value.trim().length() > 0) {
            this.xmlns.put("xmlns:xlink", value.trim());
        }
        if ((value = XMLDOMParser.getAttribute(root, "xmlns:xsi")) != null && value.trim().length() > 0) {
            this.xmlns.put("xmlns:xsi", value.trim());
        }
        if ((value = XMLDOMParser.getAttribute(root, "xsi:schemaLocation")) != null && value.trim().length() > 0) {
            this.schemaLocation = value.trim();
        }
    }

    private void parseServiceIdentification(Node node) throws Exception {
        NodeList serviceNodes = node.getChildNodes();
        if (serviceNodes != null) {
            for (int j = 0; j < serviceNodes.getLength(); ++j) {
                Node child = serviceNodes.item(j);
                Node value = child.getFirstChild();
                String valueString = "";
                if (value != null) {
                    valueString = value.getNodeValue();
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("Title")) {
                    this.identification.setTitle(valueString);
                    continue;
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("Abstract")) {
                    this.identification.setAbstract(valueString);
                    continue;
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("Keywords")) {
                    NodeList keywordsNode = child.getChildNodes();
                    if (keywordsNode == null) continue;
                    for (int k = 0; k < keywordsNode.getLength(); ++k) {
                        String key;
                        Node keyNode = keywordsNode.item(k);
                        Node keyValue = keyNode.getFirstChild();
                        if (!this.normalize(keyNode.getNodeName()).equalsIgnoreCase("Keyword") || keyValue == null || (key = keyValue.getNodeValue()) == null) continue;
                        this.identification.addKeyword(key);
                    }
                    continue;
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("Fees")) {
                    this.identification.setFees(valueString);
                    continue;
                }
                if (!this.normalize(child.getNodeName()).equalsIgnoreCase("AccessConstraints")) continue;
                this.identification.setAccessConstraints(valueString);
            }
        }
    }

    private void parseServiceProvider(XMLDOMParser parser, Node node) throws Exception {
        NodeList serviceNodes = node.getChildNodes();
        if (serviceNodes != null) {
            for (int j = 0; j < serviceNodes.getLength(); ++j) {
                Node child = serviceNodes.item(j);
                Node value = child.getFirstChild();
                String valueString = "";
                if (value != null) {
                    valueString = value.getNodeValue();
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("ProviderName")) {
                    this.provider.setName(valueString);
                    continue;
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("ProviderSite")) {
                    String v = XMLDOMParser.getAttribute(child, "xlink:href");
                    if (v != null && v.trim().length() > 0) {
                        this.provider.setSiteHref(v.trim());
                    }
                    if ((v = XMLDOMParser.getAttribute(child, "xlink:type")) == null || v.trim().length() <= 0) continue;
                    this.provider.setSiteType(v.trim());
                    continue;
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("ServiceContact")) {
                    NodeList contactsNode = child.getChildNodes();
                    if (contactsNode == null) continue;
                    for (int k = 0; k < contactsNode.getLength(); ++k) {
                        Node contactNode = contactsNode.item(k);
                        Node contactValue = contactNode.getFirstChild();
                        if (this.normalize(contactNode.getNodeName()).equalsIgnoreCase("IndividualName")) {
                            if (contactValue == null) continue;
                            this.provider.getServiceContact().setIndividualName(contactValue.getNodeValue());
                            continue;
                        }
                        if (this.normalize(contactNode.getNodeName()).equalsIgnoreCase("PositionName")) {
                            if (contactValue == null) continue;
                            this.provider.getServiceContact().setPosition(contactValue.getNodeValue());
                            continue;
                        }
                        if (this.normalize(contactNode.getNodeName()).equalsIgnoreCase("ContactInfo")) {
                            NodeList contactChilds = contactNode.getChildNodes();
                            if (contactChilds == null) continue;
                            for (int m = 0; m < contactChilds.getLength(); ++m) {
                                Node chNode = contactChilds.item(m);
                                if (this.normalize(chNode.getNodeName()).equalsIgnoreCase("Phone")) {
                                    Node facsimile;
                                    String ns = this.nameSpacePrefix(chNode.getNodeName());
                                    Node voice = XMLDOMParser.getSubElement(chNode, ns + "Voice");
                                    if (voice != null && voice.getFirstChild() != null) {
                                        this.provider.getServiceContact().getContactInfo().getPhone().setVoice(voice.getFirstChild().getNodeValue());
                                    }
                                    if ((facsimile = XMLDOMParser.getSubElement(chNode, ns + "Facsimile")) == null || facsimile.getFirstChild() == null) continue;
                                    this.provider.getServiceContact().getContactInfo().getPhone().setFacSimile(facsimile.getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (!this.normalize(chNode.getNodeName()).equalsIgnoreCase("Address")) continue;
                            }
                            continue;
                        }
                        if (!this.normalize(contactNode.getNodeName()).equalsIgnoreCase("Role") || contactValue == null) continue;
                        this.provider.getServiceContact().setRole(contactValue.getNodeValue());
                    }
                    continue;
                }
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("Fees")) {
                    this.identification.setFees(valueString);
                    continue;
                }
                if (!this.normalize(child.getNodeName()).equalsIgnoreCase("AccessConstraints")) continue;
                this.identification.setAccessConstraints(valueString);
            }
        }
    }

    private void parseOperationsMetadata(XMLDOMParser parser, Node node) throws Exception {
        NodeList operationNodes = node.getChildNodes();
        if (operationNodes != null) {
            for (int i = 0; i < operationNodes.getLength(); ++i) {
                Node opNode = operationNodes.item(i);
                if (!this.normalize(opNode.getNodeName()).equalsIgnoreCase("Operation")) continue;
                String name = XMLDOMParser.getAttribute(opNode, "name");
                Operation op = new Operation();
                op.setName(name);
                String ns = this.nameSpacePrefix(opNode.getNodeName());
                Node dcp = XMLDOMParser.getSubElement(opNode, ns + "DCP");
                if (dcp != null) {
                    Node httpNode = XMLDOMParser.getSubElement(dcp, ns + "HTTP");
                    if (httpNode != null) {
                        Node postNode;
                        Node getNode = XMLDOMParser.getSubElement(httpNode, ns + "Get");
                        if (getNode != null) {
                            String href = XMLDOMParser.getAttribute(getNode, "xlink:href");
                            String type = XMLDOMParser.getAttribute(getNode, "xlink:type");
                            op.getDCP().getHttp().setGetURL(href);
                            op.getDCP().getHttp().setGetURLtype(type);
                        }
                        if ((postNode = XMLDOMParser.getSubElement(httpNode, ns + "Post")) != null) {
                            String href = XMLDOMParser.getAttribute(postNode, "xlink:href");
                            String type = XMLDOMParser.getAttribute(postNode, "xlink:type");
                            op.getDCP().getHttp().setPostURL(href);
                            op.getDCP().getHttp().setPostURLtype(type);
                        }
                    }
                }
                this.operations.addOperation(op);
            }
        }
    }

    private void parseFeatureTypeList(XMLDOMParser parser, Node node) throws Exception {
        NodeList featureNodes = node.getChildNodes();
        if (featureNodes != null) {
            for (int i = 0; i < featureNodes.getLength(); ++i) {
                Node wgs84Node;
                Node outFormatsNode;
                Node defaultSRSNode;
                Node titleNode;
                Node ftNode = featureNodes.item(i);
                if (!this.normalize(ftNode.getNodeName()).equalsIgnoreCase("FeatureType")) continue;
                FeatureType ft = new FeatureType();
                String ns = this.nameSpacePrefix(ftNode.getNodeName());
                Node nameNode = XMLDOMParser.getSubElement(ftNode, ns + "Name");
                if (nameNode == null) {
                    XMLDOMParser.getSubElement(ftNode, "Name");
                }
                if (nameNode != null && nameNode.getFirstChild() != null) {
                    String name = nameNode.getFirstChild().getNodeValue();
                    int index = name.indexOf(":");
                    if (index > -1) {
                        ft.setNamespaceAliasName(name.substring(0, index));
                        ft.setName(name.substring(index + 1, name.length()));
                        String nspUrl = XMLDOMParser.getAttribute(nameNode, "xmlns:" + name.substring(0, index));
                        if (nspUrl == null) {
                            nspUrl = XMLDOMParser.getAttribute(ftNode, "xmlns:" + ft.getNamespaceAliasName());
                        }
                        if (nspUrl != null && nspUrl.trim().length() > 0) {
                            ft.setNamespaceURL(nspUrl.trim());
                        }
                    } else {
                        ft.setName(name);
                    }
                }
                if ((titleNode = XMLDOMParser.getSubElement(ftNode, ns + "Title")) == null) {
                    XMLDOMParser.getSubElement(ftNode, "Title");
                }
                if (titleNode != null && titleNode.getFirstChild() != null) {
                    ft.setTitle(titleNode.getFirstChild().getNodeValue());
                }
                if ((defaultSRSNode = XMLDOMParser.getSubElement(ftNode, ns + "DefaultSRS")) == null) {
                    XMLDOMParser.getSubElement(ftNode, "DefaultSRS");
                }
                if (defaultSRSNode != null && defaultSRSNode.getFirstChild() != null) {
                    ft.setDefaultSRS(defaultSRSNode.getFirstChild().getNodeValue());
                }
                if ((outFormatsNode = XMLDOMParser.getSubElement(ftNode, ns + "OutputFormats")) == null) {
                    outFormatsNode = XMLDOMParser.getSubElement(ftNode, "OutputFormats");
                }
                if (outFormatsNode != null) {
                    ArrayList outFtNodes = XMLDOMParser.getSubElements(outFormatsNode, ns + "Format");
                    if (outFtNodes != null && outFtNodes.size() > 0) {
                        for (int j = 0; j < outFtNodes.size(); ++j) {
                            if (((Node)outFtNodes.get(j)).getFirstChild() == null) continue;
                            ft.getOutputFormats().addFormat(((Node)outFtNodes.get(j)).getFirstChild().getNodeValue());
                        }
                    }
                }
                if ((wgs84Node = XMLDOMParser.getSubElement(ftNode, "ows:WGS84BoundingBox")) != null) {
                    Node lowerCornerNode = XMLDOMParser.getSubElement(wgs84Node, "ows:LowerCorner");
                    Node upperCornerNode = XMLDOMParser.getSubElement(wgs84Node, "ows:UpperCorner");
                    if (lowerCornerNode != null && lowerCornerNode.getFirstChild() != null && upperCornerNode != null && upperCornerNode.getFirstChild() != null) {
                        String lc = lowerCornerNode.getFirstChild().getNodeValue();
                        double x1 = Double.NaN;
                        double y1 = Double.NaN;
                        int index = lc.indexOf(" ");
                        if (index > -1) {
                            try {
                                x1 = Double.parseDouble(lc.substring(0, index));
                                y1 = Double.parseDouble(lc.substring(index + 1));
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        String uc = upperCornerNode.getFirstChild().getNodeValue();
                        double x2 = Double.NaN;
                        double y2 = Double.NaN;
                        index = uc.indexOf(" ");
                        if (index > -1) {
                            try {
                                x2 = Double.parseDouble(uc.substring(0, index));
                                y2 = Double.parseDouble(uc.substring(index + 1));
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        ft.getWGS84BoundingBox().setLowerCorner(new Point2D.Double(x1, y1));
                        ft.getWGS84BoundingBox().setUpperCorner(new Point2D.Double(x2, y2));
                    }
                }
                this.features.addFeatureType(ft);
            }
            FeatureType[] ftype = this.features.getFeatureTypes();
            for (int i = 0; i < ftype.length; ++i) {
                FeatureType wft = ftype[i];
                if (wft.getNamespaceAliasName() == null || wft.getNamespaceURL() == null) continue;
                this.xmlns.put("xmlns:" + wft.getNamespaceAliasName(), wft.getNamespaceURL());
            }
        }
    }

    private void parseServesGMLObjectList(Node node) throws Exception {
    }

    private void parseSupportsGMLObjectTypeList(Node node) throws Exception {
    }

    private void parseFilterCapabilities(Node node) throws Exception {
    }

    private String normalize(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        if (nodeName.indexOf(":") >= 0) {
            return nodeName.substring(nodeName.indexOf(":") + 1);
        }
        return nodeName;
    }

    private String nameSpacePrefix(String nodeName) {
        if (nodeName == null) {
            return "";
        }
        if (nodeName.indexOf(":") >= 0) {
            return nodeName.substring(0, nodeName.indexOf(":") + 1);
        }
        return "";
    }
}

