/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.geom.Point2D;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;

public class WorldMercatorUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static double[] mercParams = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
    private static double[] geodParams = new double[]{6378137.0, 298.257223563};
    private static double mdFE = mercParams[3];
    private static double mdFN = mercParams[4];
    private static double k0 = mercParams[2];
    private static double lon0 = mercParams[1];
    private static double a = geodParams[0];
    private static double f = 1.0 / geodParams[1];
    private static double e = Math.sqrt(2.0 * f - f * f);
    private static double pow4 = Math.pow(e, 4.0);
    private static double pow6 = Math.pow(e, 6.0);
    private static double pow8 = Math.pow(e, 8.0);
    private static double p1 = e * e / 2.0;
    private static double p2 = 5.0 * pow4 / 24.0;
    private static double p3 = pow6 / 12.0;
    private static double p4 = 13.0 * pow8 / 360.0;

    public static Point2D geodeticToMercator(double x, double y, Point2D res) {
        Point2D radianPt = WorldMercatorUtil.toRadian(x, y, res);
        double lon = radianPt.getX();
        double lat = radianPt.getY();
        double rx = mdFE + a * k0 * (lon - lon0);
        double sin = Math.sin(lat);
        double tan = Math.tan(0.7853981633974483 + lat / 2.0);
        double powParam1 = (1.0 - e * sin) / (1.0 + e * sin);
        double powParam2 = e / 2.0;
        double pow = Math.pow(powParam1, powParam2);
        double ry = mdFN + a * k0 * Math.log(tan * pow);
        if (res == null) {
            res = new Point2D.Double();
        }
        res.setLocation(rx, ry);
        return res;
    }

    public static Point2D mercatorToGeodetic(double x, double y, Point2D res) {
        double N = x;
        double E = y;
        double B = Math.E;
        double t = Math.pow(B, (mdFN - N) / (a * k0));
        double chi = 1.5707963267948966 - 2.0 * Math.atan2(t, 1.0);
        double p5 = Math.sin(2.0 * chi);
        double p6 = 7.0 * pow4 / 48.0;
        double p7 = 29.0 * pow6 / 240.0;
        double p8 = 811.0 * pow8 / 11520.0;
        double p9 = Math.sin(2.0 * chi);
        double p10 = 7.0 * pow6 / 120.0;
        double p11 = 81.0 * pow8 / 1120.0;
        double p12 = Math.sin(6.0 * chi);
        double p13 = 4279.0 * pow8 / 161280.0;
        double p14 = Math.sin(8.0 * chi);
        double lat = chi + (p1 + p2 + p3 + p4) * p5 + (p6 + p7 + p8) * p9 + (p10 + p11) * p12 + p13 * p14;
        double lon = (E - mdFE) / (a * k0) + lon0;
        Point2D pt = WorldMercatorUtil.toLatLong(lon, lat, res);
        return pt;
    }

    private static Point2D toRadian(double lon, double lat, Point2D res) {
        while (lon < -180.0) {
            lon += 360.0;
        }
        while (lon > 180.0) {
            lon -= 360.0;
        }
        lon = lon * Math.PI / 180.0;
        lat = lat * Math.PI / 180.0;
        if (res == null) {
            res = new Point2D.Double();
        }
        res.setLocation(lon, lat);
        return res;
    }

    private static Point2D toLatLong(double lonRadian, double latRadian, Point2D res) {
        double lat = latRadian * 180.0 / Math.PI;
        double lon = lonRadian * 180.0 / Math.PI;
        if (res == null) {
            res = new Point2D.Double();
        }
        res.setLocation(lon, lat);
        return res;
    }

    public static final JSDOGeometry geodeticToMercator(JSDOGeometry in) {
        double[] coords = in.getOrdinatesArray();
        Point2D.Double pt = new Point2D.Double();
        if (coords != null) {
            double[] out = new double[coords.length];
            int dim = in.getDimensions();
            for (int i = 0; i < coords.length; i += dim) {
                double lon = coords[i];
                double lat = coords[i + 1];
                WorldMercatorUtil.geodeticToMercator(lon, lat, pt);
                out[i] = ((Point2D)pt).getX();
                out[i + 1] = ((Point2D)pt).getY();
            }
            return new JSDOGeometry(in.getType(), 54004, in.getElemInfo(), out);
        }
        coords = in.getPoint();
        if (coords == null) {
            log.severe("Invalid input geometry.");
            return in;
        }
        WorldMercatorUtil.geodeticToMercator(coords[0], coords[1], pt);
        if (coords.length > 2 && !Double.isNaN(coords[2])) {
            return new JSDOGeometry(((Point2D)pt).getX(), ((Point2D)pt).getY(), coords[2], 54004);
        }
        return new JSDOGeometry(((Point2D)pt).getX(), ((Point2D)pt).getY(), 54004);
    }

    public static final JSDOGeometry mercatorToGeodetic(JSDOGeometry in) {
        double[] coords = in.getOrdinatesArray();
        Point2D.Double pt = new Point2D.Double();
        if (coords != null) {
            double[] out = new double[coords.length];
            int dim = in.getDimensions();
            for (int i = 0; i < coords.length; i += dim) {
                double lon = coords[i];
                double lat = coords[i + 1];
                WorldMercatorUtil.mercatorToGeodetic(lon, lat, pt);
                out[i] = ((Point2D)pt).getX();
                out[i + 1] = ((Point2D)pt).getY();
            }
            return new JSDOGeometry(in.getType(), 8307, in.getElemInfo(), out);
        }
        coords = in.getPoint();
        if (coords == null) {
            log.severe("Invalid input geometry.");
            return in;
        }
        WorldMercatorUtil.mercatorToGeodetic(coords[0], coords[1], pt);
        if (coords.length > 2 && !Double.isNaN(coords[2])) {
            return new JSDOGeometry(((Point2D)pt).getX(), ((Point2D)pt).getY(), coords[2], 8307);
        }
        return new JSDOGeometry(((Point2D)pt).getX(), ((Point2D)pt).getY(), 8307);
    }
}

