/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.sdovis.util.ConflictResolver;

public class RectArray
implements ConflictResolver {
    int[] rects;
    int size = 0;
    int capacity = 0;
    int initialSize = 256;
    int scale = 1;

    public RectArray(int initialSize, int _scale) {
        if (initialSize > 0) {
            this.initialSize = initialSize;
        }
        this.capacity = this.initialSize;
        this.rects = new int[4 * this.capacity];
        this.scale = _scale;
    }

    public RectArray(int initialSize) {
        if (initialSize > 0) {
            this.initialSize = initialSize;
        }
        this.capacity = this.initialSize;
        this.rects = new int[4 * this.capacity];
    }

    public void freeAll() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public Rectangle2D elementAt(int idx) {
        if (idx < 0 || idx >= this.size) {
            return null;
        }
        int x = this.rects[idx *= 4];
        int y = this.rects[idx + 1];
        int w = this.rects[idx + 2] - x;
        int h = this.rects[idx + 3] - y;
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public void reset() {
        this.rects = null;
        this.size = 0;
        this.capacity = 0;
    }

    @Override
    public void insert(int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this.capacity == 0) {
            this.capacity = this.initialSize;
            this.rects = new int[4 * this.capacity];
        }
        if (this.size >= this.capacity) {
            this.capacity *= 2;
            int[] temp = new int[this.capacity * 4];
            System.arraycopy(this.rects, 0, temp, 0, this.size * 4);
            this.rects = temp;
        }
        int idx = this.size * 4;
        this.rects[idx] = x;
        this.rects[idx + 1] = y;
        this.rects[idx + 2] = x + w;
        this.rects[idx + 3] = y + h;
        ++this.size;
    }

    @Override
    public void insert(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return;
        }
        if (this.capacity == 0) {
            this.capacity = this.initialSize;
            this.rects = new int[4 * this.capacity];
        }
        if (this.size >= this.capacity) {
            this.capacity *= 2;
            int[] temp = new int[this.capacity * 4];
            System.arraycopy(this.rects, 0, temp, 0, this.size * 4);
            this.rects = temp;
        }
        int idx = this.size * 4;
        this.rects[idx] = (int)(x * (double)this.scale);
        this.rects[idx + 1] = (int)(y * (double)this.scale);
        this.rects[idx + 2] = (int)((x + w) * (double)this.scale);
        this.rects[idx + 3] = (int)((y + h) * (double)this.scale);
        ++this.size;
    }

    @Override
    public void insert(Rectangle2D r) {
        this.insert((int)(r.getMinX() * (double)this.scale), (int)(r.getMinY() * (double)this.scale), (int)(r.getWidth() * (double)this.scale), (int)(r.getHeight() * (double)this.scale));
    }

    public void addAll(Vector vRects) {
        for (int i = 0; i < vRects.size(); ++i) {
            this.insert((Rectangle2D)vRects.elementAt(i));
        }
    }

    public void addAll(RectArray rectArray) {
        if (rectArray != null && rectArray.size > 0) {
            for (int i = 0; i < rectArray.size; ++i) {
                this.insert(rectArray.rects[i * 4], rectArray.rects[i * 4 + 1], rectArray.rects[i * 4 + 2] - rectArray.rects[i * 4], rectArray.rects[i * 4 + 3] - rectArray.rects[i * 4 + 1]);
            }
        }
    }

    @Override
    public boolean conflicts(int x, int y, int w, int h) {
        if (w <= 0 && h <= 0) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            int idx = i * 4;
            int x0 = this.rects[idx];
            int y0 = this.rects[idx + 1];
            int x1 = this.rects[idx + 2];
            int y1 = this.rects[idx + 3];
            if (x + w <= x0 || y + h <= y0 || x >= x1 || y >= y1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean conflicts(double x, double y, double w, double h) {
        if (w <= 0.0 && h <= 0.0) {
            return false;
        }
        int x00 = (int)(x * (double)this.scale);
        int y00 = (int)(y * (double)this.scale);
        int x11 = (int)((x + w) * (double)this.scale);
        int y11 = (int)((y + h) * (double)this.scale);
        for (int i = 0; i < this.size; ++i) {
            int idx = i * 4;
            int x0 = this.rects[idx];
            int y0 = this.rects[idx + 1];
            int x1 = this.rects[idx + 2];
            int y1 = this.rects[idx + 3];
            if (x11 <= x0 || y11 <= y0 || x00 >= x1 || y00 >= y1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean conflicts(Rectangle2D rIn) {
        return this.conflicts(rIn.getMinX(), rIn.getMinY(), rIn.getWidth(), rIn.getHeight());
    }

    public int countConflicts(Rectangle2D rIn) {
        return this.countConflicts(rIn.getMinX(), rIn.getMinY(), rIn.getWidth(), rIn.getHeight());
    }

    public int countConflicts(double x, double y, double w, double h) {
        if (w <= 0.0 && h <= 0.0) {
            return 0;
        }
        int x00 = (int)(x * (double)this.scale);
        int y00 = (int)(y * (double)this.scale);
        int x11 = (int)((x + w) * (double)this.scale);
        int y11 = (int)((y + h) * (double)this.scale);
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            int idx = i * 4;
            int x0 = this.rects[idx];
            int y0 = this.rects[idx + 1];
            int x1 = this.rects[idx + 2];
            int y1 = this.rects[idx + 3];
            if (x11 <= x0 || y11 <= y0 || x00 >= x1 || y00 >= y1) continue;
            ++count;
        }
        return count;
    }

    public int countConflicts(int x, int y, int w, int h) {
        if (w <= 0 && h <= 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            int idx = i * 4;
            int x0 = this.rects[idx];
            int y0 = this.rects[idx + 1];
            int x1 = this.rects[idx + 2];
            int y1 = this.rects[idx + 3];
            if (x + w <= x0 || y + h <= y0 || x >= x1 || y >= y1) continue;
            ++count;
        }
        return count;
    }

    public int agregateConflictArea(double x, double y, double w, double h) {
        if (w <= 0.0 && h <= 0.0) {
            return 0;
        }
        int x00 = (int)(x * (double)this.scale);
        int y00 = (int)(y * (double)this.scale);
        int x11 = (int)((x + w) * (double)this.scale);
        int y11 = (int)((y + h) * (double)this.scale);
        int conflictArea = 0;
        for (int i = 0; i < this.size; ++i) {
            int idx = i * 4;
            int x0 = this.rects[idx];
            int y0 = this.rects[idx + 1];
            int x1 = this.rects[idx + 2];
            int y1 = this.rects[idx + 3];
            if (x11 <= x0 || y11 <= y0 || x00 >= x1 || y00 >= y1) continue;
            conflictArea += (Math.min(x1, x11) - Math.max(x0, x00)) * (Math.min(y1, y11) - Math.max(y0, y00));
        }
        return conflictArea;
    }

    public int agregateConflictArea(Rectangle2D rIn) {
        return this.agregateConflictArea(rIn.getMinX(), rIn.getMinY(), rIn.getWidth(), rIn.getHeight());
    }

    public int agregateConflictArea(int x, int y, int w, int h) {
        if (w <= 0 && h <= 0) {
            return 0;
        }
        int conflictArea = 0;
        for (int i = 0; i < this.size; ++i) {
            int idx = i * 4;
            int x0 = this.rects[idx];
            int y0 = this.rects[idx + 1];
            int x1 = this.rects[idx + 2];
            int y1 = this.rects[idx + 3];
            if (x + w <= x0 || y + h <= y0 || x >= x1 || y >= y1) continue;
            conflictArea += (Math.min(x1, x + w) - Math.max(x0, x)) * (Math.min(y1, y + h) - Math.max(y0, y));
        }
        return conflictArea;
    }

    public Object clone() {
        RectArray cloned = new RectArray(Math.max(this.size, this.initialSize), this.scale);
        cloned.rects = (int[])this.rects.clone();
        cloned.capacity = this.capacity;
        cloned.size = this.size;
        return cloned;
    }
}

