/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class Quantizer {
    private static final int RGB_HIST_DEPTH = 5;
    private static final int ARGB_HIST_DEPTH = 4;

    public static RenderedImage rgb24to8(RenderedImage input) {
        return Quantizer.rgb24to8(input, false, 1, null, false);
    }

    public static RenderedImage rgb24to8(RenderedImage input, Color fixedColor) {
        return Quantizer.rgb24to8(input, false, 1, fixedColor, false);
    }

    public static RenderedImage rgb24to8(RenderedImage input, Color fixedColor, boolean transparent) {
        return Quantizer.rgb24to8(input, false, 1, fixedColor, transparent);
    }

    private static RenderedImage rgb24to8(RenderedImage input, boolean accurate, int sampling, Color fixedColor, boolean transparent) {
        Object[] sindx = null;
        if (!accurate) {
            sindx = new Object[1];
        }
        int[] transIdx = transparent ? new int[1] : null;
        byte[][] byteLUT = Quantizer.computeRGBLUTMedian(input, sampling, 256, sindx, fixedColor, transIdx);
        byte[][][] spatialIndex = null;
        if (!accurate) {
            spatialIndex = (byte[][][])sindx[0];
        }
        if (fixedColor != null && transIdx != null && transIdx[0] == 0) {
            int fr = fixedColor.getRed();
            int fg = fixedColor.getGreen();
            int fb = fixedColor.getBlue();
            int r = byteLUT[0][0];
            int g = byteLUT[1][0];
            int b = byteLUT[2][0];
            if (r < 0) {
                r += 256;
            }
            if (g < 0) {
                g += 256;
            }
            if (b < 0) {
                b += 256;
            }
            if (fr != r || fg != g || fb != b) {
                transparent = false;
            }
        }
        IndexColorModel icm = transparent ? new IndexColorModel(8, byteLUT[0].length, byteLUT[0], byteLUT[1], byteLUT[2], transIdx[0]) : new IndexColorModel(8, byteLUT[0].length, byteLUT[0], byteLUT[1], byteLUT[2]);
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), 13, icm);
        Quantizer.quantize24Bits(input, output, byteLUT, spatialIndex);
        return output;
    }

    public static RenderedImage rgb24to4(RenderedImage input) {
        return Quantizer.rgb24to4(input, false, 1, null);
    }

    private static RenderedImage rgb24to4(RenderedImage input, boolean accurate, int sampling, Color fixedColor) {
        Object[] sindx = null;
        if (!accurate) {
            sindx = new Object[1];
        }
        byte[][] byteLUT = Quantizer.computeRGBLUTMedian(input, sampling, 16, sindx, fixedColor);
        byte[][][] spatialIndex = null;
        if (!accurate) {
            spatialIndex = (byte[][][])sindx[0];
        }
        IndexColorModel icm = new IndexColorModel(4, byteLUT[0].length, byteLUT[0], byteLUT[1], byteLUT[2]);
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), 13, icm);
        Quantizer.quantize24Bits(input, output, byteLUT, spatialIndex);
        return output;
    }

    private static byte[][] computeRGBLUTMedian(RenderedImage img, int sampling, int maxColors, Object[] indexOut, Color fixedColor) {
        return Quantizer.computeRGBLUTMedian(img, sampling, maxColors, indexOut, fixedColor, null);
    }

    private static byte[][] computeRGBLUTMedian(RenderedImage img, int sampling, int maxColors, Object[] indexOut, Color fixedColor, int[] transIdx) {
        int i;
        int histDim = 32;
        int[][][] hist = new int[32][32][32];
        Quantizer.fillRGBHistogram(img, hist, sampling);
        Cube[] cubes = new Cube[maxColors];
        cubes[0] = new Cube(0, 0, 0, 31, 31, 31, hist);
        int numCubes = 1;
        while (numCubes < maxColors) {
            int toSplit = -1;
            int minGeneration = Integer.MAX_VALUE;
            for (i = 0; i < numCubes; ++i) {
                if (cubes[i].generation >= minGeneration || !cubes[i].canSplit()) continue;
                toSplit = i;
                minGeneration = cubes[toSplit].generation;
            }
            if (toSplit < 0) break;
            int splitDim = cubes[toSplit].findSplit();
            if (splitDim == 0) {
                throw new RuntimeException("Cube split inconsistency");
            }
            switch (splitDim) {
                case 1: {
                    cubes[numCubes++] = cubes[toSplit].splitRed(hist);
                    break;
                }
                case 2: {
                    cubes[numCubes++] = cubes[toSplit].splitGreen(hist);
                    break;
                }
                case 3: {
                    cubes[numCubes++] = cubes[toSplit].splitBlue(hist);
                }
            }
        }
        byte[][] tableData = new byte[3][maxColors];
        for (int i2 = 0; i2 < numCubes; ++i2) {
            int color = cubes[i2].color(hist);
            tableData[0][i2] = (byte)(color >> 16 & 0xFF);
            tableData[1][i2] = (byte)(color >> 8 & 0xFF);
            tableData[2][i2] = (byte)(color & 0xFF);
        }
        if (fixedColor != null) {
            int shift = 8 - Quantizer.numColorsToBits(hist.length);
            int r = fixedColor.getRed();
            int g = fixedColor.getGreen();
            int b = fixedColor.getBlue();
            int rShift = r >> shift;
            int gShift = g >> shift;
            int bShift = b >> shift;
            for (int i3 = 0; i3 < numCubes; ++i3) {
                if (!cubes[i3].inCube(rShift, gShift, bShift)) continue;
                tableData[0][i3] = (byte)r;
                tableData[1][i3] = (byte)g;
                tableData[2][i3] = (byte)b;
                if (transIdx == null) break;
                transIdx[0] = i3;
                break;
            }
        }
        if (indexOut != null) {
            byte[][][] index = new byte[32][32][32];
            for (i = 0; i < numCubes; ++i) {
                for (int r = cubes[i].rmin; r <= cubes[i].rmax; ++r) {
                    for (int g = cubes[i].gmin; g <= cubes[i].gmax; ++g) {
                        for (int b = cubes[i].bmin; b <= cubes[i].bmax; ++b) {
                            index[r][g][b] = (byte)i;
                        }
                    }
                }
            }
            indexOut[0] = index;
        }
        return tableData;
    }

    private static void fillRGBHistogram(RenderedImage img, int[][][] hist, int sampling) {
        int minX = img.getMinX();
        int minY = img.getMinY();
        int width = img.getWidth();
        int height = img.getHeight();
        int numBands = img.getSampleModel().getNumBands();
        if (numBands < 3) {
            throw new RuntimeException("Insufficient bit depth in fillRGBHistogram input image");
        }
        int[] pixels = new int[width * numBands];
        int shift = 8 - Quantizer.numColorsToBits(hist.length);
        int rowStride = sampling;
        int colStride = numBands * sampling;
        for (int row = minY; row < minY + height; row += rowStride) {
            Raster src = img.getData(new Rectangle(minX, row, width, 1));
            src.getPixels(minX, row, width, 1, pixels);
            for (int col = 0; col < numBands * width; col += colStride) {
                int r = pixels[col] >> shift;
                int g = pixels[col + 1] >> shift;
                int b = pixels[col + 2] >> shift;
                int[] nArray = hist[r][g];
                int n = b;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private static void quantize24Bits(RenderedImage input, BufferedImage output, byte[][] lut, byte[][][] spatialIndex) {
        int numBands;
        int shift = 0;
        if (spatialIndex != null) {
            shift = 8 - Quantizer.numColorsToBits(spatialIndex.length);
        }
        Hashtable rgbToLUT = null;
        if (spatialIndex == null) {
            rgbToLUT = new Hashtable();
        }
        if ((numBands = input.getSampleModel().getNumBands()) < 3) {
            throw new RuntimeException("Insufficient bit depth in quantize24Bits input image");
        }
        int minX = input.getMinX();
        int minY = input.getMinY();
        int width = input.getWidth();
        int height = input.getHeight();
        int[] pixels = new int[width * numBands];
        WritableRaster dest = output.getRaster();
        int y = 0;
        for (int row = minY; row < minY + height; ++row) {
            int index;
            int col;
            Raster src = input.getData(new Rectangle(minX, row, width, 1));
            src.getPixels(minX, row, width, 1, pixels);
            int x = 0;
            if (spatialIndex != null) {
                for (col = 0; col < numBands * width; col += numBands) {
                    index = spatialIndex[pixels[col] >> shift][pixels[col + 1] >> shift][pixels[col + 2] >> shift];
                    dest.setSample(x++, y, 0, index);
                }
            } else {
                for (col = 0; col < numBands * width; col += numBands) {
                    index = Quantizer.findNearestRGBIndex(pixels[col], pixels[col + 1], pixels[col + 2], lut, rgbToLUT);
                    dest.setSample(x++, y, 0, index);
                }
            }
            ++y;
        }
    }

    private static int findNearestRGBIndex(int r, int g, int b, byte[][] lut, Hashtable rgbToLUT) {
        Integer rgb = null;
        rgb = new Integer(r << 16 | g << 8 | b);
        Integer mapIndex = (Integer)rgbToLUT.get(rgb);
        if (mapIndex != null) {
            return mapIndex;
        }
        int bestDist = 196608;
        int bestIndex = 0;
        for (int i = 0; i < lut[0].length; ++i) {
            int dist = (r - (lut[0][i] & 0xFF)) * (r - (lut[0][i] & 0xFF)) + (g - (lut[1][i] & 0xFF)) * (g - (lut[1][i] & 0xFF)) + (b - (lut[2][i] & 0xFF)) * (b - (lut[2][i] & 0xFF));
            if (dist == 0) {
                bestIndex = i;
                break;
            }
            if (dist >= bestDist) continue;
            bestIndex = i;
            bestDist = dist;
        }
        rgbToLUT.put(rgb, new Integer(bestIndex));
        return bestIndex;
    }

    private static int findNearestRGBIndex(int r, int g, int b, byte[][] lut) {
        int bestDist = 196608;
        int bestIndex = 0;
        for (int i = 0; i < lut[0].length; ++i) {
            int dist = (r - (lut[0][i] & 0xFF)) * (r - (lut[0][i] & 0xFF)) + (g - (lut[1][i] & 0xFF)) * (g - (lut[1][i] & 0xFF)) + (b - (lut[2][i] & 0xFF)) * (b - (lut[2][i] & 0xFF));
            if (dist == 0) {
                return i;
            }
            if (dist >= bestDist) continue;
            bestIndex = i;
            bestDist = dist;
        }
        return bestIndex;
    }

    private static int numColorsToBits(int value) {
        int result = 0;
        --value;
        while (value > 0) {
            value = (value & Integer.MAX_VALUE) >> 1;
            ++result;
        }
        return result;
    }

    static class Cube {
        int rmin;
        int rmax;
        int gmin;
        int gmax;
        int bmin;
        int bmax;
        int generation = 0;
        int population = 0;

        boolean inCube(Color color, int shift) {
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            return (red >>= shift) >= this.rmin && red <= this.rmax && (green >>= shift) >= this.gmin && green <= this.gmax && (blue >>= shift) >= this.bmin && blue <= this.bmax;
        }

        boolean inCube(int red, int green, int blue) {
            return red >= this.rmin && red <= this.rmax && green >= this.gmin && green <= this.gmax && blue >= this.bmin && blue <= this.bmax;
        }

        Cube(int rn, int gn, int bn, int rm, int gm, int bm, int[][][] hist) {
            this.rmin = rn;
            this.rmax = rm;
            this.gmin = gn;
            this.gmax = gm;
            this.bmin = bn;
            this.bmax = bm;
            this.shrink(hist);
        }

        int color(int[][][] hist) {
            int factor = 256 / hist.length;
            long rsum = 0L;
            long gsum = 0L;
            long bsum = 0L;
            long sum = 0L;
            for (int r = this.rmin; r <= this.rmax; ++r) {
                for (int g = this.gmin; g <= this.gmax; ++g) {
                    for (int b = this.bmin; b <= this.bmax; ++b) {
                        if (hist[r][g][b] == 0) continue;
                        rsum += (long)(r * hist[r][g][b]);
                        gsum += (long)(g * hist[r][g][b]);
                        bsum += (long)(b * hist[r][g][b]);
                        sum += (long)hist[r][g][b];
                    }
                }
            }
            int red = (int)(rsum * (long)factor / sum);
            int green = (int)(gsum * (long)factor / sum);
            int blue = (int)(bsum * (long)factor / sum);
            int max = (hist.length - 1) * factor;
            if (red == max) {
                red = 255;
            }
            if (green == max) {
                green = 255;
            }
            if (blue == max) {
                blue = 255;
            }
            return red << 16 | green << 8 | blue;
        }

        void shrink(int[][][] hist) {
            int newRmin = this.rmax;
            int newRmax = this.rmin;
            int newGmin = this.gmax;
            int newGmax = this.gmin;
            int newBmin = this.bmax;
            int newBmax = this.bmin;
            for (int r = this.rmin; r <= this.rmax; ++r) {
                for (int g = this.gmin; g <= this.gmax; ++g) {
                    for (int b = this.bmin; b <= this.bmax; ++b) {
                        if (hist[r][g][b] == 0) continue;
                        if (r < newRmin) {
                            newRmin = r;
                        }
                        if (g < newGmin) {
                            newGmin = g;
                        }
                        if (b < newBmin) {
                            newBmin = b;
                        }
                        if (r > newRmax) {
                            newRmax = r;
                        }
                        if (g > newGmax) {
                            newGmax = g;
                        }
                        if (b > newBmax) {
                            newBmax = b;
                        }
                        this.population += hist[r][g][b];
                    }
                }
            }
            this.rmin = newRmin;
            this.rmax = newRmax;
            this.gmin = newGmin;
            this.gmax = newGmax;
            this.bmin = newBmin;
            this.bmax = newBmax;
        }

        boolean canSplit() {
            if (this.rmax - this.rmin == 0 && this.gmax - this.gmin == 0 && this.bmax - this.bmin == 0) {
                return false;
            }
            return this.population >= 2;
        }

        int findSplit() {
            int rLen = this.rmax - this.rmin;
            int gLen = this.gmax - this.gmin;
            int bLen = this.bmax - this.bmin;
            if (!this.canSplit()) {
                return 0;
            }
            if (gLen >= rLen && gLen >= bLen) {
                return 2;
            }
            if (rLen >= bLen) {
                return 1;
            }
            return 3;
        }

        Cube splitRed(int[][][] hist) {
            int split;
            if (this.rmax - this.rmin == 1) {
                split = this.rmax;
            } else {
                int pop = 0;
                int half = this.population / 2;
                for (split = this.rmin; split < this.rmax && pop < half; ++split) {
                    for (int g = this.gmin; g <= this.gmax && pop < half; ++g) {
                        for (int b = this.bmin; b <= this.bmax && pop < half; pop += hist[split][g][b], ++b) {
                        }
                    }
                }
            }
            if (split == this.rmin) {
                ++split;
            }
            Cube cube = new Cube(split, this.gmin, this.bmin, this.rmax, this.gmax, this.bmax, hist);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.rmax = split - 1;
            this.shrink(hist);
            return cube;
        }

        Cube splitGreen(int[][][] hist) {
            int split;
            if (this.gmax - this.gmin == 1) {
                split = this.gmax;
            } else {
                int pop = 0;
                int half = this.population / 2;
                for (split = this.gmin; split < this.gmax && pop < half; ++split) {
                    for (int r = this.rmin; r <= this.rmax && pop < half; ++r) {
                        for (int b = this.bmin; b <= this.bmax && pop < half; pop += hist[r][split][b], ++b) {
                        }
                    }
                }
            }
            if (split == this.gmin) {
                ++split;
            }
            Cube cube = new Cube(this.rmin, split, this.bmin, this.rmax, this.gmax, this.bmax, hist);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.gmax = split - 1;
            this.shrink(hist);
            return cube;
        }

        Cube splitBlue(int[][][] hist) {
            int split;
            if (this.bmax - this.bmin == 1) {
                split = this.bmax;
            } else {
                int pop = 0;
                int half = this.population / 2;
                for (split = this.bmin; split < this.bmax && pop < half; ++split) {
                    for (int r = this.rmin; r <= this.rmax && pop < half; ++r) {
                        for (int g = this.gmin; g <= this.gmax && pop < half; pop += hist[r][g][split], ++g) {
                        }
                    }
                }
            }
            if (split == this.bmin) {
                ++split;
            }
            Cube cube = new Cube(this.rmin, this.gmin, split, this.rmax, this.gmax, this.bmax, hist);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.bmax = split - 1;
            this.shrink(hist);
            return cube;
        }

        public String toString() {
            String s = "(" + this.rmin + ", " + this.gmin + ", " + this.bmin + ") (" + this.rmax + ", " + this.gmax + ", " + this.bmax + "); gen = " + this.generation + "; pop = " + this.population;
            return s;
        }
    }
}

