/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.Util;

public class HttpGetThread
extends Thread {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String serviceUrl = null;
    String response = null;
    private boolean completed = false;
    private Exception exception = null;

    public HttpGetThread(String url) {
        this.serviceUrl = url;
    }

    @Override
    public void run() {
        this.completed = false;
        this.exception = null;
        if (this.serviceUrl == null) {
            this.response = null;
            this.exception = new Exception("Service URL is null.");
            return;
        }
        try {
            this.response = Util.issueHttpGetRequest(this.serviceUrl);
        }
        catch (Exception e) {
            this.exception = e;
            this.response = null;
            return;
        }
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void checkTimeout(long timeout) {
        try {
            this.join(timeout);
        }
        catch (InterruptedException ie) {
            return;
        }
    }

    public String getResponse() {
        return this.response;
    }

    public Exception getException() {
        return this.exception;
    }
}

