/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import oracle.mapviewer.share.util.LogFactory;

public class HttpConnection {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private HttpURLConnection mHttp = null;
    private String sURL = null;
    private URL mURL = null;
    private String contentType = "application/xml";
    private boolean acceptGZIPencoding = false;
    private String cookie = null;

    public URL getURL() {
        return this.mURL;
    }

    public boolean connect(String url) {
        if (url == null) {
            return false;
        }
        this.sURL = url;
        try {
            this.mURL = new URL(url);
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.mHttp = (HttpURLConnection)this.mURL.openConnection();
            this.mHttp.setDoOutput(true);
            this.mHttp.setDoInput(true);
            this.mHttp.setUseCaches(false);
            this.mHttp.setRequestMethod("POST");
            this.mHttp.setRequestProperty("Content-Type", this.contentType);
            if (this.acceptGZIPencoding) {
                this.mHttp.setRequestProperty("Accept-Encoding", "gzip");
            }
            if (this.cookie != null) {
                this.mHttp.setRequestProperty("Cookie", this.cookie);
            }
        }
        catch (IOException e) {
            this.mHttp = null;
            return false;
        }
        return true;
    }

    public void setRequestProperty(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.contentType = value;
        } else if ("Cookie".equalsIgnoreCase(name)) {
            this.cookie = value;
        }
        if (this.mHttp != null) {
            this.mHttp.setRequestProperty(name, value);
        }
    }

    public void setContentTypeProperty(String property) {
        if (property == null) {
            return;
        }
        this.contentType = property;
        if (this.mHttp != null) {
            this.mHttp.setRequestProperty("Content-Type", property);
        }
    }

    public void disConnect() {
        try {
            if (this.mHttp != null) {
                this.mHttp.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendXMLRequest(String reqParameter, String reqValue) throws Exception {
        if (this.sURL == null) {
            throw new Exception("Null url.");
        }
        this.connect(this.sURL);
        if (this.mHttp == null) {
            throw new Exception("mHttp is null.");
        }
        OutputStream os = this.mHttp.getOutputStream();
        if (reqParameter != null && reqParameter.trim().length() > 0) {
            os.write((reqParameter.trim() + "=").getBytes());
        }
        os.write(reqValue.getBytes("UTF8"));
        os.flush();
        os.close();
        os = null;
    }

    public String getXMLResponse() throws Exception {
        InputStream is = this.mHttp.getInputStream();
        int c = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        while ((c = is.read()) != -1) {
            baos.write(c);
        }
        is.close();
        baos.close();
        String res = new String(baos.toByteArray(), "UTF-8");
        return res;
    }

    public String getGZIPXMLResponse() throws Exception {
        int chunk = 8192;
        InputStream is = this.mHttp.getInputStream();
        GZIPInputStream gis = new GZIPInputStream(is);
        BufferedInputStream bis = new BufferedInputStream(gis);
        try {
            String res;
            int len = 0;
            byte[] buffer = new byte[chunk];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            while ((len = gis.read(buffer, 0, chunk)) != -1) {
                baos.write(buffer, 0, len);
            }
            bis.close();
            baos.close();
            String string = res = new String(baos.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (gis != null) {
                gis.close();
            }
        }
    }

    public void setAcceptGZIPencoding(boolean accept) {
        this.acceptGZIPencoding = accept;
    }

    public boolean getAcceptGZIPencoding() {
        return this.acceptGZIPencoding;
    }

    public void clearCookieParameters() {
        this.cookie = null;
    }
}

