/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import oracle.sdovis.util.DoubleGeneralPath;

class DoubleGeneralPathIterator
implements PathIterator {
    int typeIdx = 0;
    int pointIdx = 0;
    DoubleGeneralPath path;
    AffineTransform affine;
    private static final int[] curvesize = new int[]{2, 2, 4, 6, 0};

    DoubleGeneralPathIterator(DoubleGeneralPath path) {
        this(path, null);
    }

    DoubleGeneralPathIterator(DoubleGeneralPath path, AffineTransform at) {
        this.path = path;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.typeIdx >= this.path.numTypes;
    }

    @Override
    public void next() {
        byte type = this.path.pointTypes[this.typeIdx++];
        this.pointIdx += curvesize[type];
    }

    @Override
    public int currentSegment(float[] coords) {
        byte type = this.path.pointTypes[this.typeIdx];
        int numCoords = curvesize[type];
        if (numCoords > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, coords, 0, numCoords / 2);
        } else {
            for (int i = 0; i < numCoords; ++i) {
                coords[i * 2] = (float)this.path.pointCoords[this.pointIdx + i * 2];
                coords[i * 2 + 1] = (float)this.path.pointCoords[this.pointIdx + i * 2 + 1];
            }
        }
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        byte type = this.path.pointTypes[this.typeIdx];
        int numCoords = curvesize[type];
        if (numCoords > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, coords, 0, numCoords / 2);
        } else {
            for (int i = 0; i < numCoords; ++i) {
                coords[i] = this.path.pointCoords[this.pointIdx + i];
            }
        }
        return type;
    }
}

