/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

public class CoordList {
    int idx = -1;
    double[] buf = null;

    public CoordList() {
        this.buf = new double[256];
    }

    public CoordList(int initSize) {
        if (initSize < 0) {
            throw new IllegalArgumentException("Invalid initSize.");
        }
        this.buf = new double[initSize];
    }

    public void clear() {
        this.idx = -1;
    }

    public int size() {
        return this.buf == null ? 0 : this.idx + 1;
    }

    public void add(double v) {
        ++this.idx;
        if (this.idx >= this.buf.length) {
            double[] tmp = new double[this.buf.length + 256];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
        this.buf[this.idx] = v;
    }

    public double get(int i) {
        return this.buf[i];
    }

    public void trim() {
        if (this.buf.length > this.size()) {
            double[] tmp = new double[this.size()];
            System.arraycopy(this.buf, 0, tmp, 0, this.size());
            this.buf = tmp;
        }
    }

    public double[] getCoords() {
        return this.buf;
    }
}

