/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.sdovis.util.CRC32;

class ChunkStream
extends DataOutputStream
implements DataOutput {
    private byte[] type = null;
    private ByteArrayOutputStream baos = null;

    public ChunkStream(String type) throws IOException {
        super(new ByteArrayOutputStream());
        if (type.length() != 4) {
            throw new IllegalArgumentException("Chunk type improper length");
        }
        for (int i = 0; i < 4; ++i) {
            if ((byte)type.charAt(i) >= 65 && (byte)type.charAt(i) <= 122) continue;
            throw new IllegalArgumentException("Chunk type contains non-letter");
        }
        if ((byte)type.charAt(2) < 65 || (byte)type.charAt(2) > 90) {
            throw new IllegalArgumentException("Chunk type contains illegal reserved value");
        }
        this.baos = (ByteArrayOutputStream)this.out;
        this.type = new byte[4];
        this.type[0] = (byte)type.charAt(0);
        this.type[1] = (byte)type.charAt(1);
        this.type[2] = (byte)type.charAt(2);
        this.type[3] = (byte)type.charAt(3);
    }

    public void writeToStream(DataOutputStream output) throws IOException {
        this.flush();
        this.baos.flush();
        byte[] data = this.baos.toByteArray();
        int len = data.length;
        output.writeInt(len);
        output.write(this.type);
        output.write(data, 0, len);
        int crc = -1;
        crc = CRC32.updateCRC(crc, this.type, 0, 4);
        crc = CRC32.updateCRC(crc, data, 0, len);
        output.writeInt(~crc);
    }
}

