/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.Util;

public class WMSMapThemeDefinition
extends ThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String serverUrlPrefix;
    String wmtVersion;
    String srs;
    String format;
    String bgColor;
    String exceptions;
    boolean transparent;
    String[] layers;
    String[] styles;
    String[][] vsps;
    String capabilitiesUrlPrefix = null;
    String userName = null;
    String password = null;

    public WMSMapThemeDefinition() {
        this.wmtVersion = "1.1.1";
        this.format = "image/png";
        this.transparent = false;
        this.bgColor = "0xffffff";
        this.exceptions = "application/vnd.ogc.se_xml";
    }

    public WMSMapThemeDefinition(String name, String urlPrefix, String wmtVer, String[] layers_, String[] styles_, String srs_, String format_, boolean transparent_, String bgColor_, String exceptions_, String[][] vsps_) {
        int i;
        this.serverUrlPrefix = urlPrefix.endsWith("?") ? urlPrefix.substring(0, urlPrefix.length() - 1) : urlPrefix;
        this.setName(name);
        this.wmtVersion = wmtVer;
        this.transparent = transparent_;
        this.setSrs(srs_);
        this.bgColor = bgColor_;
        this.format = format_ == null ? "image/png" : format_.toLowerCase();
        if (layers_ != null) {
            this.layers = new String[layers_.length];
            for (i = 0; i < layers_.length; ++i) {
                this.layers[i] = new String(layers_[i]);
            }
        } else {
            this.layers = null;
        }
        if (styles_ != null) {
            this.styles = new String[styles_.length];
            for (i = 0; i < styles_.length; ++i) {
                this.styles[i] = new String(styles_[i]);
            }
        } else {
            this.styles = null;
        }
        this.setExceptions(exceptions_);
        if (vsps_ != null && vsps_.length == 2) {
            this.vsps = vsps_;
        } else {
            this.vsps = null;
            log.finer("No VSPs");
        }
    }

    public void setAuthentication(String user, String pwd) {
        this.userName = user;
        this.password = pwd;
    }

    public boolean hasAuthentication() {
        return this.userName != null && this.password != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public void setServerUrlPrefix(String serverUrlPrefix) {
        this.serverUrlPrefix = serverUrlPrefix;
    }

    public String getServerUrlPrefix() {
        return this.serverUrlPrefix;
    }

    public void setWmtVersion(String wmtVersion) {
        this.wmtVersion = wmtVersion;
        this.validateExceptions();
    }

    public String getWmtVersion() {
        return this.wmtVersion;
    }

    public void setSrs(String srsname) {
        int index;
        if (this.srs != null && srsname != null && this.srs.equalsIgnoreCase(srsname)) {
            return;
        }
        this.srs = srsname;
        if (srsname != null && (srsname.indexOf("epsg.xml") > -1 || srsname.indexOf("#") > -1) && (index = srsname.indexOf("#")) > -1) {
            this.srs = "EPSG:" + srsname.substring(index + 1, srsname.length());
        }
        String sridS = "";
        if (this.srs != null) {
            sridS = this.srs;
            int index2 = this.srs.indexOf(":");
            if (index2 > -1) {
                sridS = this.srs.substring(index2 + 1, this.srs.length());
            }
            int srsid = 0;
            try {
                srsid = Integer.parseInt(sridS);
            }
            catch (Exception ex) {
                return;
            }
            if (this.srs.toUpperCase().indexOf("CRS:") > -1) {
                if (srsid == 84) {
                    this.srid = 8307;
                } else if (srsid == 83) {
                    this.srid = 8265;
                } else if (srsid == 27) {
                    this.srid = 8260;
                } else {
                    log.warning("There is no associate SDO SRID for CRS " + srsid);
                    this.srid = 0;
                }
            } else if (this.srs.toUpperCase().indexOf("EPSG:") == -1) {
                this.srid = srsid;
            } else {
                int sdosrid = 0;
                String sridmap = EPSG2SDO.EPSGtoSDO(String.valueOf(srsid));
                if (sridmap != null) {
                    sdosrid = Integer.parseInt(sridmap);
                } else if (this.dataSource != null) {
                    sdosrid = Util.EPSGsrid_To_Oraclesrid(this.dataSource, srsid);
                }
                if (sdosrid > 0) {
                    this.srid = sdosrid;
                    log.info("Theme SRID set to " + this.srid + " for EPSG " + srsid);
                } else if (Util.existsOracleSRID(this.dataSource, srsid)) {
                    this.srid = srsid;
                    log.info("Theme SRID set to " + this.srid);
                } else {
                    log.warning("Unable to find an equivalent SDO SRID for EPSG " + srsid);
                    this.srid = 0;
                }
            }
        }
    }

    public String getSrs() {
        return this.srs;
    }

    public String getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String theException) {
        this.exceptions = theException;
        this.validateExceptions();
    }

    private void validateExceptions() {
        this.exceptions = this.exceptions != null ? (this.wmtVersion != null && this.wmtVersion.equals("1.3.0") ? (this.exceptions.equalsIgnoreCase("XML") || this.exceptions.equalsIgnoreCase("INIMAGE") || this.exceptions.equalsIgnoreCase("BLANK") ? this.exceptions.toUpperCase() : "XML") : (this.exceptions.equalsIgnoreCase("application/vnd.ogc.se_xml") || this.exceptions.equalsIgnoreCase("application/vnd.ogc.se_inimage") || this.exceptions.equalsIgnoreCase("application/vnd.ogc.se_blank") ? this.exceptions.toLowerCase() : "application/vnd.ogc.se_xml")) : (this.wmtVersion != null && this.wmtVersion.equals("1.3.0") ? "XML" : "application/vnd.ogc.se_xml");
    }

    public void setFormat(String format_) {
        this.format = format_ == null ? "image/png" : format_.toLowerCase();
    }

    public String getFormat() {
        return this.format;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String theColor) {
        this.bgColor = theColor;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setLayers(String[] layers_) {
        if (layers_ != null) {
            this.layers = new String[layers_.length];
            for (int i = 0; i < layers_.length; ++i) {
                this.layers[i] = new String(layers_[i]);
            }
        } else {
            this.layers = null;
        }
    }

    public String[] getLayers() {
        return this.layers;
    }

    public void setStyles(String[] theStyles) {
        if (theStyles != null) {
            this.styles = new String[theStyles.length];
            for (int i = 0; i < theStyles.length; ++i) {
                this.styles[i] = new String(theStyles[i]);
            }
        } else {
            this.styles = null;
        }
    }

    public String[] getStyles() {
        return this.styles;
    }

    public void setVsps(String[][] vsps_) {
        if (vsps_ != null) {
            this.vsps = new String[2][vsps_[0].length];
            for (int i = 0; i < vsps_.length; ++i) {
                for (int j = 0; j < vsps_[i].length; ++j) {
                    this.vsps[i][j] = new String(vsps_[i][j]);
                }
            }
        } else {
            this.vsps = null;
        }
    }

    public String[][] getVsps() {
        return this.vsps;
    }

    @Override
    public String getThemeType() {
        return "WMS";
    }

    @Override
    public String getXMLDefinition() {
        return "";
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.serverUrlPrefix);
        ti.setType("WMS");
        ti.setKeyColumn(null);
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(null);
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    public void setCapabilitiesUrlPrefix(String capUrlPrefix) {
        this.capabilitiesUrlPrefix = capUrlPrefix;
    }

    public String getCapabilitiesUrlPrefix() {
        return this.capabilitiesUrlPrefix;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        return null;
    }

    @Override
    public Field[] getDistinctAttrColumns() {
        return null;
    }
}

