/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.Bidi;
import java.util.ArrayList;
import oracle.sdovis.SRS;
import oracle.sdovis.Spheroid;

public class SVGUtil {
    private static final double HalfPI = 1.5707963267948966;
    private static FontRenderContext frc = new FontRenderContext(null, true, true);

    public static String getDoubleString(double d) {
        return SVGUtil.getDoubleString(d, 1);
    }

    public static String getDoubleString(double d, int precision) {
        if (precision < 1 || d == (double)((int)d)) {
            return Integer.toString((int)d);
        }
        String dstr = Double.toString(d);
        int didx = dstr.indexOf(46);
        if (didx < 0 || dstr.indexOf(69) > 0) {
            return dstr;
        }
        if (Math.abs(d) > 1.0) {
            ++didx;
        } else {
            ++didx;
            while (didx < dstr.length() && dstr.charAt(didx) == '0') {
                ++didx;
            }
        }
        int endIdx = Math.min(didx + precision, dstr.length()) - 1;
        while (dstr.charAt(endIdx) == '0') {
            --endIdx;
        }
        if (dstr.charAt(endIdx) == '.') {
            --endIdx;
        }
        return dstr.substring(0, endIdx + 1);
    }

    public static ArrayList getIntersectionPoints(double minX, double minY, double maxX, double maxY, double llx, double lly, double lx, double ly) {
        return SVGUtil.getIntersectionPoints(minX, minY, maxX, maxY, llx, lly, lx, ly, true);
    }

    public static ArrayList getIntersectionPoints(double minX, double minY, double maxX, double maxY, double llx, double lly, double lx, double ly, boolean forLineString) {
        if (llx == lx && lly == ly) {
            return null;
        }
        if (llx >= minX && llx <= maxX && lly >= minY && lly <= maxY && lx >= minX && lx <= maxX && ly >= minY && ly <= maxY) {
            return null;
        }
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(2);
        if (llx == lx) {
            if (lx < minX || lx > maxX || ly > maxY && lly > maxY || ly < minY && lly < minY) {
                return null;
            }
            if (ly > maxY) {
                if (lly < minY) {
                    points.add(new Point2D.Double(lx, minY));
                    points.add(new Point2D.Double(lx, maxY));
                } else {
                    points.add(new Point2D.Double(lx, maxY));
                }
            } else if (ly < minY) {
                if (lly > maxY) {
                    points.add(new Point2D.Double(lx, maxY));
                    points.add(new Point2D.Double(lx, minY));
                } else {
                    points.add(new Point2D.Double(lx, minY));
                }
            } else if (lly < minY) {
                points.add(new Point2D.Double(lx, minY));
            } else if (lly > maxY) {
                points.add(new Point2D.Double(lx, maxY));
            }
        } else if (lly == ly) {
            if (ly < minY || ly > maxY || lx > maxX && llx > maxX || lx < minX && llx < minX) {
                return null;
            }
            if (lx > maxX) {
                if (llx < minX) {
                    points.add(new Point2D.Double(minX, ly));
                    points.add(new Point2D.Double(maxX, ly));
                } else {
                    points.add(new Point2D.Double(maxX, ly));
                }
            } else if (lx < minX) {
                if (llx > maxX) {
                    points.add(new Point2D.Double(maxX, ly));
                    points.add(new Point2D.Double(minX, ly));
                } else {
                    points.add(new Point2D.Double(minX, ly));
                }
            } else if (llx < minX) {
                points.add(new Point2D.Double(minX, ly));
            } else if (llx > maxX) {
                points.add(new Point2D.Double(maxX, ly));
            }
        } else {
            double tmpY2;
            double k = (lly - ly) * 1.0 / (llx - lx);
            double b = (ly * llx - lly * lx) * 1.0 / (llx - lx);
            double tmpY1 = k * maxX + b;
            Point2D.Double point1 = null;
            Point2D.Double point2 = null;
            Point2D.Double point = null;
            if (tmpY1 <= maxY && tmpY1 >= minY && (tmpY1 >= lly && tmpY1 <= ly || tmpY1 <= lly && tmpY1 >= ly)) {
                point = new Point2D.Double(maxX, tmpY1);
                if (llx > maxX) {
                    point1 = point;
                } else {
                    point2 = point;
                }
            }
            if ((tmpY2 = k * minX + b) <= maxY && tmpY2 >= minY && (tmpY2 >= lly && tmpY2 <= ly || tmpY2 <= lly && tmpY2 >= ly)) {
                point = new Point2D.Double(minX, tmpY2);
                if (llx < minX) {
                    point1 = point;
                } else {
                    point2 = point;
                }
            }
            if (point1 == null || point2 == null) {
                double tmpX2;
                double tmpX1 = (maxY - b) / k;
                if (tmpX1 <= maxX && tmpX1 >= minX && (tmpX1 >= llx && tmpX1 <= lx || tmpX1 <= llx && tmpX1 >= lx)) {
                    if (lly > maxY) {
                        if (point1 == null) {
                            point1 = new Point2D.Double(tmpX1, maxY);
                        }
                    } else if (point2 == null) {
                        point2 = new Point2D.Double(tmpX1, maxY);
                    }
                }
                if ((tmpX2 = (minY - b) / k) <= maxX && tmpX2 >= minX && (tmpX2 >= llx && tmpX2 <= lx || tmpX2 <= llx && tmpX2 >= lx)) {
                    if (lly < minY) {
                        if (point1 == null) {
                            point1 = new Point2D.Double(tmpX2, minY);
                        }
                    } else if (point2 == null) {
                        point2 = new Point2D.Double(tmpX2, minY);
                    }
                }
            }
            if (point1 != null) {
                points.add(point1);
            }
            if (point2 != null) {
                points.add(point2);
            }
            if (points.size() == 0 && !forLineString) {
                if (llx > maxX && lx > maxX || llx < minX && lx < minX || lly > maxY && ly > maxY || lly < minY && ly < minY) {
                    return points;
                }
                if (tmpY1 < minY && tmpY2 < minY) {
                    if (llx < minX && lly > minY || lx < minX && ly > minY) {
                        points.add(new Point2D.Double(0.0, 0.0));
                    } else if (llx > maxX && lly > minY || lx > maxX && ly > minY) {
                        points.add(new Point2D.Double(maxX, 0.0));
                    }
                } else if (tmpY1 > maxY && tmpY2 > maxY) {
                    if (llx < minX && lly < maxY || lx < minX && ly < maxY) {
                        points.add(new Point2D.Double(0.0, maxY));
                    } else if (llx > maxX && lly < maxY || lx > maxX && ly < maxY) {
                        points.add(new Point2D.Double(maxX, maxY));
                    }
                }
            }
        }
        return points;
    }

    public static final String getJSDistFunction(SRS srs) {
        String unit = srs.getUnit();
        boolean geodetic = srs.isGeodetic();
        Spheroid spheroid = srs.getSpheroid();
        Double df_ = SRS.getDistanceConversionFactor(unit);
        if (df_ == null && !geodetic) {
            return SVGUtil.getNonGeodeticJSDistFunction(null);
        }
        double inMeter = -1.0;
        if (geodetic) {
            if (spheroid == null) {
                return SVGUtil.getNonGeodeticJSDistFunction(null);
            }
            return SVGUtil.getGeodeticJSDistFunction(spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - spheroid.getEccentricity2()), spheroid.getFlattening());
        }
        return SVGUtil.getNonGeodeticJSDistFunction(df_);
    }

    private static String getNonGeodeticJSDistFunction(Double df_) {
        StringBuffer sb = new StringBuffer(100);
        if (df_ == null) {
            sb.append("    var useunit=0;\n");
        } else {
            sb.append("    var useunit=1;\n");
        }
        sb.append("    function getDistance(x1, y1, x2, y2)\n");
        sb.append("    {\n");
        sb.append("      var x=x2-x1;y=y2-y1;\n");
        sb.append("      var dist=Math.sqrt(x*x+y*y);\n");
        if (df_ == null) {
            sb.append("      return dist;\n");
        } else {
            sb.append("      return dist*" + df_ + ";\n");
        }
        sb.append("    }\n");
        return sb.toString();
    }

    private static final String getGeodeticJSDistFunction(double smax, double t, double flat) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("    var useunit=1;\n");
        sb.append("    function getDistance(x1, y1, x2, y2)\n");
        sb.append("    {\n");
        sb.append("      var DEG2RAD=0.017453292519943295,HalfPI=1.5707963267948966;\n");
        sb.append("      x1=x1*DEG2RAD;x2=x2*DEG2RAD;y1=y1*DEG2RAD;y2=y2*DEG2RAD;\n");
        sb.append("      var lamm,phim,dphim,cl,d,ce,cyp,ctp,cx,cy;\n");
        sb.append("      var ct,cd,ca,phi1,phi2;\n");
        sb.append("      var sphim,cphim,sdphim,cdphim,slamm,sd;\n");
        sb.append("      if(HalfPI-Math.abs(y1)<1.e-10)\n");
        sb.append("        phi1=y1;\n");
        sb.append("      else\n");
        sb.append("        phi1=Math.atan(" + t + "*Math.tan(y1));\n");
        sb.append("      if(HalfPI-Math.abs(y2)<1.e-10)\n");
        sb.append("        phi2=y2;\n");
        sb.append("      else\n");
        sb.append("        phi2=Math.atan(" + t + "*Math.tan(y2));\n");
        sb.append("      phim=(phi1+phi2)/2.;\n");
        sb.append("      dphim=(phi1-phi2)/2.;\n");
        sb.append("      lamm=Math.abs(x1 - x2);\n");
        sb.append("      if(lamm>Math.PI)\n");
        sb.append("        lamm=2.*Math.PI-lamm;\n");
        sb.append("      lamm/=2.;\n");
        sb.append("      if(lamm<5.e-8&&Math.abs(dphim)<5.e-8)\n");
        sb.append("        return 0.;\n");
        sb.append("      else if((HalfPI-lamm<5.e-8&&Math.abs(phim)<5.e-8)||");
        sb.append("HalfPI-Math.abs(dphim)<5.e-8)\n");
        sb.append("        return -1.;\n");
        sb.append("      sphim=Math.sin(phim);\n");
        sb.append("      cphim=Math.cos(phim);\n");
        sb.append("      sdphim=Math.sin(dphim);\n");
        sb.append("      cdphim=Math.cos(dphim);\n");
        sb.append("      slamm=Math.sin(lamm);\n");
        sb.append("      cl=sdphim*sdphim+slamm*slamm*(cdphim*cdphim-sphim*sphim);\n");
        sb.append("      d=Math.acos(1.-2.*cl);\n");
        sb.append("      sd=Math.sin(d);\n");
        sb.append("      ce=2.*(1.-2.*cl);\n");
        sb.append("      cyp=2.*sphim*sphim*cdphim*cdphim/(1.-cl);\n");
        sb.append("      ctp=2.*sdphim*sdphim*cphim*cphim/cl;\n");
        sb.append("      cx=cyp+ctp;\n");
        sb.append("      cy=cyp-ctp;\n");
        sb.append("      ct=d/sd;\n");
        sb.append("      cd=4.*ct*ct;\n");
        sb.append("      ca=cd*ce;\n");
        sb.append("      return " + smax + "*sd*(ct-" + flat + "*(ct*cx-cy)/4.+" + flat + "*" + flat + "*");
        sb.append("(cx*(ca+(ct-(ca-ce)/2.)*cx)-cy*(2.*cd+ce*cy)+cd*cx*cy)/64.);\n");
        sb.append("    }\n");
        return sb.toString();
    }

    public static String UTFEncode(String instr, boolean escapeQuote) {
        if (instr == null) {
            return instr;
        }
        StringBuffer sb = new StringBuffer(instr.length());
        for (int i = 0; i < instr.length(); ++i) {
            char ch = instr.charAt(i);
            if (!SVGUtil.isSafe(ch) || ch == '&' && !SVGUtil.andSignIsPartOfUTFCode(instr, i)) {
                sb.append("&#" + ch + ";");
                continue;
            }
            if (escapeQuote && ch == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(ch);
        }
        return new String(sb);
    }

    public static String UTFEncode(String instr) {
        if (instr == null) {
            return instr;
        }
        StringBuffer sb = new StringBuffer(instr.length());
        boolean beginquote = false;
        for (int i = 0; i < instr.length(); ++i) {
            char ch = instr.charAt(i);
            if (!SVGUtil.isSafe(ch) || ch == '&' && !SVGUtil.andSignIsPartOfUTFCode(instr, i)) {
                sb.append("&#" + ch + ";");
                continue;
            }
            sb.append(ch);
        }
        return new String(sb);
    }

    private static boolean andSignIsPartOfUTFCode(String instr, int i) {
        int j;
        if (instr.length() <= i + 3) {
            return false;
        }
        if (instr.charAt(i + 1) != '#') {
            return false;
        }
        for (j = i + 2; j < instr.length() && instr.charAt(j) <= '9' && instr.charAt(j) >= '0'; ++j) {
        }
        return j != i + 2 && j != instr.length() && instr.charAt(j) == ';';
    }

    private static boolean isSafe(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '&' || c == '-' || c == '_' || c == '.' || c == '*' || c == '#' || c == ' ' || c == '\t' || c == ';' || c == '$' || c == ',' || c == ']' || c == '[' || c == '\'';
    }

    public static int getStringLength(String s, Font font) {
        if (font == null) {
            return 0;
        }
        char[] chars = s.toCharArray();
        if (!Bidi.requiresBidi(chars, 0, chars.length)) {
            GlyphVector gV = font.createGlyphVector(frc, s);
            return gV != null ? (int)gV.getVisualBounds().getWidth() : 0;
        }
        TextLayout tl = new TextLayout(s, font, frc);
        return (int)tl.getBounds().getWidth();
    }
}

