/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class SVGImageTranscoder
extends ImageTranscoder {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    BufferedImage userImage;
    BufferedImage resultImage;

    public SVGImageTranscoder() {
    }

    public SVGImageTranscoder(BufferedImage buffer) {
        if (buffer != null) {
            this.userImage = buffer;
        }
    }

    public BufferedImage createImage(int width, int height) {
        if (this.userImage != null && this.userImage.getWidth() == width && this.userImage.getHeight() == height) {
            return this.userImage;
        }
        log.finest("creating a new buffered image for transcoding: width=" + width + ", height=" + height);
        BufferedImage tmp = new BufferedImage(width, height, 2);
        return tmp;
    }

    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        this.resultImage = img;
    }

    public BufferedImage getRenderedImage() {
        return this.resultImage;
    }
}

