/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class TextStroke
implements Stroke {
    static final String ERROR_INVALID_TEXT_ARGUMENT = "Error : bad text";
    static final FontRenderContext frc = new FontRenderContext(null, true, true);
    static final int FLATTENESS = 1;
    private Area glyphMBRs;
    private GlyphVector glyphVector;
    private float ascent;
    private int nGlyphs;
    private boolean cycle;
    private float cycleGap;
    private String text;
    private Font font;
    float[] seg = new float[6];
    SegmentControl ctl = new SegmentControl();
    Rectangle2D deviceView = null;
    private double startOffset;
    AffineTransform glyphTransform = new AffineTransform();
    AffineTransform at = new AffineTransform();

    public TextStroke(Font font, boolean cycle, float cycleGap, double startOffset) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.setFont(font);
        this.cycle = cycle;
        this.cycleGap = cycleGap;
        if (cycleGap < 0.0f) {
            this.cycleGap = font.getSize();
        }
        this.startOffset = startOffset;
    }

    public void setFont(Font f) {
        if (f == null) {
            throw new NullPointerException();
        }
        if (this.font == null || !this.font.equals(f)) {
            this.font = f;
            LineMetrics metrics = this.font.getLineMetrics("ljqLJQ", frc);
            this.ascent = metrics.getAscent();
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDeviceView(double x0, double y0, double x1, double y1) {
        this.deviceView = new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        return this.createStrokedShape(shape, 0, null, false);
    }

    public Shape createStrokedShape(Shape shp, int startSeg, RectArray mbrVecs, boolean forcedLabeling) {
        int segCount = 0;
        int segTotal = ShapeUtil.numLineSegments(shp, this.seg);
        if (this.text == null || this.text.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_INVALID_TEXT_ARGUMENT);
        }
        this.glyphVector = this.font.createGlyphVector(frc, this.text);
        this.glyphVector.performDefaultLayout();
        this.nGlyphs = this.glyphVector.getNumGlyphs();
        PathIterator pi = shp.getPathIterator(null);
        int segType = 0;
        this.ctl.reset();
        boolean stop = false;
        while (!pi.isDone()) {
            segType = pi.currentSegment(this.seg);
            switch (segType) {
                case 0: {
                    if (!this.ctl.fits) {
                        this.ctl.reset();
                    }
                    this.ctl.x = this.seg[0];
                    this.ctl.y = this.seg[1];
                    this.ctl.mx = this.ctl.x;
                    this.ctl.my = this.ctl.y;
                    this.ctl.start = true;
                    break;
                }
                case 1: {
                    this.ctl.dx = this.seg[0];
                    this.ctl.dy = this.seg[1];
                    this.ctl.start = false;
                    stop = this.processSegment(this.ctl, mbrVecs, ++segCount >= segTotal, forcedLabeling);
                    break;
                }
                case 4: {
                    this.ctl.dx = this.ctl.mx;
                    this.ctl.dy = this.ctl.my;
                    this.ctl.start = false;
                    stop = this.processSegment(this.ctl, mbrVecs, segCount >= segTotal, forcedLabeling);
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + segType);
                }
            }
            pi.next();
            if (this.ctl.abort) {
                return null;
            }
            if (!stop) continue;
        }
        if (mbrVecs != null) {
            mbrVecs.addAll(this.ctl.mbrs);
        }
        if (this.ctl.glyphIndex < this.nGlyphs - 1) {
            return null;
        }
        return this.ctl.s;
    }

    private boolean processSegment(SegmentControl ctl, RectArray mbrVecs, boolean lastSeg, boolean forcedLabeling) {
        boolean stop = false;
        float segLength = (float)Point2D.distance(ctl.x, ctl.y, ctl.dx, ctl.dy);
        float dx = (ctl.dx - ctl.x) / segLength;
        float dy = (ctl.dy - ctl.y) / segLength;
        if (ctl.firstTime) {
            ctl.startCredit = (float)((double)(-segLength) * this.startOffset);
            ctl.firstTime = false;
        }
        ctl.x -= dx * ctl.startCredit;
        ctl.y -= dy * ctl.startCredit;
        float insertDist = ctl.ngx - ctl.d;
        float x = ctl.x + insertDist * dx;
        float y = ctl.y + insertDist * dy;
        float rotationAngle = (float)Math.atan2(ctl.dy - ctl.y, ctl.dx - ctl.x);
        float shiftDistance = 0.0f;
        if (!ctl.start) {
            float deltaAngle = rotationAngle - ctl.previousAngle;
            if ((double)deltaAngle < -Math.PI) {
                deltaAngle += (float)Math.PI * 2;
            }
            if ((double)deltaAngle > Math.PI) {
                deltaAngle -= (float)Math.PI * 2;
            }
            if (deltaAngle < 0.0f) {
                shiftDistance = Math.abs(this.ascent * (float)Math.tan(deltaAngle / 2.0f));
                segLength -= shiftDistance;
                x += shiftDistance * dx;
                y += shiftDistance * dy;
            }
        }
        if (ctl.d + ctl.startCredit + segLength > ctl.ngx + (float)ctl.glyphWidth) {
            ctl.previousAngle = rotationAngle;
            this.at.setToIdentity();
            this.at.translate(x - ctl.ngx, y - ctl.ngy);
            this.at.rotate(rotationAngle, ctl.ngx, ctl.ngy);
            this.at.concatenate(ctl.defaultTransform);
            if (this.deviceView != null && !this.deviceView.contains(x, y)) {
                ctl.abort = true;
                stop = true;
                return stop;
            }
            float remainingSegLength = segLength + ctl.startCredit;
            ctl.fits = true;
            while (ctl.fits) {
                Point2D glyphPos = this.glyphVector.getGlyphPosition(ctl.glyphIndex);
                this.glyphTransform.setToIdentity();
                this.glyphTransform.concatenate(this.at);
                Shape outline = this.glyphVector.getGlyphOutline(ctl.glyphIndex);
                Rectangle2D r2d = outline.getBounds2D();
                Shape glyphShp = null;
                if (r2d.getMinX() < 1.0) {
                    this.glyphTransform.translate(glyphPos.getX(), glyphPos.getY());
                }
                glyphShp = this.glyphTransform.createTransformedShape(outline);
                r2d = glyphShp.getBounds2D();
                ctl.mbrs.addElement(r2d);
                if (mbrVecs != null && !forcedLabeling && mbrVecs.conflicts(r2d)) {
                    ctl.abort = true;
                    stop = true;
                    break;
                }
                ctl.s.append(glyphShp, false);
                float newD = (float)ctl.defaultTransform.getTranslateX() + (float)glyphPos.getX() + (float)ctl.glyphWidth;
                remainingSegLength -= newD - ctl.d;
                ctl.d = newD;
                ctl.x += (float)ctl.glyphWidth * dx;
                ctl.y += (float)ctl.glyphWidth * dy;
                ++ctl.glyphIndex;
                if (ctl.glyphIndex >= this.nGlyphs) {
                    if (!this.cycle) {
                        stop = true;
                        ctl.fits = false;
                    } else {
                        ctl.defaultTransform.translate((float)this.glyphVector.getVisualBounds().getWidth() + this.cycleGap, 0.0);
                        this.at.translate((float)this.glyphVector.getVisualBounds().getWidth() + this.cycleGap, 0.0);
                    }
                }
                if (stop) continue;
                ctl.glyphIndex %= this.nGlyphs;
                ctl.ngx = (float)ctl.defaultTransform.getTranslateX() + (float)this.glyphVector.getGlyphPosition(ctl.glyphIndex).getX();
                ctl.ngy = (float)this.glyphVector.getGlyphPosition(ctl.glyphIndex).getY();
                ctl.glyphWidth = this.glyphVector.getGlyphLogicalBounds((int)ctl.glyphIndex).getBounds().width;
                boolean bl = ctl.fits = ctl.d + remainingSegLength > ctl.ngx + (float)ctl.glyphWidth;
                if (ctl.fits || !lastSeg) continue;
                stop = true;
                ctl.abort = true;
                break;
            }
            ctl.x = ctl.dx;
            ctl.y = ctl.dy;
            ctl.startCredit = remainingSegLength;
        }
        return stop;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public float getCycleGap() {
        return this.cycleGap;
    }

    class SegmentControl {
        boolean abort = false;
        boolean fits = true;
        boolean done = false;
        float x;
        float y;
        float mx;
        float my;
        float dx;
        float dy;
        float startCredit;
        float d;
        float ngx;
        float ngy;
        int glyphWidth;
        int glyphIndex;
        boolean start;
        boolean firstTime = true;
        float previousAngle;
        Vector mbrs = new Vector(48);
        GeneralPath s = new GeneralPath();
        AffineTransform defaultTransform = new AffineTransform();

        public void reset() {
            this.done = false;
            this.firstTime = true;
            this.mbrs.removeAllElements();
            this.s.reset();
            this.defaultTransform.setToIdentity();
            this.abort = false;
            this.glyphIndex = 0;
            this.fits = true;
            this.ngx = 0.0f;
            this.ngy = 0.0f;
            this.glyphWidth = ((TextStroke)TextStroke.this).glyphVector.getGlyphOutline((int)0).getBounds().width;
            this.previousAngle = 0.0f;
            this.d = 0.0f;
            this.startCredit = 0.0f;
        }
    }
}

