/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Util;

public class AllStyleTable
extends StyleTable
implements StyleStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String mOwner = null;
    String mName = null;
    int mType = 0;
    String mDescription = null;
    StringBuffer mSVGData = null;
    byte[] mImageData = null;
    JSDOGeometry mGeometry = null;
    Hashtable stylesNotFound = null;
    private Clob mCLOBSVG;
    private Blob mBLOBImage;

    @Override
    public int getType() {
        return this.mType;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String getLogin() {
        return this.mUser;
    }

    @Override
    public StringBuffer getDefinition() {
        return this.mSVGData;
    }

    @Override
    public byte[] getImageData() {
        return this.mImageData;
    }

    @Override
    public JSDOGeometry getGeometry() {
        return this.mGeometry;
    }

    public AllStyleTable(String dataSrc, String tableName) throws SQLException {
        super(dataSrc, "ALL_SDO_STYLES");
    }

    @Override
    public Style getStyleObject(String name) throws DataException {
        if (name == null) {
            return null;
        }
        String owner = this.mUser;
        if (name.indexOf(58) > 0) {
            int idx = name.indexOf(58);
            owner = name.substring(0, idx);
            name = name.substring(idx + 1, name.length());
            return this.getStyleObject(name, owner, false);
        }
        return this.getStyleObject(name, owner, true);
    }

    public Style getStyleObject(String name, String owner, boolean checkCurrentSchema) throws DataException {
        if (name == null) {
            return null;
        }
        if (!this.shouldQueryTheStyle(name, owner)) {
            return null;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            String currentSchema = owner;
            if (checkCurrentSchema && (currentSchema = Util.getCurrentSchema(conn, null)) == null) {
                currentSchema = owner;
            }
            String sql = "select * from all_sdo_styles where name=? and owner=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, name.toUpperCase());
            ps.setString(2, currentSchema.toUpperCase());
            rs = ps.executeQuery();
            if (!rs.next()) {
                log.warning("Cannot find style named " + name + " of " + currentSchema + " in all_sdo_styles");
                if (this.stylesNotFound == null) {
                    this.stylesNotFound = new Hashtable();
                }
                this.recordMissingEntry(name, currentSchema);
                Style style = null;
                return style;
            }
            this.removeFromStylesNotFound(name, currentSchema);
            this.updateLocalData(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {}
        }
        String description = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(description);
        }
        return style;
    }

    @Override
    public TruetypeFont getTTFont(String name) throws DataException {
        if (name == null) {
            return null;
        }
        String owner = this.mUser;
        Object font = null;
        if (name.indexOf(58) > 0) {
            int idx = name.indexOf(58);
            owner = name.substring(0, idx);
            name = name.substring(idx + 1, name.length());
        }
        return this.getTTFont(name, owner);
    }

    @Override
    public TruetypeFont getTTFont(String name, String owner) throws DataException {
        if (name == null || owner == null) {
            return null;
        }
        if (!this.shouldQueryTheStyle(name, owner)) {
            return null;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            String sql = "select * from all_sdo_styles where name=? and type='TTF' and owner=?";
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            ps = conn.prepareStatement(sql);
            ps.setString(1, name.toUpperCase());
            ps.setString(2, owner.toUpperCase());
            rs = ps.executeQuery();
            if (!rs.next()) {
                log.warning("Cannot find TTF font named " + name + " of " + owner + " in " + this.mTableName);
                this.recordMissingEntry(name, owner);
                TruetypeFont truetypeFont = null;
                return truetypeFont;
            }
            this.removeFromStylesNotFound(name, owner);
            this.updateLocalData(rs);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {}
        }
        TruetypeFont ttf = new TruetypeFont();
        ttf.setName(this.mName);
        ttf.setDescription(this.mDescription);
        ttf.setFontData(this.mImageData);
        Font font = null;
        try {
            String tempDir;
            DataSourceI dsi;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, bais);
            ttf.setFont(font);
            if (this.mDataSource != null && (dsi = DSManager.get(this.mDataSource)) != null && (tempDir = dsi.getTemporaryDirectory()) != null) {
                String fname = this.mDataSource + "_" + owner + "_-_";
                String tfname = font.getFontName().replaceAll(" ", "-_-");
                fname = tempDir + fname.toLowerCase() + tfname + ".ttf";
                try {
                    File f = new File(fname);
                    if (!f.exists()) {
                        FileOutputStream fout = new FileOutputStream(fname);
                        fout.write(this.mImageData);
                        fout.close();
                        log.finest("TTF file [" + tfname + "] has been saved on temporary directory [" + tempDir + "]");
                    }
                }
                catch (Exception ex) {
                    log.warning("Unable to write temporary TTF file [" + fname + "]");
                    log.warning(ex.getMessage());
                }
            }
            return ttf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DataException(e.getCause());
        }
    }

    @Override
    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void updateLocalData(ResultSet rs) throws SQLException {
        this.mName = rs.getString("NAME");
        this.mOwner = rs.getString("OWNER");
        String typeName = rs.getString("TYPE");
        this.mType = StyleUtils.getTypeCodeFromName(typeName);
        this.mDescription = rs.getString("DESCRIPTION");
        this.mCLOBSVG = rs.getClob("DEFINITION");
        this.mBLOBImage = rs.getBlob("IMAGE");
        try {
            this.mSVGData = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mSVGData = null;
        }
        if (this.mBLOBImage == null) {
            this.mImageData = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mImageData = null;
                return;
            }
            this.mImageData = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mImageData = null;
        }
    }

    @Override
    protected void updateLocalData() throws SQLException {
        this.updateLocalData(this.mResultSet);
    }

    @Override
    public int update() throws SQLException {
        throw new SQLException("update not supported on ALL_SDO_STYLES");
    }

    @Override
    public int insert() throws SQLException {
        throw new SQLException("insert not supported on ALL_SDO_STYLES");
    }

    @Override
    public int delete() throws SQLException {
        throw new SQLException("delete not supported on ALL_SDO_STYLES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStyleNames(String type) {
        ArrayList<String> arrayList;
        ArrayList<String> res = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                ArrayList<String> arrayList2 = res;
                return arrayList2;
            }
            res = new ArrayList<String>();
            String owner = this.mUser;
            String q1 = "select name from all_sdo_styles where owner=? order by name";
            String q2 = "select name from all_sdo_styles where owner=? and type=? order by name";
            String query = type == null ? q1 : q2;
            stmt = conn.prepareStatement(query);
            stmt.setString(1, owner);
            if (type != null) {
                stmt.setString(2, type);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                res.add(rs.getString(1));
            }
            arrayList = res;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ArrayList<String> arrayList3 = res;
            return arrayList3;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStyleNamesAndTypes(String[] types) {
        ArrayList<String> i3;
        ArrayList<String> res = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String q1 = "select name, type from all_sdo_styles where owner=? ";
        if (types != null && types.length > 0) {
            q1 = q1 + "and (";
            for (int i2 = 0; i2 < types.length; ++i2) {
                q1 = i2 == 0 ? q1 + "type=?" : q1 + " or type=?";
            }
            q1 = q1 + ") ";
        }
        q1 = q1 + " order by name";
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                ArrayList<String> i2 = res;
                return i2;
            }
            res = new ArrayList<String>();
            String owner = this.mUser;
            String query = q1;
            stmt = conn.prepareStatement(query);
            stmt.setString(1, owner);
            if (types != null && types.length > 0) {
                for (int i3 = 0; i3 < types.length; ++i3) {
                    stmt.setString(2 + i3, types[i3]);
                }
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                res.add(rs.getString(1) + ":" + rs.getString(2));
            }
            i3 = res;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return i3;
    }

    @Override
    public StyleRowData getStyleData(String name) throws DataException {
        if (name == null) {
            return null;
        }
        String owner = this.mUser;
        if (name.indexOf(58) > 0) {
            int idx = name.indexOf(58);
            owner = name.substring(0, idx);
            name = name.substring(idx + 1, name.length());
            return this.getStyleData(name, owner, false);
        }
        return this.getStyleData(name, owner, true);
    }

    public StyleRowData getStyleData(String name, String owner, boolean checkCurrentSchema) throws DataException {
        StyleRowData styleRowData;
        if (name == null) {
            return null;
        }
        if (!this.shouldQueryTheStyle(name, owner)) {
            return null;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            String currentSchema = owner;
            if (checkCurrentSchema && (currentSchema = Util.getCurrentSchema(conn, null)) == null) {
                currentSchema = owner;
            }
            String sql = "select * from all_sdo_styles where name=? and owner=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, name.toUpperCase());
            ps.setString(2, currentSchema.toUpperCase());
            rs = ps.executeQuery();
            if (!rs.next()) {
                log.warning("Cannot find style named " + name + " of " + currentSchema + " in all_sdo_styles");
                this.recordMissingEntry(name, currentSchema);
                StyleRowData styleRowData2 = null;
                return styleRowData2;
            }
            this.removeFromStylesNotFound(name, currentSchema);
            this.updateLocalData(rs);
            StyleRowData row = new StyleRowData();
            row.name = this.mName;
            row.description = this.mDescription;
            row.definition = this.mSVGData.toString();
            row.geometry = this.mGeometry;
            row.image = this.mImageData;
            styleRowData = row;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {}
        }
        return styleRowData;
    }

    private String getKey(String styleName, String dbOwner) {
        return dbOwner == null ? styleName.toLowerCase() : dbOwner.toLowerCase() + "__" + styleName.toLowerCase();
    }

    private boolean shouldQueryTheStyle(String styleName, String dbOwner) {
        if (this.stylesNotFound == null) {
            return true;
        }
        long t = System.currentTimeMillis();
        String key = this.getKey(styleName, dbOwner);
        Object o = this.stylesNotFound.get(key);
        if (o == null) {
            return true;
        }
        MissingStyleEntry mse = (MissingStyleEntry)o;
        long t2 = mse.lastAttempt;
        if (t - t2 > 60000L) {
            return true;
        }
        mse.lastAttempt = t;
        return false;
    }

    private void recordMissingEntry(String styleName, String dbOwner) {
        long t = System.currentTimeMillis();
        String key = this.getKey(styleName, dbOwner);
        MissingStyleEntry mse = new MissingStyleEntry(t);
        if (this.stylesNotFound == null) {
            this.stylesNotFound = new Hashtable();
        }
        this.stylesNotFound.put(key, mse);
    }

    private void removeFromStylesNotFound(String styleName, String dbOwner) {
        if (this.stylesNotFound != null) {
            String key = this.getKey(styleName, dbOwner);
            this.stylesNotFound.remove(key);
        }
    }

    class MissingStyleEntry {
        long lastAttempt;

        public MissingStyleEntry(long time) {
            this.lastAttempt = time;
        }
    }
}

