/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.FeatureDescriptor;
import oracle.mapviewer.share.FeatureGroup;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.FieldArray;
import oracle.mapviewer.share.SimpleFeature;
import oracle.mapviewer.share.SimpleFeatureI;
import oracle.mapviewer.share.SimpleGeometry;
import oracle.mapviewer.share.SimpleStyledFeature;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mapviewer.share.TopologyNode;
import oracle.mapviewer.share.TopologyPrimitives;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.stream.GeometryFeaturePump;
import oracle.sdovis.stream.JsonUtils;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.AnnotationTextFeature;
import oracle.sdovis.text.jaxb.FontStyle;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.text.jaxb.TextDecoration;
import oracle.sdovis.text.jaxb.TextStyle;
import oracle.sdovis.text.jaxb.Textlayout;
import oracle.sdovis.util.PolygonUtil;
import oracle.spatial.geometry.JGeometry;

public class GeoJsonUtils2 {
    static final NumberFormat[] NFs = new NumberFormat[17];
    static String defaultAttrInfo;

    private static DecimalFormat getDecimalFormat(Locale locale, String pattern, int maxFractionDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        df.setMaximumFractionDigits(maxFractionDigits);
        return df;
    }

    public static final StringBuilder featureGroup2GeoJson(FeatureGroup fg, StringBuilder sb, boolean includeLabelBox, boolean includeId) {
        return GeoJsonUtils2.featureGroup2GeoJson(fg, sb, 5, true, includeLabelBox, includeId, false);
    }

    public static final StringBuilder featureGroup2GeoJson(FeatureGroup fg, StringBuilder sb, int precision, boolean includeStyleInfo, boolean includeLabelBox, boolean includeId, boolean strictGeoJson) {
        if (fg == null) {
            return new StringBuilder("{}");
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        String name = fg.getName();
        sb.append("{\"type\":\"FeatureCollection\",\n\"collectionName\":\"" + name + "\",\n");
        sb.append("\"srs\":" + fg.getSrid() + ",\n");
        sb.append("\"geodetic\":" + fg.isGeodeticSrid() + ",\n");
        NumberFormat nf = GeoJsonUtils2.getNumberFormat(precision);
        double[] mbr = fg.getMbr();
        if (mbr != null) {
            sb.append("\"bbox\":[" + nf.format(mbr[0]) + ", " + nf.format(mbr[1]) + ", " + nf.format(mbr[2]) + ", " + nf.format(mbr[3]) + "],\n");
        }
        sb.append(GeoJsonUtils2.getFeatureAttrTypesInfo(fg));
        if (fg.getIdAttribute() != null) {
            sb.append("\"edit_properties\":{");
            sb.append("\"id_attr\":\"" + fg.getIdAttribute() + "\"");
            if (fg.getBaseTable() != null) {
                sb.append(",\"base_table\":\"" + fg.getBaseTable() + "\"");
            }
            if (fg.getSpatialAttribute() != null) {
                sb.append(",\"spatial_attr\":\"" + fg.getSpatialAttribute() + "\"");
            }
            if (fg.getSpatialType() != null) {
                sb.append(",\"spatial_type\":\"" + fg.getSpatialType() + "\"");
            }
            if (fg.getWorkspace() != null) {
                sb.append(",\"workspace\":\"" + fg.getWorkspace() + "\"");
            }
            sb.append("},\n");
        }
        sb.append("\"features\":[\n");
        List<SimpleFeatureI> features = fg.getFeatures();
        FeatureDescriptor desc = fg.getType();
        int size = features.size();
        for (int i = 0; i < size; ++i) {
            SimpleFeatureI sf = features.get(i);
            GeoJsonUtils2.simpleFeature2GeoJson(sf, desc, sb, nf, includeStyleInfo, includeLabelBox, includeId, strictGeoJson);
            if (i >= size - 1) continue;
            sb.append(",\n");
        }
        sb.append("]}");
        return sb;
    }

    public static String getFeatureAttrTypesInfo(FeatureGroup fg) {
        FeatureDescriptor ft = fg.getType();
        if (ft == null) {
            return defaultAttrInfo;
        }
        Field[] fields = ft.getAttributeTypes();
        int len = fields.length;
        if (fields != null && len > 0) {
            Field f;
            int i;
            StringBuilder sb = new StringBuilder(512);
            sb.append("\"attr_names\":[");
            for (i = 0; i < len; ++i) {
                f = fields[i];
                String name = null;
                if (f.getDisplayName() == null) {
                    name = JsonUtils.encode(f.getName());
                } else {
                    name = JsonUtils.encode(f.getDisplayName());
                    if (name == null || name.trim().length() == 0) {
                        name = JsonUtils.encode(f.getName());
                    }
                }
                sb.append(name);
                if (i >= len - 1) continue;
                sb.append(",");
            }
            sb.append("],\n");
            sb.append("\"attr_types\":[");
            for (i = 0; i < len; ++i) {
                f = fields[i];
                String type = f.getShortJavaTypeName();
                if (f.isArray()) {
                    type = "array-" + type;
                }
                sb.append("\"" + type + "\"");
                if (i >= len - 1) continue;
                sb.append(",");
            }
            sb.append("],\n");
            String[] notNullAttrs = ft.getNotNullAttributes();
            if (notNullAttrs != null && notNullAttrs.length > 0) {
                sb.append("\"not_null_attr_names\":[");
                for (int i2 = 0; i2 < notNullAttrs.length; ++i2) {
                    sb.append(JsonUtils.encode(notNullAttrs[i2]));
                    if (i2 >= notNullAttrs.length - 1) continue;
                    sb.append(",");
                }
                sb.append("],\n");
            }
            return sb.toString();
        }
        return defaultAttrInfo;
    }

    public static String getFeatureStyleInfo(SimpleFeatureI sf) {
        String column;
        int i;
        String[] cols;
        SimpleStyledFeature ssf = (SimpleStyledFeature)sf;
        if (ssf == null || ssf.getRenderingStyleName() == null && ssf.getLabelingStylename() == null) {
            return null;
        }
        StringBuffer tempSB = new StringBuffer(1024);
        tempSB.append("\"styles\":{");
        if (ssf.getRenderingStyleName() != null) {
            tempSB.append("\"rendering\":");
            String rsName = ssf.getRenderingStyleName();
            tempSB.append("{\"style\":\"" + rsName + "\"");
            cols = ssf.getRenderingColumns();
            if (cols != null && cols.length > 0) {
                tempSB.append(", \"columns\":[");
                for (i = 0; i < cols.length; ++i) {
                    column = GeoJsonUtils2.getDisplayName(ssf, cols[i]);
                    tempSB.append(JsonUtils.encode(column));
                    if (i >= cols.length - 1) continue;
                    tempSB.append(",");
                }
                tempSB.append("]");
            }
            tempSB.append("}");
            if (ssf.getLabelingStylename() != null) {
                tempSB.append(",");
            }
        }
        if (ssf.getLabelingStylename() != null) {
            tempSB.append("\"labeling\":");
            String lsName = ssf.getLabelingStylename();
            tempSB.append("{\"style\":\"" + lsName + "\"");
            cols = ssf.getLabeingColumns();
            if (cols != null && cols.length > 0) {
                tempSB.append(", \"columns\":[");
                for (i = 0; i < cols.length; ++i) {
                    column = GeoJsonUtils2.getDisplayName(ssf, cols[i]);
                    tempSB.append(JsonUtils.encode(column));
                    if (i >= cols.length - 1) continue;
                    tempSB.append(",");
                }
                tempSB.append("]");
            }
            tempSB.append("}");
        }
        tempSB.append("}");
        return tempSB.toString();
    }

    private static final String getDisplayName(SimpleStyledFeature sf, String origColumn) {
        Field[] attrs = sf.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                Field f = attrs[i];
                if (f == null || f.getDisplayName() == null || !f.getName().equalsIgnoreCase(origColumn)) continue;
                return f.getDisplayName();
            }
        }
        return origColumn;
    }

    public static final StringBuilder simpleFeature2GeoJson(SimpleFeature sf, FeatureDescriptor desc, StringBuilder sb) {
        return GeoJsonUtils2.simpleFeature2GeoJson(sf, desc, sb, NFs[5], true, false, true, false);
    }

    public static final StringBuilder simpleFeature2GeoJson(SimpleFeatureI sf, FeatureDescriptor desc, StringBuilder sb, NumberFormat nf, boolean includeStyleInfo, boolean includeLabelBox, boolean includeId, boolean strictGeoJson) {
        JGeometry jgeom;
        double[] lbox;
        String styleInfo;
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("{");
        sb.append("\"type\":\"Feature\",");
        if (includeId) {
            sb.append("\"_id\":\"" + sf.getKey() + "\",");
        }
        sb.append("\"geometry\": ");
        GeoJsonUtils2.simpleGeometry2GeoJson(sf.getGeometry(), sb, nf, strictGeoJson);
        Field[] attrs = sf.getAttributes();
        Field[] attrTypes = null;
        if (desc != null) {
            attrTypes = desc.getAttributeTypes();
        }
        if (attrs.length > 0) {
            sb.append(",\"properties\":{");
            for (int i = 0; i < attrs.length; ++i) {
                String name = attrTypes[i].getDisplayName();
                if (name == null) {
                    name = attrTypes[i].getName();
                }
                String propName = JsonUtils.encode(name);
                if (attrs[i].isArray()) {
                    String[] values = ((FieldArray)attrs[i]).toStringArray();
                    String value = "";
                    if (values != null && values.length > 0) {
                        for (int k = 0; k < values.length; ++k) {
                            if (k > 0) {
                                value = value + ",";
                            }
                            value = value + values[k];
                        }
                    }
                    sb.append(propName + ":[");
                    sb.append(value);
                    sb.append("]");
                } else {
                    String value = attrs[i].toString();
                    value = JsonUtils.encode(value);
                    sb.append(propName + ":");
                    sb.append(value);
                }
                if (i == attrs.length - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        if (includeStyleInfo && (styleInfo = GeoJsonUtils2.getFeatureStyleInfo(sf)) != null && styleInfo.length() > 0) {
            sb.append("," + styleInfo);
        }
        SimpleGeometry sgeom = sf.getGeometry();
        if (includeLabelBox && GeoJsonUtils2.shouldGenerateLabelBox(sgeom) && (lbox = PolygonUtil.findLabelBox(jgeom = GeoJsonUtils2.simpleGeometryToJGeometry(sgeom))) != null) {
            sb.append(",\"label_box\":[");
            sb.append(nf.format(lbox[0]) + "," + nf.format(lbox[1]) + "," + nf.format(lbox[2]) + "," + nf.format(lbox[3]));
            sb.append("]");
        }
        sb.append("}");
        return sb;
    }

    public static final StringBuilder simpleGeometry2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        int geomType = geom.getGtype() % 10;
        switch (geomType) {
            case 1: {
                GeoJsonUtils2.point2GeoJson(geom, sb, nf, strictGeoJson);
                break;
            }
            case 2: {
                GeoJsonUtils2.lineString2GeoJson(geom, sb, nf, strictGeoJson);
                break;
            }
            case 3: {
                GeoJsonUtils2.polygon2GeoJson(geom, sb, nf, strictGeoJson);
                break;
            }
            case 4: {
                GeoJsonUtils2.collection2GeoJson(geom, sb, nf, strictGeoJson);
                break;
            }
            case 5: {
                GeoJsonUtils2.multiPoint2GeoJson(geom, sb, nf, strictGeoJson);
                break;
            }
            case 6: {
                GeoJsonUtils2.multiLineString2GeoJson(geom, sb, nf, strictGeoJson);
                break;
            }
            case 7: {
                GeoJsonUtils2.multiPolygon2GeoJson(geom, sb, nf, strictGeoJson);
            }
        }
        return sb;
    }

    static final StringBuilder oneRing2GeoJson(int numDim, int numPoints, double[] theOrdinates, int startOrdOffset, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("[");
        for (int i = 1; i <= numPoints; ++i) {
            double x = theOrdinates[startOrdOffset + (i - 1) * numDim];
            double y = theOrdinates[startOrdOffset + (i - 1) * numDim + 1];
            if (strictGeoJson) {
                sb.append("[");
            }
            sb.append(nf.format(x) + "," + nf.format(y));
            if (numDim == 3) {
                double z = theOrdinates[startOrdOffset + (i - 1) * numDim + 2];
                sb.append("," + nf.format(z));
            }
            if (strictGeoJson) {
                sb.append("]");
            }
            if (i >= numPoints) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb;
    }

    static final StringBuilder cwRectangle2GeoJson(int numDim, double[] coords, int startOrdOffset, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        double minx = coords[startOrdOffset];
        double miny = coords[startOrdOffset + 1];
        double maxx = coords[startOrdOffset + 2];
        double maxy = coords[startOrdOffset + 3];
        if (numDim == 3) {
            maxx = coords[startOrdOffset + 3];
            maxy = coords[startOrdOffset + 4];
        }
        sb.append("[");
        if (!strictGeoJson) {
            sb.append(nf.format(minx) + "," + nf.format(miny) + ",");
            sb.append(nf.format(minx) + "," + nf.format(maxy) + ",");
            sb.append(nf.format(maxx) + "," + nf.format(maxy) + ",");
            sb.append(nf.format(maxx) + "," + nf.format(miny) + ",");
            sb.append(nf.format(minx) + "," + nf.format(miny));
        } else {
            sb.append("[");
            sb.append(nf.format(minx) + "," + nf.format(miny) + "],[");
            sb.append(nf.format(minx) + "," + nf.format(maxy) + "],[");
            sb.append(nf.format(maxx) + "," + nf.format(maxy) + "],[");
            sb.append(nf.format(maxx) + "," + nf.format(miny) + "],[");
            sb.append(nf.format(minx) + "," + nf.format(miny));
            sb.append("]");
        }
        sb.append("]");
        return sb;
    }

    static final StringBuilder ccwRectangle2GeoJson(int numDim, double[] coords, int startOrdOffset, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        double minx = coords[startOrdOffset];
        double miny = coords[startOrdOffset + 1];
        double maxx = coords[startOrdOffset + 2];
        double maxy = coords[startOrdOffset + 3];
        if (numDim == 3) {
            maxx = coords[startOrdOffset + 3];
            maxy = coords[startOrdOffset + 4];
        }
        sb.append("[");
        if (!strictGeoJson) {
            sb.append(nf.format(minx) + "," + nf.format(miny) + ",");
            sb.append(nf.format(maxx) + "," + nf.format(miny) + ",");
            sb.append(nf.format(maxx) + "," + nf.format(maxy) + ",");
            sb.append(nf.format(minx) + "," + nf.format(maxy) + ",");
            sb.append(nf.format(minx) + "," + nf.format(miny));
        } else {
            sb.append("[");
            sb.append(nf.format(minx) + "," + nf.format(miny) + "],[");
            sb.append(nf.format(maxx) + "," + nf.format(miny) + "],[");
            sb.append(nf.format(maxx) + "," + nf.format(maxy) + "],[");
            sb.append(nf.format(minx) + "," + nf.format(maxy) + "],[");
            sb.append(nf.format(minx) + "," + nf.format(miny));
            sb.append("]");
        }
        sb.append("]");
        return sb;
    }

    public static final StringBuilder point2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        double y;
        double x;
        int dim;
        if (sb == null) {
            sb = new StringBuilder();
        }
        String dimStr = (dim = geom.getDim()) > 2 ? "\"dim\":" + dim + ", " : "";
        double[] ords = geom.getOrdinates();
        double z = Double.NaN;
        if (ords == null) {
            x = geom.getX();
            y = geom.getY();
            z = geom.getZ();
        } else {
            x = ords[0];
            y = ords[1];
            if (dim > 2) {
                z = ords[2];
            }
        }
        if (!geom.isOrientedPoint()) {
            sb.append("{\"type\":\"Point\", " + dimStr + "\"coordinates\":");
            sb.append("[" + nf.format(x) + ", " + nf.format(y));
            if (dim > 2) {
                sb.append(", " + nf.format(z) + "]");
            } else {
                sb.append("]");
            }
        } else {
            double[] ordinates = geom.ordinates;
            sb.append("{\"type\":\"OrientedPoint\", " + dimStr + "\"coordinates\":");
            if (!strictGeoJson) {
                if (dim < 3) {
                    sb.append("[" + nf.format(ordinates[0]) + ", " + nf.format(ordinates[1]) + ", " + nf.format(ordinates[dim]) + ", " + nf.format(ordinates[dim + 1]) + "]");
                } else {
                    sb.append("[" + nf.format(ordinates[0]) + ", " + nf.format(ordinates[1]) + ", " + nf.format(ordinates[2]) + ", " + nf.format(ordinates[dim]) + ", " + nf.format(ordinates[dim + 1]) + ", " + nf.format(ordinates[dim + 2]) + "]");
                }
            } else if (dim < 3) {
                sb.append("[[" + nf.format(ordinates[0]) + ", " + nf.format(ordinates[1]) + "], [" + nf.format(ordinates[dim]) + ", " + nf.format(ordinates[dim + 1]) + "]]");
            } else {
                sb.append("[[" + nf.format(ordinates[0]) + ", " + nf.format(ordinates[1]) + ", " + nf.format(ordinates[2]) + "], [" + nf.format(ordinates[dim]) + ", " + nf.format(ordinates[dim + 1]) + ", " + nf.format(ordinates[dim + 2]) + "]]");
            }
        }
        sb.append("}");
        return sb;
    }

    public static final StringBuilder multiPoint2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        int[] elemInfoArray = geom.getElemInfo();
        int numElements = elemInfoArray.length / 3;
        int numDim = geom.dim;
        String dimStr = numDim > 2 ? "\"dim\":" + numDim + ", " : "";
        double[] coords = geom.ordinates;
        int numPoints = 0;
        if (numElements == 1 && elemInfoArray[2] > 1) {
            numPoints = elemInfoArray[2];
        } else if (numElements > 1) {
            numPoints = numElements;
        }
        boolean oriented = geom.isOrientedMultiPoint();
        if (!oriented) {
            sb.append("{\"type\":\"MultiPoint\", " + dimStr + "\"coordinates\":[");
            for (int j = 1; j <= numPoints; ++j) {
                int ordOffset = numDim * (j - 1);
                if (elemInfoArray.length >= ordOffset + 2 && elemInfoArray[ordOffset + 2] == 0) continue;
                double x = coords[ordOffset];
                double y = coords[ordOffset + 1];
                sb.append("[" + nf.format(x) + ", " + nf.format(y));
                if (numDim > 2) {
                    sb.append(", " + nf.format(coords[ordOffset + 2]) + "]");
                } else {
                    sb.append("]");
                }
                if (j == numPoints) continue;
                sb.append(", ");
            }
        } else {
            sb.append("{\"type\":\"OrientedMultiPoint\", " + dimStr + "\"coordinates\":[");
            numPoints /= 2;
            for (int j = 1; j <= numPoints; ++j) {
                int ordOffset = numDim * 2 * (j - 1);
                double x = coords[ordOffset];
                double y = coords[ordOffset + 1];
                double rx = coords[ordOffset + numDim];
                double ry = coords[ordOffset + numDim + 1];
                if (!strictGeoJson) {
                    if (numDim < 3) {
                        sb.append("[" + nf.format(x) + ", " + nf.format(y) + ", " + nf.format(rx) + ", " + nf.format(ry) + "]");
                    } else {
                        sb.append("[" + nf.format(x) + ", " + nf.format(y) + ", " + nf.format(coords[ordOffset + 2]) + ", " + nf.format(rx) + ", " + nf.format(ry) + ", " + nf.format(coords[ordOffset + numDim + 2]) + "]");
                    }
                } else if (numDim < 3) {
                    sb.append("[[" + nf.format(x) + ", " + nf.format(y) + "], [" + nf.format(rx) + ", " + nf.format(ry) + "]]");
                } else {
                    sb.append("[[" + nf.format(x) + ", " + nf.format(y) + ", " + nf.format(coords[ordOffset + 2]) + "], [" + nf.format(rx) + ", " + nf.format(ry) + ", " + nf.format(coords[ordOffset + numDim + 2]) + "]]");
                }
                if (j == numPoints) continue;
                sb.append(", ");
            }
        }
        sb.append("]}");
        return sb;
    }

    public static final StringBuilder lineString2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        double[] coords = geom.ordinates;
        int dim = geom.dim;
        String dimStr = dim > 2 ? "\"dim\":" + dim + ", " : "";
        sb.append("{\"type\":\"LineString\", " + dimStr + "\"coordinates\":");
        GeoJsonUtils2.oneRing2GeoJson(dim, coords.length / dim, coords, 0, sb, nf, strictGeoJson);
        sb.append("}");
        return sb;
    }

    public static final StringBuilder polygon2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        int dim;
        if (geom.isCircle()) {
            return GeoJsonUtils2.circle2GeoJson(geom, sb, nf);
        }
        if (geom.isRectangle()) {
            return GeoJsonUtils2.rectangle2GeoJson(geom, sb, nf, strictGeoJson);
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        String dimStr = (dim = geom.dim) > 2 ? "\"dim\":" + dim + ", " : "";
        sb.append("{\"type\":\"Polygon\", " + dimStr + "\"coordinates\":[");
        int[] elemInfoArray = geom.getElemInfo();
        int numElements = elemInfoArray.length / 3;
        double[] coords = geom.ordinates;
        if (numElements == 1 && elemInfoArray[1] % 10 == 3 && elemInfoArray[2] == 3) {
            GeoJsonUtils2.ccwRectangle2GeoJson(dim, coords, 0, sb, nf, strictGeoJson);
            sb.append("]}");
            return sb;
        }
        if (numElements == 1) {
            if (elemInfoArray[2] == 3) {
                GeoJsonUtils2.ccwRectangle2GeoJson(dim, coords, 0, sb, nf, strictGeoJson);
            } else {
                GeoJsonUtils2.oneRing2GeoJson(dim, coords.length / dim, coords, 0, sb, nf, strictGeoJson);
            }
            sb.append("]}");
            return sb;
        }
        if (numElements > 1) {
            int numPoints = (elemInfoArray[3] - elemInfoArray[0]) / dim;
            if (elemInfoArray[2] == 3) {
                GeoJsonUtils2.ccwRectangle2GeoJson(dim, coords, 0, sb, nf, strictGeoJson);
            } else {
                GeoJsonUtils2.oneRing2GeoJson(dim, numPoints, coords, 0, sb, nf, strictGeoJson);
            }
            sb.append(",");
            for (int j = 2; j <= numElements; ++j) {
                numPoints = j == numElements ? (coords.length - elemInfoArray[3 * (j - 1)] + 1) / dim : (elemInfoArray[3 * j] - elemInfoArray[3 * (j - 1)]) / dim;
                int ordOffset = elemInfoArray[3 * (j - 1)] - 1;
                if (elemInfoArray[3 * (j - 1) + 2] == 3) {
                    GeoJsonUtils2.cwRectangle2GeoJson(dim, coords, ordOffset, sb, nf, strictGeoJson);
                    continue;
                }
                GeoJsonUtils2.oneRing2GeoJson(dim, numPoints, coords, ordOffset, sb, nf, strictGeoJson);
                if (j >= numElements) continue;
                sb.append(", ");
            }
            sb.append("]}");
        }
        return sb;
    }

    public static final StringBuilder circle2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("{\"type\":\"Circle\", \"coordinates\":[");
        double[] coords = GeoJsonUtils2.getCircleCenterRadius(geom);
        sb.append(nf.format(coords[0]));
        sb.append("," + nf.format(coords[1]));
        sb.append("," + nf.format(coords[2]));
        sb.append("]}");
        return sb;
    }

    public static final StringBuilder rectangle2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("{\"type\":\"Rectangle\", \"coordinates\":[");
        double[] coords = GeoJsonUtils2.getMBR(geom);
        if (!strictGeoJson) {
            sb.append(nf.format(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                sb.append("," + nf.format(coords[i]));
            }
        } else {
            sb.append("[");
            sb.append(nf.format(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                if (i % 2 == 0) {
                    sb.append(",[" + nf.format(coords[i]));
                } else {
                    sb.append("," + nf.format(coords[i]));
                }
                if (i % 2 != 1) continue;
                sb.append("]");
            }
        }
        sb.append("]}");
        return sb;
    }

    public static StringBuilder multiLineString2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        int dim;
        if (sb == null) {
            sb = new StringBuilder();
        }
        String dimStr = (dim = geom.dim) > 2 ? "\"dim\":" + dim + ", " : "";
        sb.append("{\"type\":\"MultiLineString\", " + dimStr + "\"coordinates\":[");
        int[] elemInfoArray = geom.getElemInfo();
        int numElements = elemInfoArray.length / 3;
        double[] coords = geom.ordinates;
        int numPoints = 0;
        int ordOffset = 0;
        for (int j = 1; j <= numElements; ++j) {
            numPoints = j == numElements ? (coords.length - elemInfoArray[3 * (j - 1)] + 1) / dim : (elemInfoArray[3 * j] - elemInfoArray[3 * (j - 1)]) / dim;
            ordOffset = elemInfoArray[3 * (j - 1)] - 1;
            GeoJsonUtils2.oneRing2GeoJson(dim, numPoints, coords, ordOffset, sb, nf, strictGeoJson);
            if (j >= numElements) continue;
            sb.append(", ");
        }
        sb.append("]}");
        return sb;
    }

    public static StringBuilder multiPolygon2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        int numDim;
        if (sb == null) {
            sb = new StringBuilder();
        }
        String dimStr = (numDim = geom.dim) > 2 ? "\"dim\":" + numDim + ", " : "";
        sb.append("{\"type\":\"MultiPolygon\", " + dimStr + "\"coordinates\":[");
        int[] theElemInfoArray = geom.getElemInfo();
        int numElements = theElemInfoArray.length / 3;
        double[] theOrdinates = geom.ordinates;
        int numPoints = 0;
        int ordOffset = 0;
        boolean isRectangle = false;
        boolean startNewMember = true;
        for (int j = 1; j <= numElements; ++j) {
            numPoints = j == numElements ? (theOrdinates.length - theElemInfoArray[3 * (j - 1)] + 1) / numDim : (theElemInfoArray[3 * j] - theElemInfoArray[3 * (j - 1)]) / numDim;
            ordOffset = theElemInfoArray[3 * (j - 1)] - 1;
            boolean bl = isRectangle = theElemInfoArray[3 * (j - 1) + 2] == 3;
            if (startNewMember) {
                sb.append("[");
                if (isRectangle) {
                    GeoJsonUtils2.ccwRectangle2GeoJson(numDim, theOrdinates, ordOffset, sb, nf, strictGeoJson);
                } else {
                    GeoJsonUtils2.oneRing2GeoJson(numDim, numPoints, theOrdinates, ordOffset, sb, nf, strictGeoJson);
                }
            } else if (isRectangle) {
                GeoJsonUtils2.cwRectangle2GeoJson(numDim, theOrdinates, ordOffset, sb, nf, strictGeoJson);
            } else {
                GeoJsonUtils2.oneRing2GeoJson(numDim, numPoints, theOrdinates, ordOffset, sb, nf, strictGeoJson);
            }
            if (j == numElements) {
                sb.append("]");
                continue;
            }
            if (theElemInfoArray[3 * j + 1] == 2003) {
                startNewMember = false;
            } else {
                startNewMember = true;
                sb.append("]");
            }
            sb.append(",");
        }
        sb.append("]}");
        return sb;
    }

    public static StringBuilder collection2GeoJson(SimpleGeometry geom, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        JGeometry jgeom = new JGeometry(geom.getGtype(), geom.getSrid(), geom.getElemInfo(), geom.getOrdinates());
        sb.append("{\"type\":\"GeometryCollection\", \"geometries\":[");
        JGeometry[] geometries = jgeom.getElements();
        if (geometries.length > 0) {
            SimpleGeometry g = GeometryFeaturePump.toSimpleGeometry(JSDOGeometry.recast(geometries[0]));
            GeoJsonUtils2.simpleGeometry2GeoJson(g, sb, nf, strictGeoJson);
            for (int i = 1; i < geometries.length; ++i) {
                g = GeometryFeaturePump.toSimpleGeometry(JSDOGeometry.recast(geometries[i]));
                sb.append(",");
                GeoJsonUtils2.simpleGeometry2GeoJson(g, sb, nf, strictGeoJson);
            }
        }
        sb.append("]}");
        return sb;
    }

    public static NumberFormat getNumberFormat(int precision) {
        return precision < NFs.length ? NFs[precision] : NFs[NFs.length - 1];
    }

    private static double[] getCircleCenterRadius(SimpleGeometry geom) {
        double[] result = new double[3];
        double[] coords = geom.ordinates;
        int dim = geom.dim;
        double bx = coords[0];
        double by = coords[1];
        double cx = coords[dim];
        double cy = coords[dim + 1];
        double dx = coords[dim * 2];
        double dy = coords[dim * 2 + 1];
        double temp = cx * cx + cy * cy;
        double bc = (bx * bx + by * by - temp) / 2.0;
        double cd = (temp - dx * dx - dy * dy) / 2.0;
        double det = (bx - cx) * (cy - dy) - (cx - dx) * (by - cy);
        if (Math.abs(det) < 1.0E-6) {
            result[2] = 0.0;
            result[1] = 0.0;
            result[0] = 0.0;
            return result;
        }
        det = 1.0 / det;
        result[0] = (bc * (cy - dy) - cd * (by - cy)) * det;
        result[1] = ((bx - cx) * cd - (cx - dx) * bc) * det;
        result[2] = Math.sqrt((result[0] - bx) * (result[0] - bx) + (result[1] - by) * (result[1] - by));
        return result;
    }

    private static double[] getMBR(SimpleGeometry geom) {
        double[] result = geom.getMbr();
        if (result != null) {
            return result;
        }
        result = new double[3];
        double[] coords = geom.ordinates;
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < coords.length; i += geom.dim) {
            if (minX > coords[i]) {
                minX = coords[i];
            }
            if (maxX < coords[i]) {
                maxX = coords[i];
            }
            if (minY > coords[i + 1]) {
                minY = coords[i + 1];
            }
            if (!(maxY < coords[i + 1])) continue;
            maxY = coords[i + 1];
        }
        return result;
    }

    private static JGeometry simpleGeometryToJGeometry(SimpleGeometry geom) {
        if (geom == null) {
            return null;
        }
        return new JGeometry(geom.gtype, geom.srid, geom.x, geom.y, geom.z, geom.elemInfo, geom.ordinates);
    }

    private static boolean shouldGenerateLabelBox(SimpleGeometry geom) {
        if (geom == null) {
            return false;
        }
        int geomType = geom.getGtype() % 10;
        switch (geomType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return false;
            }
            case 3: 
            case 4: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static final StringBuilder atextFeatureGroup2GeoJson(FeatureGroup fg, AnnotationTextFeature[] features, StringBuilder sb, int precision, AnnotationTextMetadata metadata, boolean strictGeoJson) {
        if (fg == null || features == null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("{}");
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        String name = fg.getName();
        sb.append("{\"type\":\"AnnotationText\",\n\"collectionName\":\"" + name + "\",\n");
        sb.append("\"srs\":" + fg.getSrid() + ",\n");
        sb.append("\"geodetic\":" + fg.isGeodeticSrid() + ",\n");
        NumberFormat nf = GeoJsonUtils2.getNumberFormat(precision);
        double[] mbr = fg.getMbr();
        if (mbr != null) {
            sb.append("\"bbox\":[" + nf.format(mbr[0]) + ", " + nf.format(mbr[1]) + ", " + nf.format(mbr[2]) + ", " + nf.format(mbr[3]) + "],\n");
        }
        sb.append(GeoJsonUtils2.getFeatureAttrTypesInfo(fg));
        TextAttributesType attrs = new TextAttributesType();
        attrs.setTextStyle(new TextStyle());
        attrs.setTextlayout(new Textlayout());
        sb.append("\"default_text_attributes\":{");
        sb.append("\"fontWeight\":\"" + attrs.getTextStyle().getFontWeight() + "\"");
        sb.append(",\"fontStyle\":\"" + attrs.getTextStyle().getFontStyle().value() + "\"");
        sb.append(",\"textDecoration\":\"" + attrs.getTextStyle().getTextDecoration().value() + "\"");
        sb.append(",\"letterSpacing\":\"" + attrs.getTextStyle().getLetterSpacing() + "\"");
        sb.append(",\"wordSpacing\":\"" + attrs.getTextStyle().getWordSpacing() + "\"");
        sb.append(",\"fill\":\"" + attrs.getTextStyle().getFill() + "\"");
        sb.append(",\"fill-opacity\":" + attrs.getTextStyle().getFillOpacity());
        sb.append(",\"stroke\":\"" + attrs.getTextStyle().getStroke() + "\"");
        sb.append(",\"strokeWidth\":" + attrs.getTextStyle().getStrokeWidth());
        sb.append(",\"stroke-opacity\":" + attrs.getTextStyle().getStrokeOpacity());
        sb.append(",\"horizontalAlignment\":\"" + attrs.getTextlayout().getHorizontalAlignment() + "\"");
        sb.append(",\"verticalAlignment\":\"" + attrs.getTextlayout().getVerticalAlignment() + "\"");
        sb.append(",\"multilineJustification\":\"" + attrs.getTextlayout().getMultilineJustification() + "\"");
        sb.append(",\"multilineSpacing\":" + attrs.getTextlayout().getMultilineSpacing());
        sb.append("},\n");
        sb.append("\"metadata\":{");
        sb.append("\"textExpression\":\"" + metadata.getTextExpression() + "\"");
        if (!Double.isNaN(metadata.getMapBaseScale())) {
            sb.append(", \"mapBaseScale\":" + metadata.getMapBaseScale());
        }
        if (metadata.getTextAtttributes() != null) {
            attrs = null;
            try {
                JAXBContext jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                Unmarshaller u = jc.createUnmarshaller();
                StringBuffer xmlStr = new StringBuffer(metadata.getTextAtttributes());
                JAXBElement jaxbEl = (JAXBElement)u.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
                attrs = (TextAttributesType)jaxbEl.getValue();
                GeoJsonUtils2.appendAnnotationTextAttributes(attrs, sb);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        sb.append("},\n");
        sb.append("\"features\":[\n");
        FeatureDescriptor desc = fg.getType();
        int size = features.length;
        for (int i = 0; i < size; ++i) {
            AnnotationTextFeature sf = features[i];
            GeoJsonUtils2.annotationtextFeature2GeoJson(sf, desc, sb, nf, strictGeoJson);
            if (i < size - 1) {
                sb.append(",\n");
                continue;
            }
            sb.append("\n");
        }
        sb.append("]}");
        return sb;
    }

    public static final StringBuilder annotationtextFeature2GeoJson(AnnotationTextFeature sf, FeatureDescriptor desc, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        AnnotationText atext;
        if (sb == null) {
            sb = new StringBuilder();
        }
        if ((atext = sf.getAnnotationTextObject()) == null) {
            return sb;
        }
        sb.append("{");
        sb.append("\"type\":\"AnnoText\"");
        sb.append(", \"elements\":[");
        AnnotationTextElement[] elements = atext.getElements();
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("{");
                JGeometry location = elements[i].getLocation();
                String textValue = elements[i].getValue();
                JGeometry leaderLine = elements[i].getLeaderLine();
                TextAttributesType attrs = elements[i].getAttributes();
                sb.append("\"location\":");
                GeoJsonUtils2.simpleGeometry2GeoJson(GeoJsonUtils2.JGeometrytoSimpleGeometry(location), sb, nf, strictGeoJson);
                if (textValue != null) {
                    sb.append(",\"textValue\":\"" + textValue + "\"");
                }
                if (leaderLine != null) {
                    sb.append(",\"leaderLine\":");
                    GeoJsonUtils2.simpleGeometry2GeoJson(GeoJsonUtils2.JGeometrytoSimpleGeometry(leaderLine), sb, nf, strictGeoJson);
                }
                if (attrs != null) {
                    GeoJsonUtils2.appendAnnotationTextAttributes(attrs, sb);
                }
                sb.append("}");
            }
        }
        sb.append("]");
        JGeometry envelope = atext.getEnvelope();
        if (envelope != null) {
            sb.append(",\"envelope\":");
            GeoJsonUtils2.simpleGeometry2GeoJson(GeoJsonUtils2.JGeometrytoSimpleGeometry(envelope), sb, nf, strictGeoJson);
        }
        Field[] attrs = sf.getAttributes();
        Field[] attrTypes = null;
        if (desc != null) {
            attrTypes = desc.getAttributeTypes();
        }
        if (attrs.length > 0) {
            sb.append(",\"properties\":{");
            for (int i = 0; i < attrs.length; ++i) {
                String propName = JsonUtils.encode(attrTypes[i].getName());
                String value = attrs[i].toString();
                value = JsonUtils.encode(value);
                sb.append(propName + ":");
                sb.append(value);
                if (i == attrs.length - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        sb.append("}");
        return sb;
    }

    private static final void appendAnnotationTextAttributes(TextAttributesType attrs, StringBuilder sb) {
        if (attrs != null) {
            sb.append(",\"textAttributes\":{");
            sb.append("\"fontFamily\":\"" + attrs.getTextStyle().getFontFamily() + "\"");
            sb.append(",\"fontSize\":" + attrs.getTextStyle().getFontSize());
            if (!attrs.getTextStyle().getFontWeight().equalsIgnoreCase("Normal")) {
                sb.append(",\"fontWeight\":\"" + attrs.getTextStyle().getFontWeight() + "\"");
            }
            if (attrs.getTextStyle().getFontStyle() != FontStyle.NORMAL) {
                sb.append(",\"fontStyle\":\"" + attrs.getTextStyle().getFontStyle().value() + "\"");
            }
            if (attrs.getTextStyle().getTextDecoration() != TextDecoration.NONE) {
                sb.append(",\"textDecoration\":\"" + attrs.getTextStyle().getTextDecoration().value() + "\"");
            }
            if (!attrs.getTextStyle().getLetterSpacing().equalsIgnoreCase("Normal")) {
                sb.append(",\"letterSpacing\":\"" + attrs.getTextStyle().getLetterSpacing() + "\"");
            }
            if (!attrs.getTextStyle().getWordSpacing().equalsIgnoreCase("Normal")) {
                sb.append(",\"wordSpacing\":\"" + attrs.getTextStyle().getWordSpacing() + "\"");
            }
            if (!attrs.getTextStyle().getFill().equalsIgnoreCase("black")) {
                sb.append(",\"fill\":\"" + attrs.getTextStyle().getFill() + "\"");
            }
            if (attrs.getTextStyle().getFillOpacity() != 1.0f) {
                sb.append(",\"fill-opacity\":" + attrs.getTextStyle().getFillOpacity());
            }
            if (!attrs.getTextStyle().getStroke().equalsIgnoreCase("black")) {
                sb.append(",\"stroke\":\"" + attrs.getTextStyle().getStroke() + "\"");
            }
            if (attrs.getTextStyle().getStrokeWidth() != 1.0f) {
                sb.append(",\"strokeWidth\":" + attrs.getTextStyle().getStrokeWidth());
            }
            if (attrs.getTextStyle().getStrokeOpacity() != 1.0f) {
                sb.append(",\"stroke-opacity\":" + attrs.getTextStyle().getStrokeOpacity());
            }
            if (!attrs.getTextlayout().getHorizontalAlignment().equalsIgnoreCase("start")) {
                sb.append(",\"horizontalAlignment\":\"" + attrs.getTextlayout().getHorizontalAlignment() + "\"");
            }
            if (!attrs.getTextlayout().getVerticalAlignment().equalsIgnoreCase("top")) {
                sb.append(",\"verticalAlignment\":\"" + attrs.getTextlayout().getVerticalAlignment() + "\"");
            }
            if (!attrs.getTextlayout().getMultilineJustification().equalsIgnoreCase("left")) {
                sb.append(",\"multilineJustification\":\"" + attrs.getTextlayout().getMultilineJustification() + "\"");
            }
            if (attrs.getTextlayout().getMultilineSpacing() != 0.0f) {
                sb.append(",\"multilineSpacing\":" + attrs.getTextlayout().getMultilineSpacing());
            }
            sb.append("}");
        }
    }

    private static SimpleGeometry JGeometrytoSimpleGeometry(JGeometry geom) {
        if (geom == null) {
            return null;
        }
        SimpleGeometry res = new SimpleGeometry();
        res.dim = geom.getDimensions();
        res.setGtype(geom.getType());
        res.setSrid(geom.getSRID());
        res.setElemInfo(geom.getElemInfo());
        res.setOrdinates(geom.getOrdinatesArray());
        double[] xyz = geom.getLabelPointXYZ();
        if (xyz != null && xyz[0] != Double.NaN) {
            res.setX(xyz[0]);
            res.setY(xyz[1]);
            if (xyz.length > 2) {
                res.setZ(xyz[2]);
            }
        }
        res.setLinfo(geom.getLRMDimension());
        res.setMbr(geom.getMBR());
        return res;
    }

    public static final StringBuilder topologyPrimitves2GeoJson(String topology, StringBuilder sb, Rectangle2D mbr, int srid, TopologyPrimitives primitives, int precision, boolean strictGeoJson) {
        if (topology == null || primitives == null || primitives.getNumberOfPrimitives() == 0) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("{}");
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("{\"type\":\"TopologyPrimitives\",\n\"topology\":\"" + topology + "\",\n");
        sb.append("\"srs\":" + srid + ",\n");
        NumberFormat nf = GeoJsonUtils2.getNumberFormat(precision);
        if (mbr != null) {
            sb.append("\"bbox\":[" + nf.format(mbr.getMinX()) + ", " + nf.format(mbr.getMinY()) + ", " + nf.format(mbr.getMaxX()) + ", " + nf.format(mbr.getMaxY()) + "],\n");
        }
        sb.append("\"face_attr_names\":[\"FACE_ID\",\"BOUNDARY_EDGE_ID\",\"ISLAND_EDGE_ID_LIST\",\"ISLAND_NODE_ID_LIST\"],\n\"face_attr_types\":[\"integer\",\"integer\",\"array:integer\",\"array:integer\"],\n\"edge_attr_names\":[\"EDGE_ID\",\"START_NODE_ID\",\"END_NODE_ID\",\"NEXT_LEFT_EDGE_ID\",\"PREV_LEFT_EDGE_ID\",\"NEXT_RIGHT_EDGE_ID\",\"PREV_RIGHT_EDGE_ID\",\"LEFT_FACE_ID\",\"RIGHT_FACE_ID\"],\n\"edge_attr_types\":[\"integer\",\"integer\",\"integer\",\"integer\",\"integer\",\"integer\",\"integer\",\"integer\",\"integer\"],\n\"node_attr_names\":[\"NODE_ID\",\"EDGE_ID\",\"FACE_ID\"],\n\"node_attr_types\":[\"integer\",\"integer\",\"integer\"],\n");
        sb.append("\"primitives\":[\n");
        int sizeFaces = primitives.getNumberOfFaces();
        for (int i = 0; i < sizeFaces; ++i) {
            TopologyFace face = primitives.getFace(i);
            GeoJsonUtils2.topologyFace2GeoJson(face, sb, nf, strictGeoJson);
            if (i >= sizeFaces - 1) continue;
            sb.append(",\n");
        }
        int sizeEdges = primitives.getNumberOfEdges();
        if (sizeEdges > 0 && sizeFaces > 0) {
            sb.append(",\n");
        }
        for (int i = 0; i < sizeEdges; ++i) {
            TopologyEdge edge = primitives.getEdge(i);
            GeoJsonUtils2.topologyEdge2GeoJson(edge, sb, nf, strictGeoJson);
            if (i >= sizeEdges - 1) continue;
            sb.append(",\n");
        }
        int sizeNodes = primitives.getNumberOfNodes();
        if (sizeNodes > 0 && (sizeFaces > 0 || sizeEdges > 0)) {
            sb.append(",\n");
        }
        for (int i = 0; i < sizeNodes; ++i) {
            TopologyNode node = primitives.getNode(i);
            GeoJsonUtils2.topologyNode2GeoJson(node, sb, nf, strictGeoJson);
            if (i >= sizeNodes - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n]}");
        return sb;
    }

    private static void topologyFace2GeoJson(TopologyFace face, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        int[] islandNodes;
        if (sb == null || face == null) {
            return;
        }
        sb.append("{");
        sb.append("\"type\":\"Face\"");
        if (face.getMBRgeometry() != null) {
            sb.append(", \"mbr_geometry\":");
            GeoJsonUtils2.simpleGeometry2GeoJson(GeoJsonUtils2.JGeometrytoSimpleGeometry(face.getMBRgeometry()), sb, nf, strictGeoJson);
        }
        sb.append(", \"properties\":{");
        String propName = JsonUtils.encode("FACE_ID");
        String value = String.valueOf(face.getId());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("BOUNDARY_EDGE_ID");
        value = String.valueOf(face.getBoundaryEdge());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        int[] islandEdges = face.getIslandEdges();
        if (islandEdges != null && islandEdges.length > 0) {
            sb.append(", ");
            propName = JsonUtils.encode("ISLAND_EDGE_ID_LIST");
            sb.append(propName + ":[");
            for (int i = 0; i < islandEdges.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                value = String.valueOf(islandEdges[i]);
                sb.append(value);
            }
            sb.append("]");
        }
        if ((islandNodes = face.getIslandNodes()) != null && islandNodes.length > 0) {
            sb.append(", ");
            propName = JsonUtils.encode("ISLAND_NODE_ID_LIST");
            sb.append(propName + ":[");
            for (int i = 0; i < islandNodes.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                value = String.valueOf(islandNodes[i]);
                sb.append(value);
            }
            sb.append("]");
        }
        sb.append("}}");
    }

    private static void topologyEdge2GeoJson(TopologyEdge edge, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null || edge == null) {
            return;
        }
        sb.append("{");
        sb.append("\"type\":\"Edge\"");
        if (edge.getGeometry() != null) {
            sb.append(", \"geometry\":");
            GeoJsonUtils2.simpleGeometry2GeoJson(GeoJsonUtils2.JGeometrytoSimpleGeometry(edge.getGeometry()), sb, nf, strictGeoJson);
        }
        sb.append(", \"properties\":{");
        String propName = JsonUtils.encode("EDGE_ID");
        String value = String.valueOf(edge.getId());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("START_NODE_ID");
        value = String.valueOf(edge.getOriginNode());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("END_NODE_ID");
        value = String.valueOf(edge.getEndNode());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("NEXT_LEFT_EDGE_ID");
        value = String.valueOf(edge.getNextEdgeL());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("PREV_LEFT_EDGE_ID");
        value = String.valueOf(edge.getPrevEdgeL());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("NEXT_RIGHT_EDGE_ID");
        value = String.valueOf(edge.getNextEdgeR());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("PREV_RIGHT_EDGE_ID");
        value = String.valueOf(edge.getPrevEdgeR());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("LEFT_FACE_ID");
        value = String.valueOf(edge.getBoundedFaceL());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("RIGHT_FACE_ID");
        value = String.valueOf(edge.getBoundedFaceR());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append("}}");
    }

    private static void topologyNode2GeoJson(TopologyNode node, StringBuilder sb, NumberFormat nf, boolean strictGeoJson) {
        if (sb == null || node == null) {
            return;
        }
        sb.append("{");
        sb.append("\"type\":\"Node\"");
        if (node.getGeometry() != null) {
            sb.append(", \"geometry\":");
            GeoJsonUtils2.simpleGeometry2GeoJson(GeoJsonUtils2.JGeometrytoSimpleGeometry(node.getGeometry()), sb, nf, strictGeoJson);
        }
        sb.append(", \"properties\":{");
        String propName = JsonUtils.encode("NODE_ID");
        String value = String.valueOf(node.getId());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("EDGE_ID");
        value = String.valueOf(node.getStartEdge());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append(", ");
        propName = JsonUtils.encode("FACE_ID");
        value = String.valueOf(node.getContainFace());
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value);
        sb.append("}}");
    }

    public static final StringBuilder topologyFeatures2GeoJson(TopologyMetadata topology, StringBuilder sb, Rectangle2D mbr, Vector<TopoFeatureDescriptor> features, Vector<Field> attributes, int precision) {
        if (topology == null || features.size() == 0) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("{}");
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("{\"type\":\"TopologyFeatures\",\n\"topology\":\"" + topology.getTopology() + "\",\n");
        sb.append("\"topology_id\":" + topology.getTopologyId() + ",\n");
        sb.append("\"topology_owner\":\"" + topology.getTopologyOwner() + "\",\n");
        sb.append("\"tolerance\":" + topology.getTolerance() + ",\n");
        sb.append("\"srs\":" + topology.getSrid() + ",\n");
        NumberFormat nf = GeoJsonUtils2.getNumberFormat(precision);
        if (mbr != null) {
            sb.append("\"bbox\":[" + nf.format(mbr.getMinX()) + ", " + nf.format(mbr.getMinY()) + ", " + nf.format(mbr.getMaxX()) + ", " + nf.format(mbr.getMaxY()) + "],\n");
        }
        sb.append("\"table_schema\":\"" + topology.getFeatureTableOwner() + "\",\n");
        sb.append("\"table_name\":\"" + topology.getFeatureTable() + "\",\n");
        sb.append("\"topo_column\":\"" + topology.getTopoColumn() + "\",\n");
        sb.append("\"layer_id\":" + topology.getTopoLayerId() + ",\n");
        sb.append("\"layer_type\":\"" + topology.getTopoLayerType() + "\",\n");
        sb.append("\"layer_level\":" + topology.getTopoLayerLevel() + ",\n");
        sb.append("\"child_layer\":" + topology.getChildLayerId() + ",\n");
        sb.append("\"node_sequence\":\"" + topology.getNodeSequence() + "\",\n");
        sb.append("\"edge_sequence\":\"" + topology.getEdgeSequence() + "\",\n");
        sb.append("\"face_sequence\":\"" + topology.getFaceSequence() + "\",\n");
        sb.append("\"feature_sequence\":\"" + topology.getTopoGeometrySequence() + "\",\n");
        sb.append("\"digits_right_decimal\":" + topology.getDigitsRightOfDecimal() + ",\n");
        if (attributes != null && attributes.size() > 0) {
            Field f;
            int i;
            sb.append("\"attr_names\":[");
            for (i = 0; i < attributes.size(); ++i) {
                f = attributes.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\"" + f.getName() + "\"");
            }
            sb.append("],\n");
            sb.append("\"attr_types\":[");
            for (i = 0; i < attributes.size(); ++i) {
                f = attributes.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\"" + f.getShortJavaTypeName() + "\"");
            }
            sb.append("],\n");
        }
        sb.append("\"features\":[\n");
        int size = features.size();
        for (int i = 0; i < size; ++i) {
            TopoFeatureDescriptor feature = features.get(i);
            GeoJsonUtils2.topologyFeature2GeoJson(feature, sb, nf);
            if (i >= size - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n]}");
        return sb;
    }

    private static void topologyFeature2GeoJson(TopoFeatureDescriptor feature, StringBuilder sb, NumberFormat nf) {
        int i;
        if (sb == null || feature == null) {
            return;
        }
        sb.append("{");
        String propName = "\"type\"";
        String value = "topology";
        value = JsonUtils.encode(value);
        sb.append(propName + ":");
        sb.append(value + ", ");
        propName = "\"tg_id\"";
        sb.append(propName + ":");
        sb.append(feature.getFeatureId());
        if (feature.getNumberOfPrimitives() > 0) {
            sb.append(", \"primitives\":[");
            TopoPrimitiveDescriptor[] primitives = feature.getPrimitives();
            for (i = 0; i < primitives.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                TopoPrimitiveDescriptor tpd = primitives[i];
                sb.append("{");
                propName = "\"topo_id\"";
                sb.append(propName + ":");
                sb.append(tpd.getTopoId());
                sb.append(",");
                propName = "\"topo_type\"";
                sb.append(propName + ":");
                sb.append(tpd.getTopoType());
                sb.append("}");
            }
            sb.append("]");
        }
        if (feature.getNumberOfChildFeatures() > 0) {
            sb.append(", \"child_features\":[");
            TopoChildFeatureDescriptor[] childFeatures = feature.getChildFeatures();
            for (i = 0; i < childFeatures.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                TopoChildFeatureDescriptor tpcd = childFeatures[i];
                sb.append("{");
                propName = "\"layer_id\"";
                sb.append(propName + ":");
                sb.append(tpcd.getLayerId());
                sb.append(",");
                propName = "\"feature_id\"";
                sb.append(propName + ":");
                sb.append(tpcd.getFeatureId());
                sb.append("}");
            }
            sb.append("]");
        }
        if (feature.getNumberOfAttributes() > 0) {
            sb.append(", \"properties\":{");
            Field[] fields = feature.getAttributes();
            for (i = 0; i < fields.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Field f = fields[i];
                propName = "\"" + f.getName() + "\"";
                value = f.toString();
                value = JsonUtils.encode(value);
                sb.append(propName + ":");
                sb.append(value);
            }
            sb.append("}");
        }
        sb.append("}");
    }

    public static final StringBuilder topologyFeatures2TopoJson(TopologyMetadata topology, StringBuilder sb, Rectangle2D mbr, int srid, Vector<TopoFeatureDescriptor> features, Vector<Field> attributes, TopologyPrimitives primitives, int precision) {
        int i;
        if (topology == null || features.size() == 0 || primitives == null || primitives.getNumberOfPrimitives() == 0) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("{}");
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        Hashtable<String, Integer> nodeIndexMap = new Hashtable<String, Integer>();
        TopologyNode[] nodes = primitives.getNodes();
        if (nodes != null && nodes.length > 0) {
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                int id = nodes[i2].getId();
                nodeIndexMap.put("" + id, new Integer(i2));
            }
        }
        Hashtable<String, Integer> edgeIndexMap = new Hashtable<String, Integer>();
        TopologyEdge[] edges = primitives.getEdges();
        if (edges != null && edges.length > 0) {
            for (int i3 = 0; i3 < edges.length; ++i3) {
                int id = edges[i3].getId();
                edgeIndexMap.put("" + id, new Integer(i3));
            }
        }
        Hashtable<String, Integer> faceIndexMap = new Hashtable<String, Integer>();
        TopologyFace[] faces = primitives.getFaces();
        if (faces != null && faces.length > 0) {
            for (int i4 = 0; i4 < faces.length; ++i4) {
                int id = faces[i4].getId();
                faceIndexMap.put("" + id, new Integer(i4));
            }
        }
        sb.append("{\n\"type\":\"Topology\",\n");
        sb.append("\"transform\": {\n");
        sb.append(" \"scale\": [1,1],\n");
        sb.append(" \"translate\": [0,0]\n },\n");
        sb.append("\"srs\":" + topology.getSrid() + ",\n");
        NumberFormat nf = GeoJsonUtils2.getNumberFormat(precision);
        if (mbr != null) {
            sb.append("\"bbox\":[" + nf.format(mbr.getMinX()) + ", " + nf.format(mbr.getMinY()) + ", " + nf.format(mbr.getMaxX()) + ", " + nf.format(mbr.getMaxY()) + "],\n");
        }
        sb.append("\"digits_right_decimal\":" + topology.getDigitsRightOfDecimal() + ",\n");
        if (attributes != null && attributes.size() > 0) {
            Field f;
            sb.append("\"attr_names\":[");
            for (i = 0; i < attributes.size(); ++i) {
                f = attributes.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\"" + f.getName() + "\"");
            }
            sb.append("],\n");
            sb.append("\"attr_types\":[");
            for (i = 0; i < attributes.size(); ++i) {
                f = attributes.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\"" + f.getShortJavaTypeName() + "\"");
            }
            sb.append("],\n");
        }
        sb.append(" \"layers\": {\n");
        sb.append("  \"" + topology.getFeatureTable() + "\": [\n");
        for (i = 0; i < features.size(); ++i) {
            Field[] attrs;
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append("     {\"type\":\"Feature\",");
            sb.append("\"_id\":\"auto-key-" + i + "\"");
            TopoFeatureDescriptor feature = features.get(i);
            TopoPrimitiveDescriptor[] tpm = feature.getPrimitives();
            if (tpm != null && tpm.length > 0) {
                sb.append(",\"geometry\": ");
                boolean hasPolygon = false;
                boolean hasLine = false;
                boolean hasPoint = false;
                int totPoints = 0;
                int totLines = 0;
                int totPolygons = 0;
                for (int j = 0; j < tpm.length; ++j) {
                    if (tpm[j].getTopoType() == 1) {
                        hasPoint = true;
                        ++totPoints;
                        continue;
                    }
                    if (tpm[j].getTopoType() == 2) {
                        hasLine = true;
                        ++totLines;
                        continue;
                    }
                    if (tpm[j].getTopoType() != 3) continue;
                    hasPolygon = true;
                    ++totPolygons;
                }
                String geomType = null;
                if (hasPoint && hasLine || hasPoint && hasPolygon || hasLine && hasPolygon) {
                    geomType = "GeometryCollection";
                } else if (hasPoint) {
                    geomType = totPoints == 1 ? "Point" : "MultiPoint";
                } else if (hasLine) {
                    geomType = totLines == 1 ? "LineString" : "MultiLineString";
                } else if (hasPolygon) {
                    geomType = totPolygons == 1 ? "Polygon" : "MultiPolygon";
                }
                if (geomType != null) {
                    if (geomType.equals("Point") || geomType.equals("MultiPoint")) {
                        GeoJsonUtils2.pointFeature2TopoJson(feature.getPrimitives(), primitives, nodeIndexMap, sb, nf);
                    } else if (geomType.equals("LineString") || geomType.equals("MultiLineString")) {
                        GeoJsonUtils2.lineFeature2TopoJson(feature.getPrimitives(), edgeIndexMap, sb);
                    } else if (geomType.equals("Polygon") || geomType.equals("MultiPolygon")) {
                        GeoJsonUtils2.polygonFeature2TopoJson(feature.getPrimitives(), primitives, faceIndexMap, edgeIndexMap, sb);
                    } else if (geomType.equals("GeometryCollection")) {
                        GeoJsonUtils2.collectionFeature2TopoJson(feature.getPrimitives(), primitives, nodeIndexMap, edgeIndexMap, faceIndexMap, sb, nf);
                    }
                }
            }
            if ((attrs = feature.getAttributes()) != null && attrs.length > 0) {
                sb.append(",\"properties\":{");
                for (int k = 0; k < attrs.length; ++k) {
                    String propName = JsonUtils.encode(attrs[k].getName());
                    String value = attrs[k].toString();
                    value = JsonUtils.encode(value);
                    sb.append(propName + ":");
                    sb.append(value);
                    if (k == attrs.length - 1) continue;
                    sb.append(", ");
                }
                sb.append("}");
            }
            sb.append("}");
        }
        sb.append("\n   ]\n },\n");
        sb.append(" \"arcs\": [\n");
        if (edges != null && edges.length > 0) {
            for (i = 0; i < edges.length; ++i) {
                double[] oords;
                if (i > 0) {
                    sb.append(",\n");
                }
                sb.append("     [");
                JGeometry geom = edges[i].getGeometry();
                if (geom != null && (oords = geom.getOrdinatesArray()) != null && oords.length > 0) {
                    for (int k = 0; k < oords.length; ++k) {
                        if (k > 0) {
                            sb.append(",");
                        }
                        sb.append("" + nf.format(oords[k]));
                    }
                }
                sb.append("]");
            }
        }
        sb.append("\n  ]\n }");
        return sb;
    }

    private static final StringBuilder pointFeature2TopoJson(TopoPrimitiveDescriptor[] tpm, TopologyPrimitives primitives, Hashtable<String, Integer> nodeIndexMap, StringBuilder sb, NumberFormat nf) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (tpm == null || tpm.length == 0) {
            return sb;
        }
        String type = "Point";
        if (tpm.length > 1) {
            type = "MultiPoint";
        }
        sb.append("{\"type\":\"" + type + "\", \"coordinates\":");
        if (type.equals("MultiPoint")) {
            sb.append("[");
        }
        for (int i = 0; i < tpm.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (tpm[i].getTopoType() != 1) {
                sb.append("[]");
                continue;
            }
            int nodeId = tpm[i].getTopoId();
            Integer nodeIdIndex = nodeIndexMap.get("" + nodeId);
            if (nodeIdIndex != null) {
                TopologyNode tpNode = primitives.getNode(nodeIdIndex);
                if (tpNode == null) {
                    sb.append("[]");
                    continue;
                }
                JGeometry geom = tpNode.getGeometry();
                Point2D pt = geom.getJavaPoint();
                sb.append("[" + nf.format(pt.getX()) + "," + nf.format(pt.getY()) + "]");
                continue;
            }
            sb.append("[]");
        }
        if (type.equals("MultiPoint")) {
            sb.append("]");
        }
        sb.append("}");
        return sb;
    }

    private static final StringBuilder lineFeature2TopoJson(TopoPrimitiveDescriptor[] tpm, Hashtable<String, Integer> edgeIndexMap, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (tpm == null || tpm.length == 0) {
            return sb;
        }
        String type = "LineString";
        if (tpm.length > 1) {
            type = "MultiLineString";
        }
        sb.append("{\"type\":\"" + type + "\", " + "\"arcs\": [");
        for (int i = 0; i < tpm.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (tpm[i].getTopoType() != 2) {
                sb.append("[]");
                continue;
            }
            int edgeId = tpm[i].getTopoId();
            Integer arcID = edgeIndexMap.get("" + Math.abs(edgeId));
            if (arcID != null) {
                if (edgeId < 0) {
                    sb.append("[" + (arcID + 1) * -1 + "]");
                    continue;
                }
                sb.append("[" + arcID + "]");
                continue;
            }
            sb.append("[]");
        }
        sb.append("]}");
        return sb;
    }

    private static final StringBuilder polygonFeature2TopoJson(TopoPrimitiveDescriptor[] tpm, TopologyPrimitives primitives, Hashtable<String, Integer> faceIndexMap, Hashtable<String, Integer> edgeIndexMap, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (tpm == null || tpm.length == 0) {
            return sb;
        }
        String type = "Polygon";
        if (tpm.length > 1) {
            type = "MultiPolygon";
        }
        sb.append("{\"type\":\"" + type + "\", " + "\"arcs\": [");
        for (int i = 0; i < tpm.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (type.equals("MultiPolygon")) {
                sb.append("[");
            }
            if (tpm[i].getTopoType() != 3) {
                sb.append("[]");
            } else {
                int faceId = tpm[i].getTopoId();
                Integer faceIndex = faceIndexMap.get("" + Math.abs(faceId));
                if (faceIndex == null) {
                    sb.append("[]");
                } else {
                    TopologyFace face = primitives.getFace(faceIndex);
                    Vector<Integer> edges = GeoJsonUtils2.getTopoEdges(face, face.getBoundaryEdge(), primitives, edgeIndexMap);
                    if (edges == null || edges.size() == 0) {
                        sb.append("[]");
                    } else {
                        sb.append("[");
                        for (int k = 0; k < edges.size(); ++k) {
                            if (k > 0) {
                                sb.append(",");
                            }
                            Integer edge = edges.get(k);
                            Integer arcID = edgeIndexMap.get("" + Math.abs(edge));
                            if (arcID == null) continue;
                            if (edge < 0) {
                                sb.append("" + (arcID + 1) * -1);
                                continue;
                            }
                            sb.append("" + arcID);
                        }
                        sb.append("]");
                        int[] isledges = face.getIslandEdges();
                        if (isledges != null && isledges.length > 0) {
                            for (int j = 0; j < isledges.length; ++j) {
                                Vector<Integer> islandEdges = GeoJsonUtils2.getTopoEdges(face, isledges[j], primitives, edgeIndexMap);
                                if (islandEdges == null || islandEdges.size() == 0) {
                                    sb.append(",[]");
                                    continue;
                                }
                                sb.append(",[");
                                for (int k = 0; k < islandEdges.size(); ++k) {
                                    if (k > 0) {
                                        sb.append(",");
                                    }
                                    Integer edge = islandEdges.get(k);
                                    Integer arcID = edgeIndexMap.get("" + Math.abs(edge));
                                    if (arcID == null) continue;
                                    if (edge < 0) {
                                        sb.append("" + (arcID + 1) * -1);
                                        continue;
                                    }
                                    sb.append("" + arcID);
                                }
                                sb.append("]");
                            }
                        }
                    }
                }
            }
            if (!type.equals("MultiPolygon")) continue;
            sb.append("]");
        }
        sb.append("]}");
        return sb;
    }

    private static final StringBuilder collectionFeature2TopoJson(TopoPrimitiveDescriptor[] tpm, TopologyPrimitives primitives, Hashtable<String, Integer> nodeIndexMap, Hashtable<String, Integer> edgeIndexMap, Hashtable<String, Integer> faceIndexMap, StringBuilder sb, NumberFormat nf) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (tpm == null || tpm.length == 0) {
            return sb;
        }
        sb.append("{\"type\":\"GeometryCollection\", \"geometries\":[");
        TopoPrimitiveDescriptor[] tpmTemp = new TopoPrimitiveDescriptor[1];
        for (int i = 0; i < tpm.length; ++i) {
            tpmTemp[0] = tpm[i];
            if (i > 0) {
                sb.append(",");
            }
            if (tpm[i].getTopoType() == 1) {
                GeoJsonUtils2.pointFeature2TopoJson(tpmTemp, primitives, nodeIndexMap, sb, nf);
                continue;
            }
            if (tpm[i].getTopoType() == 2) {
                GeoJsonUtils2.lineFeature2TopoJson(tpmTemp, edgeIndexMap, sb);
                continue;
            }
            if (tpm[i].getTopoType() == 3) {
                GeoJsonUtils2.polygonFeature2TopoJson(tpmTemp, primitives, faceIndexMap, edgeIndexMap, sb);
                continue;
            }
            sb.append("{}");
        }
        sb.append("]}");
        return sb;
    }

    private static Vector<Integer> getTopoEdges(TopologyFace face, int startEdge, TopologyPrimitives primitives, Hashtable<String, Integer> edgeIndexMap) {
        if (face == null) {
            return null;
        }
        Vector<Integer> edges = new Vector<Integer>();
        int faceId = face.getId();
        int bdedge = startEdge;
        edges.add(new Integer(bdedge));
        Integer edgeIndex = -1;
        try {
            edgeIndex = edgeIndexMap.get("" + Math.abs(bdedge));
            if (edgeIndex == null) {
                return null;
            }
            TopologyEdge e = primitives.getEdge(edgeIndex);
            if (e == null) {
                return null;
            }
            int nextEdge = -1;
            nextEdge = e.getBoundedFaceL() == faceId ? e.getNextEdgeL() : e.getNextEdgeR();
            if (e.getOriginNode() != e.getEndNode()) {
                while (Math.abs(nextEdge) != Math.abs(bdedge)) {
                    edges.add(new Integer(nextEdge));
                    edgeIndex = edgeIndexMap.get("" + Math.abs(nextEdge));
                    if (edgeIndex == null) {
                        return null;
                    }
                    TopologyEdge ne = primitives.getEdge(edgeIndex);
                    if (ne.getBoundedFaceL() == faceId) {
                        nextEdge = ne.getNextEdgeL();
                        continue;
                    }
                    nextEdge = ne.getNextEdgeR();
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return edges;
    }

    static {
        GeoJsonUtils2.NFs[0] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#", 0);
        GeoJsonUtils2.NFs[1] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.#", 1);
        GeoJsonUtils2.NFs[2] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.##", 2);
        GeoJsonUtils2.NFs[3] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.###", 3);
        GeoJsonUtils2.NFs[4] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.####", 4);
        GeoJsonUtils2.NFs[5] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.#####", 5);
        GeoJsonUtils2.NFs[6] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.######", 6);
        GeoJsonUtils2.NFs[7] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.#######", 7);
        GeoJsonUtils2.NFs[8] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.########", 8);
        GeoJsonUtils2.NFs[9] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.#########", 9);
        GeoJsonUtils2.NFs[10] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.##########", 10);
        GeoJsonUtils2.NFs[11] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.###########", 11);
        GeoJsonUtils2.NFs[12] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.############", 12);
        GeoJsonUtils2.NFs[13] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.#############", 13);
        GeoJsonUtils2.NFs[14] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.##############", 14);
        GeoJsonUtils2.NFs[15] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.###############", 15);
        GeoJsonUtils2.NFs[16] = GeoJsonUtils2.getDecimalFormat(Locale.US, "#.################", 16);
        defaultAttrInfo = "\"attr_names\":[],\n\"attr_types\":[],\n";
    }
}

